"""Factories for API object."""

import os

import factory
import factory.fuzzy

from cyberfusion.ClusterSupport.malwares import Malware
from cyberfusion.ClusterSupport.tests_factories import BaseBackendFactory


class MalwareFactory(BaseBackendFactory):
    """Factory for specific object."""

    class Meta:
        """Settings."""

        model = Malware

        exclude = ("unix_user",)

    name = "{YARA}EICAR"
    unix_user = factory.SubFactory(
        "cyberfusion.ClusterSupport.tests_factories.unix_users.UNIXUserPHPFactory",
    )
    unix_user_id = factory.SelfAttribute("unix_user.id")
    last_seen_at = factory.Faker("iso8601")
    path = factory.LazyAttribute(
        lambda obj: os.path.join(obj.unix_user.home_directory, "eicar.zip")
    )
