#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Fri Jul  7 11:59:02 2017 by generateDS.py version 2.28a.
#
# Command line options:
#   ('-o', 'sld_1_0_0.py')
#   ('-s', 'sld_1_0_0_sub_classes.py')
#   ('--external-encoding', 'utf-8')
#
# Command line arguments:
#   tmp.xsd
#
# Command line:
#   /home/vvmruder/Projekte/PyCharm/pyramid_iconizer/.venv/bin/generateds -o "sld_1_0_0.py"
#   -s "sld_1_0_0_sub_classes.py" --external-encoding="utf-8" tmp.xsd
#
# Current working directory (os.getcwd()):
#   pyramid_iconizer
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_

try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_

Validate_simpletypes_ = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc


#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for a example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')

        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name

            def utcoffset(self, dt):
                return self.__offset

            def tzname(self, dt):
                return self.__name

            def dst(self, dt):
                return None

        def gds_format_string(self, input_data, input_name=''):
            return input_data

        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data

        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)

        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data

        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)

        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values

        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')

        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)

        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values

        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data

        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)

        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values

        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()

        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)

        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0',):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values

        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue

        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds,)
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt

        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue

        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()

        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue

        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1

        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()

        def gds_str_lower(self, instring):
            return instring.lower()

        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path

        Tag_strip_pattern_ = re_.compile(r'\{.*\}')

        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)

        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1

        def gds_build_any(self, node, type_name=None):
            return None

        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))

        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                return instring.encode(ExternalEncoding)
            else:
                return instring

        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result

        def __eq__(self, other):
            if type(self) != type(other):
                return False
            return self.__dict__ == other.__dict__

        def __ne__(self, other):
            return not self.__eq__(other)


    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None

#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None


#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name,))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline,)
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8

    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value

    def getCategory(self):
        return self.category

    def getContenttype(self, content_type):
        return self.content_type

    def getValue(self):
        return self.value

    def getName(self):
        return self.name

    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:  # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name,
                pretty_print=pretty_print)

    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                        self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                        self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))

    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:  # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)

    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                      self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                      self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text

    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:  # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
                 optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional

    def set_name(self, name):
        self.name = name

    def get_name(self):
        return self.name

    def set_data_type(self, data_type):
        self.data_type = data_type

    def get_data_type_chain(self):
        return self.data_type

    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type

    def set_container(self, container):
        self.container = container

    def get_container(self):
        return self.container

    def set_child_attrs(self, child_attrs):
        self.child_attrs = child_attrs

    def get_child_attrs(self):
        return self.child_attrs

    def set_choice(self, choice):
        self.choice = choice

    def get_choice(self):
        return self.choice

    def set_optional(self, optional):
        self.optional = optional

    def get_optional(self):
        return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)


#
# Data representation classes.
#


class StyledLayerDescriptor(GeneratedsSuper):
    """A StyledLayerDescriptor is a sequence of styled layers, represented
    at the first level by NamedLayer and UserLayer elements."""
    subclass = None
    superclass = None

    def __init__(self, version=None, Name=None, Title=None, Abstract=None, NamedLayer=None, UserLayer=None):
        self.original_tagname_ = None
        self.version = _cast(None, version)
        self.Name = Name
        self.Title = Title
        self.Abstract = Abstract
        if NamedLayer is None:
            self.NamedLayer = []
        else:
            self.NamedLayer = NamedLayer
        if UserLayer is None:
            self.UserLayer = []
        else:
            self.UserLayer = UserLayer

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StyledLayerDescriptor)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StyledLayerDescriptor.subclass:
            return StyledLayerDescriptor.subclass(*args_, **kwargs_)
        else:
            return StyledLayerDescriptor(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Name(self):
        return self.Name

    def set_Name(self, Name):
        self.Name = Name

    def get_Title(self):
        return self.Title

    def set_Title(self, Title):
        self.Title = Title

    def get_Abstract(self):
        return self.Abstract

    def set_Abstract(self, Abstract):
        self.Abstract = Abstract

    def get_NamedLayer(self):
        return self.NamedLayer

    def set_NamedLayer(self, NamedLayer):
        self.NamedLayer = NamedLayer

    def add_NamedLayer(self, value):
        self.NamedLayer.append(value)

    def insert_NamedLayer_at(self, index, value):
        self.NamedLayer.insert(index, value)

    def replace_NamedLayer_at(self, index, value):
        self.NamedLayer[index] = value

    def get_UserLayer(self):
        return self.UserLayer

    def set_UserLayer(self, UserLayer):
        self.UserLayer = UserLayer

    def add_UserLayer(self, value):
        self.UserLayer.append(value)

    def insert_UserLayer_at(self, index, value):
        self.UserLayer.insert(index, value)

    def replace_UserLayer_at(self, index, value):
        self.UserLayer[index] = value

    def get_version(self):
        return self.version

    def set_version(self, version):
        self.version = version

    def hasContent_(self):
        if (
                                    self.Name is not None or
                                    self.Title is not None or
                                self.Abstract is not None or
                        self.NamedLayer or
                    self.UserLayer
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='StyledLayerDescriptor',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('StyledLayerDescriptor')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StyledLayerDescriptor')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='StyledLayerDescriptor',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='StyledLayerDescriptor'):
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.version), input_name='version')),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='StyledLayerDescriptor',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.Name), input_name='Name')),
            namespace_, eol_))
        if self.Title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTitle>%s</%sTitle>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.Title), input_name='Title')),
            namespace_, eol_))
        if self.Abstract is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAbstract>%s</%sAbstract>%s' % (namespace_, self.gds_encode(
                self.gds_format_string(quote_xml(self.Abstract), input_name='Abstract')), namespace_, eol_))
        for NamedLayer_ in self.NamedLayer:
            NamedLayer_.export(outfile, level, namespace_='sld:', name_='NamedLayer',
                               pretty_print=pretty_print)
        for UserLayer_ in self.UserLayer:
            UserLayer_.export(outfile, level, namespace_='sld:', name_='UserLayer', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Title':
            Title_ = child_.text
            Title_ = self.gds_validate_string(Title_, node, 'Title')
            self.Title = Title_
        elif nodeName_ == 'Abstract':
            Abstract_ = child_.text
            Abstract_ = self.gds_validate_string(Abstract_, node, 'Abstract')
            self.Abstract = Abstract_
        elif nodeName_ == 'NamedLayer':
            obj_ = NamedLayer.factory()
            obj_.build(child_)
            self.NamedLayer.append(obj_)
            obj_.original_tagname_ = 'NamedLayer'
        elif nodeName_ == 'UserLayer':
            obj_ = UserLayer.factory()
            obj_.build(child_)
            self.UserLayer.append(obj_)
            obj_.original_tagname_ = 'UserLayer'


# end class StyledLayerDescriptor


class NamedLayer(GeneratedsSuper):
    """A NamedLayer is a layer of data that has a name advertised by a WMS."""
    subclass = None
    superclass = None

    def __init__(self, Name=None, LayerFeatureConstraints=None, NamedStyle=None, UserStyle=None):
        self.original_tagname_ = None
        self.Name = Name
        self.LayerFeatureConstraints = LayerFeatureConstraints
        if NamedStyle is None:
            self.NamedStyle = []
        else:
            self.NamedStyle = NamedStyle
        if UserStyle is None:
            self.UserStyle = []
        else:
            self.UserStyle = UserStyle

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NamedLayer)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NamedLayer.subclass:
            return NamedLayer.subclass(*args_, **kwargs_)
        else:
            return NamedLayer(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Name(self):
        return self.Name

    def set_Name(self, Name):
        self.Name = Name

    def get_LayerFeatureConstraints(self):
        return self.LayerFeatureConstraints

    def set_LayerFeatureConstraints(self, LayerFeatureConstraints):
        self.LayerFeatureConstraints = LayerFeatureConstraints

    def get_NamedStyle(self):
        return self.NamedStyle

    def set_NamedStyle(self, NamedStyle):
        self.NamedStyle = NamedStyle

    def add_NamedStyle(self, value):
        self.NamedStyle.append(value)

    def insert_NamedStyle_at(self, index, value):
        self.NamedStyle.insert(index, value)

    def replace_NamedStyle_at(self, index, value):
        self.NamedStyle[index] = value

    def get_UserStyle(self):
        return self.UserStyle

    def set_UserStyle(self, UserStyle):
        self.UserStyle = UserStyle

    def add_UserStyle(self, value):
        self.UserStyle.append(value)

    def insert_UserStyle_at(self, index, value):
        self.UserStyle.insert(index, value)

    def replace_UserStyle_at(self, index, value):
        self.UserStyle[index] = value

    def hasContent_(self):
        if (
                                self.Name is not None or
                                self.LayerFeatureConstraints is not None or
                        self.NamedStyle or
                    self.UserStyle
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='NamedLayer',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('NamedLayer')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NamedLayer')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='NamedLayer',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='NamedLayer'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='NamedLayer', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (
            'sld:', self.gds_encode(self.gds_format_string(quote_xml(self.Name), input_name='Name')), 'sld:',
            eol_))
        if self.LayerFeatureConstraints is not None:
            self.LayerFeatureConstraints.export(outfile, level, namespace_='sld:',
                                                name_='LayerFeatureConstraints', pretty_print=pretty_print)
        for NamedStyle_ in self.NamedStyle:
            NamedStyle_.export(outfile, level, namespace_='sld:', name_='NamedStyle',
                               pretty_print=pretty_print)
        for UserStyle_ in self.UserStyle:
            UserStyle_.export(outfile, level, namespace_='sld:', name_='UserStyle', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'LayerFeatureConstraints':
            obj_ = LayerFeatureConstraints.factory()
            obj_.build(child_)
            self.LayerFeatureConstraints = obj_
            obj_.original_tagname_ = 'LayerFeatureConstraints'
        elif nodeName_ == 'NamedStyle':
            obj_ = NamedStyle.factory()
            obj_.build(child_)
            self.NamedStyle.append(obj_)
            obj_.original_tagname_ = 'NamedStyle'
        elif nodeName_ == 'UserStyle':
            obj_ = UserStyle.factory()
            obj_.build(child_)
            self.UserStyle.append(obj_)
            obj_.original_tagname_ = 'UserStyle'


# end class NamedLayer


class NamedStyle(GeneratedsSuper):
    """A NamedStyle is used to refer to a style that has a name in a WMS."""
    subclass = None
    superclass = None

    def __init__(self, Name=None):
        self.original_tagname_ = None
        self.Name = Name

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NamedStyle)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NamedStyle.subclass:
            return NamedStyle.subclass(*args_, **kwargs_)
        else:
            return NamedStyle(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Name(self):
        return self.Name

    def set_Name(self, Name):
        self.Name = Name

    def hasContent_(self):
        if (
                    self.Name is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='NamedStyle',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('NamedStyle')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NamedStyle')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='NamedStyle',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='NamedStyle'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='NamedStyle', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (
            'sld:', self.gds_encode(self.gds_format_string(quote_xml(self.Name), input_name='Name')), 'sld:',
            eol_))

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_


# end class NamedStyle


class UserLayer(GeneratedsSuper):
    """A UserLayer allows a user-defined layer to be built from WFS and WCS
    data."""
    subclass = None
    superclass = None

    def __init__(self, Name=None, RemoteOWS=None, LayerFeatureConstraints=None, UserStyle=None):
        self.original_tagname_ = None
        self.Name = Name
        self.RemoteOWS = RemoteOWS
        self.LayerFeatureConstraints = LayerFeatureConstraints
        if UserStyle is None:
            self.UserStyle = []
        else:
            self.UserStyle = UserStyle

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UserLayer)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UserLayer.subclass:
            return UserLayer.subclass(*args_, **kwargs_)
        else:
            return UserLayer(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Name(self):
        return self.Name

    def set_Name(self, Name):
        self.Name = Name

    def get_RemoteOWS(self):
        return self.RemoteOWS

    def set_RemoteOWS(self, RemoteOWS):
        self.RemoteOWS = RemoteOWS

    def get_LayerFeatureConstraints(self):
        return self.LayerFeatureConstraints

    def set_LayerFeatureConstraints(self, LayerFeatureConstraints):
        self.LayerFeatureConstraints = LayerFeatureConstraints

    def get_UserStyle(self):
        return self.UserStyle

    def set_UserStyle(self, UserStyle):
        self.UserStyle = UserStyle

    def add_UserStyle(self, value):
        self.UserStyle.append(value)

    def insert_UserStyle_at(self, index, value):
        self.UserStyle.insert(index, value)

    def replace_UserStyle_at(self, index, value):
        self.UserStyle[index] = value

    def hasContent_(self):
        if (
                                self.Name is not None or
                                self.RemoteOWS is not None or
                            self.LayerFeatureConstraints is not None or
                    self.UserStyle
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='UserLayer',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('UserLayer')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UserLayer')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='UserLayer',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='UserLayer'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='UserLayer', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.Name), input_name='Name')),
            namespace_, eol_))
        if self.RemoteOWS is not None:
            self.RemoteOWS.export(outfile, level, namespace_='sld:', name_='RemoteOWS',
                                  pretty_print=pretty_print)
        if self.LayerFeatureConstraints is not None:
            self.LayerFeatureConstraints.export(outfile, level, namespace_='sld:',
                                                name_='LayerFeatureConstraints', pretty_print=pretty_print)
        for UserStyle_ in self.UserStyle:
            UserStyle_.export(outfile, level, namespace_='sld:', name_='UserStyle', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'RemoteOWS':
            obj_ = RemoteOWS.factory()
            obj_.build(child_)
            self.RemoteOWS = obj_
            obj_.original_tagname_ = 'RemoteOWS'
        elif nodeName_ == 'LayerFeatureConstraints':
            obj_ = LayerFeatureConstraints.factory()
            obj_.build(child_)
            self.LayerFeatureConstraints = obj_
            obj_.original_tagname_ = 'LayerFeatureConstraints'
        elif nodeName_ == 'UserStyle':
            obj_ = UserStyle.factory()
            obj_.build(child_)
            self.UserStyle.append(obj_)
            obj_.original_tagname_ = 'UserStyle'


# end class UserLayer


class RemoteOWS(GeneratedsSuper):
    """A RemoteOWS gives a reference to a remote WFS/WCS/other-OWS server."""
    subclass = None
    superclass = None

    def __init__(self, Service=None, OnlineResource=None):
        self.original_tagname_ = None
        self.Service = Service
        self.validate_Service(self.Service)
        self.OnlineResource = OnlineResource

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RemoteOWS)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RemoteOWS.subclass:
            return RemoteOWS.subclass(*args_, **kwargs_)
        else:
            return RemoteOWS(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Service(self):
        return self.Service

    def set_Service(self, Service):
        self.Service = Service

    def get_OnlineResource(self):
        return self.OnlineResource

    def set_OnlineResource(self, OnlineResource):
        self.OnlineResource = OnlineResource

    def validate_Service(self, value):
        # Validate type Service, a restriction on xsd:string.
        pass

    def hasContent_(self):
        if (
                        self.Service is not None or
                        self.OnlineResource is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='RemoteOWS',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RemoteOWS')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RemoteOWS')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='RemoteOWS',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='RemoteOWS'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='RemoteOWS', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Service is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sService>%s</%sService>%s' % (
            'sld:', self.gds_encode(self.gds_format_string(quote_xml(self.Service), input_name='Service')),
            'sld:', eol_))
        if self.OnlineResource is not None:
            self.OnlineResource.export(outfile, level, namespace_='sld:', name_='OnlineResource',
                                       pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Service':
            Service_ = child_.text
            Service_ = self.gds_validate_string(Service_, node, 'Service')
            self.Service = Service_
            # validate type Service
            self.validate_Service(self.Service)
        elif nodeName_ == 'OnlineResource':
            obj_ = OnlineResource.factory()
            obj_.build(child_)
            self.OnlineResource = obj_
            obj_.original_tagname_ = 'OnlineResource'


# end class RemoteOWS


class Service(GeneratedsSuper):
    """A Service refers to the type of a remote OWS server."""
    subclass = None
    superclass = None

    def __init__(self):
        self.original_tagname_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Service)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Service.subclass:
            return Service.subclass(*args_, **kwargs_)
        else:
            return Service(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='Service',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Service')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Service')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='Service',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='Service'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='Service', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class Service


class OnlineResource(GeneratedsSuper):
    """An OnlineResource is typically used to refer to an HTTP URL."""
    subclass = None
    superclass = None

    def __init__(self, type_=None, href=None, role=None, arcrole=None, title=None, show=None, actuate=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OnlineResource)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OnlineResource.subclass:
            return OnlineResource.subclass(*args_, **kwargs_)
        else:
            return OnlineResource(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='OnlineResource',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OnlineResource')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OnlineResource')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='OnlineResource',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='OnlineResource'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='OnlineResource', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class OnlineResource


class LayerFeatureConstraints(GeneratedsSuper):
    """LayerFeatureConstraints define what features & feature types are
    referenced in a layer."""
    subclass = None
    superclass = None

    def __init__(self, FeatureTypeConstraint=None):
        self.original_tagname_ = None
        if FeatureTypeConstraint is None:
            self.FeatureTypeConstraint = []
        else:
            self.FeatureTypeConstraint = FeatureTypeConstraint

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LayerFeatureConstraints)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LayerFeatureConstraints.subclass:
            return LayerFeatureConstraints.subclass(*args_, **kwargs_)
        else:
            return LayerFeatureConstraints(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_FeatureTypeConstraint(self):
        return self.FeatureTypeConstraint

    def set_FeatureTypeConstraint(self, FeatureTypeConstraint):
        self.FeatureTypeConstraint = FeatureTypeConstraint

    def add_FeatureTypeConstraint(self, value):
        self.FeatureTypeConstraint.append(value)

    def insert_FeatureTypeConstraint_at(self, index, value):
        self.FeatureTypeConstraint.insert(index, value)

    def replace_FeatureTypeConstraint_at(self, index, value):
        self.FeatureTypeConstraint[index] = value

    def hasContent_(self):
        if (
                self.FeatureTypeConstraint
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LayerFeatureConstraints',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LayerFeatureConstraints')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LayerFeatureConstraints')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LayerFeatureConstraints',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='LayerFeatureConstraints'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LayerFeatureConstraints',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for FeatureTypeConstraint_ in self.FeatureTypeConstraint:
            FeatureTypeConstraint_.export(outfile, level, namespace_='sld:', name_='FeatureTypeConstraint',
                                          pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'FeatureTypeConstraint':
            obj_ = FeatureTypeConstraint.factory()
            obj_.build(child_)
            self.FeatureTypeConstraint.append(obj_)
            obj_.original_tagname_ = 'FeatureTypeConstraint'


# end class LayerFeatureConstraints


class FeatureTypeConstraint(GeneratedsSuper):
    """A FeatureTypeConstraint identifies a specific feature type and
    supplies fitlering."""
    subclass = None
    superclass = None

    def __init__(self, FeatureTypeName=None, Filter=None, Extent=None):
        self.original_tagname_ = None
        self.FeatureTypeName = FeatureTypeName
        self.Filter = Filter
        if Extent is None:
            self.Extent = []
        else:
            self.Extent = Extent

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FeatureTypeConstraint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FeatureTypeConstraint.subclass:
            return FeatureTypeConstraint.subclass(*args_, **kwargs_)
        else:
            return FeatureTypeConstraint(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_FeatureTypeName(self):
        return self.FeatureTypeName

    def set_FeatureTypeName(self, FeatureTypeName):
        self.FeatureTypeName = FeatureTypeName

    def get_Filter(self):
        return self.Filter

    def set_Filter(self, Filter):
        self.Filter = Filter

    def get_Extent(self):
        return self.Extent

    def set_Extent(self, Extent):
        self.Extent = Extent

    def add_Extent(self, value):
        self.Extent.append(value)

    def insert_Extent_at(self, index, value):
        self.Extent.insert(index, value)

    def replace_Extent_at(self, index, value):
        self.Extent[index] = value

    def hasContent_(self):
        if (
                            self.FeatureTypeName is not None or
                            self.Filter is not None or
                    self.Extent
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='FeatureTypeConstraint',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('FeatureTypeConstraint')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FeatureTypeConstraint')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='FeatureTypeConstraint',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='FeatureTypeConstraint'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='FeatureTypeConstraint',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.FeatureTypeName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFeatureTypeName>%s</%sFeatureTypeName>%s' % (namespace_, self.gds_encode(
                self.gds_format_string(quote_xml(self.FeatureTypeName), input_name='FeatureTypeName')),
                                                                           namespace_, eol_))
        if self.Filter is not None:
            self.Filter.export(outfile, level, namespace_='ogc:', name_='Filter', pretty_print=pretty_print)
        for Extent_ in self.Extent:
            Extent_.export(outfile, level, namespace_='sld:', name_='Extent', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'FeatureTypeName':
            FeatureTypeName_ = child_.text
            FeatureTypeName_ = self.gds_validate_string(FeatureTypeName_, node, 'FeatureTypeName')
            self.FeatureTypeName = FeatureTypeName_
        elif nodeName_ == 'Filter':
            obj_ = FilterType.factory()
            obj_.build(child_)
            self.Filter = obj_
            obj_.original_tagname_ = 'Filter'
        elif nodeName_ == 'Extent':
            obj_ = Extent.factory()
            obj_.build(child_)
            self.Extent.append(obj_)
            obj_.original_tagname_ = 'Extent'


# end class FeatureTypeConstraint


class Extent(GeneratedsSuper):
    """An Extent gives feature/coverage/raster/matrix dimension extent."""
    subclass = None
    superclass = None

    def __init__(self, Name=None, Value=None):
        self.original_tagname_ = None
        self.Name = Name
        self.Value = Value

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Extent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Extent.subclass:
            return Extent.subclass(*args_, **kwargs_)
        else:
            return Extent(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Name(self):
        return self.Name

    def set_Name(self, Name):
        self.Name = Name

    def get_Value(self):
        return self.Value

    def set_Value(self, Value):
        self.Value = Value

    def hasContent_(self):
        if (
                        self.Name is not None or
                        self.Value is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='Extent',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Extent')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Extent')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='Extent',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='Extent'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='Extent', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (
            'sld:', self.gds_encode(self.gds_format_string(quote_xml(self.Name), input_name='Name')), 'sld:',
            eol_))
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (
            'sld:', self.gds_encode(self.gds_format_string(quote_xml(self.Value), input_name='Value')),
            'sld:', eol_))

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_


# end class Extent


class UserStyle(GeneratedsSuper):
    """A UserStyle allows user-defined styling and is semantically
    equivalent to a WMS named style."""
    subclass = None
    superclass = None

    def __init__(self, Name=None, Title=None, Abstract=None, IsDefault=None, FeatureTypeStyle=None):
        self.original_tagname_ = None
        self.Name = Name
        self.Title = Title
        self.Abstract = Abstract
        self.IsDefault = IsDefault
        if FeatureTypeStyle is None:
            self.FeatureTypeStyle = []
        else:
            self.FeatureTypeStyle = FeatureTypeStyle

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UserStyle)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UserStyle.subclass:
            return UserStyle.subclass(*args_, **kwargs_)
        else:
            return UserStyle(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Name(self):
        return self.Name

    def set_Name(self, Name):
        self.Name = Name

    def get_Title(self):
        return self.Title

    def set_Title(self, Title):
        self.Title = Title

    def get_Abstract(self):
        return self.Abstract

    def set_Abstract(self, Abstract):
        self.Abstract = Abstract

    def get_IsDefault(self):
        return self.IsDefault

    def set_IsDefault(self, IsDefault):
        self.IsDefault = IsDefault

    def get_FeatureTypeStyle(self):
        return self.FeatureTypeStyle

    def set_FeatureTypeStyle(self, FeatureTypeStyle):
        self.FeatureTypeStyle = FeatureTypeStyle

    def add_FeatureTypeStyle(self, value):
        self.FeatureTypeStyle.append(value)

    def insert_FeatureTypeStyle_at(self, index, value):
        self.FeatureTypeStyle.insert(index, value)

    def replace_FeatureTypeStyle_at(self, index, value):
        self.FeatureTypeStyle[index] = value

    def hasContent_(self):
        if (
                                    self.Name is not None or
                                    self.Title is not None or
                                self.Abstract is not None or
                            self.IsDefault is not None or
                    self.FeatureTypeStyle
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='UserStyle',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('UserStyle')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UserStyle')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='UserStyle',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='UserStyle'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='UserStyle', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.Name), input_name='Name')),
            namespace_, eol_))
        if self.Title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTitle>%s</%sTitle>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.Title), input_name='Title')),
            namespace_, eol_))
        if self.Abstract is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAbstract>%s</%sAbstract>%s' % (namespace_, self.gds_encode(
                self.gds_format_string(quote_xml(self.Abstract), input_name='Abstract')), namespace_, eol_))
        if self.IsDefault is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsDefault>%s</%sIsDefault>%s' % (
            namespace_, self.gds_format_boolean(self.IsDefault, input_name='IsDefault'), namespace_, eol_))
        for FeatureTypeStyle_ in self.FeatureTypeStyle:
            FeatureTypeStyle_.export(outfile, level, namespace_='sld:', name_='FeatureTypeStyle',
                                     pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Title':
            Title_ = child_.text
            Title_ = self.gds_validate_string(Title_, node, 'Title')
            self.Title = Title_
        elif nodeName_ == 'Abstract':
            Abstract_ = child_.text
            Abstract_ = self.gds_validate_string(Abstract_, node, 'Abstract')
            self.Abstract = Abstract_
        elif nodeName_ == 'IsDefault':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsDefault')
            self.IsDefault = ival_
        elif nodeName_ == 'FeatureTypeStyle':
            obj_ = FeatureTypeStyle.factory()
            obj_.build(child_)
            self.FeatureTypeStyle.append(obj_)
            obj_.original_tagname_ = 'FeatureTypeStyle'


# end class UserStyle


class FeatureTypeStyle(GeneratedsSuper):
    """A FeatureTypeStyle contains styling information specific to one
    feature type. This is the SLD level that separates the 'layer'
    handling from the 'feature' handling."""
    subclass = None
    superclass = None

    def __init__(self, Name=None, Title=None, Abstract=None, FeatureTypeName=None,
                 SemanticTypeIdentifier=None, Rule=None):
        self.original_tagname_ = None
        self.Name = Name
        self.Title = Title
        self.Abstract = Abstract
        self.FeatureTypeName = FeatureTypeName
        if SemanticTypeIdentifier is None:
            self.SemanticTypeIdentifier = []
        else:
            self.SemanticTypeIdentifier = SemanticTypeIdentifier
        if Rule is None:
            self.Rule = []
        else:
            self.Rule = Rule

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FeatureTypeStyle)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FeatureTypeStyle.subclass:
            return FeatureTypeStyle.subclass(*args_, **kwargs_)
        else:
            return FeatureTypeStyle(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Name(self):
        return self.Name

    def set_Name(self, Name):
        self.Name = Name

    def get_Title(self):
        return self.Title

    def set_Title(self, Title):
        self.Title = Title

    def get_Abstract(self):
        return self.Abstract

    def set_Abstract(self, Abstract):
        self.Abstract = Abstract

    def get_FeatureTypeName(self):
        return self.FeatureTypeName

    def set_FeatureTypeName(self, FeatureTypeName):
        self.FeatureTypeName = FeatureTypeName

    def get_SemanticTypeIdentifier(self):
        return self.SemanticTypeIdentifier

    def set_SemanticTypeIdentifier(self, SemanticTypeIdentifier):
        self.SemanticTypeIdentifier = SemanticTypeIdentifier

    def add_SemanticTypeIdentifier(self, value):
        self.SemanticTypeIdentifier.append(value)

    def insert_SemanticTypeIdentifier_at(self, index, value):
        self.SemanticTypeIdentifier.insert(index, value)

    def replace_SemanticTypeIdentifier_at(self, index, value):
        self.SemanticTypeIdentifier[index] = value

    def get_Rule(self):
        return self.Rule

    def set_Rule(self, Rule):
        self.Rule = Rule

    def add_Rule(self, value):
        self.Rule.append(value)

    def insert_Rule_at(self, index, value):
        self.Rule.insert(index, value)

    def replace_Rule_at(self, index, value):
        self.Rule[index] = value

    def hasContent_(self):
        if (
                                        self.Name is not None or
                                        self.Title is not None or
                                    self.Abstract is not None or
                                self.FeatureTypeName is not None or
                        self.SemanticTypeIdentifier or
                    self.Rule
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='FeatureTypeStyle',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('FeatureTypeStyle')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FeatureTypeStyle')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='FeatureTypeStyle',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='FeatureTypeStyle'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='FeatureTypeStyle', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.Name), input_name='Name')),
            namespace_, eol_))
        if self.Title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTitle>%s</%sTitle>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.Title), input_name='Title')),
            namespace_, eol_))
        if self.Abstract is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAbstract>%s</%sAbstract>%s' % (namespace_, self.gds_encode(
                self.gds_format_string(quote_xml(self.Abstract), input_name='Abstract')), namespace_, eol_))
        if self.FeatureTypeName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFeatureTypeName>%s</%sFeatureTypeName>%s' % (namespace_, self.gds_encode(
                self.gds_format_string(quote_xml(self.FeatureTypeName), input_name='FeatureTypeName')),
                                                                           namespace_, eol_))
        for SemanticTypeIdentifier_ in self.SemanticTypeIdentifier:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSemanticTypeIdentifier>%s</%sSemanticTypeIdentifier>%s' % (namespace_,
                                                                                         self.gds_encode(
                                                                                             self.gds_format_string(
                                                                                                 quote_xml(
                                                                                                     SemanticTypeIdentifier_),
                                                                                                 input_name='SemanticTypeIdentifier')),
                                                                                         namespace_, eol_))
        for Rule_ in self.Rule:
            Rule_.export(outfile, level, namespace_='sld:', name_='Rule', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Title':
            Title_ = child_.text
            Title_ = self.gds_validate_string(Title_, node, 'Title')
            self.Title = Title_
        elif nodeName_ == 'Abstract':
            Abstract_ = child_.text
            Abstract_ = self.gds_validate_string(Abstract_, node, 'Abstract')
            self.Abstract = Abstract_
        elif nodeName_ == 'FeatureTypeName':
            FeatureTypeName_ = child_.text
            FeatureTypeName_ = self.gds_validate_string(FeatureTypeName_, node, 'FeatureTypeName')
            self.FeatureTypeName = FeatureTypeName_
        elif nodeName_ == 'SemanticTypeIdentifier':
            SemanticTypeIdentifier_ = child_.text
            SemanticTypeIdentifier_ = self.gds_validate_string(SemanticTypeIdentifier_, node,
                                                               'SemanticTypeIdentifier')
            self.SemanticTypeIdentifier.append(SemanticTypeIdentifier_)
        elif nodeName_ == 'Rule':
            obj_ = Rule.factory()
            obj_.build(child_)
            self.Rule.append(obj_)
            obj_.original_tagname_ = 'Rule'


# end class FeatureTypeStyle


class Rule(GeneratedsSuper):
    """A Rule is used to attach property/scale conditions to and group the
    individual symbolizers used for rendering."""
    subclass = None
    superclass = None

    def __init__(self, Name=None, Title=None, Abstract=None, LegendGraphic=None, Filter=None, ElseFilter=None,
                 MinScaleDenominator=None, MaxScaleDenominator=None, Symbolizer=None):
        self.original_tagname_ = None
        self.Name = Name
        self.Title = Title
        self.Abstract = Abstract
        self.LegendGraphic = LegendGraphic
        self.Filter = Filter
        self.ElseFilter = ElseFilter
        self.MinScaleDenominator = MinScaleDenominator
        self.MaxScaleDenominator = MaxScaleDenominator
        if Symbolizer is None:
            self.Symbolizer = []
        else:
            self.Symbolizer = Symbolizer

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Rule)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Rule.subclass:
            return Rule.subclass(*args_, **kwargs_)
        else:
            return Rule(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Name(self):
        return self.Name

    def set_Name(self, Name):
        self.Name = Name

    def get_Title(self):
        return self.Title

    def set_Title(self, Title):
        self.Title = Title

    def get_Abstract(self):
        return self.Abstract

    def set_Abstract(self, Abstract):
        self.Abstract = Abstract

    def get_LegendGraphic(self):
        return self.LegendGraphic

    def set_LegendGraphic(self, LegendGraphic):
        self.LegendGraphic = LegendGraphic

    def get_Filter(self):
        return self.Filter

    def set_Filter(self, Filter):
        self.Filter = Filter

    def get_ElseFilter(self):
        return self.ElseFilter

    def set_ElseFilter(self, ElseFilter):
        self.ElseFilter = ElseFilter

    def get_MinScaleDenominator(self):
        return self.MinScaleDenominator

    def set_MinScaleDenominator(self, MinScaleDenominator):
        self.MinScaleDenominator = MinScaleDenominator

    def get_MaxScaleDenominator(self):
        return self.MaxScaleDenominator

    def set_MaxScaleDenominator(self, MaxScaleDenominator):
        self.MaxScaleDenominator = MaxScaleDenominator

    def get_Symbolizer(self):
        return self.Symbolizer

    def set_Symbolizer(self, Symbolizer):
        self.Symbolizer = Symbolizer

    def add_Symbolizer(self, value):
        self.Symbolizer.append(value)

    def insert_Symbolizer_at(self, index, value):
        self.Symbolizer.insert(index, value)

    def replace_Symbolizer_at(self, index, value):
        self.Symbolizer[index] = value

    def hasContent_(self):
        if (
                                                    self.Name is not None or
                                                    self.Title is not None or
                                                self.Abstract is not None or
                                            self.LegendGraphic is not None or
                                        self.Filter is not None or
                                    self.ElseFilter is not None or
                                self.MinScaleDenominator is not None or
                            self.MaxScaleDenominator is not None or
                    self.Symbolizer
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='Rule',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Rule')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Rule')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='Rule',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='Rule'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='Rule', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.Name), input_name='Name')),
            namespace_, eol_))
        if self.Title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTitle>%s</%sTitle>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.Title), input_name='Title')),
            namespace_, eol_))
        if self.Abstract is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAbstract>%s</%sAbstract>%s' % (namespace_, self.gds_encode(
                self.gds_format_string(quote_xml(self.Abstract), input_name='Abstract')), namespace_, eol_))
        if self.LegendGraphic is not None:
            self.LegendGraphic.export(outfile, level, namespace_='sld:', name_='LegendGraphic',
                                      pretty_print=pretty_print)
        if self.Filter is not None:
            self.Filter.export(outfile, level, namespace_='ogc:', name_='Filter', pretty_print=pretty_print)
        if self.ElseFilter is not None:
            self.ElseFilter.export(outfile, level, namespace_='sld:', name_='ElseFilter',
                                   pretty_print=pretty_print)
        if self.MinScaleDenominator is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMinScaleDenominator>%s</%sMinScaleDenominator>%s' % (
            namespace_, self.gds_format_double(self.MinScaleDenominator, input_name='MinScaleDenominator'),
            namespace_, eol_))
        if self.MaxScaleDenominator is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMaxScaleDenominator>%s</%sMaxScaleDenominator>%s' % (
            namespace_, self.gds_format_double(self.MaxScaleDenominator, input_name='MaxScaleDenominator'),
            namespace_, eol_))
        for Symbolizer_ in self.Symbolizer:
            Symbolizer_.export(outfile, level, namespace_, name_='Symbolizer', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Name':
            Name_ = child_.text
            Name_ = self.gds_validate_string(Name_, node, 'Name')
            self.Name = Name_
        elif nodeName_ == 'Title':
            Title_ = child_.text
            Title_ = self.gds_validate_string(Title_, node, 'Title')
            self.Title = Title_
        elif nodeName_ == 'Abstract':
            Abstract_ = child_.text
            Abstract_ = self.gds_validate_string(Abstract_, node, 'Abstract')
            self.Abstract = Abstract_
        elif nodeName_ == 'LegendGraphic':
            obj_ = LegendGraphic.factory()
            obj_.build(child_)
            self.LegendGraphic = obj_
            obj_.original_tagname_ = 'LegendGraphic'
        elif nodeName_ == 'Filter':
            obj_ = FilterType.factory()
            obj_.build(child_)
            self.Filter = obj_
            obj_.original_tagname_ = 'Filter'
        elif nodeName_ == 'ElseFilter':
            obj_ = ElseFilter.factory()
            obj_.build(child_)
            self.ElseFilter = obj_
            obj_.original_tagname_ = 'ElseFilter'
        elif nodeName_ == 'MinScaleDenominator':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'MinScaleDenominator')
            self.MinScaleDenominator = fval_
        elif nodeName_ == 'MaxScaleDenominator':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'MaxScaleDenominator')
            self.MaxScaleDenominator = fval_
        elif nodeName_ == 'Symbolizer':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <Symbolizer> element')
            self.Symbolizer.append(obj_)
            obj_.original_tagname_ = 'Symbolizer'
        elif nodeName_ == 'LineSymbolizer':
            obj_ = LineSymbolizer.factory()
            obj_.build(child_)
            self.Symbolizer.append(obj_)
            obj_.original_tagname_ = 'LineSymbolizer'
        elif nodeName_ == 'PolygonSymbolizer':
            obj_ = PolygonSymbolizer.factory()
            obj_.build(child_)
            self.Symbolizer.append(obj_)
            obj_.original_tagname_ = 'PolygonSymbolizer'
        elif nodeName_ == 'PointSymbolizer':
            obj_ = PointSymbolizer.factory()
            obj_.build(child_)
            self.Symbolizer.append(obj_)
            obj_.original_tagname_ = 'PointSymbolizer'
        elif nodeName_ == 'TextSymbolizer':
            obj_ = TextSymbolizer.factory()
            obj_.build(child_)
            self.Symbolizer.append(obj_)
            obj_.original_tagname_ = 'TextSymbolizer'
        elif nodeName_ == 'RasterSymbolizer':
            obj_ = RasterSymbolizer.factory()
            obj_.build(child_)
            self.Symbolizer.append(obj_)
            obj_.original_tagname_ = 'RasterSymbolizer'


# end class Rule


class LegendGraphic(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, Graphic=None):
        self.original_tagname_ = None
        self.Graphic = Graphic

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LegendGraphic)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LegendGraphic.subclass:
            return LegendGraphic.subclass(*args_, **kwargs_)
        else:
            return LegendGraphic(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Graphic(self):
        return self.Graphic

    def set_Graphic(self, Graphic):
        self.Graphic = Graphic

    def hasContent_(self):
        if (
                    self.Graphic is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LegendGraphic',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LegendGraphic')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LegendGraphic')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LegendGraphic',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='LegendGraphic'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LegendGraphic', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Graphic is not None:
            self.Graphic.export(outfile, level, namespace_='sld:', name_='Graphic', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Graphic':
            obj_ = Graphic.factory()
            obj_.build(child_)
            self.Graphic = obj_
            obj_.original_tagname_ = 'Graphic'


# end class LegendGraphic


class ElseFilter(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self):
        self.original_tagname_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ElseFilter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ElseFilter.subclass:
            return ElseFilter.subclass(*args_, **kwargs_)
        else:
            return ElseFilter(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='ElseFilter',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ElseFilter')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ElseFilter')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='ElseFilter',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='ElseFilter'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='ElseFilter', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class ElseFilter


class SymbolizerType(GeneratedsSuper):
    """A "SymbolizerType" is an abstract type for encoding the graphical
    properties used to portray geographic information. Concrete
    symbol types are derived from this base type."""
    subclass = None
    superclass = None

    def __init__(self, extensiontype_=None):
        self.original_tagname_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SymbolizerType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SymbolizerType.subclass:
            return SymbolizerType.subclass(*args_, **kwargs_)
        else:
            return SymbolizerType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='SymbolizerType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SymbolizerType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SymbolizerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='SymbolizerType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='SymbolizerType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='SymbolizerType', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class SymbolizerType


class LineSymbolizer(SymbolizerType):
    """A LineSymbolizer is used to render a "stroke" along a linear
    geometry."""
    subclass = None
    superclass = SymbolizerType

    def __init__(self, Geometry=None, Stroke=None):
        self.original_tagname_ = None
        super(LineSymbolizer, self).__init__()
        self.Geometry = Geometry
        self.Stroke = Stroke

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LineSymbolizer)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LineSymbolizer.subclass:
            return LineSymbolizer.subclass(*args_, **kwargs_)
        else:
            return LineSymbolizer(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Geometry(self):
        return self.Geometry

    def set_Geometry(self, Geometry):
        self.Geometry = Geometry

    def get_Stroke(self):
        return self.Stroke

    def set_Stroke(self, Stroke):
        self.Stroke = Stroke

    def hasContent_(self):
        if (
                            self.Geometry is not None or
                            self.Stroke is not None or
                    super(LineSymbolizer, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LineSymbolizer',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LineSymbolizer')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LineSymbolizer')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LineSymbolizer',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='LineSymbolizer'):
        super(LineSymbolizer, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                     name_='LineSymbolizer')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LineSymbolizer', fromsubclass_=False,
                       pretty_print=True):
        super(LineSymbolizer, self).exportChildren(outfile, level, namespace_, name_, True,
                                                   pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Geometry is not None:
            self.Geometry.export(outfile, level, namespace_='sld:', name_='Geometry',
                                 pretty_print=pretty_print)
        if self.Stroke is not None:
            self.Stroke.export(outfile, level, namespace_='sld:', name_='Stroke', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(LineSymbolizer, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Geometry':
            obj_ = Geometry.factory()
            obj_.build(child_)
            self.Geometry = obj_
            obj_.original_tagname_ = 'Geometry'
        elif nodeName_ == 'Stroke':
            obj_ = Stroke.factory()
            obj_.build(child_)
            self.Stroke = obj_
            obj_.original_tagname_ = 'Stroke'
        super(LineSymbolizer, self).buildChildren(child_, node, nodeName_, True)


# end class LineSymbolizer


class Geometry(GeneratedsSuper):
    """A Geometry gives reference to a (the) geometry property of a feature
    to be used for rendering."""
    subclass = None
    superclass = None

    def __init__(self, PropertyName=None):
        self.original_tagname_ = None
        self.PropertyName = PropertyName

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Geometry)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Geometry.subclass:
            return Geometry.subclass(*args_, **kwargs_)
        else:
            return Geometry(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_PropertyName(self):
        return self.PropertyName

    def set_PropertyName(self, PropertyName):
        self.PropertyName = PropertyName

    def hasContent_(self):
        if (
                    self.PropertyName is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='Geometry',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Geometry')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Geometry')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='Geometry',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='Geometry'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='Geometry', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PropertyName is not None:
            self.PropertyName.export(outfile, level, namespace_='ogc:', name_='PropertyName',
                                     pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PropertyName':
            obj_ = PropertyNameType.factory()
            obj_.build(child_)
            self.PropertyName = obj_
            obj_.original_tagname_ = 'PropertyName'


# end class Geometry


class Stroke(GeneratedsSuper):
    """A "Stroke" specifies the appearance of a linear geometry. It is
    defined in parallel with SVG strokes. The following
    CssParameters may be used: "stroke" (color), "stroke-opacity",
    "stroke-width", "stroke-linejoin", "stroke-linecap", "stroke-
    dasharray", and "stroke-dashoffset"."""
    subclass = None
    superclass = None

    def __init__(self, GraphicFill=None, GraphicStroke=None, CssParameter=None):
        self.original_tagname_ = None
        self.GraphicFill = GraphicFill
        self.GraphicStroke = GraphicStroke
        if CssParameter is None:
            self.CssParameter = []
        else:
            self.CssParameter = CssParameter

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Stroke)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Stroke.subclass:
            return Stroke.subclass(*args_, **kwargs_)
        else:
            return Stroke(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_GraphicFill(self):
        return self.GraphicFill

    def set_GraphicFill(self, GraphicFill):
        self.GraphicFill = GraphicFill

    def get_GraphicStroke(self):
        return self.GraphicStroke

    def set_GraphicStroke(self, GraphicStroke):
        self.GraphicStroke = GraphicStroke

    def get_CssParameter(self):
        return self.CssParameter

    def set_CssParameter(self, CssParameter):
        self.CssParameter = CssParameter

    def add_CssParameter(self, value):
        self.CssParameter.append(value)

    def insert_CssParameter_at(self, index, value):
        self.CssParameter.insert(index, value)

    def replace_CssParameter_at(self, index, value):
        self.CssParameter[index] = value

    def hasContent_(self):
        if (
                            self.GraphicFill is not None or
                            self.GraphicStroke is not None or
                    self.CssParameter
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='Stroke',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Stroke')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Stroke')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='Stroke',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='Stroke'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='Stroke', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.GraphicFill is not None:
            self.GraphicFill.export(outfile, level, namespace_='sld:', name_='GraphicFill',
                                    pretty_print=pretty_print)
        if self.GraphicStroke is not None:
            self.GraphicStroke.export(outfile, level, namespace_='sld:', name_='GraphicStroke',
                                      pretty_print=pretty_print)
        for CssParameter_ in self.CssParameter:
            CssParameter_.export(outfile, level, namespace_='sld:', name_='CssParameter',
                                 pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'GraphicFill':
            obj_ = GraphicFill.factory()
            obj_.build(child_)
            self.GraphicFill = obj_
            obj_.original_tagname_ = 'GraphicFill'
        elif nodeName_ == 'GraphicStroke':
            obj_ = GraphicStroke.factory()
            obj_.build(child_)
            self.GraphicStroke = obj_
            obj_.original_tagname_ = 'GraphicStroke'
        elif nodeName_ == 'CssParameter':
            obj_ = CssParameter.factory()
            obj_.build(child_)
            self.CssParameter.append(obj_)
            obj_.original_tagname_ = 'CssParameter'


# end class Stroke


class ParameterValueType(GeneratedsSuper):
    """The "ParameterValueType" uses WFS-Filter expressions to give values
    for SLD graphic parameters. A "mixed" element-content model is
    used with textual substitution for values."""
    subclass = None
    superclass = None

    def __init__(self, expression=None, valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None):
        self.original_tagname_ = None
        if expression is None:
            self.expression = []
        else:
            self.expression = expression
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParameterValueType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParameterValueType.subclass:
            return ParameterValueType.subclass(*args_, **kwargs_)
        else:
            return ParameterValueType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_expression(self):
        return self.expression

    def set_expression(self, expression):
        self.expression = expression

    def add_expression(self, value):
        self.expression.append(value)

    def insert_expression_at(self, index, value):
        self.expression.insert(index, value)

    def replace_expression_at(self, index, value):
        self.expression[index] = value

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if (
                    self.expression or
                    1 if type(self.valueOf_) in [int, float] else self.valueOf_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='ParameterValueType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParameterValueType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ParameterValueType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='ParameterValueType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='ParameterValueType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='ParameterValueType',
                       fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'expression':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <expression> element')
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'expression', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_expression'):
                self.add_expression(obj_.value)
            elif hasattr(self, 'set_expression'):
                self.set_expression(obj_.value)
        elif nodeName_ == 'Add':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Add', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Add'):
                self.add_Add(obj_.value)
            elif hasattr(self, 'set_Add'):
                self.set_Add(obj_.value)
        elif nodeName_ == 'Sub':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Sub'):
                self.add_Sub(obj_.value)
            elif hasattr(self, 'set_Sub'):
                self.set_Sub(obj_.value)
        elif nodeName_ == 'Mul':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Mul', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Mul'):
                self.add_Mul(obj_.value)
            elif hasattr(self, 'set_Mul'):
                self.set_Mul(obj_.value)
        elif nodeName_ == 'Div':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Div', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Div'):
                self.add_Div(obj_.value)
            elif hasattr(self, 'set_Div'):
                self.set_Div(obj_.value)
        elif nodeName_ == 'PropertyName':
            obj_ = PropertyNameType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'PropertyName', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_PropertyName'):
                self.add_PropertyName(obj_.value)
            elif hasattr(self, 'set_PropertyName'):
                self.set_PropertyName(obj_.value)
        elif nodeName_ == 'Function':
            obj_ = FunctionType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Function', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Function'):
                self.add_Function(obj_.value)
            elif hasattr(self, 'set_Function'):
                self.set_Function(obj_.value)
        elif nodeName_ == 'Literal':
            obj_ = LiteralType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Literal', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Literal'):
                self.add_Literal(obj_.value)
            elif hasattr(self, 'set_Literal'):
                self.set_Literal(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)


# end class ParameterValueType


class GraphicFill(GeneratedsSuper):
    """A "GraphicFill" defines repeated-graphic filling (stippling) pattern
    for an area geometry."""
    subclass = None
    superclass = None

    def __init__(self, Graphic=None):
        self.original_tagname_ = None
        self.Graphic = Graphic

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GraphicFill)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GraphicFill.subclass:
            return GraphicFill.subclass(*args_, **kwargs_)
        else:
            return GraphicFill(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Graphic(self):
        return self.Graphic

    def set_Graphic(self, Graphic):
        self.Graphic = Graphic

    def hasContent_(self):
        if (
                    self.Graphic is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='GraphicFill',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GraphicFill')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GraphicFill')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='GraphicFill',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='GraphicFill'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='GraphicFill', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Graphic is not None:
            self.Graphic.export(outfile, level, namespace_='sld:', name_='Graphic', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Graphic':
            obj_ = Graphic.factory()
            obj_.build(child_)
            self.Graphic = obj_
            obj_.original_tagname_ = 'Graphic'


# end class GraphicFill


class GraphicStroke(GeneratedsSuper):
    """A "GraphicStroke" defines a repated-linear graphic pattern to be
    used for stroking a line."""
    subclass = None
    superclass = None

    def __init__(self, Graphic=None):
        self.original_tagname_ = None
        self.Graphic = Graphic

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GraphicStroke)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GraphicStroke.subclass:
            return GraphicStroke.subclass(*args_, **kwargs_)
        else:
            return GraphicStroke(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Graphic(self):
        return self.Graphic

    def set_Graphic(self, Graphic):
        self.Graphic = Graphic

    def hasContent_(self):
        if (
                    self.Graphic is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='GraphicStroke',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GraphicStroke')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GraphicStroke')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='GraphicStroke',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='GraphicStroke'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='GraphicStroke', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Graphic is not None:
            self.Graphic.export(outfile, level, namespace_='sld:', name_='Graphic', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Graphic':
            obj_ = Graphic.factory()
            obj_.build(child_)
            self.Graphic = obj_
            obj_.original_tagname_ = 'Graphic'


# end class GraphicStroke


class PolygonSymbolizer(SymbolizerType):
    """A "PolygonSymbolizer" specifies the rendering of a polygon or area
    geometry, including its interior fill and border stroke."""
    subclass = None
    superclass = SymbolizerType

    def __init__(self, Geometry=None, Fill=None, Stroke=None):
        self.original_tagname_ = None
        super(PolygonSymbolizer, self).__init__()
        self.Geometry = Geometry
        self.Fill = Fill
        self.Stroke = Stroke

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PolygonSymbolizer)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PolygonSymbolizer.subclass:
            return PolygonSymbolizer.subclass(*args_, **kwargs_)
        else:
            return PolygonSymbolizer(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Geometry(self):
        return self.Geometry

    def set_Geometry(self, Geometry):
        self.Geometry = Geometry

    def get_Fill(self):
        return self.Fill

    def set_Fill(self, Fill):
        self.Fill = Fill

    def get_Stroke(self):
        return self.Stroke

    def set_Stroke(self, Stroke):
        self.Stroke = Stroke

    def hasContent_(self):
        if (
                                self.Geometry is not None or
                                self.Fill is not None or
                            self.Stroke is not None or
                    super(PolygonSymbolizer, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='PolygonSymbolizer',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PolygonSymbolizer')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PolygonSymbolizer')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='PolygonSymbolizer',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='PolygonSymbolizer'):
        super(PolygonSymbolizer, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                        name_='PolygonSymbolizer')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='PolygonSymbolizer',
                       fromsubclass_=False, pretty_print=True):
        super(PolygonSymbolizer, self).exportChildren(outfile, level, namespace_, name_, True,
                                                      pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Geometry is not None:
            self.Geometry.export(outfile, level, namespace_='sld:', name_='Geometry',
                                 pretty_print=pretty_print)
        if self.Fill is not None:
            self.Fill.export(outfile, level, namespace_='sld:', name_='Fill', pretty_print=pretty_print)
        if self.Stroke is not None:
            self.Stroke.export(outfile, level, namespace_='sld:', name_='Stroke', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(PolygonSymbolizer, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Geometry':
            obj_ = Geometry.factory()
            obj_.build(child_)
            self.Geometry = obj_
            obj_.original_tagname_ = 'Geometry'
        elif nodeName_ == 'Fill':
            obj_ = Fill.factory()
            obj_.build(child_)
            self.Fill = obj_
            obj_.original_tagname_ = 'Fill'
        elif nodeName_ == 'Stroke':
            obj_ = Stroke.factory()
            obj_.build(child_)
            self.Stroke = obj_
            obj_.original_tagname_ = 'Stroke'
        super(PolygonSymbolizer, self).buildChildren(child_, node, nodeName_, True)


# end class PolygonSymbolizer


class Fill(GeneratedsSuper):
    """A "Fill" specifies the pattern for filling an area geometry. The
    allowed CssParameters are: "fill" (color) and "fill-opacity"."""
    subclass = None
    superclass = None

    def __init__(self, GraphicFill=None, CssParameter=None):
        self.original_tagname_ = None
        self.GraphicFill = GraphicFill
        if CssParameter is None:
            self.CssParameter = []
        else:
            self.CssParameter = CssParameter

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Fill)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Fill.subclass:
            return Fill.subclass(*args_, **kwargs_)
        else:
            return Fill(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_GraphicFill(self):
        return self.GraphicFill

    def set_GraphicFill(self, GraphicFill):
        self.GraphicFill = GraphicFill

    def get_CssParameter(self):
        return self.CssParameter

    def set_CssParameter(self, CssParameter):
        self.CssParameter = CssParameter

    def add_CssParameter(self, value):
        self.CssParameter.append(value)

    def insert_CssParameter_at(self, index, value):
        self.CssParameter.insert(index, value)

    def replace_CssParameter_at(self, index, value):
        self.CssParameter[index] = value

    def hasContent_(self):
        if (
                        self.GraphicFill is not None or
                    self.CssParameter
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='Fill',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Fill')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Fill')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='Fill',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='Fill'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='Fill', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.GraphicFill is not None:
            self.GraphicFill.export(outfile, level, namespace_='sld:', name_='GraphicFill',
                                    pretty_print=pretty_print)
        for CssParameter_ in self.CssParameter:
            CssParameter_.export(outfile, level, namespace_='sld:', name_='CssParameter',
                                 pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'GraphicFill':
            obj_ = GraphicFill.factory()
            obj_.build(child_)
            self.GraphicFill = obj_
            obj_.original_tagname_ = 'GraphicFill'
        elif nodeName_ == 'CssParameter':
            obj_ = CssParameter.factory()
            obj_.build(child_)
            self.CssParameter.append(obj_)
            obj_.original_tagname_ = 'CssParameter'


# end class Fill


class PointSymbolizer(SymbolizerType):
    """A "PointSymbolizer" specifies the rendering of a "graphic symbol" at
    a point."""
    subclass = None
    superclass = SymbolizerType

    def __init__(self, Geometry=None, Graphic=None):
        self.original_tagname_ = None
        super(PointSymbolizer, self).__init__()
        self.Geometry = Geometry
        self.Graphic = Graphic

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PointSymbolizer)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PointSymbolizer.subclass:
            return PointSymbolizer.subclass(*args_, **kwargs_)
        else:
            return PointSymbolizer(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Geometry(self):
        return self.Geometry

    def set_Geometry(self, Geometry):
        self.Geometry = Geometry

    def get_Graphic(self):
        return self.Graphic

    def set_Graphic(self, Graphic):
        self.Graphic = Graphic

    def hasContent_(self):
        if (
                            self.Geometry is not None or
                            self.Graphic is not None or
                    super(PointSymbolizer, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='PointSymbolizer',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PointSymbolizer')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PointSymbolizer')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='PointSymbolizer',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='PointSymbolizer'):
        super(PointSymbolizer, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                      name_='PointSymbolizer')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='PointSymbolizer', fromsubclass_=False,
                       pretty_print=True):
        super(PointSymbolizer, self).exportChildren(outfile, level, namespace_, name_, True,
                                                    pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Geometry is not None:
            self.Geometry.export(outfile, level, namespace_='sld:', name_='Geometry',
                                 pretty_print=pretty_print)
        if self.Graphic is not None:
            self.Graphic.export(outfile, level, namespace_='sld:', name_='Graphic', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(PointSymbolizer, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Geometry':
            obj_ = Geometry.factory()
            obj_.build(child_)
            self.Geometry = obj_
            obj_.original_tagname_ = 'Geometry'
        elif nodeName_ == 'Graphic':
            obj_ = Graphic.factory()
            obj_.build(child_)
            self.Graphic = obj_
            obj_.original_tagname_ = 'Graphic'
        super(PointSymbolizer, self).buildChildren(child_, node, nodeName_, True)


# end class PointSymbolizer


class Graphic(GeneratedsSuper):
    """A "Graphic" specifies or refers to a "graphic symbol" with inherent
    shape, size, and coloring."""
    subclass = None
    superclass = None

    def __init__(self, ExternalGraphic=None, Mark=None, Opacity=None, Size=None, Rotation=None):
        self.original_tagname_ = None
        if ExternalGraphic is None:
            self.ExternalGraphic = []
        else:
            self.ExternalGraphic = ExternalGraphic
        if Mark is None:
            self.Mark = []
        else:
            self.Mark = Mark
        self.Opacity = Opacity
        self.Size = Size
        self.Rotation = Rotation

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Graphic)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Graphic.subclass:
            return Graphic.subclass(*args_, **kwargs_)
        else:
            return Graphic(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ExternalGraphic(self):
        return self.ExternalGraphic

    def set_ExternalGraphic(self, ExternalGraphic):
        self.ExternalGraphic = ExternalGraphic

    def add_ExternalGraphic(self, value):
        self.ExternalGraphic.append(value)

    def insert_ExternalGraphic_at(self, index, value):
        self.ExternalGraphic.insert(index, value)

    def replace_ExternalGraphic_at(self, index, value):
        self.ExternalGraphic[index] = value

    def get_Mark(self):
        return self.Mark

    def set_Mark(self, Mark):
        self.Mark = Mark

    def add_Mark(self, value):
        self.Mark.append(value)

    def insert_Mark_at(self, index, value):
        self.Mark.insert(index, value)

    def replace_Mark_at(self, index, value):
        self.Mark[index] = value

    def get_Opacity(self):
        return self.Opacity

    def set_Opacity(self, Opacity):
        self.Opacity = Opacity

    def get_Size(self):
        return self.Size

    def set_Size(self, Size):
        self.Size = Size

    def get_Rotation(self):
        return self.Rotation

    def set_Rotation(self, Rotation):
        self.Rotation = Rotation

    def hasContent_(self):
        if (
                                self.ExternalGraphic or
                                self.Mark or
                                self.Opacity is not None or
                            self.Size is not None or
                        self.Rotation is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='Graphic',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Graphic')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Graphic')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='Graphic',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='Graphic'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='Graphic', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ExternalGraphic_ in self.ExternalGraphic:
            ExternalGraphic_.export(outfile, level, namespace_='sld:', name_='ExternalGraphic',
                                    pretty_print=pretty_print)
        for Mark_ in self.Mark:
            Mark_.export(outfile, level, namespace_='sld:', name_='Mark', pretty_print=pretty_print)
        if self.Opacity is not None:
            self.Opacity.export(outfile, level, namespace_='sld:', name_='Opacity', pretty_print=pretty_print)
        if self.Size is not None:
            self.Size.export(outfile, level, namespace_='sld:', name_='Size', pretty_print=pretty_print)
        if self.Rotation is not None:
            self.Rotation.export(outfile, level, namespace_='sld:', name_='Rotation',
                                 pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ExternalGraphic':
            obj_ = ExternalGraphic.factory()
            obj_.build(child_)
            self.ExternalGraphic.append(obj_)
            obj_.original_tagname_ = 'ExternalGraphic'
        elif nodeName_ == 'Mark':
            obj_ = Mark.factory()
            obj_.build(child_)
            self.Mark.append(obj_)
            obj_.original_tagname_ = 'Mark'
        elif nodeName_ == 'Opacity':
            class_obj_ = self.get_class_obj_(child_, ParameterValueType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Opacity = obj_
            obj_.original_tagname_ = 'Opacity'
        elif nodeName_ == 'Size':
            class_obj_ = self.get_class_obj_(child_, ParameterValueType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Size = obj_
            obj_.original_tagname_ = 'Size'
        elif nodeName_ == 'Rotation':
            class_obj_ = self.get_class_obj_(child_, ParameterValueType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Rotation = obj_
            obj_.original_tagname_ = 'Rotation'


# end class Graphic


class ExternalGraphic(GeneratedsSuper):
    """An "ExternalGraphic" gives a reference to an external raster or
    vector graphical object."""
    subclass = None
    superclass = None

    def __init__(self, OnlineResource=None, Format=None):
        self.original_tagname_ = None
        self.OnlineResource = OnlineResource
        self.Format = Format

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExternalGraphic)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExternalGraphic.subclass:
            return ExternalGraphic.subclass(*args_, **kwargs_)
        else:
            return ExternalGraphic(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_OnlineResource(self):
        return self.OnlineResource

    def set_OnlineResource(self, OnlineResource):
        self.OnlineResource = OnlineResource

    def get_Format(self):
        return self.Format

    def set_Format(self, Format):
        self.Format = Format

    def hasContent_(self):
        if (
                        self.OnlineResource is not None or
                        self.Format is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='ExternalGraphic',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ExternalGraphic')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExternalGraphic')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='ExternalGraphic',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='ExternalGraphic'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='ExternalGraphic', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.OnlineResource is not None:
            self.OnlineResource.export(outfile, level, namespace_='sld:', name_='OnlineResource',
                                       pretty_print=pretty_print)
        if self.Format is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFormat>%s</%sFormat>%s' % (
            'sld:', self.gds_encode(self.gds_format_string(quote_xml(self.Format), input_name='Format')),
            'sld:', eol_))

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'OnlineResource':
            obj_ = OnlineResource.factory()
            obj_.build(child_)
            self.OnlineResource = obj_
            obj_.original_tagname_ = 'OnlineResource'
        elif nodeName_ == 'Format':
            Format_ = child_.text
            Format_ = self.gds_validate_string(Format_, node, 'Format')
            self.Format = Format_


# end class ExternalGraphic


class Mark(GeneratedsSuper):
    """A "Mark" specifies a geometric shape and applies coloring to it."""
    subclass = None
    superclass = None

    def __init__(self, WellKnownName=None, Fill=None, Stroke=None):
        self.original_tagname_ = None
        self.WellKnownName = WellKnownName
        self.Fill = Fill
        self.Stroke = Stroke

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Mark)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Mark.subclass:
            return Mark.subclass(*args_, **kwargs_)
        else:
            return Mark(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_WellKnownName(self):
        return self.WellKnownName

    def set_WellKnownName(self, WellKnownName):
        self.WellKnownName = WellKnownName

    def get_Fill(self):
        return self.Fill

    def set_Fill(self, Fill):
        self.Fill = Fill

    def get_Stroke(self):
        return self.Stroke

    def set_Stroke(self, Stroke):
        self.Stroke = Stroke

    def hasContent_(self):
        if (
                            self.WellKnownName is not None or
                            self.Fill is not None or
                        self.Stroke is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='Mark',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Mark')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Mark')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='Mark',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='Mark'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='Mark', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.WellKnownName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWellKnownName>%s</%sWellKnownName>%s' % (namespace_, self.gds_encode(
                self.gds_format_string(quote_xml(self.WellKnownName), input_name='WellKnownName')),
                                                                       namespace_, eol_))
        if self.Fill is not None:
            self.Fill.export(outfile, level, namespace_='sld:', name_='Fill', pretty_print=pretty_print)
        if self.Stroke is not None:
            self.Stroke.export(outfile, level, namespace_='sld:', name_='Stroke', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'WellKnownName':
            WellKnownName_ = child_.text
            WellKnownName_ = self.gds_validate_string(WellKnownName_, node, 'WellKnownName')
            self.WellKnownName = WellKnownName_
        elif nodeName_ == 'Fill':
            obj_ = Fill.factory()
            obj_.build(child_)
            self.Fill = obj_
            obj_.original_tagname_ = 'Fill'
        elif nodeName_ == 'Stroke':
            obj_ = Stroke.factory()
            obj_.build(child_)
            self.Stroke = obj_
            obj_.original_tagname_ = 'Stroke'


# end class Mark


class TextSymbolizer(SymbolizerType):
    """A "TextSymbolizer" is used to render text labels according to
    various graphical parameters."""
    subclass = None
    superclass = SymbolizerType

    def __init__(self, Geometry=None, Label=None, Font=None, LabelPlacement=None, Halo=None, Fill=None):
        self.original_tagname_ = None
        super(TextSymbolizer, self).__init__()
        self.Geometry = Geometry
        self.Label = Label
        self.Font = Font
        self.LabelPlacement = LabelPlacement
        self.Halo = Halo
        self.Fill = Fill

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TextSymbolizer)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TextSymbolizer.subclass:
            return TextSymbolizer.subclass(*args_, **kwargs_)
        else:
            return TextSymbolizer(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Geometry(self):
        return self.Geometry

    def set_Geometry(self, Geometry):
        self.Geometry = Geometry

    def get_Label(self):
        return self.Label

    def set_Label(self, Label):
        self.Label = Label

    def get_Font(self):
        return self.Font

    def set_Font(self, Font):
        self.Font = Font

    def get_LabelPlacement(self):
        return self.LabelPlacement

    def set_LabelPlacement(self, LabelPlacement):
        self.LabelPlacement = LabelPlacement

    def get_Halo(self):
        return self.Halo

    def set_Halo(self, Halo):
        self.Halo = Halo

    def get_Fill(self):
        return self.Fill

    def set_Fill(self, Fill):
        self.Fill = Fill

    def hasContent_(self):
        if (
                                            self.Geometry is not None or
                                            self.Label is not None or
                                        self.Font is not None or
                                    self.LabelPlacement is not None or
                                self.Halo is not None or
                            self.Fill is not None or
                    super(TextSymbolizer, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='TextSymbolizer',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TextSymbolizer')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TextSymbolizer')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='TextSymbolizer',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='TextSymbolizer'):
        super(TextSymbolizer, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                     name_='TextSymbolizer')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='TextSymbolizer', fromsubclass_=False,
                       pretty_print=True):
        super(TextSymbolizer, self).exportChildren(outfile, level, namespace_, name_, True,
                                                   pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Geometry is not None:
            self.Geometry.export(outfile, level, namespace_='sld:', name_='Geometry',
                                 pretty_print=pretty_print)
        if self.Label is not None:
            self.Label.export(outfile, level, namespace_='sld:', name_='Label', pretty_print=pretty_print)
        if self.Font is not None:
            self.Font.export(outfile, level, namespace_='sld:', name_='Font', pretty_print=pretty_print)
        if self.LabelPlacement is not None:
            self.LabelPlacement.export(outfile, level, namespace_='sld:', name_='LabelPlacement',
                                       pretty_print=pretty_print)
        if self.Halo is not None:
            self.Halo.export(outfile, level, namespace_='sld:', name_='Halo', pretty_print=pretty_print)
        if self.Fill is not None:
            self.Fill.export(outfile, level, namespace_='sld:', name_='Fill', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(TextSymbolizer, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Geometry':
            obj_ = Geometry.factory()
            obj_.build(child_)
            self.Geometry = obj_
            obj_.original_tagname_ = 'Geometry'
        elif nodeName_ == 'Label':
            class_obj_ = self.get_class_obj_(child_, ParameterValueType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Label = obj_
            obj_.original_tagname_ = 'Label'
        elif nodeName_ == 'Font':
            obj_ = Font.factory()
            obj_.build(child_)
            self.Font = obj_
            obj_.original_tagname_ = 'Font'
        elif nodeName_ == 'LabelPlacement':
            obj_ = LabelPlacement.factory()
            obj_.build(child_)
            self.LabelPlacement = obj_
            obj_.original_tagname_ = 'LabelPlacement'
        elif nodeName_ == 'Halo':
            obj_ = Halo.factory()
            obj_.build(child_)
            self.Halo = obj_
            obj_.original_tagname_ = 'Halo'
        elif nodeName_ == 'Fill':
            obj_ = Fill.factory()
            obj_.build(child_)
            self.Fill = obj_
            obj_.original_tagname_ = 'Fill'
        super(TextSymbolizer, self).buildChildren(child_, node, nodeName_, True)


# end class TextSymbolizer


class Font(GeneratedsSuper):
    """A "Font" element specifies the text font to use. The allowed
    CssParameters are: "font-family", "font-style", "font-weight",
    and "font-size"."""
    subclass = None
    superclass = None

    def __init__(self, CssParameter=None):
        self.original_tagname_ = None
        if CssParameter is None:
            self.CssParameter = []
        else:
            self.CssParameter = CssParameter

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Font)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Font.subclass:
            return Font.subclass(*args_, **kwargs_)
        else:
            return Font(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_CssParameter(self):
        return self.CssParameter

    def set_CssParameter(self, CssParameter):
        self.CssParameter = CssParameter

    def add_CssParameter(self, value):
        self.CssParameter.append(value)

    def insert_CssParameter_at(self, index, value):
        self.CssParameter.insert(index, value)

    def replace_CssParameter_at(self, index, value):
        self.CssParameter[index] = value

    def hasContent_(self):
        if (
                self.CssParameter
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='Font',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Font')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Font')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='Font',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='Font'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='Font', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for CssParameter_ in self.CssParameter:
            CssParameter_.export(outfile, level, namespace_='sld:', name_='CssParameter',
                                 pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CssParameter':
            obj_ = CssParameter.factory()
            obj_.build(child_)
            self.CssParameter.append(obj_)
            obj_.original_tagname_ = 'CssParameter'


# end class Font


class LabelPlacement(GeneratedsSuper):
    """The "LabelPlacement" specifies where and how a text label should be
    rendered relative to a geometry. The present mechanism is poorly
    aligned with CSS/SVG."""
    subclass = None
    superclass = None

    def __init__(self, PointPlacement=None, LinePlacement=None):
        self.original_tagname_ = None
        self.PointPlacement = PointPlacement
        self.LinePlacement = LinePlacement

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LabelPlacement)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LabelPlacement.subclass:
            return LabelPlacement.subclass(*args_, **kwargs_)
        else:
            return LabelPlacement(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_PointPlacement(self):
        return self.PointPlacement

    def set_PointPlacement(self, PointPlacement):
        self.PointPlacement = PointPlacement

    def get_LinePlacement(self):
        return self.LinePlacement

    def set_LinePlacement(self, LinePlacement):
        self.LinePlacement = LinePlacement

    def hasContent_(self):
        if (
                        self.PointPlacement is not None or
                        self.LinePlacement is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LabelPlacement',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LabelPlacement')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LabelPlacement')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LabelPlacement',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='LabelPlacement'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LabelPlacement', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PointPlacement is not None:
            self.PointPlacement.export(outfile, level, namespace_='sld:', name_='PointPlacement',
                                       pretty_print=pretty_print)
        if self.LinePlacement is not None:
            self.LinePlacement.export(outfile, level, namespace_='sld:', name_='LinePlacement',
                                      pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PointPlacement':
            obj_ = PointPlacement.factory()
            obj_.build(child_)
            self.PointPlacement = obj_
            obj_.original_tagname_ = 'PointPlacement'
        elif nodeName_ == 'LinePlacement':
            obj_ = LinePlacement.factory()
            obj_.build(child_)
            self.LinePlacement = obj_
            obj_.original_tagname_ = 'LinePlacement'


# end class LabelPlacement


class PointPlacement(GeneratedsSuper):
    """A "PointPlacement" specifies how a text label should be rendered
    relative to a geometric point."""
    subclass = None
    superclass = None

    def __init__(self, AnchorPoint=None, Displacement=None, Rotation=None):
        self.original_tagname_ = None
        self.AnchorPoint = AnchorPoint
        self.Displacement = Displacement
        self.Rotation = Rotation

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PointPlacement)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PointPlacement.subclass:
            return PointPlacement.subclass(*args_, **kwargs_)
        else:
            return PointPlacement(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_AnchorPoint(self):
        return self.AnchorPoint

    def set_AnchorPoint(self, AnchorPoint):
        self.AnchorPoint = AnchorPoint

    def get_Displacement(self):
        return self.Displacement

    def set_Displacement(self, Displacement):
        self.Displacement = Displacement

    def get_Rotation(self):
        return self.Rotation

    def set_Rotation(self, Rotation):
        self.Rotation = Rotation

    def hasContent_(self):
        if (
                            self.AnchorPoint is not None or
                            self.Displacement is not None or
                        self.Rotation is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='PointPlacement',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PointPlacement')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PointPlacement')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='PointPlacement',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='PointPlacement'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='PointPlacement', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AnchorPoint is not None:
            self.AnchorPoint.export(outfile, level, namespace_='sld:', name_='AnchorPoint',
                                    pretty_print=pretty_print)
        if self.Displacement is not None:
            self.Displacement.export(outfile, level, namespace_='sld:', name_='Displacement',
                                     pretty_print=pretty_print)
        if self.Rotation is not None:
            self.Rotation.export(outfile, level, namespace_='sld:', name_='Rotation',
                                 pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AnchorPoint':
            obj_ = AnchorPoint.factory()
            obj_.build(child_)
            self.AnchorPoint = obj_
            obj_.original_tagname_ = 'AnchorPoint'
        elif nodeName_ == 'Displacement':
            obj_ = Displacement.factory()
            obj_.build(child_)
            self.Displacement = obj_
            obj_.original_tagname_ = 'Displacement'
        elif nodeName_ == 'Rotation':
            class_obj_ = self.get_class_obj_(child_, ParameterValueType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Rotation = obj_
            obj_.original_tagname_ = 'Rotation'


# end class PointPlacement


class AnchorPoint(GeneratedsSuper):
    """An "AnchorPoint" identifies the location inside of a text label to
    use an an 'anchor' for positioning it relative to a point
    geometry."""
    subclass = None
    superclass = None

    def __init__(self, AnchorPointX=None, AnchorPointY=None):
        self.original_tagname_ = None
        self.AnchorPointX = AnchorPointX
        self.AnchorPointY = AnchorPointY

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AnchorPoint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AnchorPoint.subclass:
            return AnchorPoint.subclass(*args_, **kwargs_)
        else:
            return AnchorPoint(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_AnchorPointX(self):
        return self.AnchorPointX

    def set_AnchorPointX(self, AnchorPointX):
        self.AnchorPointX = AnchorPointX

    def get_AnchorPointY(self):
        return self.AnchorPointY

    def set_AnchorPointY(self, AnchorPointY):
        self.AnchorPointY = AnchorPointY

    def hasContent_(self):
        if (
                        self.AnchorPointX is not None or
                        self.AnchorPointY is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='AnchorPoint',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AnchorPoint')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AnchorPoint')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='AnchorPoint',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='AnchorPoint'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='AnchorPoint', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AnchorPointX is not None:
            self.AnchorPointX.export(outfile, level, namespace_='sld:', name_='AnchorPointX',
                                     pretty_print=pretty_print)
        if self.AnchorPointY is not None:
            self.AnchorPointY.export(outfile, level, namespace_='sld:', name_='AnchorPointY',
                                     pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AnchorPointX':
            class_obj_ = self.get_class_obj_(child_, ParameterValueType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.AnchorPointX = obj_
            obj_.original_tagname_ = 'AnchorPointX'
        elif nodeName_ == 'AnchorPointY':
            class_obj_ = self.get_class_obj_(child_, ParameterValueType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.AnchorPointY = obj_
            obj_.original_tagname_ = 'AnchorPointY'


# end class AnchorPoint


class Displacement(GeneratedsSuper):
    """A "Displacement" gives X and Y offset displacements to use for
    rendering a text label near a point."""
    subclass = None
    superclass = None

    def __init__(self, DisplacementX=None, DisplacementY=None):
        self.original_tagname_ = None
        self.DisplacementX = DisplacementX
        self.DisplacementY = DisplacementY

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Displacement)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Displacement.subclass:
            return Displacement.subclass(*args_, **kwargs_)
        else:
            return Displacement(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_DisplacementX(self):
        return self.DisplacementX

    def set_DisplacementX(self, DisplacementX):
        self.DisplacementX = DisplacementX

    def get_DisplacementY(self):
        return self.DisplacementY

    def set_DisplacementY(self, DisplacementY):
        self.DisplacementY = DisplacementY

    def hasContent_(self):
        if (
                        self.DisplacementX is not None or
                        self.DisplacementY is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='Displacement',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Displacement')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Displacement')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='Displacement',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='Displacement'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='Displacement', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.DisplacementX is not None:
            self.DisplacementX.export(outfile, level, namespace_='sld:', name_='DisplacementX',
                                      pretty_print=pretty_print)
        if self.DisplacementY is not None:
            self.DisplacementY.export(outfile, level, namespace_='sld:', name_='DisplacementY',
                                      pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DisplacementX':
            class_obj_ = self.get_class_obj_(child_, ParameterValueType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.DisplacementX = obj_
            obj_.original_tagname_ = 'DisplacementX'
        elif nodeName_ == 'DisplacementY':
            class_obj_ = self.get_class_obj_(child_, ParameterValueType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.DisplacementY = obj_
            obj_.original_tagname_ = 'DisplacementY'


# end class Displacement


class LinePlacement(GeneratedsSuper):
    """A "LinePlacement" specifies how a text label should be rendered
    relative to a linear geometry."""
    subclass = None
    superclass = None

    def __init__(self, PerpendicularOffset=None):
        self.original_tagname_ = None
        self.PerpendicularOffset = PerpendicularOffset

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LinePlacement)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LinePlacement.subclass:
            return LinePlacement.subclass(*args_, **kwargs_)
        else:
            return LinePlacement(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_PerpendicularOffset(self):
        return self.PerpendicularOffset

    def set_PerpendicularOffset(self, PerpendicularOffset):
        self.PerpendicularOffset = PerpendicularOffset

    def hasContent_(self):
        if (
                    self.PerpendicularOffset is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LinePlacement',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LinePlacement')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinePlacement')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LinePlacement',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='LinePlacement'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LinePlacement', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PerpendicularOffset is not None:
            self.PerpendicularOffset.export(outfile, level, namespace_='sld:', name_='PerpendicularOffset',
                                            pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PerpendicularOffset':
            class_obj_ = self.get_class_obj_(child_, ParameterValueType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.PerpendicularOffset = obj_
            obj_.original_tagname_ = 'PerpendicularOffset'


# end class LinePlacement


class Halo(GeneratedsSuper):
    """A "Halo" fills an extended area outside the glyphs of a rendered
    text label to make the label easier to read over a background."""
    subclass = None
    superclass = None

    def __init__(self, Radius=None, Fill=None):
        self.original_tagname_ = None
        self.Radius = Radius
        self.Fill = Fill

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Halo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Halo.subclass:
            return Halo.subclass(*args_, **kwargs_)
        else:
            return Halo(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Radius(self):
        return self.Radius

    def set_Radius(self, Radius):
        self.Radius = Radius

    def get_Fill(self):
        return self.Fill

    def set_Fill(self, Fill):
        self.Fill = Fill

    def hasContent_(self):
        if (
                        self.Radius is not None or
                        self.Fill is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='Halo',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Halo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Halo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='Halo',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='Halo'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='Halo', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Radius is not None:
            self.Radius.export(outfile, level, namespace_='sld:', name_='Radius', pretty_print=pretty_print)
        if self.Fill is not None:
            self.Fill.export(outfile, level, namespace_='sld:', name_='Fill', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Radius':
            class_obj_ = self.get_class_obj_(child_, ParameterValueType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Radius = obj_
            obj_.original_tagname_ = 'Radius'
        elif nodeName_ == 'Fill':
            obj_ = Fill.factory()
            obj_.build(child_)
            self.Fill = obj_
            obj_.original_tagname_ = 'Fill'


# end class Halo


class RasterSymbolizer(SymbolizerType):
    """A "RasterSymbolizer" is used to specify the rendering of raster/
    matrix-coverage data (e.g., satellite images, DEMs)."""
    subclass = None
    superclass = SymbolizerType

    def __init__(self, Geometry=None, Opacity=None, ChannelSelection=None, OverlapBehavior=None,
                 ColorMap=None, ContrastEnhancement=None, ShadedRelief=None, ImageOutline=None):
        self.original_tagname_ = None
        super(RasterSymbolizer, self).__init__()
        self.Geometry = Geometry
        self.Opacity = Opacity
        self.ChannelSelection = ChannelSelection
        self.OverlapBehavior = OverlapBehavior
        self.ColorMap = ColorMap
        self.ContrastEnhancement = ContrastEnhancement
        self.ShadedRelief = ShadedRelief
        self.ImageOutline = ImageOutline

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RasterSymbolizer)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RasterSymbolizer.subclass:
            return RasterSymbolizer.subclass(*args_, **kwargs_)
        else:
            return RasterSymbolizer(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Geometry(self):
        return self.Geometry

    def set_Geometry(self, Geometry):
        self.Geometry = Geometry

    def get_Opacity(self):
        return self.Opacity

    def set_Opacity(self, Opacity):
        self.Opacity = Opacity

    def get_ChannelSelection(self):
        return self.ChannelSelection

    def set_ChannelSelection(self, ChannelSelection):
        self.ChannelSelection = ChannelSelection

    def get_OverlapBehavior(self):
        return self.OverlapBehavior

    def set_OverlapBehavior(self, OverlapBehavior):
        self.OverlapBehavior = OverlapBehavior

    def get_ColorMap(self):
        return self.ColorMap

    def set_ColorMap(self, ColorMap):
        self.ColorMap = ColorMap

    def get_ContrastEnhancement(self):
        return self.ContrastEnhancement

    def set_ContrastEnhancement(self, ContrastEnhancement):
        self.ContrastEnhancement = ContrastEnhancement

    def get_ShadedRelief(self):
        return self.ShadedRelief

    def set_ShadedRelief(self, ShadedRelief):
        self.ShadedRelief = ShadedRelief

    def get_ImageOutline(self):
        return self.ImageOutline

    def set_ImageOutline(self, ImageOutline):
        self.ImageOutline = ImageOutline

    def hasContent_(self):
        if (
                                                    self.Geometry is not None or
                                                    self.Opacity is not None or
                                                self.ChannelSelection is not None or
                                            self.OverlapBehavior is not None or
                                        self.ColorMap is not None or
                                    self.ContrastEnhancement is not None or
                                self.ShadedRelief is not None or
                            self.ImageOutline is not None or
                    super(RasterSymbolizer, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='RasterSymbolizer',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RasterSymbolizer')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RasterSymbolizer')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='RasterSymbolizer',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='RasterSymbolizer'):
        super(RasterSymbolizer, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                       name_='RasterSymbolizer')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='RasterSymbolizer', fromsubclass_=False,
                       pretty_print=True):
        super(RasterSymbolizer, self).exportChildren(outfile, level, namespace_, name_, True,
                                                     pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Geometry is not None:
            self.Geometry.export(outfile, level, namespace_='sld:', name_='Geometry',
                                 pretty_print=pretty_print)
        if self.Opacity is not None:
            self.Opacity.export(outfile, level, namespace_='sld:', name_='Opacity', pretty_print=pretty_print)
        if self.ChannelSelection is not None:
            self.ChannelSelection.export(outfile, level, namespace_='sld:', name_='ChannelSelection',
                                         pretty_print=pretty_print)
        if self.OverlapBehavior is not None:
            self.OverlapBehavior.export(outfile, level, namespace_='sld:', name_='OverlapBehavior',
                                        pretty_print=pretty_print)
        if self.ColorMap is not None:
            self.ColorMap.export(outfile, level, namespace_='sld:', name_='ColorMap',
                                 pretty_print=pretty_print)
        if self.ContrastEnhancement is not None:
            self.ContrastEnhancement.export(outfile, level, namespace_='sld:', name_='ContrastEnhancement',
                                            pretty_print=pretty_print)
        if self.ShadedRelief is not None:
            self.ShadedRelief.export(outfile, level, namespace_='sld:', name_='ShadedRelief',
                                     pretty_print=pretty_print)
        if self.ImageOutline is not None:
            self.ImageOutline.export(outfile, level, namespace_='sld:', name_='ImageOutline',
                                     pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(RasterSymbolizer, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Geometry':
            obj_ = Geometry.factory()
            obj_.build(child_)
            self.Geometry = obj_
            obj_.original_tagname_ = 'Geometry'
        elif nodeName_ == 'Opacity':
            class_obj_ = self.get_class_obj_(child_, ParameterValueType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Opacity = obj_
            obj_.original_tagname_ = 'Opacity'
        elif nodeName_ == 'ChannelSelection':
            obj_ = ChannelSelection.factory()
            obj_.build(child_)
            self.ChannelSelection = obj_
            obj_.original_tagname_ = 'ChannelSelection'
        elif nodeName_ == 'OverlapBehavior':
            obj_ = OverlapBehavior.factory()
            obj_.build(child_)
            self.OverlapBehavior = obj_
            obj_.original_tagname_ = 'OverlapBehavior'
        elif nodeName_ == 'ColorMap':
            obj_ = ColorMap.factory()
            obj_.build(child_)
            self.ColorMap = obj_
            obj_.original_tagname_ = 'ColorMap'
        elif nodeName_ == 'ContrastEnhancement':
            obj_ = ContrastEnhancement.factory()
            obj_.build(child_)
            self.ContrastEnhancement = obj_
            obj_.original_tagname_ = 'ContrastEnhancement'
        elif nodeName_ == 'ShadedRelief':
            obj_ = ShadedRelief.factory()
            obj_.build(child_)
            self.ShadedRelief = obj_
            obj_.original_tagname_ = 'ShadedRelief'
        elif nodeName_ == 'ImageOutline':
            obj_ = ImageOutline.factory()
            obj_.build(child_)
            self.ImageOutline = obj_
            obj_.original_tagname_ = 'ImageOutline'
        super(RasterSymbolizer, self).buildChildren(child_, node, nodeName_, True)


# end class RasterSymbolizer


class ChannelSelection(GeneratedsSuper):
    """ "ChannelSelection" specifies the false-color channel selection for a
    multi-spectral raster source. """
    subclass = None
    superclass = None

    def __init__(self, RedChannel=None, GreenChannel=None, BlueChannel=None, GrayChannel=None):
        self.original_tagname_ = None
        self.RedChannel = RedChannel
        self.GreenChannel = GreenChannel
        self.BlueChannel = BlueChannel
        self.GrayChannel = GrayChannel

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelSelection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelSelection.subclass:
            return ChannelSelection.subclass(*args_, **kwargs_)
        else:
            return ChannelSelection(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_RedChannel(self):
        return self.RedChannel

    def set_RedChannel(self, RedChannel):
        self.RedChannel = RedChannel

    def get_GreenChannel(self):
        return self.GreenChannel

    def set_GreenChannel(self, GreenChannel):
        self.GreenChannel = GreenChannel

    def get_BlueChannel(self):
        return self.BlueChannel

    def set_BlueChannel(self, BlueChannel):
        self.BlueChannel = BlueChannel

    def get_GrayChannel(self):
        return self.GrayChannel

    def set_GrayChannel(self, GrayChannel):
        self.GrayChannel = GrayChannel

    def hasContent_(self):
        if (
                                self.RedChannel is not None or
                                self.GreenChannel is not None or
                            self.BlueChannel is not None or
                        self.GrayChannel is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='ChannelSelection',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ChannelSelection')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelSelection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='ChannelSelection',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='ChannelSelection'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='ChannelSelection', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.RedChannel is not None:
            self.RedChannel.export(outfile, level, namespace_='sld:', name_='RedChannel',
                                   pretty_print=pretty_print)
        if self.GreenChannel is not None:
            self.GreenChannel.export(outfile, level, namespace_='sld:', name_='GreenChannel',
                                     pretty_print=pretty_print)
        if self.BlueChannel is not None:
            self.BlueChannel.export(outfile, level, namespace_='sld:', name_='BlueChannel',
                                    pretty_print=pretty_print)
        if self.GrayChannel is not None:
            self.GrayChannel.export(outfile, level, namespace_='sld:', name_='GrayChannel',
                                    pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'RedChannel':
            obj_ = SelectedChannelType.factory()
            obj_.build(child_)
            self.RedChannel = obj_
            obj_.original_tagname_ = 'RedChannel'
        elif nodeName_ == 'GreenChannel':
            obj_ = SelectedChannelType.factory()
            obj_.build(child_)
            self.GreenChannel = obj_
            obj_.original_tagname_ = 'GreenChannel'
        elif nodeName_ == 'BlueChannel':
            obj_ = SelectedChannelType.factory()
            obj_.build(child_)
            self.BlueChannel = obj_
            obj_.original_tagname_ = 'BlueChannel'
        elif nodeName_ == 'GrayChannel':
            obj_ = SelectedChannelType.factory()
            obj_.build(child_)
            self.GrayChannel = obj_
            obj_.original_tagname_ = 'GrayChannel'


# end class ChannelSelection


class SelectedChannelType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, SourceChannelName=None, ContrastEnhancement=None):
        self.original_tagname_ = None
        self.SourceChannelName = SourceChannelName
        self.ContrastEnhancement = ContrastEnhancement

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SelectedChannelType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SelectedChannelType.subclass:
            return SelectedChannelType.subclass(*args_, **kwargs_)
        else:
            return SelectedChannelType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_SourceChannelName(self):
        return self.SourceChannelName

    def set_SourceChannelName(self, SourceChannelName):
        self.SourceChannelName = SourceChannelName

    def get_ContrastEnhancement(self):
        return self.ContrastEnhancement

    def set_ContrastEnhancement(self, ContrastEnhancement):
        self.ContrastEnhancement = ContrastEnhancement

    def hasContent_(self):
        if (
                        self.SourceChannelName is not None or
                        self.ContrastEnhancement is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='SelectedChannelType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SelectedChannelType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SelectedChannelType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='SelectedChannelType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='SelectedChannelType'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='SelectedChannelType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.SourceChannelName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSourceChannelName>%s</%sSourceChannelName>%s' % ('sld:', self.gds_encode(
                self.gds_format_string(quote_xml(self.SourceChannelName), input_name='SourceChannelName')),
                                                                               'sld:', eol_))
        if self.ContrastEnhancement is not None:
            self.ContrastEnhancement.export(outfile, level, namespace_='sld:', name_='ContrastEnhancement',
                                            pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'SourceChannelName':
            SourceChannelName_ = child_.text
            SourceChannelName_ = self.gds_validate_string(SourceChannelName_, node, 'SourceChannelName')
            self.SourceChannelName = SourceChannelName_
        elif nodeName_ == 'ContrastEnhancement':
            obj_ = ContrastEnhancement.factory()
            obj_.build(child_)
            self.ContrastEnhancement = obj_
            obj_.original_tagname_ = 'ContrastEnhancement'


# end class SelectedChannelType


class OverlapBehavior(GeneratedsSuper):
    """ "OverlapBehavior" tells a system how to behave when multiple raster
    images in a layer overlap each other, for example with
    satellite-image scenes. """
    subclass = None
    superclass = None

    def __init__(self, LATEST_ON_TOP=None, EARLIEST_ON_TOP=None, AVERAGE=None, RANDOM=None):
        self.original_tagname_ = None
        self.LATEST_ON_TOP = LATEST_ON_TOP
        self.EARLIEST_ON_TOP = EARLIEST_ON_TOP
        self.AVERAGE = AVERAGE
        self.RANDOM = RANDOM

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OverlapBehavior)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OverlapBehavior.subclass:
            return OverlapBehavior.subclass(*args_, **kwargs_)
        else:
            return OverlapBehavior(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_LATEST_ON_TOP(self):
        return self.LATEST_ON_TOP

    def set_LATEST_ON_TOP(self, LATEST_ON_TOP):
        self.LATEST_ON_TOP = LATEST_ON_TOP

    def get_EARLIEST_ON_TOP(self):
        return self.EARLIEST_ON_TOP

    def set_EARLIEST_ON_TOP(self, EARLIEST_ON_TOP):
        self.EARLIEST_ON_TOP = EARLIEST_ON_TOP

    def get_AVERAGE(self):
        return self.AVERAGE

    def set_AVERAGE(self, AVERAGE):
        self.AVERAGE = AVERAGE

    def get_RANDOM(self):
        return self.RANDOM

    def set_RANDOM(self, RANDOM):
        self.RANDOM = RANDOM

    def hasContent_(self):
        if (
                                self.LATEST_ON_TOP is not None or
                                self.EARLIEST_ON_TOP is not None or
                            self.AVERAGE is not None or
                        self.RANDOM is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='OverlapBehavior',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OverlapBehavior')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OverlapBehavior')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='OverlapBehavior',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='OverlapBehavior'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='OverlapBehavior', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.LATEST_ON_TOP is not None:
            self.LATEST_ON_TOP.export(outfile, level, namespace_='sld:', name_='LATEST_ON_TOP',
                                      pretty_print=pretty_print)
        if self.EARLIEST_ON_TOP is not None:
            self.EARLIEST_ON_TOP.export(outfile, level, namespace_='sld:', name_='EARLIEST_ON_TOP',
                                        pretty_print=pretty_print)
        if self.AVERAGE is not None:
            self.AVERAGE.export(outfile, level, namespace_='sld:', name_='AVERAGE', pretty_print=pretty_print)
        if self.RANDOM is not None:
            self.RANDOM.export(outfile, level, namespace_='sld:', name_='RANDOM', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'LATEST_ON_TOP':
            obj_ = LATEST_ON_TOP.factory()
            obj_.build(child_)
            self.LATEST_ON_TOP = obj_
            obj_.original_tagname_ = 'LATEST_ON_TOP'
        elif nodeName_ == 'EARLIEST_ON_TOP':
            obj_ = EARLIEST_ON_TOP.factory()
            obj_.build(child_)
            self.EARLIEST_ON_TOP = obj_
            obj_.original_tagname_ = 'EARLIEST_ON_TOP'
        elif nodeName_ == 'AVERAGE':
            obj_ = AVERAGE.factory()
            obj_.build(child_)
            self.AVERAGE = obj_
            obj_.original_tagname_ = 'AVERAGE'
        elif nodeName_ == 'RANDOM':
            obj_ = RANDOM.factory()
            obj_.build(child_)
            self.RANDOM = obj_
            obj_.original_tagname_ = 'RANDOM'


# end class OverlapBehavior


class LATEST_ON_TOP(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self):
        self.original_tagname_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LATEST_ON_TOP)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LATEST_ON_TOP.subclass:
            return LATEST_ON_TOP.subclass(*args_, **kwargs_)
        else:
            return LATEST_ON_TOP(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LATEST_ON_TOP',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LATEST_ON_TOP')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LATEST_ON_TOP')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LATEST_ON_TOP',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='LATEST_ON_TOP'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LATEST_ON_TOP', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class LATEST_ON_TOP


class EARLIEST_ON_TOP(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self):
        self.original_tagname_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EARLIEST_ON_TOP)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EARLIEST_ON_TOP.subclass:
            return EARLIEST_ON_TOP.subclass(*args_, **kwargs_)
        else:
            return EARLIEST_ON_TOP(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='EARLIEST_ON_TOP',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('EARLIEST_ON_TOP')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EARLIEST_ON_TOP')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='EARLIEST_ON_TOP',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='EARLIEST_ON_TOP'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='EARLIEST_ON_TOP', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class EARLIEST_ON_TOP


class AVERAGE(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self):
        self.original_tagname_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AVERAGE)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AVERAGE.subclass:
            return AVERAGE.subclass(*args_, **kwargs_)
        else:
            return AVERAGE(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='AVERAGE',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AVERAGE')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AVERAGE')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='AVERAGE',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='AVERAGE'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='AVERAGE', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class AVERAGE


class RANDOM(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self):
        self.original_tagname_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RANDOM)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RANDOM.subclass:
            return RANDOM.subclass(*args_, **kwargs_)
        else:
            return RANDOM(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='RANDOM',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RANDOM')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RANDOM')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='RANDOM',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='RANDOM'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='RANDOM', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class RANDOM


class ColorMap(GeneratedsSuper):
    """A "ColorMap" defines either the colors of a pallet-type raster
    source or the mapping of numeric pixel values to colors."""
    subclass = None
    superclass = None

    def __init__(self, ColorMapEntry=None):
        self.original_tagname_ = None
        if ColorMapEntry is None:
            self.ColorMapEntry = []
        else:
            self.ColorMapEntry = ColorMapEntry

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ColorMap)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ColorMap.subclass:
            return ColorMap.subclass(*args_, **kwargs_)
        else:
            return ColorMap(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ColorMapEntry(self):
        return self.ColorMapEntry

    def set_ColorMapEntry(self, ColorMapEntry):
        self.ColorMapEntry = ColorMapEntry

    def add_ColorMapEntry(self, value):
        self.ColorMapEntry.append(value)

    def insert_ColorMapEntry_at(self, index, value):
        self.ColorMapEntry.insert(index, value)

    def replace_ColorMapEntry_at(self, index, value):
        self.ColorMapEntry[index] = value

    def hasContent_(self):
        if (
                self.ColorMapEntry
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='ColorMap',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ColorMap')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ColorMap')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='ColorMap',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='ColorMap'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='ColorMap', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ColorMapEntry_ in self.ColorMapEntry:
            ColorMapEntry_.export(outfile, level, namespace_='sld:', name_='ColorMapEntry',
                                  pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ColorMapEntry':
            obj_ = ColorMapEntry.factory()
            obj_.build(child_)
            self.ColorMapEntry.append(obj_)
            obj_.original_tagname_ = 'ColorMapEntry'


# end class ColorMap


class ColorMapEntry(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, color=None, opacity=None, quantity=None, label=None):
        self.original_tagname_ = None
        self.color = _cast(None, color)
        self.opacity = _cast(float, opacity)
        self.quantity = _cast(float, quantity)
        self.label = _cast(None, label)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ColorMapEntry)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ColorMapEntry.subclass:
            return ColorMapEntry.subclass(*args_, **kwargs_)
        else:
            return ColorMapEntry(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_color(self):
        return self.color

    def set_color(self, color):
        self.color = color

    def get_opacity(self):
        return self.opacity

    def set_opacity(self, opacity):
        self.opacity = opacity

    def get_quantity(self):
        return self.quantity

    def set_quantity(self, quantity):
        self.quantity = quantity

    def get_label(self):
        return self.label

    def set_label(self, label):
        self.label = label

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='ColorMapEntry',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ColorMapEntry')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ColorMapEntry')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='ColorMapEntry',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='ColorMapEntry'):
        if self.color is not None and 'color' not in already_processed:
            already_processed.add('color')
            outfile.write(' color=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.color), input_name='color')),))
        if self.opacity is not None and 'opacity' not in already_processed:
            already_processed.add('opacity')
            outfile.write(' opacity="%s"' % self.gds_format_double(self.opacity, input_name='opacity'))
        if self.quantity is not None and 'quantity' not in already_processed:
            already_processed.add('quantity')
            outfile.write(' quantity="%s"' % self.gds_format_double(self.quantity, input_name='quantity'))
        if self.label is not None and 'label' not in already_processed:
            already_processed.add('label')
            outfile.write(' label=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.label), input_name='label')),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='ColorMapEntry', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('color', node)
        if value is not None and 'color' not in already_processed:
            already_processed.add('color')
            self.color = value
        value = find_attr_value_('opacity', node)
        if value is not None and 'opacity' not in already_processed:
            already_processed.add('opacity')
            try:
                self.opacity = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (opacity): %s' % exp)
        value = find_attr_value_('quantity', node)
        if value is not None and 'quantity' not in already_processed:
            already_processed.add('quantity')
            try:
                self.quantity = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (quantity): %s' % exp)
        value = find_attr_value_('label', node)
        if value is not None and 'label' not in already_processed:
            already_processed.add('label')
            self.label = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class ColorMapEntry


class ContrastEnhancement(GeneratedsSuper):
    """ "ContrastEnhancement" defines the 'stretching' of contrast for a
    channel of a false-color image or for a whole grey/color image.
    Contrast enhancement is used to make ground features in images
    more visible. """
    subclass = None
    superclass = None

    def __init__(self, Normalize=None, Histogram=None, GammaValue=None):
        self.original_tagname_ = None
        self.Normalize = Normalize
        self.Histogram = Histogram
        self.GammaValue = GammaValue

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContrastEnhancement)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContrastEnhancement.subclass:
            return ContrastEnhancement.subclass(*args_, **kwargs_)
        else:
            return ContrastEnhancement(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Normalize(self):
        return self.Normalize

    def set_Normalize(self, Normalize):
        self.Normalize = Normalize

    def get_Histogram(self):
        return self.Histogram

    def set_Histogram(self, Histogram):
        self.Histogram = Histogram

    def get_GammaValue(self):
        return self.GammaValue

    def set_GammaValue(self, GammaValue):
        self.GammaValue = GammaValue

    def hasContent_(self):
        if (
                            self.Normalize is not None or
                            self.Histogram is not None or
                        self.GammaValue is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='ContrastEnhancement',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ContrastEnhancement')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContrastEnhancement')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='ContrastEnhancement',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='ContrastEnhancement'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='ContrastEnhancement',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Normalize is not None:
            self.Normalize.export(outfile, level, namespace_='sld:', name_='Normalize',
                                  pretty_print=pretty_print)
        if self.Histogram is not None:
            self.Histogram.export(outfile, level, namespace_='sld:', name_='Histogram',
                                  pretty_print=pretty_print)
        if self.GammaValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sGammaValue>%s</%sGammaValue>%s' % (
            namespace_, self.gds_format_double(self.GammaValue, input_name='GammaValue'), namespace_, eol_))

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Normalize':
            obj_ = Normalize.factory()
            obj_.build(child_)
            self.Normalize = obj_
            obj_.original_tagname_ = 'Normalize'
        elif nodeName_ == 'Histogram':
            obj_ = Histogram.factory()
            obj_.build(child_)
            self.Histogram = obj_
            obj_.original_tagname_ = 'Histogram'
        elif nodeName_ == 'GammaValue':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'GammaValue')
            self.GammaValue = fval_


# end class ContrastEnhancement


class Normalize(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self):
        self.original_tagname_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Normalize)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Normalize.subclass:
            return Normalize.subclass(*args_, **kwargs_)
        else:
            return Normalize(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='Normalize',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Normalize')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Normalize')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='Normalize',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='Normalize'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='Normalize', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class Normalize


class Histogram(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self):
        self.original_tagname_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Histogram)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Histogram.subclass:
            return Histogram.subclass(*args_, **kwargs_)
        else:
            return Histogram(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='Histogram',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Histogram')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Histogram')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='Histogram',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='Histogram'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='Histogram', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class Histogram


class ShadedRelief(GeneratedsSuper):
    """ "ShadedRelief" specifies the application of relief shading (or "hill
    shading") to a DEM raster to give it somewhat of a three-
    dimensional effect and to make elevation changes more visible. """
    subclass = None
    superclass = None

    def __init__(self, BrightnessOnly=None, ReliefFactor=None):
        self.original_tagname_ = None
        self.BrightnessOnly = BrightnessOnly
        self.ReliefFactor = ReliefFactor

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ShadedRelief)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShadedRelief.subclass:
            return ShadedRelief.subclass(*args_, **kwargs_)
        else:
            return ShadedRelief(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_BrightnessOnly(self):
        return self.BrightnessOnly

    def set_BrightnessOnly(self, BrightnessOnly):
        self.BrightnessOnly = BrightnessOnly

    def get_ReliefFactor(self):
        return self.ReliefFactor

    def set_ReliefFactor(self, ReliefFactor):
        self.ReliefFactor = ReliefFactor

    def hasContent_(self):
        if (
                        self.BrightnessOnly is not None or
                        self.ReliefFactor is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='ShadedRelief',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ShadedRelief')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ShadedRelief')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='ShadedRelief',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='ShadedRelief'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='ShadedRelief', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.BrightnessOnly is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBrightnessOnly>%s</%sBrightnessOnly>%s' % (
            namespace_, self.gds_format_boolean(self.BrightnessOnly, input_name='BrightnessOnly'), namespace_,
            eol_))
        if self.ReliefFactor is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReliefFactor>%s</%sReliefFactor>%s' % (
            namespace_, self.gds_format_double(self.ReliefFactor, input_name='ReliefFactor'), namespace_,
            eol_))

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'BrightnessOnly':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'BrightnessOnly')
            self.BrightnessOnly = ival_
        elif nodeName_ == 'ReliefFactor':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'ReliefFactor')
            self.ReliefFactor = fval_


# end class ShadedRelief


class ImageOutline(GeneratedsSuper):
    """ "ImageOutline" specifies how individual source rasters in a multi-
    raster set (such as a set of satellite-image scenes) should be
    outlined to make the individual-image locations visible. """
    subclass = None
    superclass = None

    def __init__(self, LineSymbolizer=None, PolygonSymbolizer=None):
        self.original_tagname_ = None
        self.LineSymbolizer = LineSymbolizer
        self.PolygonSymbolizer = PolygonSymbolizer

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ImageOutline)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ImageOutline.subclass:
            return ImageOutline.subclass(*args_, **kwargs_)
        else:
            return ImageOutline(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_LineSymbolizer(self):
        return self.LineSymbolizer

    def set_LineSymbolizer(self, LineSymbolizer):
        self.LineSymbolizer = LineSymbolizer

    def get_PolygonSymbolizer(self):
        return self.PolygonSymbolizer

    def set_PolygonSymbolizer(self, PolygonSymbolizer):
        self.PolygonSymbolizer = PolygonSymbolizer

    def hasContent_(self):
        if (
                        self.LineSymbolizer is not None or
                        self.PolygonSymbolizer is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='ImageOutline',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ImageOutline')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ImageOutline')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='ImageOutline',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='ImageOutline'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='ImageOutline', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.LineSymbolizer is not None:
            self.LineSymbolizer.export(outfile, level, namespace_='sld:', name_='LineSymbolizer',
                                       pretty_print=pretty_print)
        if self.PolygonSymbolizer is not None:
            self.PolygonSymbolizer.export(outfile, level, namespace_='sld:', name_='PolygonSymbolizer',
                                          pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'LineSymbolizer':
            obj_ = LineSymbolizer.factory()
            obj_.build(child_)
            self.LineSymbolizer = obj_
            obj_.original_tagname_ = 'LineSymbolizer'
        elif nodeName_ == 'PolygonSymbolizer':
            obj_ = PolygonSymbolizer.factory()
            obj_.build(child_)
            self.PolygonSymbolizer = obj_
            obj_.original_tagname_ = 'PolygonSymbolizer'


# end class ImageOutline


class simple(GeneratedsSuper):
    """Intended for use as the type of user-declared elements to make them
    simple links."""
    subclass = None
    superclass = None

    def __init__(self, type_=None, href=None, role=None, arcrole=None, title=None, show=None, actuate=None,
                 anytypeobjs_=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, simple)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if simple.subclass:
            return simple.subclass(*args_, **kwargs_)
        else:
            return simple(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def add_anytypeobjs_(self, value):
        self.anytypeobjs_.append(value)

    def insert_anytypeobjs_(self, index, value):
        self._anytypeobjs_[index] = value

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
                    self.anytypeobjs_ or
                    1 if type(self.valueOf_) in [int, float] else self.valueOf_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='simple',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('simple')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='simple')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='simple',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='simple'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='simple', fromsubclass_=False,
                       pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == '':
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, '', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_'):
                self.add_(obj_.value)
            elif hasattr(self, 'set_'):
                self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)


# end class simple


class extended(GeneratedsSuper):
    """Intended for use as the type of user-declared elements to make them
    extended links. Note that the elements referenced in the content
    model are all abstract. The intention is that by simply
    declaring elements with these as their substitutionGroup, all
    the right things will happen."""
    subclass = None
    superclass = None

    def __init__(self, type_=None, role=None, title_attr=None, title=None, resource=None, locator=None,
                 arc=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.role = _cast(None, role)
        self.title_attr = _cast(None, title_attr)
        if title is None:
            self.title = []
        else:
            self.title = title
        if resource is None:
            self.resource = []
        else:
            self.resource = resource
        if locator is None:
            self.locator = []
        else:
            self.locator = locator
        if arc is None:
            self.arc = []
        else:
            self.arc = arc

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, extended)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if extended.subclass:
            return extended.subclass(*args_, **kwargs_)
        else:
            return extended(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def add_title(self, value):
        self.title.append(value)

    def insert_title_at(self, index, value):
        self.title.insert(index, value)

    def replace_title_at(self, index, value):
        self.title[index] = value

    def get_resource(self):
        return self.resource

    def set_resource(self, resource):
        self.resource = resource

    def add_resource(self, value):
        self.resource.append(value)

    def insert_resource_at(self, index, value):
        self.resource.insert(index, value)

    def replace_resource_at(self, index, value):
        self.resource[index] = value

    def get_locator(self):
        return self.locator

    def set_locator(self, locator):
        self.locator = locator

    def add_locator(self, value):
        self.locator.append(value)

    def insert_locator_at(self, index, value):
        self.locator.insert(index, value)

    def replace_locator_at(self, index, value):
        self.locator[index] = value

    def get_arc(self):
        return self.arc

    def set_arc(self, arc):
        self.arc = arc

    def add_arc(self, value):
        self.arc.append(value)

    def insert_arc_at(self, index, value):
        self.arc.insert(index, value)

    def replace_arc_at(self, index, value):
        self.arc[index] = value

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_title_attr(self):
        return self.title_attr

    def set_title_attr(self, title_attr):
        self.title_attr = title_attr

    def hasContent_(self):
        if (
                            self.title or
                            self.resource or
                        self.locator or
                    self.arc
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='extended',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:xlink="http://www.w3.org/1999/xlink" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('extended')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='extended')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='extended',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='extended'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.title_attr is not None and 'title_attr' not in already_processed:
            already_processed.add('title_attr')
            outfile.write(' title=%s' % (quote_attrib(self.title_attr),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='extended', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for title_ in self.title:
            title_.export(outfile, level, namespace_, name_='title', pretty_print=pretty_print)
        for resource_ in self.resource:
            resource_.export(outfile, level, namespace_, name_='resource', pretty_print=pretty_print)
        for locator_ in self.locator:
            locator_.export(outfile, level, namespace_, name_='locator', pretty_print=pretty_print)
        for arc_ in self.arc:
            arc_.export(outfile, level, namespace_, name_='arc', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('title', node)
        if value is not None and 'title_attr' not in already_processed:
            already_processed.add('title_attr')
            self.title_attr = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'title':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <title> element')
            self.title.append(obj_)
            obj_.original_tagname_ = 'title'
        elif nodeName_ == 'resource':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <resource> element')
            self.resource.append(obj_)
            obj_.original_tagname_ = 'resource'
        elif nodeName_ == 'locator':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <locator> element')
            self.locator.append(obj_)
            obj_.original_tagname_ = 'locator'
        elif nodeName_ == 'arc':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <arc> element')
            self.arc.append(obj_)
            obj_.original_tagname_ = 'arc'


# end class extended


class titleEltType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, type_=None, lang=None, anytypeobjs_=None, valueOf_=None, mixedclass_=None,
                 content_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.lang = _cast(None, lang)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, titleEltType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if titleEltType.subclass:
            return titleEltType.subclass(*args_, **kwargs_)
        else:
            return titleEltType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def add_anytypeobjs_(self, value):
        self.anytypeobjs_.append(value)

    def insert_anytypeobjs_(self, index, value):
        self._anytypeobjs_[index] = value

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
                    self.anytypeobjs_ or
                    1 if type(self.valueOf_) in [int, float] else self.valueOf_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='titleEltType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('titleEltType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='titleEltType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='titleEltType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='titleEltType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' lang=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.lang), input_name='lang')),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='titleEltType', fromsubclass_=False,
                       pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == '':
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, '', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_'):
                self.add_(obj_.value)
            elif hasattr(self, 'set_'):
                self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)


# end class titleEltType


class resourceType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, type_=None, role=None, title=None, label=None, anytypeobjs_=None, valueOf_=None,
                 mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.role = _cast(None, role)
        self.title = _cast(None, title)
        self.label = _cast(None, label)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, resourceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if resourceType.subclass:
            return resourceType.subclass(*args_, **kwargs_)
        else:
            return resourceType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def add_anytypeobjs_(self, value):
        self.anytypeobjs_.append(value)

    def insert_anytypeobjs_(self, index, value):
        self._anytypeobjs_[index] = value

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_label(self):
        return self.label

    def set_label(self, label):
        self.label = label

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
                    self.anytypeobjs_ or
                    1 if type(self.valueOf_) in [int, float] else self.valueOf_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='resourceType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('resourceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='resourceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='resourceType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='resourceType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.label is not None and 'label' not in already_processed:
            already_processed.add('label')
            outfile.write(' label=%s' % (quote_attrib(self.label),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='resourceType', fromsubclass_=False,
                       pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('label', node)
        if value is not None and 'label' not in already_processed:
            already_processed.add('label')
            self.label = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == '':
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, '', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_'):
                self.add_(obj_.value)
            elif hasattr(self, 'set_'):
                self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)


# end class resourceType


class locatorType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, type_=None, href=None, role=None, title_attr=None, label=None, title=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.title_attr = _cast(None, title_attr)
        self.label = _cast(None, label)
        if title is None:
            self.title = []
        else:
            self.title = title

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, locatorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if locatorType.subclass:
            return locatorType.subclass(*args_, **kwargs_)
        else:
            return locatorType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def add_title(self, value):
        self.title.append(value)

    def insert_title_at(self, index, value):
        self.title.insert(index, value)

    def replace_title_at(self, index, value):
        self.title[index] = value

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_title_attr(self):
        return self.title_attr

    def set_title_attr(self, title_attr):
        self.title_attr = title_attr

    def get_label(self):
        return self.label

    def set_label(self, label):
        self.label = label

    def hasContent_(self):
        if (
                self.title
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='locatorType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:xlink="http://www.w3.org/1999/xlink" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('locatorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='locatorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='locatorType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='locatorType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.title_attr is not None and 'title_attr' not in already_processed:
            already_processed.add('title_attr')
            outfile.write(' title=%s' % (quote_attrib(self.title_attr),))
        if self.label is not None and 'label' not in already_processed:
            already_processed.add('label')
            outfile.write(' label=%s' % (quote_attrib(self.label),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='locatorType', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for title_ in self.title:
            title_.export(outfile, level, namespace_, name_='title', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('title', node)
        if value is not None and 'title_attr' not in already_processed:
            already_processed.add('title_attr')
            self.title_attr = value
        value = find_attr_value_('label', node)
        if value is not None and 'label' not in already_processed:
            already_processed.add('label')
            self.label = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'title':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <title> element')
            self.title.append(obj_)
            obj_.original_tagname_ = 'title'


# end class locatorType


class arcType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, type_=None, arcrole=None, title_attr=None, show=None, actuate=None, from_=None,
                 to=None, title=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.arcrole = _cast(None, arcrole)
        self.title_attr = _cast(None, title_attr)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self.from_ = _cast(None, from_)
        self.to = _cast(None, to)
        if title is None:
            self.title = []
        else:
            self.title = title

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, arcType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if arcType.subclass:
            return arcType.subclass(*args_, **kwargs_)
        else:
            return arcType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def add_title(self, value):
        self.title.append(value)

    def insert_title_at(self, index, value):
        self.title.insert(index, value)

    def replace_title_at(self, index, value):
        self.title[index] = value

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title_attr(self):
        return self.title_attr

    def set_title_attr(self, title_attr):
        self.title_attr = title_attr

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def get_from(self):
        return self.from_

    def set_from(self, from_):
        self.from_ = from_

    def get_to(self):
        return self.to

    def set_to(self, to):
        self.to = to

    def hasContent_(self):
        if (
                self.title
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='arcType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:xlink="http://www.w3.org/1999/xlink" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('arcType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='arcType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='arcType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='arcType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title_attr is not None and 'title_attr' not in already_processed:
            already_processed.add('title_attr')
            outfile.write(' title=%s' % (quote_attrib(self.title_attr),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))
        if self.from_ is not None and 'from_' not in already_processed:
            already_processed.add('from_')
            outfile.write(' from=%s' % (quote_attrib(self.from_),))
        if self.to is not None and 'to' not in already_processed:
            already_processed.add('to')
            outfile.write(' to=%s' % (quote_attrib(self.to),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='arcType', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for title_ in self.title:
            title_.export(outfile, level, namespace_, name_='title', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title_attr' not in already_processed:
            already_processed.add('title_attr')
            self.title_attr = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value
        value = find_attr_value_('from', node)
        if value is not None and 'from' not in already_processed:
            already_processed.add('from')
            self.from_ = value
        value = find_attr_value_('to', node)
        if value is not None and 'to' not in already_processed:
            already_processed.add('to')
            self.to = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'title':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <title> element')
            self.title.append(obj_)
            obj_.original_tagname_ = 'title'


# end class arcType


class ComparisonOpsType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, extensiontype_=None):
        self.original_tagname_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ComparisonOpsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ComparisonOpsType.subclass:
            return ComparisonOpsType.subclass(*args_, **kwargs_)
        else:
            return ComparisonOpsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='ComparisonOpsType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ComparisonOpsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ComparisonOpsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='ComparisonOpsType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='ComparisonOpsType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='ComparisonOpsType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class ComparisonOpsType


class SpatialOpsType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, extensiontype_=None):
        self.original_tagname_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpatialOpsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpatialOpsType.subclass:
            return SpatialOpsType.subclass(*args_, **kwargs_)
        else:
            return SpatialOpsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='SpatialOpsType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SpatialOpsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpatialOpsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='SpatialOpsType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='SpatialOpsType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='SpatialOpsType', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class SpatialOpsType


class LogicOpsType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, extensiontype_=None):
        self.original_tagname_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LogicOpsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LogicOpsType.subclass:
            return LogicOpsType.subclass(*args_, **kwargs_)
        else:
            return LogicOpsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LogicOpsType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LogicOpsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LogicOpsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LogicOpsType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='LogicOpsType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LogicOpsType', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class LogicOpsType


class FilterType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, spatialOps=None, comparisonOps=None, logicOps=None, FeatureId=None):
        self.original_tagname_ = None
        self.spatialOps = spatialOps
        self.comparisonOps = comparisonOps
        self.logicOps = logicOps
        if FeatureId is None:
            self.FeatureId = []
        else:
            self.FeatureId = FeatureId

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FilterType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FilterType.subclass:
            return FilterType.subclass(*args_, **kwargs_)
        else:
            return FilterType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_spatialOps(self):
        return self.spatialOps

    def set_spatialOps(self, spatialOps):
        self.spatialOps = spatialOps

    def get_comparisonOps(self):
        return self.comparisonOps

    def set_comparisonOps(self, comparisonOps):
        self.comparisonOps = comparisonOps

    def get_logicOps(self):
        return self.logicOps

    def set_logicOps(self, logicOps):
        self.logicOps = logicOps

    def get_FeatureId(self):
        return self.FeatureId

    def set_FeatureId(self, FeatureId):
        self.FeatureId = FeatureId

    def add_FeatureId(self, value):
        self.FeatureId.append(value)

    def insert_FeatureId_at(self, index, value):
        self.FeatureId.insert(index, value)

    def replace_FeatureId_at(self, index, value):
        self.FeatureId[index] = value

    def hasContent_(self):
        if (
                                self.spatialOps is not None or
                                self.comparisonOps is not None or
                            self.logicOps is not None or
                    self.FeatureId
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='FilterType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('FilterType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FilterType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='FilterType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='FilterType'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='FilterType', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.spatialOps is not None:
            self.spatialOps.export(outfile, level, namespace_, name_='spatialOps', pretty_print=pretty_print)
        if self.comparisonOps is not None:
            self.comparisonOps.export(outfile, level, namespace_, name_='comparisonOps',
                                      pretty_print=pretty_print)
        if self.logicOps is not None:
            self.logicOps.export(outfile, level, namespace_, name_='logicOps', pretty_print=pretty_print)
        for FeatureId_ in self.FeatureId:
            FeatureId_.export(outfile, level, namespace_='ogc:', name_='FeatureId', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'spatialOps':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <spatialOps> element')
            self.spatialOps = obj_
            obj_.original_tagname_ = 'spatialOps'
        elif nodeName_ == 'Equals':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Equals'
        elif nodeName_ == 'Disjoint':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Disjoint'
        elif nodeName_ == 'Touches':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Touches'
        elif nodeName_ == 'Within':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Within'
        elif nodeName_ == 'Overlaps':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Overlaps'
        elif nodeName_ == 'Crosses':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Crosses'
        elif nodeName_ == 'Intersects':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Intersects'
        elif nodeName_ == 'Contains':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Contains'
        elif nodeName_ == 'DWithin':
            obj_ = DistanceBufferType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'DWithin'
        elif nodeName_ == 'Beyond':
            obj_ = DistanceBufferType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Beyond'
        elif nodeName_ == 'BBOX':
            obj_ = BBOXType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'BBOX'
        elif nodeName_ == 'comparisonOps':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <comparisonOps> element')
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'comparisonOps'
        elif nodeName_ == 'PropertyIsEqualTo':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsEqualTo'
        elif nodeName_ == 'PropertyIsNotEqualTo':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsNotEqualTo'
        elif nodeName_ == 'PropertyIsLessThan':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsLessThan'
        elif nodeName_ == 'PropertyIsGreaterThan':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsGreaterThan'
        elif nodeName_ == 'PropertyIsLessThanOrEqualTo':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsLessThanOrEqualTo'
        elif nodeName_ == 'PropertyIsGreaterThanOrEqualTo':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsGreaterThanOrEqualTo'
        elif nodeName_ == 'PropertyIsLike':
            obj_ = PropertyIsLikeType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsLike'
        elif nodeName_ == 'PropertyIsNull':
            obj_ = PropertyIsNullType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsNull'
        elif nodeName_ == 'PropertyIsBetween':
            obj_ = PropertyIsBetweenType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsBetween'
        elif nodeName_ == 'logicOps':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <logicOps> element')
            self.logicOps = obj_
            obj_.original_tagname_ = 'logicOps'
        elif nodeName_ == 'And':
            obj_ = BinaryLogicOpType.factory()
            obj_.build(child_)
            self.logicOps = obj_
            obj_.original_tagname_ = 'And'
        elif nodeName_ == 'Or':
            obj_ = BinaryLogicOpType.factory()
            obj_.build(child_)
            self.logicOps = obj_
            obj_.original_tagname_ = 'Or'
        elif nodeName_ == 'Not':
            obj_ = UnaryLogicOpType.factory()
            obj_.build(child_)
            self.logicOps = obj_
            obj_.original_tagname_ = 'Not'
        elif nodeName_ == 'FeatureId':
            obj_ = FeatureIdType.factory()
            obj_.build(child_)
            self.FeatureId.append(obj_)
            obj_.original_tagname_ = 'FeatureId'


# end class FilterType


class FeatureIdType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, fid=None):
        self.original_tagname_ = None
        self.fid = _cast(None, fid)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FeatureIdType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FeatureIdType.subclass:
            return FeatureIdType.subclass(*args_, **kwargs_)
        else:
            return FeatureIdType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_fid(self):
        return self.fid

    def set_fid(self, fid):
        self.fid = fid

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='FeatureIdType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('FeatureIdType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FeatureIdType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='FeatureIdType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='FeatureIdType'):
        if self.fid is not None and 'fid' not in already_processed:
            already_processed.add('fid')
            outfile.write(' fid=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.fid), input_name='fid')),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='FeatureIdType', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('fid', node)
        if value is not None and 'fid' not in already_processed:
            already_processed.add('fid')
            self.fid = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class FeatureIdType


class BinaryComparisonOpType(ComparisonOpsType):
    subclass = None
    superclass = ComparisonOpsType

    def __init__(self, expression=None):
        self.original_tagname_ = None
        super(BinaryComparisonOpType, self).__init__()
        if expression is None:
            self.expression = []
        else:
            self.expression = expression

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BinaryComparisonOpType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BinaryComparisonOpType.subclass:
            return BinaryComparisonOpType.subclass(*args_, **kwargs_)
        else:
            return BinaryComparisonOpType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_expression(self):
        return self.expression

    def set_expression(self, expression):
        self.expression = expression

    def add_expression(self, value):
        self.expression.append(value)

    def insert_expression_at(self, index, value):
        self.expression.insert(index, value)

    def replace_expression_at(self, index, value):
        self.expression[index] = value

    def hasContent_(self):
        if (
                    self.expression or
                    super(BinaryComparisonOpType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='BinaryComparisonOpType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BinaryComparisonOpType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BinaryComparisonOpType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='BinaryComparisonOpType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='BinaryComparisonOpType'):
        super(BinaryComparisonOpType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                             name_='BinaryComparisonOpType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='BinaryComparisonOpType',
                       fromsubclass_=False, pretty_print=True):
        super(BinaryComparisonOpType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                           pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for expression_ in self.expression:
            expression_.export(outfile, level, namespace_, name_='expression', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(BinaryComparisonOpType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'expression':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <expression> element')
            self.expression.append(obj_)
            obj_.original_tagname_ = 'expression'
        elif nodeName_ == 'Add':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression.append(obj_)
            obj_.original_tagname_ = 'Add'
        elif nodeName_ == 'Sub':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression.append(obj_)
            obj_.original_tagname_ = 'Sub'
        elif nodeName_ == 'Mul':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression.append(obj_)
            obj_.original_tagname_ = 'Mul'
        elif nodeName_ == 'Div':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression.append(obj_)
            obj_.original_tagname_ = 'Div'
        elif nodeName_ == 'PropertyName':
            obj_ = PropertyNameType.factory()
            obj_.build(child_)
            self.expression.append(obj_)
            obj_.original_tagname_ = 'PropertyName'
        elif nodeName_ == 'Function':
            obj_ = FunctionType.factory()
            obj_.build(child_)
            self.expression.append(obj_)
            obj_.original_tagname_ = 'Function'
        elif nodeName_ == 'Literal':
            obj_ = LiteralType.factory()
            obj_.build(child_)
            self.expression.append(obj_)
            obj_.original_tagname_ = 'Literal'
        super(BinaryComparisonOpType, self).buildChildren(child_, node, nodeName_, True)


# end class BinaryComparisonOpType


class PropertyIsLikeType(ComparisonOpsType):
    subclass = None
    superclass = ComparisonOpsType

    def __init__(self, wildCard=None, singleChar=None, escape=None, PropertyName=None, Literal=None):
        self.original_tagname_ = None
        super(PropertyIsLikeType, self).__init__()
        self.wildCard = _cast(None, wildCard)
        self.singleChar = _cast(None, singleChar)
        self.escape = _cast(None, escape)
        self.PropertyName = PropertyName
        self.Literal = Literal

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PropertyIsLikeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PropertyIsLikeType.subclass:
            return PropertyIsLikeType.subclass(*args_, **kwargs_)
        else:
            return PropertyIsLikeType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_PropertyName(self):
        return self.PropertyName

    def set_PropertyName(self, PropertyName):
        self.PropertyName = PropertyName

    def get_Literal(self):
        return self.Literal

    def set_Literal(self, Literal):
        self.Literal = Literal

    def get_wildCard(self):
        return self.wildCard

    def set_wildCard(self, wildCard):
        self.wildCard = wildCard

    def get_singleChar(self):
        return self.singleChar

    def set_singleChar(self, singleChar):
        self.singleChar = singleChar

    def get_escape(self):
        return self.escape

    def set_escape(self, escape):
        self.escape = escape

    def hasContent_(self):
        if (
                            self.PropertyName is not None or
                            self.Literal is not None or
                    super(PropertyIsLikeType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='PropertyIsLikeType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PropertyIsLikeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PropertyIsLikeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='PropertyIsLikeType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='PropertyIsLikeType'):
        super(PropertyIsLikeType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                         name_='PropertyIsLikeType')
        if self.wildCard is not None and 'wildCard' not in already_processed:
            already_processed.add('wildCard')
            outfile.write(' wildCard=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.wildCard), input_name='wildCard')),))
        if self.singleChar is not None and 'singleChar' not in already_processed:
            already_processed.add('singleChar')
            outfile.write(' singleChar=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.singleChar), input_name='singleChar')),))
        if self.escape is not None and 'escape' not in already_processed:
            already_processed.add('escape')
            outfile.write(' escape=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.escape), input_name='escape')),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='PropertyIsLikeType',
                       fromsubclass_=False, pretty_print=True):
        super(PropertyIsLikeType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                       pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PropertyName is not None:
            self.PropertyName.export(outfile, level, namespace_='ogc:', name_='PropertyName',
                                     pretty_print=pretty_print)
        if self.Literal is not None:
            self.Literal.export(outfile, level, namespace_='ogc:', name_='Literal', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('wildCard', node)
        if value is not None and 'wildCard' not in already_processed:
            already_processed.add('wildCard')
            self.wildCard = value
        value = find_attr_value_('singleChar', node)
        if value is not None and 'singleChar' not in already_processed:
            already_processed.add('singleChar')
            self.singleChar = value
        value = find_attr_value_('escape', node)
        if value is not None and 'escape' not in already_processed:
            already_processed.add('escape')
            self.escape = value
        super(PropertyIsLikeType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PropertyName':
            obj_ = PropertyNameType.factory()
            obj_.build(child_)
            self.PropertyName = obj_
            obj_.original_tagname_ = 'PropertyName'
        elif nodeName_ == 'Literal':
            obj_ = LiteralType.factory()
            obj_.build(child_)
            self.Literal = obj_
            obj_.original_tagname_ = 'Literal'
        super(PropertyIsLikeType, self).buildChildren(child_, node, nodeName_, True)


# end class PropertyIsLikeType


class PropertyIsNullType(ComparisonOpsType):
    subclass = None
    superclass = ComparisonOpsType

    def __init__(self, PropertyName=None, Literal=None):
        self.original_tagname_ = None
        super(PropertyIsNullType, self).__init__()
        self.PropertyName = PropertyName
        self.Literal = Literal

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PropertyIsNullType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PropertyIsNullType.subclass:
            return PropertyIsNullType.subclass(*args_, **kwargs_)
        else:
            return PropertyIsNullType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_PropertyName(self):
        return self.PropertyName

    def set_PropertyName(self, PropertyName):
        self.PropertyName = PropertyName

    def get_Literal(self):
        return self.Literal

    def set_Literal(self, Literal):
        self.Literal = Literal

    def hasContent_(self):
        if (
                            self.PropertyName is not None or
                            self.Literal is not None or
                    super(PropertyIsNullType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='PropertyIsNullType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PropertyIsNullType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PropertyIsNullType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='PropertyIsNullType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='PropertyIsNullType'):
        super(PropertyIsNullType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                         name_='PropertyIsNullType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='PropertyIsNullType',
                       fromsubclass_=False, pretty_print=True):
        super(PropertyIsNullType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                       pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PropertyName is not None:
            self.PropertyName.export(outfile, level, namespace_='ogc:', name_='PropertyName',
                                     pretty_print=pretty_print)
        if self.Literal is not None:
            self.Literal.export(outfile, level, namespace_='ogc:', name_='Literal', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(PropertyIsNullType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PropertyName':
            obj_ = PropertyNameType.factory()
            obj_.build(child_)
            self.PropertyName = obj_
            obj_.original_tagname_ = 'PropertyName'
        elif nodeName_ == 'Literal':
            obj_ = LiteralType.factory()
            obj_.build(child_)
            self.Literal = obj_
            obj_.original_tagname_ = 'Literal'
        super(PropertyIsNullType, self).buildChildren(child_, node, nodeName_, True)


# end class PropertyIsNullType


class PropertyIsBetweenType(ComparisonOpsType):
    subclass = None
    superclass = ComparisonOpsType

    def __init__(self, expression=None, LowerBoundary=None, UpperBoundary=None):
        self.original_tagname_ = None
        super(PropertyIsBetweenType, self).__init__()
        self.expression = expression
        self.LowerBoundary = LowerBoundary
        self.UpperBoundary = UpperBoundary

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PropertyIsBetweenType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PropertyIsBetweenType.subclass:
            return PropertyIsBetweenType.subclass(*args_, **kwargs_)
        else:
            return PropertyIsBetweenType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_expression(self):
        return self.expression

    def set_expression(self, expression):
        self.expression = expression

    def get_LowerBoundary(self):
        return self.LowerBoundary

    def set_LowerBoundary(self, LowerBoundary):
        self.LowerBoundary = LowerBoundary

    def get_UpperBoundary(self):
        return self.UpperBoundary

    def set_UpperBoundary(self, UpperBoundary):
        self.UpperBoundary = UpperBoundary

    def hasContent_(self):
        if (
                                self.expression is not None or
                                self.LowerBoundary is not None or
                            self.UpperBoundary is not None or
                    super(PropertyIsBetweenType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='PropertyIsBetweenType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PropertyIsBetweenType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PropertyIsBetweenType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='PropertyIsBetweenType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='PropertyIsBetweenType'):
        super(PropertyIsBetweenType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                            name_='PropertyIsBetweenType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='PropertyIsBetweenType',
                       fromsubclass_=False, pretty_print=True):
        super(PropertyIsBetweenType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                          pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.expression is not None:
            self.expression.export(outfile, level, namespace_, name_='expression', pretty_print=pretty_print)
        if self.LowerBoundary is not None:
            self.LowerBoundary.export(outfile, level, namespace_, name_='LowerBoundary',
                                      pretty_print=pretty_print)
        if self.UpperBoundary is not None:
            self.UpperBoundary.export(outfile, level, namespace_, name_='UpperBoundary',
                                      pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(PropertyIsBetweenType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'expression':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <expression> element')
            self.expression = obj_
            obj_.original_tagname_ = 'expression'
        elif nodeName_ == 'Add':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Add'
        elif nodeName_ == 'Sub':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Sub'
        elif nodeName_ == 'Mul':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Mul'
        elif nodeName_ == 'Div':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Div'
        elif nodeName_ == 'PropertyName':
            obj_ = PropertyNameType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'PropertyName'
        elif nodeName_ == 'Function':
            obj_ = FunctionType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Function'
        elif nodeName_ == 'Literal':
            obj_ = LiteralType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Literal'
        elif nodeName_ == 'LowerBoundary':
            obj_ = LowerBoundaryType.factory()
            obj_.build(child_)
            self.LowerBoundary = obj_
            obj_.original_tagname_ = 'LowerBoundary'
        elif nodeName_ == 'UpperBoundary':
            obj_ = UpperBoundaryType.factory()
            obj_.build(child_)
            self.UpperBoundary = obj_
            obj_.original_tagname_ = 'UpperBoundary'
        super(PropertyIsBetweenType, self).buildChildren(child_, node, nodeName_, True)


# end class PropertyIsBetweenType


class LowerBoundaryType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, expression=None):
        self.original_tagname_ = None
        self.expression = expression

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LowerBoundaryType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LowerBoundaryType.subclass:
            return LowerBoundaryType.subclass(*args_, **kwargs_)
        else:
            return LowerBoundaryType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_expression(self):
        return self.expression

    def set_expression(self, expression):
        self.expression = expression

    def hasContent_(self):
        if (
                    self.expression is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LowerBoundaryType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LowerBoundaryType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LowerBoundaryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LowerBoundaryType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='LowerBoundaryType'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LowerBoundaryType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.expression is not None:
            self.expression.export(outfile, level, namespace_, name_='expression', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'expression':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <expression> element')
            self.expression = obj_
            obj_.original_tagname_ = 'expression'
        elif nodeName_ == 'Add':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Add'
        elif nodeName_ == 'Sub':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Sub'
        elif nodeName_ == 'Mul':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Mul'
        elif nodeName_ == 'Div':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Div'
        elif nodeName_ == 'PropertyName':
            obj_ = PropertyNameType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'PropertyName'
        elif nodeName_ == 'Function':
            obj_ = FunctionType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Function'
        elif nodeName_ == 'Literal':
            obj_ = LiteralType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Literal'


# end class LowerBoundaryType


class UpperBoundaryType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, expression=None):
        self.original_tagname_ = None
        self.expression = expression

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UpperBoundaryType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UpperBoundaryType.subclass:
            return UpperBoundaryType.subclass(*args_, **kwargs_)
        else:
            return UpperBoundaryType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_expression(self):
        return self.expression

    def set_expression(self, expression):
        self.expression = expression

    def hasContent_(self):
        if (
                    self.expression is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='UpperBoundaryType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('UpperBoundaryType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UpperBoundaryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='UpperBoundaryType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='UpperBoundaryType'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='UpperBoundaryType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.expression is not None:
            self.expression.export(outfile, level, namespace_, name_='expression', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'expression':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <expression> element')
            self.expression = obj_
            obj_.original_tagname_ = 'expression'
        elif nodeName_ == 'Add':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Add'
        elif nodeName_ == 'Sub':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Sub'
        elif nodeName_ == 'Mul':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Mul'
        elif nodeName_ == 'Div':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Div'
        elif nodeName_ == 'PropertyName':
            obj_ = PropertyNameType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'PropertyName'
        elif nodeName_ == 'Function':
            obj_ = FunctionType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Function'
        elif nodeName_ == 'Literal':
            obj_ = LiteralType.factory()
            obj_.build(child_)
            self.expression = obj_
            obj_.original_tagname_ = 'Literal'


# end class UpperBoundaryType


class BinarySpatialOpType(SpatialOpsType):
    subclass = None
    superclass = SpatialOpsType

    def __init__(self, PropertyName=None, _Geometry=None, Box=None):
        self.original_tagname_ = None
        super(BinarySpatialOpType, self).__init__()
        self.PropertyName = PropertyName
        self._Geometry = _Geometry
        self.Box = Box

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BinarySpatialOpType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BinarySpatialOpType.subclass:
            return BinarySpatialOpType.subclass(*args_, **kwargs_)
        else:
            return BinarySpatialOpType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_PropertyName(self):
        return self.PropertyName

    def set_PropertyName(self, PropertyName):
        self.PropertyName = PropertyName

    def get__Geometry(self):
        return self._Geometry

    def set__Geometry(self, _Geometry):
        self._Geometry = _Geometry

    def get_Box(self):
        return self.Box

    def set_Box(self, Box):
        self.Box = Box

    def hasContent_(self):
        if (
                                self.PropertyName is not None or
                                self._Geometry is not None or
                            self.Box is not None or
                    super(BinarySpatialOpType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='BinarySpatialOpType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BinarySpatialOpType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BinarySpatialOpType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='BinarySpatialOpType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='BinarySpatialOpType'):
        super(BinarySpatialOpType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                          name_='BinarySpatialOpType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='BinarySpatialOpType',
                       fromsubclass_=False, pretty_print=True):
        super(BinarySpatialOpType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                        pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PropertyName is not None:
            self.PropertyName.export(outfile, level, namespace_='ogc:', name_='PropertyName',
                                     pretty_print=pretty_print)
        if self._Geometry is not None:
            self._Geometry.export(outfile, level, namespace_, name_='_Geometry', pretty_print=pretty_print)
        if self.Box is not None:
            self.Box.export(outfile, level, namespace_='gml:', name_='Box', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(BinarySpatialOpType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PropertyName':
            obj_ = PropertyNameType.factory()
            obj_.build(child_)
            self.PropertyName = obj_
            obj_.original_tagname_ = 'PropertyName'
        elif nodeName_ == '_Geometry':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <_Geometry> element')
            self._Geometry = obj_
            obj_.original_tagname_ = '_Geometry'
        elif nodeName_ == '_GeometryCollection':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = '_GeometryCollection'
        elif nodeName_ == 'Point':
            obj_ = PointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Point'
        elif nodeName_ == 'LineString':
            obj_ = LineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LineString'
        elif nodeName_ == 'LinearRing':
            obj_ = LinearRingType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LinearRing'
        elif nodeName_ == 'Polygon':
            obj_ = PolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Polygon'
        elif nodeName_ == 'MultiGeometry':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiGeometry'
        elif nodeName_ == 'MultiPoint':
            obj_ = MultiPointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPoint'
        elif nodeName_ == 'MultiLineString':
            obj_ = MultiLineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiLineString'
        elif nodeName_ == 'MultiPolygon':
            obj_ = MultiPolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPolygon'
        elif nodeName_ == '_GeometryCollection':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = '_GeometryCollection'
        elif nodeName_ == 'Point':
            obj_ = PointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Point'
        elif nodeName_ == 'LineString':
            obj_ = LineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LineString'
        elif nodeName_ == 'LinearRing':
            obj_ = LinearRingType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LinearRing'
        elif nodeName_ == 'Polygon':
            obj_ = PolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Polygon'
        elif nodeName_ == 'MultiGeometry':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiGeometry'
        elif nodeName_ == 'MultiPoint':
            obj_ = MultiPointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPoint'
        elif nodeName_ == 'MultiLineString':
            obj_ = MultiLineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiLineString'
        elif nodeName_ == 'MultiPolygon':
            obj_ = MultiPolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPolygon'
        elif nodeName_ == 'Box':
            obj_ = BoxType.factory()
            obj_.build(child_)
            self.Box = obj_
            obj_.original_tagname_ = 'Box'
        super(BinarySpatialOpType, self).buildChildren(child_, node, nodeName_, True)


# end class BinarySpatialOpType


class BBOXType(SpatialOpsType):
    subclass = None
    superclass = SpatialOpsType

    def __init__(self, PropertyName=None, Box=None):
        self.original_tagname_ = None
        super(BBOXType, self).__init__()
        self.PropertyName = PropertyName
        self.Box = Box

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BBOXType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BBOXType.subclass:
            return BBOXType.subclass(*args_, **kwargs_)
        else:
            return BBOXType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_PropertyName(self):
        return self.PropertyName

    def set_PropertyName(self, PropertyName):
        self.PropertyName = PropertyName

    def get_Box(self):
        return self.Box

    def set_Box(self, Box):
        self.Box = Box

    def hasContent_(self):
        if (
                            self.PropertyName is not None or
                            self.Box is not None or
                    super(BBOXType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='BBOXType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BBOXType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BBOXType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='BBOXType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='BBOXType'):
        super(BBOXType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                               name_='BBOXType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='BBOXType', fromsubclass_=False,
                       pretty_print=True):
        super(BBOXType, self).exportChildren(outfile, level, namespace_, name_, True,
                                             pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PropertyName is not None:
            self.PropertyName.export(outfile, level, namespace_='ogc:', name_='PropertyName',
                                     pretty_print=pretty_print)
        if self.Box is not None:
            self.Box.export(outfile, level, namespace_='gml:', name_='Box', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(BBOXType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PropertyName':
            obj_ = PropertyNameType.factory()
            obj_.build(child_)
            self.PropertyName = obj_
            obj_.original_tagname_ = 'PropertyName'
        elif nodeName_ == 'Box':
            obj_ = BoxType.factory()
            obj_.build(child_)
            self.Box = obj_
            obj_.original_tagname_ = 'Box'
        super(BBOXType, self).buildChildren(child_, node, nodeName_, True)


# end class BBOXType


class DistanceBufferType(SpatialOpsType):
    subclass = None
    superclass = SpatialOpsType

    def __init__(self, PropertyName=None, _Geometry=None, Distance=None):
        self.original_tagname_ = None
        super(DistanceBufferType, self).__init__()
        self.PropertyName = PropertyName
        self._Geometry = _Geometry
        self.Distance = Distance

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DistanceBufferType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DistanceBufferType.subclass:
            return DistanceBufferType.subclass(*args_, **kwargs_)
        else:
            return DistanceBufferType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_PropertyName(self):
        return self.PropertyName

    def set_PropertyName(self, PropertyName):
        self.PropertyName = PropertyName

    def get__Geometry(self):
        return self._Geometry

    def set__Geometry(self, _Geometry):
        self._Geometry = _Geometry

    def get_Distance(self):
        return self.Distance

    def set_Distance(self, Distance):
        self.Distance = Distance

    def hasContent_(self):
        if (
                                self.PropertyName is not None or
                                self._Geometry is not None or
                            self.Distance is not None or
                    super(DistanceBufferType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='DistanceBufferType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DistanceBufferType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DistanceBufferType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='DistanceBufferType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='DistanceBufferType'):
        super(DistanceBufferType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                         name_='DistanceBufferType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='DistanceBufferType',
                       fromsubclass_=False, pretty_print=True):
        super(DistanceBufferType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                       pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PropertyName is not None:
            self.PropertyName.export(outfile, level, namespace_='ogc:', name_='PropertyName',
                                     pretty_print=pretty_print)
        if self._Geometry is not None:
            self._Geometry.export(outfile, level, namespace_, name_='_Geometry', pretty_print=pretty_print)
        if self.Distance is not None:
            self.Distance.export(outfile, level, namespace_, name_='Distance', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(DistanceBufferType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'PropertyName':
            obj_ = PropertyNameType.factory()
            obj_.build(child_)
            self.PropertyName = obj_
            obj_.original_tagname_ = 'PropertyName'
        elif nodeName_ == '_Geometry':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <_Geometry> element')
            self._Geometry = obj_
            obj_.original_tagname_ = '_Geometry'
        elif nodeName_ == '_GeometryCollection':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = '_GeometryCollection'
        elif nodeName_ == 'Point':
            obj_ = PointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Point'
        elif nodeName_ == 'LineString':
            obj_ = LineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LineString'
        elif nodeName_ == 'LinearRing':
            obj_ = LinearRingType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LinearRing'
        elif nodeName_ == 'Polygon':
            obj_ = PolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Polygon'
        elif nodeName_ == 'MultiGeometry':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiGeometry'
        elif nodeName_ == 'MultiPoint':
            obj_ = MultiPointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPoint'
        elif nodeName_ == 'MultiLineString':
            obj_ = MultiLineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiLineString'
        elif nodeName_ == 'MultiPolygon':
            obj_ = MultiPolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPolygon'
        elif nodeName_ == '_GeometryCollection':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = '_GeometryCollection'
        elif nodeName_ == 'Point':
            obj_ = PointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Point'
        elif nodeName_ == 'LineString':
            obj_ = LineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LineString'
        elif nodeName_ == 'LinearRing':
            obj_ = LinearRingType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LinearRing'
        elif nodeName_ == 'Polygon':
            obj_ = PolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Polygon'
        elif nodeName_ == 'MultiGeometry':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiGeometry'
        elif nodeName_ == 'MultiPoint':
            obj_ = MultiPointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPoint'
        elif nodeName_ == 'MultiLineString':
            obj_ = MultiLineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiLineString'
        elif nodeName_ == 'MultiPolygon':
            obj_ = MultiPolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPolygon'
        elif nodeName_ == 'Distance':
            obj_ = DistanceType.factory()
            obj_.build(child_)
            self.Distance = obj_
            obj_.original_tagname_ = 'Distance'
        super(DistanceBufferType, self).buildChildren(child_, node, nodeName_, True)


# end class DistanceBufferType


class DistanceType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, units=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DistanceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DistanceType.subclass:
            return DistanceType.subclass(*args_, **kwargs_)
        else:
            return DistanceType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_units(self):
        return self.units

    def set_units(self, units):
        self.units = units

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
                1 if type(self.valueOf_) in [int, float] else self.valueOf_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='DistanceType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DistanceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DistanceType')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='DistanceType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='DistanceType', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass


# end class DistanceType


class BinaryLogicOpType(LogicOpsType):
    subclass = None
    superclass = LogicOpsType

    def __init__(self, comparisonOps=None, spatialOps=None, logicOps=None):
        self.original_tagname_ = None
        super(BinaryLogicOpType, self).__init__()
        if comparisonOps is None:
            self.comparisonOps = []
        else:
            self.comparisonOps = comparisonOps
        if spatialOps is None:
            self.spatialOps = []
        else:
            self.spatialOps = spatialOps
        if logicOps is None:
            self.logicOps = []
        else:
            self.logicOps = logicOps

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BinaryLogicOpType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BinaryLogicOpType.subclass:
            return BinaryLogicOpType.subclass(*args_, **kwargs_)
        else:
            return BinaryLogicOpType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_comparisonOps(self):
        return self.comparisonOps

    def set_comparisonOps(self, comparisonOps):
        self.comparisonOps = comparisonOps

    def add_comparisonOps(self, value):
        self.comparisonOps.append(value)

    def insert_comparisonOps_at(self, index, value):
        self.comparisonOps.insert(index, value)

    def replace_comparisonOps_at(self, index, value):
        self.comparisonOps[index] = value

    def get_spatialOps(self):
        return self.spatialOps

    def set_spatialOps(self, spatialOps):
        self.spatialOps = spatialOps

    def add_spatialOps(self, value):
        self.spatialOps.append(value)

    def insert_spatialOps_at(self, index, value):
        self.spatialOps.insert(index, value)

    def replace_spatialOps_at(self, index, value):
        self.spatialOps[index] = value

    def get_logicOps(self):
        return self.logicOps

    def set_logicOps(self, logicOps):
        self.logicOps = logicOps

    def add_logicOps(self, value):
        self.logicOps.append(value)

    def insert_logicOps_at(self, index, value):
        self.logicOps.insert(index, value)

    def replace_logicOps_at(self, index, value):
        self.logicOps[index] = value

    def hasContent_(self):
        if (
                            self.comparisonOps or
                            self.spatialOps or
                        self.logicOps or
                    super(BinaryLogicOpType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='BinaryLogicOpType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BinaryLogicOpType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BinaryLogicOpType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='BinaryLogicOpType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='BinaryLogicOpType'):
        super(BinaryLogicOpType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                        name_='BinaryLogicOpType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='BinaryLogicOpType',
                       fromsubclass_=False, pretty_print=True):
        super(BinaryLogicOpType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                      pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for comparisonOps_ in self.comparisonOps:
            comparisonOps_.export(outfile, level, namespace_, name_='comparisonOps',
                                  pretty_print=pretty_print)
        for spatialOps_ in self.spatialOps:
            spatialOps_.export(outfile, level, namespace_, name_='spatialOps', pretty_print=pretty_print)
        for logicOps_ in self.logicOps:
            logicOps_.export(outfile, level, namespace_, name_='logicOps', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(BinaryLogicOpType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'comparisonOps':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <comparisonOps> element')
            self.comparisonOps.append(obj_)
            obj_.original_tagname_ = 'comparisonOps'
        elif nodeName_ == 'PropertyIsEqualTo':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps.append(obj_)
            obj_.original_tagname_ = 'PropertyIsEqualTo'
        elif nodeName_ == 'PropertyIsNotEqualTo':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps.append(obj_)
            obj_.original_tagname_ = 'PropertyIsNotEqualTo'
        elif nodeName_ == 'PropertyIsLessThan':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps.append(obj_)
            obj_.original_tagname_ = 'PropertyIsLessThan'
        elif nodeName_ == 'PropertyIsGreaterThan':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps.append(obj_)
            obj_.original_tagname_ = 'PropertyIsGreaterThan'
        elif nodeName_ == 'PropertyIsLessThanOrEqualTo':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps.append(obj_)
            obj_.original_tagname_ = 'PropertyIsLessThanOrEqualTo'
        elif nodeName_ == 'PropertyIsGreaterThanOrEqualTo':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps.append(obj_)
            obj_.original_tagname_ = 'PropertyIsGreaterThanOrEqualTo'
        elif nodeName_ == 'PropertyIsLike':
            obj_ = PropertyIsLikeType.factory()
            obj_.build(child_)
            self.comparisonOps.append(obj_)
            obj_.original_tagname_ = 'PropertyIsLike'
        elif nodeName_ == 'PropertyIsNull':
            obj_ = PropertyIsNullType.factory()
            obj_.build(child_)
            self.comparisonOps.append(obj_)
            obj_.original_tagname_ = 'PropertyIsNull'
        elif nodeName_ == 'PropertyIsBetween':
            obj_ = PropertyIsBetweenType.factory()
            obj_.build(child_)
            self.comparisonOps.append(obj_)
            obj_.original_tagname_ = 'PropertyIsBetween'
        elif nodeName_ == 'spatialOps':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <spatialOps> element')
            self.spatialOps.append(obj_)
            obj_.original_tagname_ = 'spatialOps'
        elif nodeName_ == 'Equals':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps.append(obj_)
            obj_.original_tagname_ = 'Equals'
        elif nodeName_ == 'Disjoint':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps.append(obj_)
            obj_.original_tagname_ = 'Disjoint'
        elif nodeName_ == 'Touches':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps.append(obj_)
            obj_.original_tagname_ = 'Touches'
        elif nodeName_ == 'Within':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps.append(obj_)
            obj_.original_tagname_ = 'Within'
        elif nodeName_ == 'Overlaps':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps.append(obj_)
            obj_.original_tagname_ = 'Overlaps'
        elif nodeName_ == 'Crosses':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps.append(obj_)
            obj_.original_tagname_ = 'Crosses'
        elif nodeName_ == 'Intersects':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps.append(obj_)
            obj_.original_tagname_ = 'Intersects'
        elif nodeName_ == 'Contains':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps.append(obj_)
            obj_.original_tagname_ = 'Contains'
        elif nodeName_ == 'DWithin':
            obj_ = DistanceBufferType.factory()
            obj_.build(child_)
            self.spatialOps.append(obj_)
            obj_.original_tagname_ = 'DWithin'
        elif nodeName_ == 'Beyond':
            obj_ = DistanceBufferType.factory()
            obj_.build(child_)
            self.spatialOps.append(obj_)
            obj_.original_tagname_ = 'Beyond'
        elif nodeName_ == 'BBOX':
            obj_ = BBOXType.factory()
            obj_.build(child_)
            self.spatialOps.append(obj_)
            obj_.original_tagname_ = 'BBOX'
        elif nodeName_ == 'logicOps':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <logicOps> element')
            self.logicOps.append(obj_)
            obj_.original_tagname_ = 'logicOps'
        elif nodeName_ == 'And':
            obj_ = BinaryLogicOpType.factory()
            obj_.build(child_)
            self.logicOps.append(obj_)
            obj_.original_tagname_ = 'And'
        elif nodeName_ == 'Or':
            obj_ = BinaryLogicOpType.factory()
            obj_.build(child_)
            self.logicOps.append(obj_)
            obj_.original_tagname_ = 'Or'
        elif nodeName_ == 'Not':
            obj_ = UnaryLogicOpType.factory()
            obj_.build(child_)
            self.logicOps.append(obj_)
            obj_.original_tagname_ = 'Not'
        super(BinaryLogicOpType, self).buildChildren(child_, node, nodeName_, True)


# end class BinaryLogicOpType


class UnaryLogicOpType(LogicOpsType):
    subclass = None
    superclass = LogicOpsType

    def __init__(self, comparisonOps=None, spatialOps=None, logicOps=None):
        self.original_tagname_ = None
        super(UnaryLogicOpType, self).__init__()
        self.comparisonOps = comparisonOps
        self.spatialOps = spatialOps
        self.logicOps = logicOps

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UnaryLogicOpType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UnaryLogicOpType.subclass:
            return UnaryLogicOpType.subclass(*args_, **kwargs_)
        else:
            return UnaryLogicOpType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_comparisonOps(self):
        return self.comparisonOps

    def set_comparisonOps(self, comparisonOps):
        self.comparisonOps = comparisonOps

    def get_spatialOps(self):
        return self.spatialOps

    def set_spatialOps(self, spatialOps):
        self.spatialOps = spatialOps

    def get_logicOps(self):
        return self.logicOps

    def set_logicOps(self, logicOps):
        self.logicOps = logicOps

    def hasContent_(self):
        if (
                                self.comparisonOps is not None or
                                self.spatialOps is not None or
                            self.logicOps is not None or
                    super(UnaryLogicOpType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='UnaryLogicOpType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('UnaryLogicOpType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UnaryLogicOpType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='UnaryLogicOpType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='UnaryLogicOpType'):
        super(UnaryLogicOpType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                       name_='UnaryLogicOpType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='UnaryLogicOpType', fromsubclass_=False,
                       pretty_print=True):
        super(UnaryLogicOpType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                     pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.comparisonOps is not None:
            self.comparisonOps.export(outfile, level, namespace_, name_='comparisonOps',
                                      pretty_print=pretty_print)
        if self.spatialOps is not None:
            self.spatialOps.export(outfile, level, namespace_, name_='spatialOps', pretty_print=pretty_print)
        if self.logicOps is not None:
            self.logicOps.export(outfile, level, namespace_, name_='logicOps', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(UnaryLogicOpType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'comparisonOps':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <comparisonOps> element')
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'comparisonOps'
        elif nodeName_ == 'PropertyIsEqualTo':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsEqualTo'
        elif nodeName_ == 'PropertyIsNotEqualTo':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsNotEqualTo'
        elif nodeName_ == 'PropertyIsLessThan':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsLessThan'
        elif nodeName_ == 'PropertyIsGreaterThan':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsGreaterThan'
        elif nodeName_ == 'PropertyIsLessThanOrEqualTo':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsLessThanOrEqualTo'
        elif nodeName_ == 'PropertyIsGreaterThanOrEqualTo':
            obj_ = BinaryComparisonOpType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsGreaterThanOrEqualTo'
        elif nodeName_ == 'PropertyIsLike':
            obj_ = PropertyIsLikeType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsLike'
        elif nodeName_ == 'PropertyIsNull':
            obj_ = PropertyIsNullType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsNull'
        elif nodeName_ == 'PropertyIsBetween':
            obj_ = PropertyIsBetweenType.factory()
            obj_.build(child_)
            self.comparisonOps = obj_
            obj_.original_tagname_ = 'PropertyIsBetween'
        elif nodeName_ == 'spatialOps':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <spatialOps> element')
            self.spatialOps = obj_
            obj_.original_tagname_ = 'spatialOps'
        elif nodeName_ == 'Equals':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Equals'
        elif nodeName_ == 'Disjoint':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Disjoint'
        elif nodeName_ == 'Touches':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Touches'
        elif nodeName_ == 'Within':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Within'
        elif nodeName_ == 'Overlaps':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Overlaps'
        elif nodeName_ == 'Crosses':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Crosses'
        elif nodeName_ == 'Intersects':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Intersects'
        elif nodeName_ == 'Contains':
            obj_ = BinarySpatialOpType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Contains'
        elif nodeName_ == 'DWithin':
            obj_ = DistanceBufferType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'DWithin'
        elif nodeName_ == 'Beyond':
            obj_ = DistanceBufferType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'Beyond'
        elif nodeName_ == 'BBOX':
            obj_ = BBOXType.factory()
            obj_.build(child_)
            self.spatialOps = obj_
            obj_.original_tagname_ = 'BBOX'
        elif nodeName_ == 'logicOps':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <logicOps> element')
            self.logicOps = obj_
            obj_.original_tagname_ = 'logicOps'
        elif nodeName_ == 'And':
            obj_ = BinaryLogicOpType.factory()
            obj_.build(child_)
            self.logicOps = obj_
            obj_.original_tagname_ = 'And'
        elif nodeName_ == 'Or':
            obj_ = BinaryLogicOpType.factory()
            obj_.build(child_)
            self.logicOps = obj_
            obj_.original_tagname_ = 'Or'
        elif nodeName_ == 'Not':
            obj_ = UnaryLogicOpType.factory()
            obj_.build(child_)
            self.logicOps = obj_
            obj_.original_tagname_ = 'Not'
        super(UnaryLogicOpType, self).buildChildren(child_, node, nodeName_, True)


# end class UnaryLogicOpType


class ExpressionType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExpressionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExpressionType.subclass:
            return ExpressionType.subclass(*args_, **kwargs_)
        else:
            return ExpressionType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if (
                1 if type(self.valueOf_) in [int, float] else self.valueOf_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='ExpressionType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ExpressionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExpressionType')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='ExpressionType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='ExpressionType', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass


# end class ExpressionType


class BinaryOperatorType(ExpressionType):
    subclass = None
    superclass = ExpressionType

    def __init__(self, expression=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(BinaryOperatorType, self).__init__(valueOf_, mixedclass_, content_, )
        if expression is None:
            self.expression = []
        else:
            self.expression = expression
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BinaryOperatorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BinaryOperatorType.subclass:
            return BinaryOperatorType.subclass(*args_, **kwargs_)
        else:
            return BinaryOperatorType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_expression(self):
        return self.expression

    def set_expression(self, expression):
        self.expression = expression

    def add_expression(self, value):
        self.expression.append(value)

    def insert_expression_at(self, index, value):
        self.expression.insert(index, value)

    def replace_expression_at(self, index, value):
        self.expression[index] = value

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
                    self.expression or
                    1 if type(self.valueOf_) in [int, float] else self.valueOf_ or
                    super(BinaryOperatorType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='BinaryOperatorType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BinaryOperatorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BinaryOperatorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='BinaryOperatorType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='BinaryOperatorType'):
        super(BinaryOperatorType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                         name_='BinaryOperatorType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='BinaryOperatorType',
                       fromsubclass_=False, pretty_print=True):
        super(BinaryOperatorType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                       pretty_print=pretty_print)
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(BinaryOperatorType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'expression':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <expression> element')
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'expression', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_expression'):
                self.add_expression(obj_.value)
            elif hasattr(self, 'set_expression'):
                self.set_expression(obj_.value)
        elif nodeName_ == 'Add':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Add', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Add'):
                self.add_Add(obj_.value)
            elif hasattr(self, 'set_Add'):
                self.set_Add(obj_.value)
        elif nodeName_ == 'Sub':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Sub'):
                self.add_Sub(obj_.value)
            elif hasattr(self, 'set_Sub'):
                self.set_Sub(obj_.value)
        elif nodeName_ == 'Mul':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Mul', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Mul'):
                self.add_Mul(obj_.value)
            elif hasattr(self, 'set_Mul'):
                self.set_Mul(obj_.value)
        elif nodeName_ == 'Div':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Div', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Div'):
                self.add_Div(obj_.value)
            elif hasattr(self, 'set_Div'):
                self.set_Div(obj_.value)
        elif nodeName_ == 'PropertyName':
            obj_ = PropertyNameType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'PropertyName', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_PropertyName'):
                self.add_PropertyName(obj_.value)
            elif hasattr(self, 'set_PropertyName'):
                self.set_PropertyName(obj_.value)
        elif nodeName_ == 'Function':
            obj_ = FunctionType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Function', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Function'):
                self.add_Function(obj_.value)
            elif hasattr(self, 'set_Function'):
                self.set_Function(obj_.value)
        elif nodeName_ == 'Literal':
            obj_ = LiteralType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Literal', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Literal'):
                self.add_Literal(obj_.value)
            elif hasattr(self, 'set_Literal'):
                self.set_Literal(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(BinaryOperatorType, self).buildChildren(child_, node, nodeName_, True)


# end class BinaryOperatorType


class FunctionType(ExpressionType):
    subclass = None
    superclass = ExpressionType

    def __init__(self, name=None, expression=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(FunctionType, self).__init__(valueOf_, mixedclass_, content_, )
        self.name = _cast(None, name)
        if expression is None:
            self.expression = []
        else:
            self.expression = expression
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FunctionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FunctionType.subclass:
            return FunctionType.subclass(*args_, **kwargs_)
        else:
            return FunctionType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_expression(self):
        return self.expression

    def set_expression(self, expression):
        self.expression = expression

    def add_expression(self, value):
        self.expression.append(value)

    def insert_expression_at(self, index, value):
        self.expression.insert(index, value)

    def replace_expression_at(self, index, value):
        self.expression[index] = value

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
                    self.expression or
                    1 if type(self.valueOf_) in [int, float] else self.valueOf_ or
                    super(FunctionType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='FunctionType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" ',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('FunctionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FunctionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='FunctionType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='FunctionType'):
        super(FunctionType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                   name_='FunctionType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='FunctionType', fromsubclass_=False,
                       pretty_print=True):
        super(FunctionType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                 pretty_print=pretty_print)
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        super(FunctionType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'expression':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <expression> element')
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'expression', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_expression'):
                self.add_expression(obj_.value)
            elif hasattr(self, 'set_expression'):
                self.set_expression(obj_.value)
        elif nodeName_ == 'Add':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Add', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Add'):
                self.add_Add(obj_.value)
            elif hasattr(self, 'set_Add'):
                self.set_Add(obj_.value)
        elif nodeName_ == 'Sub':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Sub', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Sub'):
                self.add_Sub(obj_.value)
            elif hasattr(self, 'set_Sub'):
                self.set_Sub(obj_.value)
        elif nodeName_ == 'Mul':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Mul', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Mul'):
                self.add_Mul(obj_.value)
            elif hasattr(self, 'set_Mul'):
                self.set_Mul(obj_.value)
        elif nodeName_ == 'Div':
            obj_ = BinaryOperatorType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Div', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Div'):
                self.add_Div(obj_.value)
            elif hasattr(self, 'set_Div'):
                self.set_Div(obj_.value)
        elif nodeName_ == 'PropertyName':
            obj_ = PropertyNameType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'PropertyName', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_PropertyName'):
                self.add_PropertyName(obj_.value)
            elif hasattr(self, 'set_PropertyName'):
                self.set_PropertyName(obj_.value)
        elif nodeName_ == 'Function':
            obj_ = FunctionType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Function', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Function'):
                self.add_Function(obj_.value)
            elif hasattr(self, 'set_Function'):
                self.set_Function(obj_.value)
        elif nodeName_ == 'Literal':
            obj_ = LiteralType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Literal', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Literal'):
                self.add_Literal(obj_.value)
            elif hasattr(self, 'set_Literal'):
                self.set_Literal(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(FunctionType, self).buildChildren(child_, node, nodeName_, True)


# end class FunctionType


class LiteralType(ExpressionType):
    subclass = None
    superclass = ExpressionType

    def __init__(self, anytypeobjs_=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(LiteralType, self).__init__(valueOf_, mixedclass_, content_, )
        self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LiteralType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LiteralType.subclass:
            return LiteralType.subclass(*args_, **kwargs_)
        else:
            return LiteralType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
                        self.anytypeobjs_ is not None or
                    1 if type(self.valueOf_) in [int, float] else self.valueOf_ or
                    super(LiteralType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LiteralType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LiteralType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LiteralType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LiteralType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='LiteralType'):
        super(LiteralType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                  name_='LiteralType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LiteralType', fromsubclass_=False,
                       pretty_print=True):
        super(LiteralType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                pretty_print=pretty_print)
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(LiteralType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == '':
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, '', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_'):
                self.add_(obj_.value)
            elif hasattr(self, 'set_'):
                self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(LiteralType, self).buildChildren(child_, node, nodeName_, True)


# end class LiteralType


class PropertyNameType(ExpressionType):
    subclass = None
    superclass = ExpressionType

    def __init__(self, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(PropertyNameType, self).__init__(valueOf_, mixedclass_, content_, )
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PropertyNameType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PropertyNameType.subclass:
            return PropertyNameType.subclass(*args_, **kwargs_)
        else:
            return PropertyNameType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
                1 if type(self.valueOf_) in [int, float] else self.valueOf_ or
                    super(PropertyNameType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='PropertyNameType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PropertyNameType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PropertyNameType')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='PropertyNameType'):
        super(PropertyNameType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                       name_='PropertyNameType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='PropertyNameType', fromsubclass_=False,
                       pretty_print=True):
        super(PropertyNameType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                     pretty_print=pretty_print)
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(PropertyNameType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(PropertyNameType, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class PropertyNameType


class AbstractGeometryType(GeneratedsSuper):
    """All geometry elements are derived from this abstract supertype; a
    geometry element may have an identifying attribute (gid). It may
    be associated with a spatial reference system."""
    subclass = None
    superclass = None

    def __init__(self, gid=None, srsName=None):
        self.original_tagname_ = None
        self.gid = _cast(None, gid)
        self.srsName = _cast(None, srsName)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AbstractGeometryType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AbstractGeometryType.subclass:
            return AbstractGeometryType.subclass(*args_, **kwargs_)
        else:
            return AbstractGeometryType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_gid(self):
        return self.gid

    def set_gid(self, gid):
        self.gid = gid

    def get_srsName(self):
        return self.srsName

    def set_srsName(self, srsName):
        self.srsName = srsName

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='AbstractGeometryType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AbstractGeometryType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractGeometryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='AbstractGeometryType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='AbstractGeometryType'):
        if self.gid is not None and 'gid' not in already_processed:
            already_processed.add('gid')
            outfile.write(' gid=%s' % (quote_attrib(self.gid),))
        if self.srsName is not None and 'srsName' not in already_processed:
            already_processed.add('srsName')
            outfile.write(' srsName=%s' % (quote_attrib(self.srsName),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='AbstractGeometryType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('gid', node)
        if value is not None and 'gid' not in already_processed:
            already_processed.add('gid')
            self.gid = value
        value = find_attr_value_('srsName', node)
        if value is not None and 'srsName' not in already_processed:
            already_processed.add('srsName')
            self.srsName = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class AbstractGeometryType


class AbstractGeometryCollectionBaseType(GeneratedsSuper):
    """This abstract base type for geometry collections just makes the
    srsName attribute mandatory."""
    subclass = None
    superclass = None

    def __init__(self, gid=None, srsName=None):
        self.original_tagname_ = None
        self.gid = _cast(None, gid)
        self.srsName = _cast(None, srsName)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AbstractGeometryCollectionBaseType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AbstractGeometryCollectionBaseType.subclass:
            return AbstractGeometryCollectionBaseType.subclass(*args_, **kwargs_)
        else:
            return AbstractGeometryCollectionBaseType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_gid(self):
        return self.gid

    def set_gid(self, gid):
        self.gid = gid

    def get_srsName(self):
        return self.srsName

    def set_srsName(self, srsName):
        self.srsName = srsName

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='AbstractGeometryCollectionBaseType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AbstractGeometryCollectionBaseType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_,
                              name_='AbstractGeometryCollectionBaseType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:',
                                name_='AbstractGeometryCollectionBaseType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='AbstractGeometryCollectionBaseType'):
        if self.gid is not None and 'gid' not in already_processed:
            already_processed.add('gid')
            outfile.write(' gid=%s' % (quote_attrib(self.gid),))
        if self.srsName is not None and 'srsName' not in already_processed:
            already_processed.add('srsName')
            outfile.write(' srsName=%s' % (quote_attrib(self.srsName),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='AbstractGeometryCollectionBaseType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('gid', node)
        if value is not None and 'gid' not in already_processed:
            already_processed.add('gid')
            self.gid = value
        value = find_attr_value_('srsName', node)
        if value is not None and 'srsName' not in already_processed:
            already_processed.add('srsName')
            self.srsName = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class AbstractGeometryCollectionBaseType


class GeometryAssociationType(GeneratedsSuper):
    """An instance of this type (e.g. a geometryMember) can either enclose
    or point to a primitive geometry element. When serving as a
    simple link that references a remote geometry instance, the
    value of the gml:remoteSchema attribute can be used to locate a
    schema fragment that constrains the target instance."""
    subclass = None
    superclass = None

    def __init__(self, remoteSchema=None, type_=None, href=None, role=None, arcrole=None, title=None,
                 show=None, actuate=None, _Geometry=None):
        self.original_tagname_ = None
        self.remoteSchema = _cast(None, remoteSchema)
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self._Geometry = _Geometry

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GeometryAssociationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GeometryAssociationType.subclass:
            return GeometryAssociationType.subclass(*args_, **kwargs_)
        else:
            return GeometryAssociationType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get__Geometry(self):
        return self._Geometry

    def set__Geometry(self, _Geometry):
        self._Geometry = _Geometry

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def hasContent_(self):
        if (
                    self._Geometry is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='GeometryAssociationType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GeometryAssociationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GeometryAssociationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='GeometryAssociationType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='GeometryAssociationType'):
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='GeometryAssociationType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self._Geometry is not None:
            self._Geometry.export(outfile, level, namespace_, name_='_Geometry', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == '_Geometry':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <_Geometry> element')
            self._Geometry = obj_
            obj_.original_tagname_ = '_Geometry'
        elif nodeName_ == '_GeometryCollection':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = '_GeometryCollection'
        elif nodeName_ == 'Point':
            obj_ = PointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Point'
        elif nodeName_ == 'LineString':
            obj_ = LineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LineString'
        elif nodeName_ == 'LinearRing':
            obj_ = LinearRingType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LinearRing'
        elif nodeName_ == 'Polygon':
            obj_ = PolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Polygon'
        elif nodeName_ == 'MultiGeometry':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiGeometry'
        elif nodeName_ == 'MultiPoint':
            obj_ = MultiPointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPoint'
        elif nodeName_ == 'MultiLineString':
            obj_ = MultiLineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiLineString'
        elif nodeName_ == 'MultiPolygon':
            obj_ = MultiPolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPolygon'
        elif nodeName_ == '_GeometryCollection':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = '_GeometryCollection'
        elif nodeName_ == 'Point':
            obj_ = PointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Point'
        elif nodeName_ == 'LineString':
            obj_ = LineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LineString'
        elif nodeName_ == 'LinearRing':
            obj_ = LinearRingType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LinearRing'
        elif nodeName_ == 'Polygon':
            obj_ = PolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Polygon'
        elif nodeName_ == 'MultiGeometry':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiGeometry'
        elif nodeName_ == 'MultiPoint':
            obj_ = MultiPointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPoint'
        elif nodeName_ == 'MultiLineString':
            obj_ = MultiLineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiLineString'
        elif nodeName_ == 'MultiPolygon':
            obj_ = MultiPolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPolygon'


# end class GeometryAssociationType


class PointMemberType(GeneratedsSuper):
    """Restricts the geometry member to being a Point instance."""
    subclass = None
    superclass = None

    def __init__(self, type_=None, href=None, role=None, arcrole=None, title=None, show=None, actuate=None,
                 remoteSchema=None, Point=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self.remoteSchema = _cast(None, remoteSchema)
        self.Point = Point

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PointMemberType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PointMemberType.subclass:
            return PointMemberType.subclass(*args_, **kwargs_)
        else:
            return PointMemberType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Point(self):
        return self.Point

    def set_Point(self, Point):
        self.Point = Point

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def hasContent_(self):
        if (
                    self.Point is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='PointMemberType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PointMemberType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PointMemberType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='PointMemberType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='PointMemberType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='PointMemberType', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Point is not None:
            self.Point.export(outfile, level, namespace_='gml:', name_='Point', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Point':
            obj_ = PointType.factory()
            obj_.build(child_)
            self.Point = obj_
            obj_.original_tagname_ = 'Point'


# end class PointMemberType


class LineStringMemberType(GeneratedsSuper):
    """Restricts the geometry member to being a LineString instance."""
    subclass = None
    superclass = None

    def __init__(self, type_=None, href=None, role=None, arcrole=None, title=None, show=None, actuate=None,
                 remoteSchema=None, LineString=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self.remoteSchema = _cast(None, remoteSchema)
        self.LineString = LineString

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LineStringMemberType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LineStringMemberType.subclass:
            return LineStringMemberType.subclass(*args_, **kwargs_)
        else:
            return LineStringMemberType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_LineString(self):
        return self.LineString

    def set_LineString(self, LineString):
        self.LineString = LineString

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def hasContent_(self):
        if (
                    self.LineString is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LineStringMemberType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LineStringMemberType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LineStringMemberType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LineStringMemberType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='LineStringMemberType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LineStringMemberType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.LineString is not None:
            self.LineString.export(outfile, level, namespace_='gml:', name_='LineString',
                                   pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'LineString':
            obj_ = LineStringType.factory()
            obj_.build(child_)
            self.LineString = obj_
            obj_.original_tagname_ = 'LineString'


# end class LineStringMemberType


class PolygonMemberType(GeneratedsSuper):
    """Restricts the geometry member to being a Polygon instance."""
    subclass = None
    superclass = None

    def __init__(self, type_=None, href=None, role=None, arcrole=None, title=None, show=None, actuate=None,
                 remoteSchema=None, Polygon=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self.remoteSchema = _cast(None, remoteSchema)
        self.Polygon = Polygon

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PolygonMemberType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PolygonMemberType.subclass:
            return PolygonMemberType.subclass(*args_, **kwargs_)
        else:
            return PolygonMemberType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Polygon(self):
        return self.Polygon

    def set_Polygon(self, Polygon):
        self.Polygon = Polygon

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def hasContent_(self):
        if (
                    self.Polygon is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='PolygonMemberType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PolygonMemberType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PolygonMemberType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='PolygonMemberType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='PolygonMemberType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='PolygonMemberType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Polygon is not None:
            self.Polygon.export(outfile, level, namespace_='gml:', name_='Polygon', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Polygon':
            obj_ = PolygonType.factory()
            obj_.build(child_)
            self.Polygon = obj_
            obj_.original_tagname_ = 'Polygon'


# end class PolygonMemberType


class LinearRingMemberType(GeneratedsSuper):
    """Restricts the outer or inner boundary of a polygon instance to being
    a LinearRing."""
    subclass = None
    superclass = None

    def __init__(self, type_=None, href=None, role=None, arcrole=None, title=None, show=None, actuate=None,
                 remoteSchema=None, LinearRing=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self.remoteSchema = _cast(None, remoteSchema)
        self.LinearRing = LinearRing

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LinearRingMemberType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LinearRingMemberType.subclass:
            return LinearRingMemberType.subclass(*args_, **kwargs_)
        else:
            return LinearRingMemberType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_LinearRing(self):
        return self.LinearRing

    def set_LinearRing(self, LinearRing):
        self.LinearRing = LinearRing

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def hasContent_(self):
        if (
                    self.LinearRing is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LinearRingMemberType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LinearRingMemberType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinearRingMemberType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LinearRingMemberType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='LinearRingMemberType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LinearRingMemberType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.LinearRing is not None:
            self.LinearRing.export(outfile, level, namespace_='gml:', name_='LinearRing',
                                   pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'LinearRing':
            obj_ = LinearRingType.factory()
            obj_.build(child_)
            self.LinearRing = obj_
            obj_.original_tagname_ = 'LinearRing'


# end class LinearRingMemberType


class PointType(AbstractGeometryType):
    """A Point is defined by a single coordinate tuple."""
    subclass = None
    superclass = AbstractGeometryType

    def __init__(self, gid=None, srsName=None, coord=None, coordinates=None):
        self.original_tagname_ = None
        super(PointType, self).__init__(gid, srsName, )
        self.coord = coord
        self.coordinates = coordinates

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PointType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PointType.subclass:
            return PointType.subclass(*args_, **kwargs_)
        else:
            return PointType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_coord(self):
        return self.coord

    def set_coord(self, coord):
        self.coord = coord

    def get_coordinates(self):
        return self.coordinates

    def set_coordinates(self, coordinates):
        self.coordinates = coordinates

    def hasContent_(self):
        if (
                            self.coord is not None or
                            self.coordinates is not None or
                    super(PointType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='PointType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PointType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PointType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='PointType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='PointType'):
        super(PointType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                name_='PointType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='PointType', fromsubclass_=False,
                       pretty_print=True):
        super(PointType, self).exportChildren(outfile, level, namespace_, name_, True,
                                              pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.coord is not None:
            self.coord.export(outfile, level, namespace_='gml:', name_='coord', pretty_print=pretty_print)
        if self.coordinates is not None:
            self.coordinates.export(outfile, level, namespace_='gml:', name_='coordinates',
                                    pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(PointType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'coord':
            obj_ = CoordType.factory()
            obj_.build(child_)
            self.coord = obj_
            obj_.original_tagname_ = 'coord'
        elif nodeName_ == 'coordinates':
            obj_ = CoordinatesType.factory()
            obj_.build(child_)
            self.coordinates = obj_
            obj_.original_tagname_ = 'coordinates'
        super(PointType, self).buildChildren(child_, node, nodeName_, True)


# end class PointType


class LineStringType(AbstractGeometryType):
    """A LineString is defined by two or more coordinate tuples, with
    linear interpolation between them."""
    subclass = None
    superclass = AbstractGeometryType

    def __init__(self, gid=None, srsName=None, coord=None, coordinates=None):
        self.original_tagname_ = None
        super(LineStringType, self).__init__(gid, srsName, )
        if coord is None:
            self.coord = []
        else:
            self.coord = coord
        self.coordinates = coordinates

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LineStringType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LineStringType.subclass:
            return LineStringType.subclass(*args_, **kwargs_)
        else:
            return LineStringType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_coord(self):
        return self.coord

    def set_coord(self, coord):
        self.coord = coord

    def add_coord(self, value):
        self.coord.append(value)

    def insert_coord_at(self, index, value):
        self.coord.insert(index, value)

    def replace_coord_at(self, index, value):
        self.coord[index] = value

    def get_coordinates(self):
        return self.coordinates

    def set_coordinates(self, coordinates):
        self.coordinates = coordinates

    def hasContent_(self):
        if (
                        self.coord or
                            self.coordinates is not None or
                    super(LineStringType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LineStringType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LineStringType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LineStringType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LineStringType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='LineStringType'):
        super(LineStringType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                     name_='LineStringType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LineStringType', fromsubclass_=False,
                       pretty_print=True):
        super(LineStringType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                   pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for coord_ in self.coord:
            coord_.export(outfile, level, namespace_='gml:', name_='coord', pretty_print=pretty_print)
        if self.coordinates is not None:
            self.coordinates.export(outfile, level, namespace_='gml:', name_='coordinates',
                                    pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(LineStringType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'coord':
            obj_ = CoordType.factory()
            obj_.build(child_)
            self.coord.append(obj_)
            obj_.original_tagname_ = 'coord'
        elif nodeName_ == 'coordinates':
            obj_ = CoordinatesType.factory()
            obj_.build(child_)
            self.coordinates = obj_
            obj_.original_tagname_ = 'coordinates'
        super(LineStringType, self).buildChildren(child_, node, nodeName_, True)


# end class LineStringType


class LinearRingType(AbstractGeometryType):
    """A LinearRing is defined by four or more coordinate tuples, with
    linear interpolation between them; the first and last
    coordinates must be coincident."""
    subclass = None
    superclass = AbstractGeometryType

    def __init__(self, gid=None, srsName=None, coord=None, coordinates=None):
        self.original_tagname_ = None
        super(LinearRingType, self).__init__(gid, srsName, )
        if coord is None:
            self.coord = []
        else:
            self.coord = coord
        self.coordinates = coordinates

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LinearRingType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LinearRingType.subclass:
            return LinearRingType.subclass(*args_, **kwargs_)
        else:
            return LinearRingType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_coord(self):
        return self.coord

    def set_coord(self, coord):
        self.coord = coord

    def add_coord(self, value):
        self.coord.append(value)

    def insert_coord_at(self, index, value):
        self.coord.insert(index, value)

    def replace_coord_at(self, index, value):
        self.coord[index] = value

    def get_coordinates(self):
        return self.coordinates

    def set_coordinates(self, coordinates):
        self.coordinates = coordinates

    def hasContent_(self):
        if (
                        self.coord or
                            self.coordinates is not None or
                    super(LinearRingType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LinearRingType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LinearRingType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinearRingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LinearRingType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='LinearRingType'):
        super(LinearRingType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                     name_='LinearRingType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LinearRingType', fromsubclass_=False,
                       pretty_print=True):
        super(LinearRingType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                   pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for coord_ in self.coord:
            coord_.export(outfile, level, namespace_='gml:', name_='coord', pretty_print=pretty_print)
        if self.coordinates is not None:
            self.coordinates.export(outfile, level, namespace_='gml:', name_='coordinates',
                                    pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(LinearRingType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'coord':
            obj_ = CoordType.factory()
            obj_.build(child_)
            self.coord.append(obj_)
            obj_.original_tagname_ = 'coord'
        elif nodeName_ == 'coordinates':
            obj_ = CoordinatesType.factory()
            obj_.build(child_)
            self.coordinates = obj_
            obj_.original_tagname_ = 'coordinates'
        super(LinearRingType, self).buildChildren(child_, node, nodeName_, True)


# end class LinearRingType


class BoxType(AbstractGeometryType):
    """The Box structure defines an extent using a pair of coordinate
    tuples."""
    subclass = None
    superclass = AbstractGeometryType

    def __init__(self, gid=None, srsName=None, coord=None, coordinates=None):
        self.original_tagname_ = None
        super(BoxType, self).__init__(gid, srsName, )
        if coord is None:
            self.coord = []
        else:
            self.coord = coord
        self.coordinates = coordinates

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BoxType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BoxType.subclass:
            return BoxType.subclass(*args_, **kwargs_)
        else:
            return BoxType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_coord(self):
        return self.coord

    def set_coord(self, coord):
        self.coord = coord

    def add_coord(self, value):
        self.coord.append(value)

    def insert_coord_at(self, index, value):
        self.coord.insert(index, value)

    def replace_coord_at(self, index, value):
        self.coord[index] = value

    def get_coordinates(self):
        return self.coordinates

    def set_coordinates(self, coordinates):
        self.coordinates = coordinates

    def hasContent_(self):
        if (
                        self.coord or
                            self.coordinates is not None or
                    super(BoxType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='BoxType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BoxType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BoxType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='BoxType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='BoxType'):
        super(BoxType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BoxType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='BoxType', fromsubclass_=False,
                       pretty_print=True):
        super(BoxType, self).exportChildren(outfile, level, namespace_, name_, True,
                                            pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for coord_ in self.coord:
            coord_.export(outfile, level, namespace_='gml:', name_='coord', pretty_print=pretty_print)
        if self.coordinates is not None:
            self.coordinates.export(outfile, level, namespace_='gml:', name_='coordinates',
                                    pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(BoxType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'coord':
            obj_ = CoordType.factory()
            obj_.build(child_)
            self.coord.append(obj_)
            obj_.original_tagname_ = 'coord'
        elif nodeName_ == 'coordinates':
            obj_ = CoordinatesType.factory()
            obj_.build(child_)
            self.coordinates = obj_
            obj_.original_tagname_ = 'coordinates'
        super(BoxType, self).buildChildren(child_, node, nodeName_, True)


# end class BoxType


class PolygonType(AbstractGeometryType):
    """A Polygon is defined by an outer boundary and zero or more inner
    boundaries which are in turn defined by LinearRings."""
    subclass = None
    superclass = AbstractGeometryType

    def __init__(self, gid=None, srsName=None, outerBoundaryIs=None, innerBoundaryIs=None):
        self.original_tagname_ = None
        super(PolygonType, self).__init__(gid, srsName, )
        self.outerBoundaryIs = outerBoundaryIs
        if innerBoundaryIs is None:
            self.innerBoundaryIs = []
        else:
            self.innerBoundaryIs = innerBoundaryIs

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PolygonType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PolygonType.subclass:
            return PolygonType.subclass(*args_, **kwargs_)
        else:
            return PolygonType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_outerBoundaryIs(self):
        return self.outerBoundaryIs

    def set_outerBoundaryIs(self, outerBoundaryIs):
        self.outerBoundaryIs = outerBoundaryIs

    def get_innerBoundaryIs(self):
        return self.innerBoundaryIs

    def set_innerBoundaryIs(self, innerBoundaryIs):
        self.innerBoundaryIs = innerBoundaryIs

    def add_innerBoundaryIs(self, value):
        self.innerBoundaryIs.append(value)

    def insert_innerBoundaryIs_at(self, index, value):
        self.innerBoundaryIs.insert(index, value)

    def replace_innerBoundaryIs_at(self, index, value):
        self.innerBoundaryIs[index] = value

    def hasContent_(self):
        if (
                            self.outerBoundaryIs is not None or
                        self.innerBoundaryIs or
                    super(PolygonType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='PolygonType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PolygonType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PolygonType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='PolygonType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='PolygonType'):
        super(PolygonType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                  name_='PolygonType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='PolygonType', fromsubclass_=False,
                       pretty_print=True):
        super(PolygonType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.outerBoundaryIs is not None:
            self.outerBoundaryIs.export(outfile, level, namespace_='gml:', name_='outerBoundaryIs',
                                        pretty_print=pretty_print)
        for innerBoundaryIs_ in self.innerBoundaryIs:
            innerBoundaryIs_.export(outfile, level, namespace_='gml:', name_='innerBoundaryIs',
                                    pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(PolygonType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'outerBoundaryIs':
            obj_ = LinearRingMemberType.factory()
            obj_.build(child_)
            self.outerBoundaryIs = obj_
            obj_.original_tagname_ = 'outerBoundaryIs'
        elif nodeName_ == 'innerBoundaryIs':
            obj_ = LinearRingMemberType.factory()
            obj_.build(child_)
            self.innerBoundaryIs.append(obj_)
            obj_.original_tagname_ = 'innerBoundaryIs'
        super(PolygonType, self).buildChildren(child_, node, nodeName_, True)


# end class PolygonType


class GeometryCollectionType(AbstractGeometryCollectionBaseType):
    """A geometry collection must include one or more geometries,
    referenced through geometryMember elements. User-defined
    geometry collections that accept GML geometry classes as members
    must instantiate--or derive from--this type."""
    subclass = None
    superclass = AbstractGeometryCollectionBaseType

    def __init__(self, gid=None, srsName=None, geometryMember=None):
        self.original_tagname_ = None
        super(GeometryCollectionType, self).__init__(gid, srsName, )
        if geometryMember is None:
            self.geometryMember = []
        else:
            self.geometryMember = geometryMember

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GeometryCollectionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GeometryCollectionType.subclass:
            return GeometryCollectionType.subclass(*args_, **kwargs_)
        else:
            return GeometryCollectionType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_geometryMember(self):
        return self.geometryMember

    def set_geometryMember(self, geometryMember):
        self.geometryMember = geometryMember

    def add_geometryMember(self, value):
        self.geometryMember.append(value)

    def insert_geometryMember_at(self, index, value):
        self.geometryMember.insert(index, value)

    def replace_geometryMember_at(self, index, value):
        self.geometryMember[index] = value

    def hasContent_(self):
        if (
                    self.geometryMember or
                    super(GeometryCollectionType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='GeometryCollectionType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GeometryCollectionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GeometryCollectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='GeometryCollectionType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='GeometryCollectionType'):
        super(GeometryCollectionType, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                             name_='GeometryCollectionType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='GeometryCollectionType',
                       fromsubclass_=False, pretty_print=True):
        super(GeometryCollectionType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                           pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for geometryMember_ in self.geometryMember:
            geometryMember_.export(outfile, level, namespace_='gml:', name_='geometryMember',
                                   pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(GeometryCollectionType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'geometryMember':
            obj_ = GeometryAssociationType.factory()
            obj_.build(child_)
            self.geometryMember.append(obj_)
            obj_.original_tagname_ = 'geometryMember'
        elif nodeName_ == 'pointMember':
            obj_ = PointMemberType.factory()
            obj_.build(child_)
            self.geometryMember.append(obj_)
            obj_.original_tagname_ = 'pointMember'
        elif nodeName_ == 'lineStringMember':
            obj_ = LineStringMemberType.factory()
            obj_.build(child_)
            self.geometryMember.append(obj_)
            obj_.original_tagname_ = 'lineStringMember'
        elif nodeName_ == 'polygonMember':
            obj_ = PolygonMemberType.factory()
            obj_.build(child_)
            self.geometryMember.append(obj_)
            obj_.original_tagname_ = 'polygonMember'
        elif nodeName_ == 'pointMember':
            obj_ = PointMemberType.factory()
            obj_.build(child_)
            self.geometryMember.append(obj_)
            obj_.original_tagname_ = 'pointMember'
        elif nodeName_ == 'lineStringMember':
            obj_ = LineStringMemberType.factory()
            obj_.build(child_)
            self.geometryMember.append(obj_)
            obj_.original_tagname_ = 'lineStringMember'
        elif nodeName_ == 'polygonMember':
            obj_ = PolygonMemberType.factory()
            obj_.build(child_)
            self.geometryMember.append(obj_)
            obj_.original_tagname_ = 'polygonMember'
        super(GeometryCollectionType, self).buildChildren(child_, node, nodeName_, True)


# end class GeometryCollectionType


class MultiPointType(GeneratedsSuper):
    """A MultiPoint is defined by one or more Points, referenced through
    pointMember elements."""
    subclass = None
    superclass = None

    def __init__(self, gid=None, srsName=None, pointMember=None):
        self.original_tagname_ = None
        self.gid = _cast(None, gid)
        self.srsName = _cast(None, srsName)
        if pointMember is None:
            self.pointMember = []
        else:
            self.pointMember = pointMember

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MultiPointType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MultiPointType.subclass:
            return MultiPointType.subclass(*args_, **kwargs_)
        else:
            return MultiPointType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_pointMember(self):
        return self.pointMember

    def set_pointMember(self, pointMember):
        self.pointMember = pointMember

    def add_pointMember(self, value):
        self.pointMember.append(value)

    def insert_pointMember_at(self, index, value):
        self.pointMember.insert(index, value)

    def replace_pointMember_at(self, index, value):
        self.pointMember[index] = value

    def get_gid(self):
        return self.gid

    def set_gid(self, gid):
        self.gid = gid

    def get_srsName(self):
        return self.srsName

    def set_srsName(self, srsName):
        self.srsName = srsName

    def hasContent_(self):
        if (
                self.pointMember
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='MultiPointType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MultiPointType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MultiPointType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='MultiPointType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='MultiPointType'):
        if self.gid is not None and 'gid' not in already_processed:
            already_processed.add('gid')
            outfile.write(' gid=%s' % (quote_attrib(self.gid),))
        if self.srsName is not None and 'srsName' not in already_processed:
            already_processed.add('srsName')
            outfile.write(' srsName=%s' % (quote_attrib(self.srsName),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='MultiPointType', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for pointMember_ in self.pointMember:
            pointMember_.export(outfile, level, namespace_='gml:', name_='pointMember',
                                pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('gid', node)
        if value is not None and 'gid' not in already_processed:
            already_processed.add('gid')
            self.gid = value
        value = find_attr_value_('srsName', node)
        if value is not None and 'srsName' not in already_processed:
            already_processed.add('srsName')
            self.srsName = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'pointMember':
            obj_ = PointMemberType.factory()
            obj_.build(child_)
            self.pointMember.append(obj_)
            obj_.original_tagname_ = 'pointMember'


# end class MultiPointType


class MultiLineStringType(GeneratedsSuper):
    """A MultiLineString is defined by one or more LineStrings, referenced
    through lineStringMember elements."""
    subclass = None
    superclass = None

    def __init__(self, gid=None, srsName=None, lineStringMember=None):
        self.original_tagname_ = None
        self.gid = _cast(None, gid)
        self.srsName = _cast(None, srsName)
        if lineStringMember is None:
            self.lineStringMember = []
        else:
            self.lineStringMember = lineStringMember

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MultiLineStringType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MultiLineStringType.subclass:
            return MultiLineStringType.subclass(*args_, **kwargs_)
        else:
            return MultiLineStringType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_lineStringMember(self):
        return self.lineStringMember

    def set_lineStringMember(self, lineStringMember):
        self.lineStringMember = lineStringMember

    def add_lineStringMember(self, value):
        self.lineStringMember.append(value)

    def insert_lineStringMember_at(self, index, value):
        self.lineStringMember.insert(index, value)

    def replace_lineStringMember_at(self, index, value):
        self.lineStringMember[index] = value

    def get_gid(self):
        return self.gid

    def set_gid(self, gid):
        self.gid = gid

    def get_srsName(self):
        return self.srsName

    def set_srsName(self, srsName):
        self.srsName = srsName

    def hasContent_(self):
        if (
                self.lineStringMember
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='MultiLineStringType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MultiLineStringType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MultiLineStringType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='MultiLineStringType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='MultiLineStringType'):
        if self.gid is not None and 'gid' not in already_processed:
            already_processed.add('gid')
            outfile.write(' gid=%s' % (quote_attrib(self.gid),))
        if self.srsName is not None and 'srsName' not in already_processed:
            already_processed.add('srsName')
            outfile.write(' srsName=%s' % (quote_attrib(self.srsName),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='MultiLineStringType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for lineStringMember_ in self.lineStringMember:
            lineStringMember_.export(outfile, level, namespace_='gml:', name_='lineStringMember',
                                     pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('gid', node)
        if value is not None and 'gid' not in already_processed:
            already_processed.add('gid')
            self.gid = value
        value = find_attr_value_('srsName', node)
        if value is not None and 'srsName' not in already_processed:
            already_processed.add('srsName')
            self.srsName = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'lineStringMember':
            obj_ = LineStringMemberType.factory()
            obj_.build(child_)
            self.lineStringMember.append(obj_)
            obj_.original_tagname_ = 'lineStringMember'


# end class MultiLineStringType


class MultiPolygonType(GeneratedsSuper):
    """A MultiPolygon is defined by one or more Polygons, referenced
    through polygonMember elements."""
    subclass = None
    superclass = None

    def __init__(self, gid=None, srsName=None, polygonMember=None):
        self.original_tagname_ = None
        self.gid = _cast(None, gid)
        self.srsName = _cast(None, srsName)
        if polygonMember is None:
            self.polygonMember = []
        else:
            self.polygonMember = polygonMember

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MultiPolygonType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MultiPolygonType.subclass:
            return MultiPolygonType.subclass(*args_, **kwargs_)
        else:
            return MultiPolygonType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_polygonMember(self):
        return self.polygonMember

    def set_polygonMember(self, polygonMember):
        self.polygonMember = polygonMember

    def add_polygonMember(self, value):
        self.polygonMember.append(value)

    def insert_polygonMember_at(self, index, value):
        self.polygonMember.insert(index, value)

    def replace_polygonMember_at(self, index, value):
        self.polygonMember[index] = value

    def get_gid(self):
        return self.gid

    def set_gid(self, gid):
        self.gid = gid

    def get_srsName(self):
        return self.srsName

    def set_srsName(self, srsName):
        self.srsName = srsName

    def hasContent_(self):
        if (
                self.polygonMember
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='MultiPolygonType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MultiPolygonType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MultiPolygonType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='MultiPolygonType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='MultiPolygonType'):
        if self.gid is not None and 'gid' not in already_processed:
            already_processed.add('gid')
            outfile.write(' gid=%s' % (quote_attrib(self.gid),))
        if self.srsName is not None and 'srsName' not in already_processed:
            already_processed.add('srsName')
            outfile.write(' srsName=%s' % (quote_attrib(self.srsName),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='MultiPolygonType', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for polygonMember_ in self.polygonMember:
            polygonMember_.export(outfile, level, namespace_='gml:', name_='polygonMember',
                                  pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('gid', node)
        if value is not None and 'gid' not in already_processed:
            already_processed.add('gid')
            self.gid = value
        value = find_attr_value_('srsName', node)
        if value is not None and 'srsName' not in already_processed:
            already_processed.add('srsName')
            self.srsName = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'polygonMember':
            obj_ = PolygonMemberType.factory()
            obj_.build(child_)
            self.polygonMember.append(obj_)
            obj_.original_tagname_ = 'polygonMember'


# end class MultiPolygonType


class CoordType(GeneratedsSuper):
    """Represents a coordinate tuple in one, two, or three dimensions."""
    subclass = None
    superclass = None

    def __init__(self, X=None, Y=None, Z=None):
        self.original_tagname_ = None
        self.X = X
        self.Y = Y
        self.Z = Z

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CoordType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CoordType.subclass:
            return CoordType.subclass(*args_, **kwargs_)
        else:
            return CoordType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_X(self):
        return self.X

    def set_X(self, X):
        self.X = X

    def get_Y(self):
        return self.Y

    def set_Y(self, Y):
        self.Y = Y

    def get_Z(self):
        return self.Z

    def set_Z(self, Z):
        self.Z = Z

    def hasContent_(self):
        if (
                            self.X is not None or
                            self.Y is not None or
                        self.Z is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='CoordType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CoordType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CoordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='CoordType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='CoordType'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='CoordType', fromsubclass_=False,
                       pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.X is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sX>%s</%sX>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.X), input_name='X')),
            namespace_, eol_))
        if self.Y is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sY>%s</%sY>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.Y), input_name='Y')),
            namespace_, eol_))
        if self.Z is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sZ>%s</%sZ>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.Z), input_name='Z')),
            namespace_, eol_))

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'X':
            X_ = child_.text
            X_ = self.gds_validate_string(X_, node, 'X')
            self.X = X_
        elif nodeName_ == 'Y':
            Y_ = child_.text
            Y_ = self.gds_validate_string(Y_, node, 'Y')
            self.Y = Y_
        elif nodeName_ == 'Z':
            Z_ = child_.text
            Z_ = self.gds_validate_string(Z_, node, 'Z')
            self.Z = Z_


# end class CoordType


class CoordinatesType(GeneratedsSuper):
    """Coordinates can be included in a single string, but there is no
    facility for validating string content. The value of the 'cs'
    attribute is the separator for coordinate values, and the value
    of the 'ts' attribute gives the tuple separator (a single space
    by default); the default values may be changed to reflect local
    usage."""
    subclass = None
    superclass = None

    def __init__(self, decimal='.', cs=',', ts=' ', valueOf_=None):
        self.original_tagname_ = None
        self.decimal = _cast(None, decimal)
        self.cs = _cast(None, cs)
        self.ts = _cast(None, ts)
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CoordinatesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CoordinatesType.subclass:
            return CoordinatesType.subclass(*args_, **kwargs_)
        else:
            return CoordinatesType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_decimal(self):
        return self.decimal

    def set_decimal(self, decimal):
        self.decimal = decimal

    def get_cs(self):
        return self.cs

    def set_cs(self, cs):
        self.cs = cs

    def get_ts(self):
        return self.ts

    def set_ts(self, ts):
        self.ts = ts

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
                1 if type(self.valueOf_) in [int, float] else self.valueOf_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='CoordinatesType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CoordinatesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CoordinatesType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='CoordinatesType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='CoordinatesType'):
        if self.decimal != "." and 'decimal' not in already_processed:
            already_processed.add('decimal')
            outfile.write(' decimal=%s' % (quote_attrib(self.decimal),))
        if self.cs != "," and 'cs' not in already_processed:
            already_processed.add('cs')
            outfile.write(' cs=%s' % (quote_attrib(self.cs),))
        if self.ts != " " and 'ts' not in already_processed:
            already_processed.add('ts')
            outfile.write(' ts=%s' % (quote_attrib(self.ts),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='CoordinatesType', fromsubclass_=False,
                       pretty_print=True):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('decimal', node)
        if value is not None and 'decimal' not in already_processed:
            already_processed.add('decimal')
            self.decimal = value
        value = find_attr_value_('cs', node)
        if value is not None and 'cs' not in already_processed:
            already_processed.add('cs')
            self.cs = value
        value = find_attr_value_('ts', node)
        if value is not None and 'ts' not in already_processed:
            already_processed.add('ts')
            self.ts = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class CoordinatesType


class AbstractFeatureType(GeneratedsSuper):
    """An abstract feature provides a set of common properties. A concrete
    feature type must derive from this type and specify additional
    properties in an application schema. A feature may optionally
    possess an identifying attribute ('fid')."""
    subclass = None
    superclass = None

    def __init__(self, fid=None, description=None, name=None, boundedBy=None):
        self.original_tagname_ = None
        self.fid = _cast(None, fid)
        self.description = description
        self.name = name
        self.boundedBy = boundedBy

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AbstractFeatureType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AbstractFeatureType.subclass:
            return AbstractFeatureType.subclass(*args_, **kwargs_)
        else:
            return AbstractFeatureType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_description(self):
        return self.description

    def set_description(self, description):
        self.description = description

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_boundedBy(self):
        return self.boundedBy

    def set_boundedBy(self, boundedBy):
        self.boundedBy = boundedBy

    def get_fid(self):
        return self.fid

    def set_fid(self, fid):
        self.fid = fid

    def hasContent_(self):
        if (
                            self.description is not None or
                            self.name is not None or
                        self.boundedBy is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='AbstractFeatureType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AbstractFeatureType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractFeatureType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='AbstractFeatureType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='AbstractFeatureType'):
        if self.fid is not None and 'fid' not in already_processed:
            already_processed.add('fid')
            outfile.write(' fid=%s' % (quote_attrib(self.fid),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='AbstractFeatureType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_encode(
                self.gds_format_string(quote_xml(self.description), input_name='description')), namespace_,
                                                                   eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')),
            namespace_, eol_))
        if self.boundedBy is not None:
            self.boundedBy.export(outfile, level, namespace_='gml:', name_='boundedBy',
                                  pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('fid', node)
        if value is not None and 'fid' not in already_processed:
            already_processed.add('fid')
            self.fid = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'boundedBy':
            obj_ = BoundingShapeType.factory()
            obj_.build(child_)
            self.boundedBy = obj_
            obj_.original_tagname_ = 'boundedBy'


# end class AbstractFeatureType


class AbstractFeatureCollectionBaseType(GeneratedsSuper):
    """This abstract base type just makes the boundedBy element mandatory
    for a feature collection."""
    subclass = None
    superclass = None

    def __init__(self, fid=None, description=None, name=None, boundedBy=None):
        self.original_tagname_ = None
        self.fid = _cast(None, fid)
        self.description = description
        self.name = name
        self.boundedBy = boundedBy

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AbstractFeatureCollectionBaseType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AbstractFeatureCollectionBaseType.subclass:
            return AbstractFeatureCollectionBaseType.subclass(*args_, **kwargs_)
        else:
            return AbstractFeatureCollectionBaseType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_description(self):
        return self.description

    def set_description(self, description):
        self.description = description

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_boundedBy(self):
        return self.boundedBy

    def set_boundedBy(self, boundedBy):
        self.boundedBy = boundedBy

    def get_fid(self):
        return self.fid

    def set_fid(self, fid):
        self.fid = fid

    def hasContent_(self):
        if (
                            self.description is not None or
                            self.name is not None or
                        self.boundedBy is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='AbstractFeatureCollectionBaseType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AbstractFeatureCollectionBaseType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_,
                              name_='AbstractFeatureCollectionBaseType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:',
                                name_='AbstractFeatureCollectionBaseType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='AbstractFeatureCollectionBaseType'):
        if self.fid is not None and 'fid' not in already_processed:
            already_processed.add('fid')
            outfile.write(' fid=%s' % (quote_attrib(self.fid),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='AbstractFeatureCollectionBaseType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_encode(
                self.gds_format_string(quote_xml(self.description), input_name='description')), namespace_,
                                                                   eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')),
            namespace_, eol_))
        if self.boundedBy is not None:
            self.boundedBy.export(outfile, level, namespace_='gml:', name_='boundedBy',
                                  pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('fid', node)
        if value is not None and 'fid' not in already_processed:
            already_processed.add('fid')
            self.fid = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'boundedBy':
            obj_ = BoundingShapeType.factory()
            obj_.build(child_)
            self.boundedBy = obj_
            obj_.original_tagname_ = 'boundedBy'


# end class AbstractFeatureCollectionBaseType


class AbstractFeatureCollectionType(AbstractFeatureCollectionBaseType):
    """A feature collection contains zero or more featureMember elements."""
    subclass = None
    superclass = AbstractFeatureCollectionBaseType

    def __init__(self, fid=None, description=None, name=None, boundedBy=None, featureMember=None):
        self.original_tagname_ = None
        super(AbstractFeatureCollectionType, self).__init__(fid, description, name, boundedBy, )
        if featureMember is None:
            self.featureMember = []
        else:
            self.featureMember = featureMember

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AbstractFeatureCollectionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AbstractFeatureCollectionType.subclass:
            return AbstractFeatureCollectionType.subclass(*args_, **kwargs_)
        else:
            return AbstractFeatureCollectionType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_featureMember(self):
        return self.featureMember

    def set_featureMember(self, featureMember):
        self.featureMember = featureMember

    def add_featureMember(self, value):
        self.featureMember.append(value)

    def insert_featureMember_at(self, index, value):
        self.featureMember.insert(index, value)

    def replace_featureMember_at(self, index, value):
        self.featureMember[index] = value

    def hasContent_(self):
        if (
                    self.featureMember or
                    super(AbstractFeatureCollectionType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='AbstractFeatureCollectionType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AbstractFeatureCollectionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_,
                              name_='AbstractFeatureCollectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='AbstractFeatureCollectionType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='AbstractFeatureCollectionType'):
        super(AbstractFeatureCollectionType, self).exportAttributes(outfile, level, already_processed,
                                                                    namespace_,
                                                                    name_='AbstractFeatureCollectionType')

    def exportChildren(self, outfile, level, namespace_='sld:', name_='AbstractFeatureCollectionType',
                       fromsubclass_=False, pretty_print=True):
        super(AbstractFeatureCollectionType, self).exportChildren(outfile, level, namespace_, name_, True,
                                                                  pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for featureMember_ in self.featureMember:
            featureMember_.export(outfile, level, namespace_='gml:', name_='featureMember',
                                  pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractFeatureCollectionType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'featureMember':
            obj_ = FeatureAssociationType.factory()
            obj_.build(child_)
            self.featureMember.append(obj_)
            obj_.original_tagname_ = 'featureMember'
        super(AbstractFeatureCollectionType, self).buildChildren(child_, node, nodeName_, True)


# end class AbstractFeatureCollectionType


class GeometryPropertyType(GeneratedsSuper):
    """A simple geometry property encapsulates a geometry element.
    Alternatively, it can function as a pointer (simple-type link)
    that refers to a remote geometry element."""
    subclass = None
    superclass = None

    def __init__(self, remoteSchema=None, type_=None, href=None, role=None, arcrole=None, title=None,
                 show=None, actuate=None, _Geometry=None):
        self.original_tagname_ = None
        self.remoteSchema = _cast(None, remoteSchema)
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self._Geometry = _Geometry

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GeometryPropertyType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GeometryPropertyType.subclass:
            return GeometryPropertyType.subclass(*args_, **kwargs_)
        else:
            return GeometryPropertyType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get__Geometry(self):
        return self._Geometry

    def set__Geometry(self, _Geometry):
        self._Geometry = _Geometry

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def hasContent_(self):
        if (
                    self._Geometry is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='GeometryPropertyType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GeometryPropertyType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GeometryPropertyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='GeometryPropertyType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='GeometryPropertyType'):
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='GeometryPropertyType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self._Geometry is not None:
            self._Geometry.export(outfile, level, namespace_, name_='_Geometry', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == '_Geometry':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <_Geometry> element')
            self._Geometry = obj_
            obj_.original_tagname_ = '_Geometry'
        elif nodeName_ == '_GeometryCollection':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = '_GeometryCollection'
        elif nodeName_ == 'Point':
            obj_ = PointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Point'
        elif nodeName_ == 'LineString':
            obj_ = LineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LineString'
        elif nodeName_ == 'LinearRing':
            obj_ = LinearRingType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LinearRing'
        elif nodeName_ == 'Polygon':
            obj_ = PolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Polygon'
        elif nodeName_ == 'MultiGeometry':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiGeometry'
        elif nodeName_ == 'MultiPoint':
            obj_ = MultiPointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPoint'
        elif nodeName_ == 'MultiLineString':
            obj_ = MultiLineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiLineString'
        elif nodeName_ == 'MultiPolygon':
            obj_ = MultiPolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPolygon'
        elif nodeName_ == '_GeometryCollection':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = '_GeometryCollection'
        elif nodeName_ == 'Point':
            obj_ = PointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Point'
        elif nodeName_ == 'LineString':
            obj_ = LineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LineString'
        elif nodeName_ == 'LinearRing':
            obj_ = LinearRingType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'LinearRing'
        elif nodeName_ == 'Polygon':
            obj_ = PolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'Polygon'
        elif nodeName_ == 'MultiGeometry':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiGeometry'
        elif nodeName_ == 'MultiPoint':
            obj_ = MultiPointType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPoint'
        elif nodeName_ == 'MultiLineString':
            obj_ = MultiLineStringType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiLineString'
        elif nodeName_ == 'MultiPolygon':
            obj_ = MultiPolygonType.factory()
            obj_.build(child_)
            self._Geometry = obj_
            obj_.original_tagname_ = 'MultiPolygon'


# end class GeometryPropertyType


class FeatureAssociationType(GeneratedsSuper):
    """An instance of this type (e.g. a featureMember) can either enclose
    or point to a feature (or feature collection); this type can be
    restricted in an application schema to allow only specified
    features as valid participants in the association. When serving
    as a simple link that references a remote feature instance, the
    value of the gml:remoteSchema attribute can be used to locate a
    schema fragment that constrains the target instance."""
    subclass = None
    superclass = None

    def __init__(self, remoteSchema=None, type_=None, href=None, role=None, arcrole=None, title=None,
                 show=None, actuate=None, _Feature=None):
        self.original_tagname_ = None
        self.remoteSchema = _cast(None, remoteSchema)
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self._Feature = _Feature

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FeatureAssociationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FeatureAssociationType.subclass:
            return FeatureAssociationType.subclass(*args_, **kwargs_)
        else:
            return FeatureAssociationType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get__Feature(self):
        return self._Feature

    def set__Feature(self, _Feature):
        self._Feature = _Feature

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def hasContent_(self):
        if (
                    self._Feature is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='FeatureAssociationType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('FeatureAssociationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FeatureAssociationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='FeatureAssociationType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='FeatureAssociationType'):
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='FeatureAssociationType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self._Feature is not None:
            self._Feature.export(outfile, level, namespace_, name_='_Feature', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == '_Feature':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <_Feature> element')
            self._Feature = obj_
            obj_.original_tagname_ = '_Feature'
        elif nodeName_ == '_FeatureCollection':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <_FeatureCollection> element')
            self._Feature = obj_
            obj_.original_tagname_ = '_FeatureCollection'
        elif nodeName_ == '_FeatureCollection':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <_FeatureCollection> element')
            self._Feature = obj_
            obj_.original_tagname_ = '_FeatureCollection'


# end class FeatureAssociationType


class BoundingShapeType(GeneratedsSuper):
    """Bounding shapes--a Box or a null element are currently allowed."""
    subclass = None
    superclass = None

    def __init__(self, Box=None, null=None):
        self.original_tagname_ = None
        self.Box = Box
        self.null = null
        self.validate_NullType(self.null)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BoundingShapeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BoundingShapeType.subclass:
            return BoundingShapeType.subclass(*args_, **kwargs_)
        else:
            return BoundingShapeType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Box(self):
        return self.Box

    def set_Box(self, Box):
        self.Box = Box

    def get_null(self):
        return self.null

    def set_null(self, null):
        self.null = null

    def validate_NullType(self, value):
        # Validate type NullType, a restriction on string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['inapplicable', 'unknown', 'unavailable', 'missing']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on NullType' % {
                    "value": value.encode("utf-8")})

    def hasContent_(self):
        if (
                        self.Box is not None or
                        self.null is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='BoundingShapeType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BoundingShapeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BoundingShapeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='BoundingShapeType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='BoundingShapeType'):
        pass

    def exportChildren(self, outfile, level, namespace_='sld:', name_='BoundingShapeType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Box is not None:
            self.Box.export(outfile, level, namespace_='gml:', name_='Box', pretty_print=pretty_print)
        if self.null is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snull>%s</%snull>%s' % (
            namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.null), input_name='null')),
            namespace_, eol_))

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Box':
            obj_ = BoxType.factory()
            obj_.build(child_)
            self.Box = obj_
            obj_.original_tagname_ = 'Box'
        elif nodeName_ == 'null':
            null_ = child_.text
            null_ = self.gds_validate_string(null_, node, 'null')
            self.null = null_
            # validate type NullType
            self.validate_NullType(self.null)


# end class BoundingShapeType


class PointPropertyType(GeneratedsSuper):
    """Encapsulates a single point to represent position, location, or
    centerOf properties."""
    subclass = None
    superclass = None

    def __init__(self, remoteSchema=None, type_=None, href=None, role=None, arcrole=None, title=None,
                 show=None, actuate=None, Point=None):
        self.original_tagname_ = None
        self.remoteSchema = _cast(None, remoteSchema)
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self.Point = Point

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PointPropertyType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PointPropertyType.subclass:
            return PointPropertyType.subclass(*args_, **kwargs_)
        else:
            return PointPropertyType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Point(self):
        return self.Point

    def set_Point(self, Point):
        self.Point = Point

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def hasContent_(self):
        if (
                    self.Point is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='PointPropertyType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PointPropertyType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PointPropertyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='PointPropertyType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='PointPropertyType'):
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='PointPropertyType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Point is not None:
            self.Point.export(outfile, level, namespace_='gml:', name_='Point', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Point':
            obj_ = PointType.factory()
            obj_.build(child_)
            self.Point = obj_
            obj_.original_tagname_ = 'Point'


# end class PointPropertyType


class PolygonPropertyType(GeneratedsSuper):
    """Encapsulates a single polygon to represent coverage or extentOf
    properties."""
    subclass = None
    superclass = None

    def __init__(self, remoteSchema=None, type_=None, href=None, role=None, arcrole=None, title=None,
                 show=None, actuate=None, Polygon=None):
        self.original_tagname_ = None
        self.remoteSchema = _cast(None, remoteSchema)
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self.Polygon = Polygon

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PolygonPropertyType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PolygonPropertyType.subclass:
            return PolygonPropertyType.subclass(*args_, **kwargs_)
        else:
            return PolygonPropertyType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Polygon(self):
        return self.Polygon

    def set_Polygon(self, Polygon):
        self.Polygon = Polygon

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def hasContent_(self):
        if (
                    self.Polygon is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='PolygonPropertyType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PolygonPropertyType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PolygonPropertyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='PolygonPropertyType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='PolygonPropertyType'):
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='PolygonPropertyType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Polygon is not None:
            self.Polygon.export(outfile, level, namespace_='gml:', name_='Polygon', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Polygon':
            obj_ = PolygonType.factory()
            obj_.build(child_)
            self.Polygon = obj_
            obj_.original_tagname_ = 'Polygon'


# end class PolygonPropertyType


class LineStringPropertyType(GeneratedsSuper):
    """Encapsulates a single LineString to represent centerLineOf or edgeOf
    properties."""
    subclass = None
    superclass = None

    def __init__(self, remoteSchema=None, type_=None, href=None, role=None, arcrole=None, title=None,
                 show=None, actuate=None, LineString=None):
        self.original_tagname_ = None
        self.remoteSchema = _cast(None, remoteSchema)
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self.LineString = LineString

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LineStringPropertyType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LineStringPropertyType.subclass:
            return LineStringPropertyType.subclass(*args_, **kwargs_)
        else:
            return LineStringPropertyType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_LineString(self):
        return self.LineString

    def set_LineString(self, LineString):
        self.LineString = LineString

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def hasContent_(self):
        if (
                    self.LineString is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='LineStringPropertyType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LineStringPropertyType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LineStringPropertyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='LineStringPropertyType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='LineStringPropertyType'):
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='LineStringPropertyType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.LineString is not None:
            self.LineString.export(outfile, level, namespace_='gml:', name_='LineString',
                                   pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'LineString':
            obj_ = LineStringType.factory()
            obj_.build(child_)
            self.LineString = obj_
            obj_.original_tagname_ = 'LineString'


# end class LineStringPropertyType


class MultiPointPropertyType(GeneratedsSuper):
    """Encapsulates a MultiPoint element to represent the following
    discontiguous geometric properties: multiLocation,
    multiPosition, multiCenterOf."""
    subclass = None
    superclass = None

    def __init__(self, remoteSchema=None, type_=None, href=None, role=None, arcrole=None, title=None,
                 show=None, actuate=None, MultiPoint=None):
        self.original_tagname_ = None
        self.remoteSchema = _cast(None, remoteSchema)
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self.MultiPoint = MultiPoint

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MultiPointPropertyType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MultiPointPropertyType.subclass:
            return MultiPointPropertyType.subclass(*args_, **kwargs_)
        else:
            return MultiPointPropertyType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_MultiPoint(self):
        return self.MultiPoint

    def set_MultiPoint(self, MultiPoint):
        self.MultiPoint = MultiPoint

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def hasContent_(self):
        if (
                    self.MultiPoint is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='MultiPointPropertyType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MultiPointPropertyType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MultiPointPropertyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='MultiPointPropertyType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='MultiPointPropertyType'):
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='MultiPointPropertyType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.MultiPoint is not None:
            self.MultiPoint.export(outfile, level, namespace_='gml:', name_='MultiPoint',
                                   pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MultiPoint':
            obj_ = MultiPointType.factory()
            obj_.build(child_)
            self.MultiPoint = obj_
            obj_.original_tagname_ = 'MultiPoint'


# end class MultiPointPropertyType


class MultiLineStringPropertyType(GeneratedsSuper):
    """Encapsulates a MultiLineString element to represent the following
    discontiguous geometric properties: multiEdgeOf,
    multiCenterLineOf."""
    subclass = None
    superclass = None

    def __init__(self, remoteSchema=None, type_=None, href=None, role=None, arcrole=None, title=None,
                 show=None, actuate=None, MultiLineString=None):
        self.original_tagname_ = None
        self.remoteSchema = _cast(None, remoteSchema)
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self.MultiLineString = MultiLineString

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MultiLineStringPropertyType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MultiLineStringPropertyType.subclass:
            return MultiLineStringPropertyType.subclass(*args_, **kwargs_)
        else:
            return MultiLineStringPropertyType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_MultiLineString(self):
        return self.MultiLineString

    def set_MultiLineString(self, MultiLineString):
        self.MultiLineString = MultiLineString

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def hasContent_(self):
        if (
                    self.MultiLineString is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='MultiLineStringPropertyType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MultiLineStringPropertyType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_,
                              name_='MultiLineStringPropertyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='MultiLineStringPropertyType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='MultiLineStringPropertyType'):
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='MultiLineStringPropertyType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.MultiLineString is not None:
            self.MultiLineString.export(outfile, level, namespace_='gml:', name_='MultiLineString',
                                        pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MultiLineString':
            obj_ = MultiLineStringType.factory()
            obj_.build(child_)
            self.MultiLineString = obj_
            obj_.original_tagname_ = 'MultiLineString'


# end class MultiLineStringPropertyType


class MultiPolygonPropertyType(GeneratedsSuper):
    """Encapsulates a MultiPolygon to represent the following discontiguous
    geometric properties: multiCoverage, multiExtentOf."""
    subclass = None
    superclass = None

    def __init__(self, remoteSchema=None, type_=None, href=None, role=None, arcrole=None, title=None,
                 show=None, actuate=None, MultiPolygon=None):
        self.original_tagname_ = None
        self.remoteSchema = _cast(None, remoteSchema)
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self.MultiPolygon = MultiPolygon

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MultiPolygonPropertyType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MultiPolygonPropertyType.subclass:
            return MultiPolygonPropertyType.subclass(*args_, **kwargs_)
        else:
            return MultiPolygonPropertyType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_MultiPolygon(self):
        return self.MultiPolygon

    def set_MultiPolygon(self, MultiPolygon):
        self.MultiPolygon = MultiPolygon

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def hasContent_(self):
        if (
                    self.MultiPolygon is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='MultiPolygonPropertyType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MultiPolygonPropertyType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MultiPolygonPropertyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='MultiPolygonPropertyType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='MultiPolygonPropertyType'):
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='MultiPolygonPropertyType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.MultiPolygon is not None:
            self.MultiPolygon.export(outfile, level, namespace_='gml:', name_='MultiPolygon',
                                     pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MultiPolygon':
            obj_ = MultiPolygonType.factory()
            obj_.build(child_)
            self.MultiPolygon = obj_
            obj_.original_tagname_ = 'MultiPolygon'


# end class MultiPolygonPropertyType


class MultiGeometryPropertyType(GeneratedsSuper):
    """Encapsulates a MultiGeometry element."""
    subclass = None
    superclass = None

    def __init__(self, remoteSchema=None, type_=None, href=None, role=None, arcrole=None, title=None,
                 show=None, actuate=None, MultiGeometry=None):
        self.original_tagname_ = None
        self.remoteSchema = _cast(None, remoteSchema)
        self.type_ = _cast(None, type_)
        self.href = _cast(None, href)
        self.role = _cast(None, role)
        self.arcrole = _cast(None, arcrole)
        self.title = _cast(None, title)
        self.show = _cast(None, show)
        self.actuate = _cast(None, actuate)
        self.MultiGeometry = MultiGeometry

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MultiGeometryPropertyType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MultiGeometryPropertyType.subclass:
            return MultiGeometryPropertyType.subclass(*args_, **kwargs_)
        else:
            return MultiGeometryPropertyType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_MultiGeometry(self):
        return self.MultiGeometry

    def set_MultiGeometry(self, MultiGeometry):
        self.MultiGeometry = MultiGeometry

    def get_remoteSchema(self):
        return self.remoteSchema

    def set_remoteSchema(self, remoteSchema):
        self.remoteSchema = remoteSchema

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_arcrole(self):
        return self.arcrole

    def set_arcrole(self, arcrole):
        self.arcrole = arcrole

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_show(self):
        return self.show

    def set_show(self, show):
        self.show = show

    def get_actuate(self):
        return self.actuate

    def set_actuate(self, actuate):
        self.actuate = actuate

    def hasContent_(self):
        if (
                    self.MultiGeometry is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='MultiGeometryPropertyType',
               namespacedef_='xmlns:sld="http://www.opengis.net/sld"', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MultiGeometryPropertyType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_,
                              name_='MultiGeometryPropertyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='MultiGeometryPropertyType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:',
                         name_='MultiGeometryPropertyType'):
        if self.remoteSchema is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            outfile.write(' remoteSchema=%s' % (quote_attrib(self.remoteSchema),))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_),))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (quote_attrib(self.href),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(' role=%s' % (quote_attrib(self.role),))
        if self.arcrole is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            outfile.write(' arcrole=%s' % (quote_attrib(self.arcrole),))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (quote_attrib(self.title),))
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (quote_attrib(self.show),))
        if self.actuate is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            outfile.write(' actuate=%s' % (quote_attrib(self.actuate),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='MultiGeometryPropertyType',
                       fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.MultiGeometry is not None:
            self.MultiGeometry.export(outfile, level, namespace_='gml:', name_='MultiGeometry',
                                      pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('remoteSchema', node)
        if value is not None and 'remoteSchema' not in already_processed:
            already_processed.add('remoteSchema')
            self.remoteSchema = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
        value = find_attr_value_('arcrole', node)
        if value is not None and 'arcrole' not in already_processed:
            already_processed.add('arcrole')
            self.arcrole = value
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('actuate', node)
        if value is not None and 'actuate' not in already_processed:
            already_processed.add('actuate')
            self.actuate = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MultiGeometry':
            obj_ = GeometryCollectionType.factory()
            obj_.build(child_)
            self.MultiGeometry = obj_
            obj_.original_tagname_ = 'MultiGeometry'


# end class MultiGeometryPropertyType


class CssParameter(ParameterValueType):
    """A "CssParameter" refers to an SVG/CSS graphical-formatting
    parameter. The parameter is identified using the "name"
    attribute and the content of the element gives the SVG/CSS-coded
    value."""
    subclass = None
    superclass = ParameterValueType

    def __init__(self, expression=None, name=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        super(CssParameter, self).__init__(expression, valueOf_, mixedclass_, content_, )
        self.name = _cast(None, name)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CssParameter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CssParameter.subclass:
            return CssParameter.subclass(*args_, **kwargs_)
        else:
            return CssParameter(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
                1 if type(self.valueOf_) in [int, float] else self.valueOf_ or
                    super(CssParameter, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespace_='sld:', name_='CssParameter', namespacedef_='',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CssParameter')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CssParameter')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespace_='sld:', name_='CssParameter',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespace_='sld:', name_='CssParameter'):
        super(CssParameter, self).exportAttributes(outfile, level, already_processed, namespace_,
                                                   name_='CssParameter')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))

    def exportChildren(self, outfile, level, namespace_='sld:', name_='CssParameter', fromsubclass_=False,
                       pretty_print=True):
        super(CssParameter, self).exportChildren(outfile, level, namespace_, name_, True,
                                                 pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        super(CssParameter, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        super(CssParameter, self).buildChildren(child_, node, nodeName_, True)
        pass


# end class CssParameter


GDSClassesMapping = {
    'Add': BinaryOperatorType,
    'AnchorPointX': ParameterValueType,
    'AnchorPointY': ParameterValueType,
    'And': BinaryLogicOpType,
    'BBOX': BBOXType,
    'Beyond': DistanceBufferType,
    'BlueChannel': SelectedChannelType,
    'Box': BoxType,
    'Contains': BinarySpatialOpType,
    'Crosses': BinarySpatialOpType,
    'DWithin': DistanceBufferType,
    'Disjoint': BinarySpatialOpType,
    'DisplacementX': ParameterValueType,
    'DisplacementY': ParameterValueType,
    'Distance': DistanceType,
    'Div': BinaryOperatorType,
    'Equals': BinarySpatialOpType,
    'FeatureId': FeatureIdType,
    'Filter': FilterType,
    'Function': FunctionType,
    'GrayChannel': SelectedChannelType,
    'GreenChannel': SelectedChannelType,
    'Intersects': BinarySpatialOpType,
    'Label': ParameterValueType,
    'LineString': LineStringType,
    'LinearRing': LinearRingType,
    'Literal': LiteralType,
    'LowerBoundary': LowerBoundaryType,
    'Mul': BinaryOperatorType,
    'MultiGeometry': GeometryCollectionType,
    'MultiLineString': MultiLineStringType,
    'MultiPoint': MultiPointType,
    'MultiPolygon': MultiPolygonType,
    'Not': UnaryLogicOpType,
    'Opacity': ParameterValueType,
    'Or': BinaryLogicOpType,
    'Overlaps': BinarySpatialOpType,
    'PerpendicularOffset': ParameterValueType,
    'Point': PointType,
    'Polygon': PolygonType,
    'PropertyIsBetween': PropertyIsBetweenType,
    'PropertyIsEqualTo': BinaryComparisonOpType,
    'PropertyIsGreaterThan': BinaryComparisonOpType,
    'PropertyIsGreaterThanOrEqualTo': BinaryComparisonOpType,
    'PropertyIsLessThan': BinaryComparisonOpType,
    'PropertyIsLessThanOrEqualTo': BinaryComparisonOpType,
    'PropertyIsLike': PropertyIsLikeType,
    'PropertyIsNotEqualTo': BinaryComparisonOpType,
    'PropertyIsNull': PropertyIsNullType,
    'PropertyName': PropertyNameType,
    'Radius': ParameterValueType,
    'RedChannel': SelectedChannelType,
    'Rotation': ParameterValueType,
    'Size': ParameterValueType,
    'Sub': BinaryOperatorType,
    'Symbolizer': SymbolizerType,
    'Touches': BinarySpatialOpType,
    'UpperBoundary': UpperBoundaryType,
    'Within': BinarySpatialOpType,
    '_Feature': AbstractFeatureType,
    '_FeatureCollection': AbstractFeatureCollectionType,
    '_Geometry': AbstractGeometryType,
    '_GeometryCollection': GeometryCollectionType,
    '_geometryProperty': GeometryAssociationType,
    'arc': arcType,
    'boundedBy': BoundingShapeType,
    'centerLineOf': LineStringPropertyType,
    'centerOf': PointPropertyType,
    'comparisonOps': ComparisonOpsType,
    'coord': CoordType,
    'coordinates': CoordinatesType,
    'coverage': PolygonPropertyType,
    'edgeOf': LineStringPropertyType,
    'expression': ExpressionType,
    'extentOf': PolygonPropertyType,
    'featureMember': FeatureAssociationType,
    'geometryMember': GeometryAssociationType,
    'geometryProperty': GeometryAssociationType,
    'innerBoundaryIs': LinearRingMemberType,
    'lineStringMember': LineStringMemberType,
    'lineStringProperty': LineStringPropertyType,
    'location': PointPropertyType,
    'locator': locatorType,
    'logicOps': LogicOpsType,
    'multiCenterLineOf': MultiLineStringPropertyType,
    'multiCenterOf': MultiPointPropertyType,
    'multiCoverage': MultiPolygonPropertyType,
    'multiEdgeOf': MultiLineStringPropertyType,
    'multiExtentOf': MultiPolygonPropertyType,
    'multiGeometryProperty': MultiGeometryPropertyType,
    'multiLineStringProperty': MultiLineStringPropertyType,
    'multiLocation': MultiPointPropertyType,
    'multiPointProperty': MultiPointPropertyType,
    'multiPolygonProperty': MultiPolygonPropertyType,
    'multiPosition': MultiPointPropertyType,
    'outerBoundaryIs': LinearRingMemberType,
    'pointMember': PointMemberType,
    'pointProperty': PointPropertyType,
    'polygonMember': PolygonMemberType,
    'polygonProperty': PolygonPropertyType,
    'position': PointPropertyType,
    'resource': resourceType,
    'spatialOps': SpatialOpsType,
    'title': titleEltType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'StyledLayerDescriptor'
        rootClass = StyledLayerDescriptor
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:sld="http://www.opengis.net/sld"',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'StyledLayerDescriptor'
        rootClass = StyledLayerDescriptor
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    if sys.version_info.major == 2:
        from StringIO import StringIO as IOBuffer
    else:
        from io import BytesIO as IOBuffer
    parser = None
    doc = parsexml_(IOBuffer(inString), parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'StyledLayerDescriptor'
        rootClass = StyledLayerDescriptor
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:sld="http://www.opengis.net/sld"')
    return rootObj


def parseLiteral(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'StyledLayerDescriptor'
        rootClass = StyledLayerDescriptor
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from sld_1_0_0 import *\n\n')
        sys.stdout.write('import sld_1_0_0 as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    # import pdb; pdb.set_trace()
    main()

__all__ = [
    "AVERAGE",
    "AbstractFeatureCollectionBaseType",
    "AbstractFeatureCollectionType",
    "AbstractFeatureType",
    "AbstractGeometryCollectionBaseType",
    "AbstractGeometryType",
    "AnchorPoint",
    "BBOXType",
    "BinaryComparisonOpType",
    "BinaryLogicOpType",
    "BinaryOperatorType",
    "BinarySpatialOpType",
    "BoundingShapeType",
    "BoxType",
    "ChannelSelection",
    "ColorMap",
    "ColorMapEntry",
    "ComparisonOpsType",
    "ContrastEnhancement",
    "CoordType",
    "CoordinatesType",
    "CssParameter",
    "Displacement",
    "DistanceBufferType",
    "DistanceType",
    "EARLIEST_ON_TOP",
    "ElseFilter",
    "ExpressionType",
    "Extent",
    "ExternalGraphic",
    "FeatureAssociationType",
    "FeatureIdType",
    "FeatureTypeConstraint",
    "FeatureTypeStyle",
    "Fill",
    "FilterType",
    "Font",
    "FunctionType",
    "Geometry",
    "GeometryAssociationType",
    "GeometryCollectionType",
    "GeometryPropertyType",
    "Graphic",
    "GraphicFill",
    "GraphicStroke",
    "Halo",
    "Histogram",
    "ImageOutline",
    "LATEST_ON_TOP",
    "LabelPlacement",
    "LayerFeatureConstraints",
    "LegendGraphic",
    "LinePlacement",
    "LineStringMemberType",
    "LineStringPropertyType",
    "LineStringType",
    "LineSymbolizer",
    "LinearRingMemberType",
    "LinearRingType",
    "LiteralType",
    "LogicOpsType",
    "LowerBoundaryType",
    "Mark",
    "MultiGeometryPropertyType",
    "MultiLineStringPropertyType",
    "MultiLineStringType",
    "MultiPointPropertyType",
    "MultiPointType",
    "MultiPolygonPropertyType",
    "MultiPolygonType",
    "NamedLayer",
    "NamedStyle",
    "Normalize",
    "OnlineResource",
    "OverlapBehavior",
    "ParameterValueType",
    "PointMemberType",
    "PointPlacement",
    "PointPropertyType",
    "PointSymbolizer",
    "PointType",
    "PolygonMemberType",
    "PolygonPropertyType",
    "PolygonSymbolizer",
    "PolygonType",
    "PropertyIsBetweenType",
    "PropertyIsLikeType",
    "PropertyIsNullType",
    "PropertyNameType",
    "RANDOM",
    "RasterSymbolizer",
    "RemoteOWS",
    "Rule",
    "SelectedChannelType",
    "Service",
    "ShadedRelief",
    "SpatialOpsType",
    "Stroke",
    "StyledLayerDescriptor",
    "SymbolizerType",
    "TextSymbolizer",
    "UnaryLogicOpType",
    "UpperBoundaryType",
    "UserLayer",
    "UserStyle",
    "arcType",
    "extended",
    "locatorType",
    "resourceType",
    "simple",
    "titleEltType"
]
