# eis-payments
This service directly communicates with the various Payment Service Providers (PSPs) 
  in order to charge or refund customers. This service will automatically connect to the PSP linked
  in your admin configuration; meaning if you configured Stripe, it will automatically create a payment
  on Stripe when you create it in Emil.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.emil.de](https://www.emil.de)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install eis.payments
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import eis.payments
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import eis.payments
```

## Getting Started

The environment variables must be set in order to properly use this SDK.

```shell 
export EMIL_USERNAME=XXXXXXX
export EMIL_PASSWORD=XXXXXXX
```

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
import time
import eis.payments
from pprint import pprint
from eis.payments.api import bank_accounts_api
from eis.payments.model.create_bank_account_request_dto import CreateBankAccountRequestDto
from eis.payments.model.list_bank_accounts_response_class import ListBankAccountsResponseClass
# Defining the host is optional and defaults to https://apiv2.emil.de
# See configuration.py for a list of all supported configuration parameters.
configuration = eis.payments.Configuration(
    host = "https://apiv2.emil.de"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Bearer is automatically handled with exported environment variables. However, you
# can manuallay configure Bearer authorization (JWT): bearer
configuration = eis.payments.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# After manual token becomes invalid, the SDK will default to re-login automatically
# with environment variable credentials.


# Enter a context with an instance of the API client
with eis.payments.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = bank_accounts_api.BankAccountsApi(api_client)
    create_bank_account_request_dto = CreateBankAccountRequestDto(
        account_code="account_code_example",
        iban="iban_example",
    ) # CreateBankAccountRequestDto | 
    authorization = "Authorization_example" # str | Bearer Token (optional)

    try:
        # Create a bank account
        api_response = api_instance.create_bank_account(create_bank_account_request_dto, authorization=authorization)
        pprint(api_response)
    except eis.payments.ApiException as e:
        print("Exception when calling BankAccountsApi->create_bank_account: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://apiv2.emil.de*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BankAccountsApi* | [**create_bank_account**](docs/BankAccountsApi.md#create_bank_account) | **POST** /paymentservice/v1/bank-accounts | Create a bank account
*BankAccountsApi* | [**list_bank_accounts**](docs/BankAccountsApi.md#list_bank_accounts) | **GET** /paymentservice/v1/bank-accounts | List bank accounts
*PaymentMethodsApi* | [**create_payment_method**](docs/PaymentMethodsApi.md#create_payment_method) | **POST** /paymentservice/v1/payment-methods | Create the payment-method
*PaymentMethodsApi* | [**delete_payment_method**](docs/PaymentMethodsApi.md#delete_payment_method) | **DELETE** /paymentservice/v1/payment-methods/{id} | Delete a payment method
*PaymentMethodsApi* | [**get_payment_method**](docs/PaymentMethodsApi.md#get_payment_method) | **GET** /paymentservice/v1/payment-methods/{code} | Retrieve a payment method
*PaymentMethodsApi* | [**list_payment_methods**](docs/PaymentMethodsApi.md#list_payment_methods) | **GET** /paymentservice/v1/payment-methods | List payment methods
*PaymentRemindersApi* | [**create_payment_reminder**](docs/PaymentRemindersApi.md#create_payment_reminder) | **POST** /paymentservice/v1/payment-reminders | Create the payment-reminder
*PaymentRemindersApi* | [**deactivate_payment_reminder**](docs/PaymentRemindersApi.md#deactivate_payment_reminder) | **POST** /paymentservice/v1/payment-reminders/{code}/deactivate | Update the payment-reminder
*PaymentRemindersApi* | [**get_policy**](docs/PaymentRemindersApi.md#get_policy) | **GET** /paymentservice/v1/payment-reminders/{code} | Retrieve the payment reminder
*PaymentRemindersApi* | [**list_payment_reminders**](docs/PaymentRemindersApi.md#list_payment_reminders) | **GET** /paymentservice/v1/payment-reminders | List payment reminders
*PaymentServiceProvidersApi* | [**validate_configuration**](docs/PaymentServiceProvidersApi.md#validate_configuration) | **POST** /paymentservice/v1/psps/validate | 
*PaymentSetupApi* | [**complete_payment_setup**](docs/PaymentSetupApi.md#complete_payment_setup) | **POST** /paymentservice/v1/payment-setup/complete | 
*PaymentSetupApi* | [**initiate_payment_setup**](docs/PaymentSetupApi.md#initiate_payment_setup) | **POST** /paymentservice/v1/payment-setup/initiate | 
*PaymentsApi* | [**create_payment**](docs/PaymentsApi.md#create_payment) | **POST** /paymentservice/v1/payments | Create a payment
*PaymentsApi* | [**get_payment**](docs/PaymentsApi.md#get_payment) | **GET** /paymentservice/v1/payments/{code} | Retrieve a payment
*PaymentsApi* | [**list_payments**](docs/PaymentsApi.md#list_payments) | **GET** /paymentservice/v1/payments | List payments
*WebhooksApi* | [**post_webhook**](docs/WebhooksApi.md#post_webhook) | **POST** /paymentservice/v1/webhooks/{pspType}/{tenantSlug} | 
*DefaultApi* | [**check**](docs/DefaultApi.md#check) | **GET** /paymentservice/health | 


## Documentation For Models

 - [BankAccountClass](docs/BankAccountClass.md)
 - [BillingProfileDto](docs/BillingProfileDto.md)
 - [BillingProfileLimitedResponseDto](docs/BillingProfileLimitedResponseDto.md)
 - [CompleteBraintreePaymentSetupRequestDto](docs/CompleteBraintreePaymentSetupRequestDto.md)
 - [CompletePaymentSetupRequestDto](docs/CompletePaymentSetupRequestDto.md)
 - [CompletePaymentSetupResponseClass](docs/CompletePaymentSetupResponseClass.md)
 - [CompleteStripePaymentSetupRequestDto](docs/CompleteStripePaymentSetupRequestDto.md)
 - [CreateBankAccountRequestDto](docs/CreateBankAccountRequestDto.md)
 - [CreatePaymentMethodResponseClass](docs/CreatePaymentMethodResponseClass.md)
 - [CreatePaymentReminderRequestDto](docs/CreatePaymentReminderRequestDto.md)
 - [CreatePaymentRequestDto](docs/CreatePaymentRequestDto.md)
 - [CreatePaymentResponseClass](docs/CreatePaymentResponseClass.md)
 - [CreatePspPaymentMethodRequestDto](docs/CreatePspPaymentMethodRequestDto.md)
 - [DeactivatePaymentReminderRequestDto](docs/DeactivatePaymentReminderRequestDto.md)
 - [GetPaymentMethodResponseClass](docs/GetPaymentMethodResponseClass.md)
 - [GetPaymentResponseClass](docs/GetPaymentResponseClass.md)
 - [GetRequestDto](docs/GetRequestDto.md)
 - [InitiateBraintreePaymentSetupRequestDto](docs/InitiateBraintreePaymentSetupRequestDto.md)
 - [InitiateBraintreePaymentSetupResponseClass](docs/InitiateBraintreePaymentSetupResponseClass.md)
 - [InitiatePaymentSetupRequestDto](docs/InitiatePaymentSetupRequestDto.md)
 - [InitiatePaymentSetupResponseClass](docs/InitiatePaymentSetupResponseClass.md)
 - [InitiateStripePaymentSetupRequestDto](docs/InitiateStripePaymentSetupRequestDto.md)
 - [InitiateStripePaymentSetupResponseClass](docs/InitiateStripePaymentSetupResponseClass.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [ListBankAccountsResponseClass](docs/ListBankAccountsResponseClass.md)
 - [ListPaymentMethodsResponseClass](docs/ListPaymentMethodsResponseClass.md)
 - [ListPaymentRemindersResponseClass](docs/ListPaymentRemindersResponseClass.md)
 - [ListPaymentsResponseClass](docs/ListPaymentsResponseClass.md)
 - [PaymentClass](docs/PaymentClass.md)
 - [PaymentMethodClass](docs/PaymentMethodClass.md)
 - [PaymentReminderClass](docs/PaymentReminderClass.md)
 - [SepaDirectDto](docs/SepaDirectDto.md)
 - [SymphonyProfileLimitedResponseDto](docs/SymphonyProfileLimitedResponseDto.md)
 - [TransactionClass](docs/TransactionClass.md)
 - [ValidatePSPConfigRequestDto](docs/ValidatePSPConfigRequestDto.md)
 - [ValidatePSPConfigResponseClass](docs/ValidatePSPConfigResponseClass.md)


## Documentation For Authorization


## bearer

- **Type**: Bearer authentication (JWT)


## Author

kontakt@emil.de


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in eis.payments.apis and eis.payments.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from eis.payments.api.default_api import DefaultApi`
- `from eis.payments.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import eis.payments
from eis.payments.apis import *
from eis.payments.models import *
```

