"""
    Emil Payment Service

    This service directly communicates with the various Payment Service Providers (PSPs)    in order to charge or refund customers. This service will automatically connect to the PSP linked   in your admin configuration; meaning if you configured Stripe, it will automatically create a payment   on Stripe when you create it in Emil.  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.payments.api_client import ApiClient, Endpoint as _Endpoint
from eis.payments.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from eis.payments.model.create_payment_request_dto import CreatePaymentRequestDto
from eis.payments.model.create_payment_response_class import CreatePaymentResponseClass
from eis.payments.model.get_payment_response_class import GetPaymentResponseClass
from eis.payments.model.list_payments_response_class import ListPaymentsResponseClass


class PaymentsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_payment_endpoint = _Endpoint(
            settings={
                'response_type': (CreatePaymentResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/paymentservice/v1/payments',
                'operation_id': 'create_payment',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'idempotency_key',
                    'create_payment_request_dto',
                    'authorization',
                ],
                'required': [
                    'idempotency_key',
                    'create_payment_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'idempotency_key':
                        (str,),
                    'create_payment_request_dto':
                        (CreatePaymentRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'idempotency_key': 'Idempotency-Key',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'idempotency_key': 'header',
                    'create_payment_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_payment_endpoint = _Endpoint(
            settings={
                'response_type': (GetPaymentResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/paymentservice/v1/payments/{code}',
                'operation_id': 'get_payment',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'authorization',
                    'expand',
                    'expand2',
                ],
                'required': [
                    'code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'authorization':
                        (str,),
                    'expand':
                        (str,),
                    'expand2':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                    'expand': 'expand',
                    'expand2': 'expand',
                },
                'location_map': {
                    'code': 'query',
                    'authorization': 'header',
                    'expand': 'query',
                    'expand2': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_payments_endpoint = _Endpoint(
            settings={
                'response_type': (ListPaymentsResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/paymentservice/v1/payments',
                'operation_id': 'list_payments',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'page_size',
                    'page_token',
                    'filter',
                    'search',
                    'order',
                    'expand',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'page_size':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'page_token':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'filter':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'search':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'order':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'expand':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'page_size': 'pageSize',
                    'page_token': 'pageToken',
                    'filter': 'filter',
                    'search': 'search',
                    'order': 'order',
                    'expand': 'expand',
                },
                'location_map': {
                    'authorization': 'header',
                    'page_size': 'query',
                    'page_token': 'query',
                    'filter': 'query',
                    'search': 'query',
                    'order': 'query',
                    'expand': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_payment(
        self,
        idempotency_key,
        create_payment_request_dto,
        **kwargs
    ):
        """Create a payment  # noqa: E501

        Creates a payment for a specified account. This function is idempotent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_payment(idempotency_key, create_payment_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            idempotency_key (str): Idempotency Key used to make the request idempotent. The key should be unique.      Usually, a generated v4 UUID is enough.
            create_payment_request_dto (CreatePaymentRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreatePaymentResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['idempotency_key'] = \
            idempotency_key
        kwargs['create_payment_request_dto'] = \
            create_payment_request_dto
        return self.create_payment_endpoint.call_with_http_info(**kwargs)

    def get_payment(
        self,
        code,
        **kwargs
    ):
        """Retrieve a payment  # noqa: E501

        Retrieves the details of a payment that was previously created. Supply the unique payment      code that was returned when you created the payment and Emil Api will return the corresponding payment      information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_payment(code, async_req=True)
        >>> result = thread.get()

        Args:
            code (str): Unique identifier for the object.

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            expand (str): Fields to expand response by. [optional]
            expand2 (str): Fields to expand response by. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetPaymentResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        return self.get_payment_endpoint.call_with_http_info(**kwargs)

    def list_payments(
        self,
        **kwargs
    ):
        """List payments  # noqa: E501

        Returns a list of payments you’ve previously created. The payments are returned in sorted order,        with the oldest payment appearing first. For more information about pagination, read the Pagination        documentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payments(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            authorization (str): Bearer Token. [optional]
            page_size (bool, date, datetime, dict, float, int, list, str, none_type): A limit on the number of objects to be returned.     Limit ranges between 1 and 100. Default: 10.. [optional]
            page_token (bool, date, datetime, dict, float, int, list, str, none_type): A cursor for use in pagination.     pageToken is an ID that defines your place in the list.     For instance, if you make a list request and receive 100 objects and pageToken=1,     your subsequent call can include pageToken=2 in order to fetch the next page of the list.. [optional]
            filter (bool, date, datetime, dict, float, int, list, str, none_type): Filter the response by one or multiple fields.     In general, fetching filtered responses will conserve bandwidth and reduce response time.. [optional]
            search (bool, date, datetime, dict, float, int, list, str, none_type): Search the list by any field. For instance, if you want to search by code     add code=xxx in order to fetch the result.. [optional]
            order (bool, date, datetime, dict, float, int, list, str, none_type): The order parameter determines how the results should be sorted according to a specified field.     It functions similarly to an SQL ORDER BY.     Sorting can be performed in either ascending (ASC) or descending (DESC) order.     Default: ASC.. [optional]
            expand (bool, date, datetime, dict, float, int, list, str, none_type): Use this parameter to fetch additional information about the list items.     The expand query parameter increases the set of fields that appear in the response in     addition to the default ones.     Expanding resources can reduce the number of API calls required to accomplish a task.     However, use this with parsimony as some expanded fields can drastically increase payload size.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListPaymentsResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_payments_endpoint.call_with_http_info(**kwargs)

