# -*- coding: utf-8 -*-
"""
Ruby-specific code review checklist.
"""

CHECKLIST = """
## Ruby 代码审查检查清单

### 代码风格和约定
- [ ] 代码是否符合 Ruby 代码风格指南 (如 [Ruby Style Guide](https://github.com/rubocop/ruby-style-guide))
- [ ] 是否使用 RuboCop 进行代码风格检查
- [ ] 两个空格缩进是否一致
- [ ] 是否有不必要的空白或者空行
- [ ] 是否使用了恰当的命名约定 (snake_case 用于方法/变量, CamelCase 用于类/模块)
- [ ] 是否有不必要的注释或者过时的注释
- [ ] 代码是否容易理解且符合惯用的 Ruby 风格
- [ ] 魔法数字是否已提取为有意义的常量

### 类和模块设计
- [ ] 类和模块是否单一职责
- [ ] 是否遵循 DRY (Don't Repeat Yourself) 原则
- [ ] 类的继承结构是否合理
- [ ] 是否合理使用模块作为 mixin
- [ ] 是否恰当地使用了模块命名空间
- [ ] 公共 API 接口是否明确且易于理解
- [ ] 是否控制了类和模块的大小 (避免过大的类/模块)
- [ ] 类变量 (@@var) 是否使用恰当 (通常应避免使用)

### 方法和代码块
- [ ] 方法是否遵循单一职责原则
- [ ] 方法长度是否合理控制
- [ ] 方法名是否清晰表达了其功能
- [ ] 参数数量是否合理 (避免过多参数)
- [ ] 是否恰当使用了可选参数和关键字参数
- [ ] 是否恰当使用了代码块和 yield
- [ ] 闭包使用是否恰当且清晰
- [ ] 是否恰当使用了方法链 (避免过长的方法链)

### 异常处理
- [ ] 是否捕获具体的异常类型而非所有异常
- [ ] 是否提供有意义的错误信息
- [ ] 资源是否在 ensure 块中正确释放
- [ ] 是否避免了使用异常控制正常流程
- [ ] 是否在合适的级别处理异常
- [ ] 是否有自定义异常类用于特定错误情况
- [ ] 是否使用了 begin/rescue/ensure/end 代码块的简洁形式
- [ ] 是否处理了第三方库可能抛出的异常

### 性能考量
- [ ] 大型集合操作是否高效 (如使用 map, select 而非循环)
- [ ] 是否避免了 N+1 查询问题
- [ ] 是否恰当使用了惰性计算
- [ ] 字符串操作是否高效
- [ ] 是否通过缓存避免重复计算
- [ ] IO 和网络操作是否异步或批量处理
- [ ] 是否避免了内存泄漏
- [ ] 是否避免了不必要的对象分配

### Rails 特定检查 (如适用)
- [ ] 模型是否遵循 ActiveRecord 最佳实践
- [ ] 控制器是否遵循"瘦控制器，胖模型"原则
- [ ] 是否恰当使用了 Rails 的回调机制
- [ ] 视图是否避免了业务逻辑
- [ ] 路由设计是否符合 RESTful 规范
- [ ] 是否使用了适当的查询优化技术
- [ ] ActiveRecord 关联是否合理配置
- [ ] 是否使用了适当的数据库索引

### 安全性
- [ ] 是否防止了 SQL 注入攻击
- [ ] 是否防止了跨站点脚本 (XSS) 攻击
- [ ] 是否防止了跨站请求伪造 (CSRF)
- [ ] 是否安全处理了用户输入
- [ ] 是否使用了安全的密码存储方式
- [ ] 是否正确处理了敏感数据
- [ ] 是否使用了 HTTPS
- [ ] 是否防止了不安全的对象反序列化

### 测试
- [ ] 是否有全面的单元测试
- [ ] 是否有整合测试
- [ ] 测试是否覆盖了边缘情况
- [ ] 测试命名是否清晰表达测试目的
- [ ] 是否使用了恰当的测试辅助工具 (如 RSpec, Minitest)
- [ ] 测试是否避免了依赖外部服务
- [ ] 是否有适当的 fixture 或 factory
- [ ] 测试是否快速且可靠 (没有随机失败)

### 依赖管理
- [ ] Gemfile 是否明确指定了版本约束
- [ ] 是否避免使用过时的 gem
- [ ] 是否考虑了 gem 的安全更新
- [ ] 是否最小化了外部依赖
- [ ] Gemfile.lock 是否包含在版本控制中
- [ ] 是否注意了依赖冲突问题
- [ ] 是否适当使用了开发环境和生产环境分组
- [ ] 是否考虑了使用 Bundler 的 require: false 选项优化加载

### 文档
- [ ] 是否使用 RDoc/YARD 对公共 API 进行文档化
- [ ] 是否有清晰的 README 文件
- [ ] 复杂逻辑是否有代码注释
- [ ] 是否有必要的开发者文档
- [ ] 文档是否与代码同步更新
- [ ] 是否有示例或者教程
- [ ] 是否有 CHANGELOG 记录变更
- [ ] API 参数和返回值是否有文档描述
""" 