# -*- coding: utf-8 -*-
"""
DevOps (Makefile, CI/CD) specific code review checklist.
"""

CHECKLIST = """
## DevOps (Makefile, CI/CD) 代码审查检查清单

### Makefile 结构与风格
- [ ] 目标是否清晰且有明确用途
- [ ] 是否使用了合适的依赖关系
- [ ] 是否有默认目标和帮助信息
- [ ] 变量命名是否一致且有意义
- [ ] 是否使用了适当的变量替换
- [ ] 是否避免了重复代码
- [ ] 目标规则是否组织良好并有注释
- [ ] 是否使用了模式规则和自动变量

### Makefile 最佳实践
- [ ] 是否使用了.PHONY伪目标
- [ ] 是否声明了必要的环境变量
- [ ] 是否使用了适当的错误处理
- [ ] 是否优化了构建性能
- [ ] 是否支持并行构建 (-j 选项)
- [ ] 是否考虑了跨平台兼容性
- [ ] 是否适当使用了条件逻辑
- [ ] 是否包含了清理目标

### CI/CD 配置审查
- [ ] 工作流程是否清晰定义
- [ ] 是否使用了合适的触发条件
- [ ] 是否正确定义了环境和依赖
- [ ] 是否有适当的阶段和步骤划分
- [ ] 是否实现了合理的并行执行
- [ ] 是否有适当的缓存策略
- [ ] 是否处理了错误和恢复机制
- [ ] 是否包含了适当的通知配置

### 环境管理
- [ ] 是否明确定义了所需的环境变量
- [ ] 敏感信息是否安全管理
- [ ] 是否有环境隔离 (开发/测试/生产)
- [ ] 是否有版本锁定机制
- [ ] 是否考虑了可重现性
- [ ] 是否有适当的环境验证步骤
- [ ] 是否考虑了可扩展性需求
- [ ] 依赖管理是否合理

### 自动化构建
- [ ] 构建步骤是否完整且按顺序
- [ ] 构建过程是否可重现
- [ ] 是否包含了必要的验证步骤
- [ ] 资源使用是否优化
- [ ] 是否有适当的错误报告
- [ ] 是否包含了版本控制信息
- [ ] 构建成品是否明确定义
- [ ] 是否有适当的构建日志

### 测试自动化
- [ ] 是否包含了单元测试
- [ ] 是否包含了集成测试
- [ ] 是否设置了适当的测试环境
- [ ] 测试结果是否易于解读
- [ ] 是否避免了测试之间的依赖
- [ ] 测试覆盖率是否合理
- [ ] 是否有失败测试的恢复机制
- [ ] 测试执行是否优化

### 部署流程
- [ ] 部署步骤是否明确且按顺序
- [ ] 是否有回滚机制
- [ ] 是否使用了蓝绿部署或金丝雀发布
- [ ] 是否进行了部署前验证
- [ ] 是否有部署后验证
- [ ] 是否有适当的权限控制
- [ ] 是否支持不同环境的部署
- [ ] 是否有部署拆分或分阶段发布机制

### 安全考虑
- [ ] 构建和部署脚本是否避免了硬编码凭证
- [ ] 是否有适当的访问控制
- [ ] 是否进行了安全扫描
- [ ] 依赖项是否经过安全审查
- [ ] 是否避免了注入漏洞
- [ ] 临时凭证管理是否安全
- [ ] 是否有安全合规检查
- [ ] 是否记录了安全相关日志

### 监控和可观测性
- [ ] 是否包含了健康检查
- [ ] 是否实现了适当的日志记录
- [ ] 是否有性能监控
- [ ] 是否有错误追踪和报警
- [ ] 是否考虑了可追踪性
- [ ] 是否有适当的指标收集
- [ ] 是否考虑了日志聚合
- [ ] 是否有状态报告机制

### 文档和维护
- [ ] 是否有清晰的使用文档
- [ ] 命令和选项是否有描述
- [ ] 是否记录了关键决策和注意事项
- [ ] 脚本是否易于维护和扩展
- [ ] 是否有明确的维护责任
- [ ] 是否有版本控制和变更历史
- [ ] 是否有明确的故障排除指南
- [ ] 依赖关系是否明确记录
""" 