# coding: utf-8

"""
    Residential Electrification Model API

    An API for REM, the Residential Electrification Model.

    The version of the OpenAPI document: 0.4.2
    Contact: datascience@rewiringamerica.org
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from rewiringamerica_rem.models.building_features import BuildingFeatures
from typing import Optional, Set
from typing_extensions import Self

class BuildingProfile(BaseModel):
    """
    A class representing the known geographic features and building characteristics for a given residence.
    """ # noqa: E501
    county: StrictStr = Field(description="The county where a residence is located (in GISJOIN format)")
    puma: StrictStr = Field(description="The Public Use Microdata Area (PUMA) where a residence is located (in GISJOIN format).")
    ashrae_iecc_climate_zone_2004: StrictStr = Field(description="The IECC Climate Zone where a residence is located.")
    weather_file_city: StrictStr = Field(description="The location of the ResStock Weather File used for the area where the residence is located.")
    state: StrictStr = Field(description="The 2 letter postal code of the state where the residence is located.")
    building_features: Optional[BuildingFeatures] = Field(default=None, description="The building characteristics found for the residence. See BuildingFeatures documentation for full details about possible characteristics and their meanings.")
    __properties: ClassVar[List[str]] = ["county", "puma", "ashrae_iecc_climate_zone_2004", "weather_file_city", "state", "building_features"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BuildingProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of building_features
        if self.building_features:
            _dict['building_features'] = self.building_features.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BuildingProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "county": obj.get("county"),
            "puma": obj.get("puma"),
            "ashrae_iecc_climate_zone_2004": obj.get("ashrae_iecc_climate_zone_2004"),
            "weather_file_city": obj.get("weather_file_city"),
            "state": obj.get("state"),
            "building_features": BuildingFeatures.from_dict(obj["building_features"]) if obj.get("building_features") is not None else None
        })
        return _obj


