# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import List, Optional
from typing_extensions import Annotated

from pulpcore.client.pulp_python.api_client import ApiClient, RequestSerialized
from pulpcore.client.pulp_python.api_response import ApiResponse
from pulpcore.client.pulp_python.rest import RESTResponseType


class PypiProvenanceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def read(
        self,
        filename: StrictStr,
        package: StrictStr,
        path: StrictStr,
        version: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Get package provenance

        Gets the provenance for a package.

        :param filename: (required)
        :type filename: str
        :param package: (required)
        :type package: str
        :param path: (required)
        :type path: str
        :param version: (required)
        :type version: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            filename=filename,
            package=package,
            path=path,
            version=version,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def read_with_http_info(
        self,
        filename: StrictStr,
        package: StrictStr,
        path: StrictStr,
        version: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Get package provenance

        Gets the provenance for a package.

        :param filename: (required)
        :type filename: str
        :param package: (required)
        :type package: str
        :param path: (required)
        :type path: str
        :param version: (required)
        :type version: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            filename=filename,
            package=package,
            path=path,
            version=version,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def read_without_preload_content(
        self,
        filename: StrictStr,
        package: StrictStr,
        path: StrictStr,
        version: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get package provenance

        Gets the provenance for a package.

        :param filename: (required)
        :type filename: str
        :param package: (required)
        :type package: str
        :param path: (required)
        :type path: str
        :param version: (required)
        :type version: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            filename=filename,
            package=package,
            path=path,
            version=version,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_serialize(
        self,
        filename,
        package,
        path,
        version,
        x_task_diagnostics,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if filename is not None:
            _path_params['filename'] = filename
        if package is not None:
            _path_params['package'] = package
        if path is not None:
            _path_params['path'] = path
        if version is not None:
            _path_params['version'] = version
        # process the query parameters
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/pypi/{path}/integrity/{package}/{version}/{filename}/provenance/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


