# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class AcquisitionChannel(str, enum.Enum):
    """
    Model for User acquisition channel
    """

    ORGANIC = "ORGANIC"
    PAID = "PAID"
    REFERRAL = "REFERRAL"
    OFFLINE = "OFFLINE"
    GATHERING = "GATHERING"
    UNKNOWN = "UNKNOWN"

    def visit(
        self,
        organic: typing.Callable[[], T_Result],
        paid: typing.Callable[[], T_Result],
        referral: typing.Callable[[], T_Result],
        offline: typing.Callable[[], T_Result],
        gathering: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is AcquisitionChannel.ORGANIC:
            return organic()
        if self is AcquisitionChannel.PAID:
            return paid()
        if self is AcquisitionChannel.REFERRAL:
            return referral()
        if self is AcquisitionChannel.OFFLINE:
            return offline()
        if self is AcquisitionChannel.GATHERING:
            return gathering()
        if self is AcquisitionChannel.UNKNOWN:
            return unknown()
