# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class CardStatus(str, enum.Enum):
    """
    Status of the card
    """

    ACTIVE = "ACTIVE"
    FROZEN = "FROZEN"
    BLOCKED = "BLOCKED"
    SUSPECTED_FRAUD = "SUSPECTED_FRAUD"
    STOLEN = "STOLEN"
    LOST = "LOST"
    CLOSED = "CLOSED"
    OTHER = "OTHER"

    def visit(
        self,
        active: typing.Callable[[], T_Result],
        frozen: typing.Callable[[], T_Result],
        blocked: typing.Callable[[], T_Result],
        suspected_fraud: typing.Callable[[], T_Result],
        stolen: typing.Callable[[], T_Result],
        lost: typing.Callable[[], T_Result],
        closed: typing.Callable[[], T_Result],
        other: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is CardStatus.ACTIVE:
            return active()
        if self is CardStatus.FROZEN:
            return frozen()
        if self is CardStatus.BLOCKED:
            return blocked()
        if self is CardStatus.SUSPECTED_FRAUD:
            return suspected_fraud()
        if self is CardStatus.STOLEN:
            return stolen()
        if self is CardStatus.LOST:
            return lost()
        if self is CardStatus.CLOSED:
            return closed()
        if self is CardStatus.OTHER:
            return other()
