# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .address import Address

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ContactDetails(pydantic.BaseModel):
    """
    Model for business user contact information details
    """

    email_ids: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="emailIds", description="Email addresses of the contacts for a given business customer"
    )
    contact_numbers: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="contactNumbers", description="Phone numbers to contact a given business customer"
    )
    fax_numbers: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="faxNumbers", description="Fax numbers to contact a business customer"
    )
    websites: typing.Optional[typing.List[str]] = pydantic.Field(description="Website of the company")
    addresses: typing.Optional[typing.List[Address]] = pydantic.Field(description="Address(es) of the company")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
