# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .address import Address
from .country_code import CountryCode
from .email_id import EmailId
from .tag import Tag

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class IbanDetails(pydantic.BaseModel):
    """
    Standardized model for Bank Details
    """

    bic: typing.Optional[str] = pydantic.Field(
        alias="BIC",
        description="Identifier for the bank. Can be routing number, BIK number, SWIFT code, BIC number etc.",
    )
    bank_name: typing.Optional[str] = pydantic.Field(alias="bankName", description="Name of the bank")
    bank_address: typing.Optional[Address] = pydantic.Field(alias="bankAddress")
    country: typing.Optional[CountryCode]
    iban: typing.Optional[str] = pydantic.Field(
        alias="IBAN", description="Account number of the user. Can be account number, IBAN number etc."
    )
    name: typing.Optional[str] = pydantic.Field(description="Name of the bank account holder")
    email_id: typing.Optional[EmailId] = pydantic.Field(alias="emailId")
    bank_branch_code: typing.Optional[str] = pydantic.Field(
        alias="bankBranchCode",
        description="Branch code of the bank. In some countries, this can be the same as the bank's SWIFT code",
    )
    payment_channel: typing.Optional[str] = pydantic.Field(alias="paymentChannel")
    tags: typing.Optional[typing.List[Tag]] = pydantic.Field(
        description="Additional information that can be added via tags"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
