# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .executed_rules_result import ExecutedRulesResult
from .hit_rules_details import HitRulesDetails
from .rule_action import RuleAction
from .transaction_risk_scoring_result import TransactionRiskScoringResult

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class TransactionMonitoringResult(pydantic.BaseModel):
    transaction_id: str = pydantic.Field(
        alias="transactionId", description="Transaction ID that the results pertain to"
    )
    status: RuleAction
    risk_score_details: typing.Optional[TransactionRiskScoringResult] = pydantic.Field(alias="riskScoreDetails")
    executed_rules: typing.List[ExecutedRulesResult] = pydantic.Field(
        alias="executedRules", description="Unique transaction identifier"
    )
    hit_rules: typing.List[HitRulesDetails] = pydantic.Field(
        alias="hitRules", description="Unique transaction identifier"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
