# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ExternalExadataInfrastructureExadataManagementArgs', 'ExternalExadataInfrastructureExadataManagement']

@pulumi.input_type
class ExternalExadataInfrastructureExadataManagementArgs:
    def __init__(__self__, *,
                 enable_exadata: pulumi.Input[bool],
                 external_exadata_infrastructure_id: pulumi.Input[str],
                 license_model: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ExternalExadataInfrastructureExadataManagement resource.
        :param pulumi.Input[bool] enable_exadata: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[str] license_model: The Oracle license model.
        """
        pulumi.set(__self__, "enable_exadata", enable_exadata)
        pulumi.set(__self__, "external_exadata_infrastructure_id", external_exadata_infrastructure_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)

    @property
    @pulumi.getter(name="enableExadata")
    def enable_exadata(self) -> pulumi.Input[bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_exadata")

    @enable_exadata.setter
    def enable_exadata(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_exadata", value)

    @property
    @pulumi.getter(name="externalExadataInfrastructureId")
    def external_exadata_infrastructure_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "external_exadata_infrastructure_id")

    @external_exadata_infrastructure_id.setter
    def external_exadata_infrastructure_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle license model.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)


@pulumi.input_type
class _ExternalExadataInfrastructureExadataManagementState:
    def __init__(__self__, *,
                 enable_exadata: Optional[pulumi.Input[bool]] = None,
                 external_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExternalExadataInfrastructureExadataManagement resources.
        :param pulumi.Input[bool] enable_exadata: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[str] license_model: The Oracle license model.
        """
        if enable_exadata is not None:
            pulumi.set(__self__, "enable_exadata", enable_exadata)
        if external_exadata_infrastructure_id is not None:
            pulumi.set(__self__, "external_exadata_infrastructure_id", external_exadata_infrastructure_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)

    @property
    @pulumi.getter(name="enableExadata")
    def enable_exadata(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_exadata")

    @enable_exadata.setter
    def enable_exadata(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_exadata", value)

    @property
    @pulumi.getter(name="externalExadataInfrastructureId")
    def external_exadata_infrastructure_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "external_exadata_infrastructure_id")

    @external_exadata_infrastructure_id.setter
    def external_exadata_infrastructure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle license model.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)


class ExternalExadataInfrastructureExadataManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_exadata: Optional[pulumi.Input[bool]] = None,
                 external_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the External Exadata Infrastructure Exadata Management resource in Oracle Cloud Infrastructure Database Management service.

        Enables Database Management for the Exadata infrastructure specified by externalExadataInfrastructureId. It covers the following
        components:

        - Exadata infrastructure
        - Exadata storage grid
        - Exadata storage server

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_exadata_infrastructure_exadata_management = oci.database_management.ExternalExadataInfrastructureExadataManagement("test_external_exadata_infrastructure_exadata_management",
            external_exadata_infrastructure_id=test_external_exadata_infrastructure["id"],
            enable_exadata=enable_exadata,
            license_model=external_exadata_infrastructure_exadata_management_license_model)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_exadata: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[str] license_model: The Oracle license model.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalExadataInfrastructureExadataManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the External Exadata Infrastructure Exadata Management resource in Oracle Cloud Infrastructure Database Management service.

        Enables Database Management for the Exadata infrastructure specified by externalExadataInfrastructureId. It covers the following
        components:

        - Exadata infrastructure
        - Exadata storage grid
        - Exadata storage server

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_exadata_infrastructure_exadata_management = oci.database_management.ExternalExadataInfrastructureExadataManagement("test_external_exadata_infrastructure_exadata_management",
            external_exadata_infrastructure_id=test_external_exadata_infrastructure["id"],
            enable_exadata=enable_exadata,
            license_model=external_exadata_infrastructure_exadata_management_license_model)
        ```

        :param str resource_name: The name of the resource.
        :param ExternalExadataInfrastructureExadataManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalExadataInfrastructureExadataManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_exadata: Optional[pulumi.Input[bool]] = None,
                 external_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalExadataInfrastructureExadataManagementArgs.__new__(ExternalExadataInfrastructureExadataManagementArgs)

            if enable_exadata is None and not opts.urn:
                raise TypeError("Missing required property 'enable_exadata'")
            __props__.__dict__["enable_exadata"] = enable_exadata
            if external_exadata_infrastructure_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_exadata_infrastructure_id'")
            __props__.__dict__["external_exadata_infrastructure_id"] = external_exadata_infrastructure_id
            __props__.__dict__["license_model"] = license_model
        super(ExternalExadataInfrastructureExadataManagement, __self__).__init__(
            'oci:DatabaseManagement/externalExadataInfrastructureExadataManagement:ExternalExadataInfrastructureExadataManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_exadata: Optional[pulumi.Input[bool]] = None,
            external_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
            license_model: Optional[pulumi.Input[str]] = None) -> 'ExternalExadataInfrastructureExadataManagement':
        """
        Get an existing ExternalExadataInfrastructureExadataManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_exadata: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[str] license_model: The Oracle license model.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalExadataInfrastructureExadataManagementState.__new__(_ExternalExadataInfrastructureExadataManagementState)

        __props__.__dict__["enable_exadata"] = enable_exadata
        __props__.__dict__["external_exadata_infrastructure_id"] = external_exadata_infrastructure_id
        __props__.__dict__["license_model"] = license_model
        return ExternalExadataInfrastructureExadataManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableExadata")
    def enable_exadata(self) -> pulumi.Output[bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_exadata")

    @property
    @pulumi.getter(name="externalExadataInfrastructureId")
    def external_exadata_infrastructure_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "external_exadata_infrastructure_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[str]:
        """
        The Oracle license model.
        """
        return pulumi.get(self, "license_model")

