# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRedisClustersResult',
    'AwaitableGetRedisClustersResult',
    'get_redis_clusters',
    'get_redis_clusters_output',
]

@pulumi.output_type
class GetRedisClustersResult:
    """
    A collection of values returned by getRedisClusters.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, redis_cluster_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if redis_cluster_collections and not isinstance(redis_cluster_collections, list):
            raise TypeError("Expected argument 'redis_cluster_collections' to be a list")
        pulumi.set(__self__, "redis_cluster_collections", redis_cluster_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the compartment that contains the cluster.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name of a cluster node.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRedisClustersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="redisClusterCollections")
    def redis_cluster_collections(self) -> Sequence['outputs.GetRedisClustersRedisClusterCollectionResult']:
        """
        The list of redis_cluster_collection.
        """
        return pulumi.get(self, "redis_cluster_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")


class AwaitableGetRedisClustersResult(GetRedisClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRedisClustersResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            redis_cluster_collections=self.redis_cluster_collections,
            state=self.state)


def get_redis_clusters(compartment_id: Optional[str] = None,
                       display_name: Optional[str] = None,
                       filters: Optional[Sequence[Union['GetRedisClustersFilterArgs', 'GetRedisClustersFilterArgsDict']]] = None,
                       id: Optional[str] = None,
                       state: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRedisClustersResult:
    """
    This data source provides the list of Redis Clusters in Oracle Cloud Infrastructure Redis service.

    Lists the Oracle Cloud Infrastructure Cache clusters in the specified compartment. A cluster is a memory-based storage solution. For more information, see [OCI Cache](https://docs.cloud.oracle.com/iaas/Content/ocicache/home.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_redis_clusters = oci.Redis.get_redis_clusters(compartment_id=compartment_id,
        display_name=redis_cluster_display_name,
        id=redis_cluster_id,
        state=redis_cluster_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Redis/getRedisClusters:getRedisClusters', __args__, opts=opts, typ=GetRedisClustersResult).value

    return AwaitableGetRedisClustersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        redis_cluster_collections=pulumi.get(__ret__, 'redis_cluster_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_redis_clusters_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                              display_name: Optional[pulumi.Input[Optional[str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRedisClustersFilterArgs', 'GetRedisClustersFilterArgsDict']]]]] = None,
                              id: Optional[pulumi.Input[Optional[str]]] = None,
                              state: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRedisClustersResult]:
    """
    This data source provides the list of Redis Clusters in Oracle Cloud Infrastructure Redis service.

    Lists the Oracle Cloud Infrastructure Cache clusters in the specified compartment. A cluster is a memory-based storage solution. For more information, see [OCI Cache](https://docs.cloud.oracle.com/iaas/Content/ocicache/home.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_redis_clusters = oci.Redis.get_redis_clusters(compartment_id=compartment_id,
        display_name=redis_cluster_display_name,
        id=redis_cluster_id,
        state=redis_cluster_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Redis/getRedisClusters:getRedisClusters', __args__, opts=opts, typ=GetRedisClustersResult)
    return __ret__.apply(lambda __response__: GetRedisClustersResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        redis_cluster_collections=pulumi.get(__response__, 'redis_cluster_collections'),
        state=pulumi.get(__response__, 'state')))
