# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecurityAttributeResult',
    'AwaitableGetSecurityAttributeResult',
    'get_security_attribute',
    'get_security_attribute_output',
]

@pulumi.output_type
class GetSecurityAttributeResult:
    """
    A collection of values returned by getSecurityAttribute.
    """
    def __init__(__self__, compartment_id=None, description=None, id=None, is_retired=None, name=None, security_attribute_name=None, security_attribute_namespace_id=None, security_attribute_namespace_name=None, state=None, time_created=None, type=None, validators=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_retired and not isinstance(is_retired, bool):
            raise TypeError("Expected argument 'is_retired' to be a bool")
        pulumi.set(__self__, "is_retired", is_retired)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if security_attribute_name and not isinstance(security_attribute_name, str):
            raise TypeError("Expected argument 'security_attribute_name' to be a str")
        pulumi.set(__self__, "security_attribute_name", security_attribute_name)
        if security_attribute_namespace_id and not isinstance(security_attribute_namespace_id, str):
            raise TypeError("Expected argument 'security_attribute_namespace_id' to be a str")
        pulumi.set(__self__, "security_attribute_namespace_id", security_attribute_namespace_id)
        if security_attribute_namespace_name and not isinstance(security_attribute_namespace_name, str):
            raise TypeError("Expected argument 'security_attribute_namespace_name' to be a str")
        pulumi.set(__self__, "security_attribute_namespace_name", security_attribute_namespace_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if validators and not isinstance(validators, list):
            raise TypeError("Expected argument 'validators' to be a list")
        pulumi.set(__self__, "validators", validators)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the security attribute definition.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description you assign to the security attribute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the security attribute definition.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isRetired")
    def is_retired(self) -> bool:
        """
        Indicates whether the security attribute is retired. See [Managing Security Attribute Namespaces](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/managing-security-attribute-namespaces.htm).
        """
        return pulumi.get(self, "is_retired")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name assigned to the security attribute during creation. This is the security attribute key. The name must be unique within the security attribute namespace and cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="securityAttributeName")
    def security_attribute_name(self) -> str:
        return pulumi.get(self, "security_attribute_name")

    @property
    @pulumi.getter(name="securityAttributeNamespaceId")
    def security_attribute_namespace_id(self) -> str:
        """
        The OCID of the security attribute namespace that contains the security attribute definition.
        """
        return pulumi.get(self, "security_attribute_namespace_id")

    @property
    @pulumi.getter(name="securityAttributeNamespaceName")
    def security_attribute_namespace_name(self) -> str:
        """
        The name of the security attribute namespace that contains the security attribute.
        """
        return pulumi.get(self, "security_attribute_namespace_name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The security attribute's current state. After creating a security attribute, make sure its `lifecycleState` is ACTIVE before using it. After retiring a security attribute, make sure its `lifecycleState` is INACTIVE before using it. If you delete a security attribute, you cannot delete another security attribute until the deleted security attribute's `lifecycleState` changes from DELETING to DELETED.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date and time the security attribute was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The data type of the security attribute.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def validators(self) -> Sequence['outputs.GetSecurityAttributeValidatorResult']:
        """
        Validates a security attribute value. Each validator performs validation steps in addition to the standard validation for security attribute values. For more information, see [Limits on Security Attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm).
        """
        return pulumi.get(self, "validators")


class AwaitableGetSecurityAttributeResult(GetSecurityAttributeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityAttributeResult(
            compartment_id=self.compartment_id,
            description=self.description,
            id=self.id,
            is_retired=self.is_retired,
            name=self.name,
            security_attribute_name=self.security_attribute_name,
            security_attribute_namespace_id=self.security_attribute_namespace_id,
            security_attribute_namespace_name=self.security_attribute_namespace_name,
            state=self.state,
            time_created=self.time_created,
            type=self.type,
            validators=self.validators)


def get_security_attribute(security_attribute_name: Optional[str] = None,
                           security_attribute_namespace_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityAttributeResult:
    """
    This data source provides details about a specific Security Attribute resource in Oracle Cloud Infrastructure Security Attribute service.

    Gets the specified security attribute's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_attribute = oci.SecurityAttribute.get_security_attribute(security_attribute_name=test_security_attribute_oci_security_attribute_security_attribute["name"],
        security_attribute_namespace_id=test_security_attribute_namespace["id"])
    ```


    :param str security_attribute_name: The name of the security attribute.
    :param str security_attribute_namespace_id: The OCID of the security attribute namespace.
    """
    __args__ = dict()
    __args__['securityAttributeName'] = security_attribute_name
    __args__['securityAttributeNamespaceId'] = security_attribute_namespace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:SecurityAttribute/getSecurityAttribute:getSecurityAttribute', __args__, opts=opts, typ=GetSecurityAttributeResult).value

    return AwaitableGetSecurityAttributeResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        is_retired=pulumi.get(__ret__, 'is_retired'),
        name=pulumi.get(__ret__, 'name'),
        security_attribute_name=pulumi.get(__ret__, 'security_attribute_name'),
        security_attribute_namespace_id=pulumi.get(__ret__, 'security_attribute_namespace_id'),
        security_attribute_namespace_name=pulumi.get(__ret__, 'security_attribute_namespace_name'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        type=pulumi.get(__ret__, 'type'),
        validators=pulumi.get(__ret__, 'validators'))
def get_security_attribute_output(security_attribute_name: Optional[pulumi.Input[str]] = None,
                                  security_attribute_namespace_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityAttributeResult]:
    """
    This data source provides details about a specific Security Attribute resource in Oracle Cloud Infrastructure Security Attribute service.

    Gets the specified security attribute's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_attribute = oci.SecurityAttribute.get_security_attribute(security_attribute_name=test_security_attribute_oci_security_attribute_security_attribute["name"],
        security_attribute_namespace_id=test_security_attribute_namespace["id"])
    ```


    :param str security_attribute_name: The name of the security attribute.
    :param str security_attribute_namespace_id: The OCID of the security attribute namespace.
    """
    __args__ = dict()
    __args__['securityAttributeName'] = security_attribute_name
    __args__['securityAttributeNamespaceId'] = security_attribute_namespace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:SecurityAttribute/getSecurityAttribute:getSecurityAttribute', __args__, opts=opts, typ=GetSecurityAttributeResult)
    return __ret__.apply(lambda __response__: GetSecurityAttributeResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        is_retired=pulumi.get(__response__, 'is_retired'),
        name=pulumi.get(__response__, 'name'),
        security_attribute_name=pulumi.get(__response__, 'security_attribute_name'),
        security_attribute_namespace_id=pulumi.get(__response__, 'security_attribute_namespace_id'),
        security_attribute_namespace_name=pulumi.get(__response__, 'security_attribute_namespace_name'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        type=pulumi.get(__response__, 'type'),
        validators=pulumi.get(__response__, 'validators')))
