# plone.api

[![Latest PyPI version](https://img.shields.io/pypi/v/plone.api.svg "Latest PyPI version")](https://pypi.python.org/pypi/plone.api/)


[![Number of PyPI downloads](https://img.shields.io/pypi/dm/plone.api.svg "Number of PyPI downloads")](https://pypi.python.org/pypi/plone.api/)

A simple API, built for humans wishing to develop with Plone.

The intention is

* to cover as much as possible the tasks carried out by a Plone developer
* to provide clear API methods for Plone functionality which may be confusing or difficult to access,
* keeping everything in one place,
* staying introspectable and discoverable, important aspects of being Pythonic.


## Documentation

[plone.api documentation](https://6.dev-docs.plone.org/plone.api/index.html) is part of the official Plone documentation.

`plone.api` comes with *cookbook*-like documentation and step-by-step instructions for doing common development tasks in Plone.
Recipes try to assume the user does not have extensive knowledge about Plone internals.


## Source Code and Contribution

[![Testing Status](https://github.com/plone/plone.api/actions/workflows/plone_python.yml/badge.svg "Testing Status")](https://github.com/plone/plone.api/actions/workflows/plone_python.yml)


Contributors
    Please read the document [Process for Plone core's development](https://docs.plone.org/develop/coredev/docs/index.html).
    Also consult the section about contribution in the [plone.api contributors documentation](https://docs.plone.org/develop/plone.api/docs/contribute/index.html).

Source Code
    at the [Plone code repository hosted at GitHub](https://github.com/plone/plone.api).

Issues
    Please use the [issue tracker](https://github.com/plone/plone.api/issues)

Continuous Integration
    tested on [GitHub Actions](https://github.com/plone/plone.api/actions).

Code Coverage
    is measured at [Coveralls.io](https://coveralls.io/github/plone/plone.api).

