#         Python Stream Deck Library
#      Released under the MIT license
#
#   dean [at] fourwalledcubicle [dot] com
#         www.fourwalledcubicle.com
#


class USBVendorIDs:
    """
    USB Vendor IDs for known StreamDeck devices.
    """

    USB_VID_ELGATO = 0x0fd9
    USB_VID_MIRABOX = 0x5548


class USBProductIDs:
    """
    USB Product IDs for known StreamDeck devices.
    """

    USB_PID_STREAMDECK_ORIGINAL = 0x0060
    USB_PID_STREAMDECK_ORIGINAL_V2 = 0x006d
    USB_PID_STREAMDECK_MK2_MODULE = 0x00b9
    USB_PID_STREAMDECK_MINI = 0x0063
    USB_PID_STREAMDECK_NEO = 0x009a
    USB_PID_STREAMDECK_XL = 0x006c
    USB_PID_STREAMDECK_XL_V2 = 0x008f
    USB_PID_STREAMDECK_XL_V2_MODULE = 0x00ba
    USB_PID_STREAMDECK_MK2 = 0x0080
    USB_PID_STREAMDECK_MK2_SCISSOR = 0x00a5
    USB_PID_STREAMDECK_PEDAL = 0x0086
    USB_PID_STREAMDECK_MINI_MK2 = 0x0090
    USB_PID_STREAMDECK_MINI_MK2_MODULE = 0x00b8
    USB_PID_STREAMDECK_PLUS = 0x0084
    USB_PID_MIRABOX_STREAMDOCK_293S = 0x6670
    
