"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportLogTasksSubmission = exports.ImportLogTasksSubmissionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cloudsiem_generated_1 = require("./cloudsiem.generated");
Object.defineProperty(exports, "ImportLogTasksSubmissionProperty", { enumerable: true, get: function () { return cloudsiem_generated_1.RosImportLogTasksSubmission; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::CloudSiem::ImportLogTasksSubmission`, which is used to import and submit a log collection task.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosImportLogTasksSubmission`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-cloudsiem-importlogtaskssubmission
 */
class ImportLogTasksSubmission extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosImportLogTasksSubmission = new cloudsiem_generated_1.RosImportLogTasksSubmission(this, id, {
            cloudCode: props.cloudCode,
            logCodes: props.logCodes,
            prodCode: props.prodCode,
            accounts: props.accounts,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosImportLogTasksSubmission;
    }
}
exports.ImportLogTasksSubmission = ImportLogTasksSubmission;
//# sourceMappingURL=data:application/json;base64,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