# Copyright (c) 2020-2025 by Fraunhofer Institute for Energy Economics
# and Energy System Technology (IEE), Kassel, and University of Kassel. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be found in the LICENSE file.

import numpy as np

from pandapipes.component_models.abstract_models.branch_wo_internals_models import \
    BranchWOInternalsComponent
from pandapipes.idx_branch import LENGTH, K, TEXT, ALPHA, D, AREA

try:
    import pandaplan.core.pplog as logging
except ImportError:
    import logging

logger = logging.getLogger(__name__)


class BranchWZeroLengthComponent(BranchWOInternalsComponent):
    """

    """

    @classmethod
    def table_name(cls):
        raise NotImplementedError

    @classmethod
    def get_component_input(cls):
        raise NotImplementedError

    @classmethod
    def get_result_table(cls, net):
        raise NotImplementedError

    @classmethod
    def active_identifier(cls):
        raise NotImplementedError

    @classmethod
    def from_to_node_cols(cls):
        raise NotImplementedError

    @classmethod
    def get_connected_node_type(cls):
        raise NotImplementedError

    @classmethod
    def create_pit_branch_entries(cls, net, branch_pit):
        """
        Function which creates pit branch entries with a specific table.

        :param net: The pandapipes network
        :type net: pandapipesNet
        :param branch_pit:
        :type branch_pit:
        :return: No Output.
        """
        branch_wzerolength_pit = \
            super().create_pit_branch_entries(net, branch_pit)
        branch_wzerolength_pit[:, LENGTH] = 0
        branch_wzerolength_pit[:, K] = 1000
        branch_wzerolength_pit[:, TEXT] = 293.15
        branch_wzerolength_pit[:, ALPHA] = 0
        branch_wzerolength_pit[:, D] = 0.1
        branch_wzerolength_pit[:, AREA] = branch_wzerolength_pit[:, D] ** 2 * np.pi / 4
        return branch_wzerolength_pit

    @classmethod
    def extract_results(cls, net, options, branch_results, mode):
        raise NotImplementedError

    @classmethod
    def calculate_temperature_lift(cls, net, branch_component_pit, node_pit):
        raise NotImplementedError
