# Copyright (c) 2020-2025 by Fraunhofer Institute for Energy Economics
# and Energy System Technology (IEE), Kassel, and University of Kassel. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be found in the LICENSE file.

# physical constants
GRAVITATION_CONSTANT = 9.81  # earth acceleration constant in m/s²
NORMAL_TEMPERATURE = 273.15  # normal temperature (= 0°C) in K
NORMAL_PRESSURE = 1.01325  # pressure under normal conditions (at sea level) in bar
MOLAR_MASS_AIR = 0.02896  # molar mass of air in m³/mol
R_UNIVERSAL = 8.314  # universal gas constant (molar) in J/(mol * K)

# specific constants
HEIGHT_EXPONENT = 5.255  # exponent for height correction (typical value of international equation)
TEMP_GRADIENT_KPM = 0.0065  # temperature gradient for moist air in K / m
AVG_TEMPERATURE_K = 288.15  # average global temperature at sea level

# calculation constants
P_CONVERSION = 1e5  # factor for conversion between Pa and bar --> relation between v and p
