/* Copyright 2023 The StableHLO Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#ifndef STABLEHLO_EXPERIMENTAL_TRANSFORMS_PASSES_H
#define STABLEHLO_EXPERIMENTAL_TRANSFORMS_PASSES_H

#include <memory>

#include "mlir/Pass/Pass.h"
#include "mlir/Transforms/DialectConversion.h"

namespace mlir {
namespace stablehlo {
namespace experimental {

#define GEN_PASS_DECL
#define GEN_PASS_REGISTRATION
#include "stablehlo/experimental/transforms/Passes.h.inc"

void createChloLegalizeToStablehloPipeline(OpPassManager &pm);

}  // namespace experimental
}  // namespace stablehlo
}  // namespace mlir

#endif  // STABLEHLO_EXPERIMENTAL_TRANSFORMS_PASSES_H
