from langchain_ollama import ChatOllama, OllamaLLM
from langchain_core.messages import AIMessage, ToolMessage, HumanMessage
from pydantic import BaseModel as PydanticModel, Field

from .base import BaseArchytasModel, EnvironmentAuth, ModelConfig



class OllamaModel(BaseArchytasModel):
    DEFAULT_MODEL = "llama3"

    MODEL_PROMPT_INSTRUCTIONS = """
If you receieve a message with a role of `tool` in response to a tool being called, the user has not seen the content
of that message. Those messages are generated by the system and sent to you for review as part of the ReAct loop. Please
treat such messages as a response from a third party that provide more information for you to use to help achieve the
user's task.
Be sure to always use the `final_answer` tool to report back to the user.
"""

    def auth(self, **kwargs) -> None:
        return

    def initialize_model(self, **kwargs):
        # Dummy tool in required to enable "tool mode" on the model
        return ChatOllama(model=self.config.model_name or self.DEFAULT_MODEL)
