import json


class ThreeDSResult(object):
    def __init__(self):
        self.__three_ds_version = None
        self.__eci = None
        self.__cavv = None
        self.__ds_transaction_id = None
        self.__xid = None
        self.__three_ds_transaction_status_reason = None
        self.__challenge_cancel = None
        self.__challenged = None
        self.__exemption_type = None

    @property
    def three_ds_version(self):
        return self.__three_ds_version

    @three_ds_version.setter
    def three_ds_version(self, value):
        self.__three_ds_version = value

    @property
    def eci(self):
        return self.__eci

    @eci.setter
    def eci(self, value):
        self.__eci = value

    @property
    def cavv(self):
        return self.__cavv

    @cavv.setter
    def cavv(self, value):
        self.__cavv = value

    @property
    def ds_transaction_id(self):
        return self.__ds_transaction_id

    @ds_transaction_id.setter
    def ds_transaction_id(self, value):
        self.__ds_transaction_id = value

    @property
    def xid(self):
        return self.__xid

    @xid.setter
    def xid(self, value):
        self.__xid = value

    @property
    def three_ds_transaction_status_reason(self):
        return self.__three_ds_transaction_status_reason

    @three_ds_transaction_status_reason.setter
    def three_ds_transaction_status_reason(self, value):
        self.__three_ds_transaction_status_reason = value

    @property
    def challenge_cancel(self):
        return self.__challenge_cancel


    @challenge_cancel.setter
    def challenge_cancel(self, value):
        self.__challenge_cancel = value


    @property
    def challenged(self):
        return self.__challenged

    @challenged.setter
    def challenged(self, value):
        self.__challenged = value


    @property
    def exemption_type(self):
        return self.__exemption_type

    @exemption_type.setter
    def exemption_type(self, value):
        self.__exemption_type = value

    def to_ams_dict(self):
        param = dict()
        if hasattr(self, 'three_ds_version') and self.three_ds_version:
            param['threeDSVersion'] = self.three_ds_version
        if hasattr(self, 'eci') and self.eci:
            param['eci'] = self.eci
        if hasattr(self, 'cavv') and self.cavv:
            param['cavv'] = self.cavv
        if hasattr(self, 'ds_transaction_id') and self.ds_transaction_id:
            param['dsTransactionId'] = self.ds_transaction_id
        if hasattr(self, 'xid') and self.xid:
            param['xid'] = self.xid
        if hasattr(self, 'three_ds_transaction_status_reason') and self.three_ds_transaction_status_reason:
            param['threeDSTransactionStatusReason'] = self.three_ds_transaction_status_reason
        if hasattr(self, 'challenge_cancel') and self.challenge_cancel:
            param['challengeCancel'] = self.challenge_cancel
        if hasattr(self, 'challenged') and self.challenged:
            param['challenged'] = self.challenged

        if hasattr(self, 'exemption_type') and self.exemption_type:
            param['exemptionType'] = self.exemption_type

        return param

    def parse_rsp_body(self, three_dS_result_body):
        if type(three_dS_result_body) == str:
            three_dS_result_body = json.loads(three_dS_result_body)
        if 'threeDSVersion' in three_dS_result_body:
            self.three_ds_version = three_dS_result_body['threeDSVersion']
        if 'eci' in three_dS_result_body:
            self.eci = three_dS_result_body['eci']
        if 'cavv' in three_dS_result_body:
            self.cavv = three_dS_result_body['cavv']
        if 'dsTransactionId' in three_dS_result_body:
            self.ds_transaction_id = three_dS_result_body['dsTransactionId']
        if 'xid' in three_dS_result_body:
            self.xid = three_dS_result_body['xid']
        if 'threeDSTransactionStatusReason' in three_dS_result_body:
            self.three_ds_transaction_status_reason = three_dS_result_body['threeDSTransactionStatusReason']
        if 'challengeCancel' in three_dS_result_body:
            self.challenge_cancel = three_dS_result_body['challengeCancel']

        if 'challenged' in three_dS_result_body:
            self.challenged = three_dS_result_body['challenged']

        if 'exemptionType' in three_dS_result_body:
            self.exemption_type = three_dS_result_body['exemptionType']
