#  Copyright (C) 2020 <Florian Alu - Prolibre - https://prolibre.com
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Affero General Public License as
#  published by the Free Software Foundation, either version 3 of the
#  License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Affero General Public License for more details.
#
#  You should have received a copy of the GNU Affero General Public License
#  along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

# Generated by Django 2.0.4 on 2018-10-16 09:19

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Absence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_date', models.DateField(verbose_name='Start date')),
                ('end_date', models.DateField(verbose_name='End date')),
            ],
        ),
        migrations.CreateModel(
            name='AbsenceType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reason', models.CharField(max_length=255, verbose_name='Reason')),
            ],
            options={
                'verbose_name': 'Absence type',
                'verbose_name_plural': 'Absences type',
            },
        ),
        migrations.CreateModel(
            name='Qualification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.TextField(verbose_name='Nom')),
                ('short_name', models.CharField(max_length=255, verbose_name='Short name')),
                ('order', models.IntegerField(default=1, verbose_name='Ordre')),
            ],
            options={
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='Staff',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('last_name', models.CharField(max_length=255, verbose_name='Last name')),
                ('first_name', models.CharField(max_length=255, verbose_name='First name')),
                ('gender', models.SmallIntegerField(choices=[(0, 'Man'), (1, 'Woman'), (2, 'Other')], null=True, verbose_name='Gender')),
                ('birthday_date', models.DateField(blank=True, null=True, verbose_name='Birthday Date')),
                ('street', models.CharField(blank=True, max_length=255, null=True, verbose_name='Street')),
                ('zip', models.PositiveIntegerField(blank=True, null=True, verbose_name='ZIP')),
                ('city', models.CharField(blank=True, max_length=50, null=True, verbose_name='City')),
                ('phone', models.CharField(blank=True, max_length=50, null=True, verbose_name='Phone')),
                ('mobile_phone', models.CharField(blank=True, max_length=50, null=True, verbose_name='Mobile phone')),
                ('avs', models.CharField(blank=True, max_length=16, null=True, verbose_name='AVS')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='Courriel')),
                ('percentage_work', models.FloatField(default=0, verbose_name='Percentage of work')),
                ('working_time', models.FloatField(verbose_name='Working time')),
                ('active', models.BooleanField(default=True, verbose_name='active')),
                ('arrival_date', models.DateField(null=True, verbose_name='Arrival date')),
                ('departure_date', models.DateField(blank=True, null=True, verbose_name='Departure Date')),
                ('qualification', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_staff.Qualification', verbose_name='Qualification')),
                ('user', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='utilisateur')),
            ],
            options={
                'verbose_name': 'Staff',
                'verbose_name_plural': 'Staffs',
                'ordering': ['first_name', 'last_name'],
                'permissions': (('can_read_list', 'Can read list'),),
            },
        ),
        migrations.CreateModel(
            name='Team',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Nom')),
                ('slug', models.SlugField(max_length=150, unique=True, verbose_name='Slug')),
            ],
        ),
        migrations.AddField(
            model_name='absence',
            name='abs_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_staff.AbsenceType', verbose_name='Absence type'),
        ),
        migrations.AddField(
            model_name='absence',
            name='staff',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='staff', to='nobinobi_staff.Staff', verbose_name='Staff'),
        ),
    ]
