#  Copyright (C) 2020 <Florian Alu - Prolibre - https://prolibre.com
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Affero General Public License as
#  published by the Free Software Foundation, either version 3 of the
#  License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Affero General Public License for more details.
#
#  You should have received a copy of the GNU Affero General Public License
#  along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

# Generated by Django 2.0.9 on 2018-10-19 08:17

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import model_utils.fields
import nobinobi_staff.models


class Migration(migrations.Migration):

    dependencies = [
        ('nobinobi_staff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AbsenceAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', model_utils.fields.StatusField(choices=[('medical', 'Medical certificate'), ('work', 'Work Certificate')], default='medical', max_length=100, no_check_for_status=True, verbose_name='Type')),
                ('file', models.FileField(blank=True, null=True, upload_to=nobinobi_staff.models.AbsenceAttachment.generate_new_filename, verbose_name='File')),
            ],
        ),
        migrations.AlterModelOptions(
            name='staff',
            options={'ordering': ['first_name', 'last_name'], 'permissions': (('can_read_list', 'Can read list'),), 'verbose_name': 'Staff', 'verbose_name_plural': 'Staffes'},
        ),
        migrations.AddField(
            model_name='absence',
            name='all_day',
            field=models.BooleanField(default=False, verbose_name='All day'),
        ),
        migrations.AddField(
            model_name='absence',
            name='comment',
            field=models.TextField(blank=True, null=True, verbose_name='Comment'),
        ),
        migrations.AlterField(
            model_name='absence',
            name='end_date',
            field=models.DateTimeField(verbose_name='End date'),
        ),
        migrations.AlterField(
            model_name='absence',
            name='start_date',
            field=models.DateTimeField(verbose_name='Start date'),
        ),
        migrations.AlterField(
            model_name='qualification',
            name='name',
            field=models.TextField(verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='qualification',
            name='order',
            field=models.IntegerField(default=1, verbose_name='Order'),
        ),
        migrations.AlterField(
            model_name='staff',
            name='active',
            field=models.BooleanField(default=True, verbose_name='Active'),
        ),
        migrations.AlterField(
            model_name='staff',
            name='email',
            field=models.EmailField(blank=True, max_length=254, null=True, verbose_name='Email'),
        ),
        migrations.AlterField(
            model_name='staff',
            name='user',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='user'),
        ),
        migrations.AlterField(
            model_name='team',
            name='name',
            field=models.CharField(max_length=100, verbose_name='Name'),
        ),
        migrations.AddField(
            model_name='absenceattachment',
            name='absence',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_staff.Absence', verbose_name='Absence'),
        ),
    ]
