#  Copyright (C) 2020 <Florian Alu - Prolibre - https://prolibre.com
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Affero General Public License as
#  published by the Free Software Foundation, either version 3 of the
#  License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Affero General Public License for more details.
#
#  You should have received a copy of the GNU Affero General Public License
#  along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

# Generated by Django 2.0.13 on 2020-02-21 10:38

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import nobinobi_staff.models


class Migration(migrations.Migration):

    dependencies = [
        ('nobinobi_staff', '0006_staff_working_base'),
    ]

    operations = [
        migrations.CreateModel(
            name='RightTraining',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('number_days', models.IntegerField(help_text='Number of days of training entitlement based on a 100% activity rate.', verbose_name='Number of days')),
                ('start_day', models.IntegerField(choices=[(0, 0), (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7), (8, 8), (9, 9), (10, 10), (11, 11), (12, 12), (13, 13), (14, 14), (15, 15), (16, 16), (17, 17), (18, 18), (19, 19), (20, 20), (21, 21), (22, 22), (23, 23), (24, 24), (25, 25), (26, 26), (27, 27), (28, 28), (29, 29), (30, 30)], verbose_name='Start day')),
                ('start_month', models.IntegerField(choices=[(1, 'January'), (2, 'February'), (3, 'Mars'), (4, 'April'), (5, 'May'), (6, 'June'), (7, 'July'), (8, 'August'), (9, 'September'), (10, 'October'), (11, 'November'), (12, 'December')], verbose_name='Start month')),
            ],
            options={
                'verbose_name': 'Right to training',
            },
        ),
        migrations.CreateModel(
            name='Training',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('default_number_days', models.FloatField(default=0.0, verbose_name='Default number of days')),
                ('number_days', models.FloatField(default=0.0, verbose_name='Number of days')),
                ('start_date', models.DateField(editable=False, verbose_name='Start date')),
                ('end_date', models.DateField(editable=False, verbose_name='Start date')),
            ],
            options={
                'verbose_name': 'Training',
                'ordering': ('start_date', 'end_date'),
            },
        ),
        migrations.AddField(
            model_name='training',
            name='staff',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='nobinobi_staff.Staff', verbose_name='Staff'),
        ),
        migrations.AlterUniqueTogether(
            name='training',
            unique_together={('start_date', 'end_date', 'staff')},
        ),
    ]
