class TonTokens:
    mapping = {
        "b113a994b5024a16719f69139328eb759596c38a25f59028b146fecdc3621dfe": {
          "address": "EQCxE6mUtQJKFnGfaROTKOt1lZbDiiX1kCixRv7Nw2Id_sDs",
          "decodedAddress": "b113a994b5024a16719f69139328eb759596c38a25f59028b146fecdc3621dfe",
          "decimals": 6,
          "name": "Tether",
          "symbol": "usdt"
        },
        "0000000000000000000000000000000000000000000000000000000000000000": {
          "address": "EQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAM9c",
          "decodedAddress": "0000000000000000000000000000000000000000000000000000000000000000",
          "decimals": 9,
          "name": "Toncoin",
          "symbol": "ton"
        },
        "2f956143c461769579baef2e32cc2d7bc18283f40d20bb03e432cd603ac33ffc": {
          "address": "EQAvlWFDxGF2lXm67y4yzC17wYKD9A0guwPkMs1gOsM__NOT",
          "decodedAddress": "2f956143c461769579baef2e32cc2d7bc18283f40d20bb03e432cd603ac33ffc",
          "decimals": 9,
          "name": "Notcoin",
          "symbol": "not"
        },
        "afc49cb8786f21c87045b19ede78fc6b46c51048513f8e9a6d44060199c1bf0c": {
          "address": "EQCvxJy4eG8hyHBFsZ7eePxrRsUQSFE_jpptRAYBmcG_DOGS",
          "decodedAddress": "afc49cb8786f21c87045b19ede78fc6b46c51048513f8e9a6d44060199c1bf0c",
          "decimals": 9,
          "name": "Dogs",
          "symbol": "dogs"
        },
        "f495a8a4d0580757c68d7d185e6e2f060c6daba43c8a1977a6d0c05fc9afc4c3": {
          "address": "EQD0laik0FgHV8aNfRhebi8GDG2rpDyKGXem0MBfya_Ew1-8",
          "decodedAddress": "f495a8a4d0580757c68d7d185e6e2f060c6daba43c8a1977a6d0c05fc9afc4c3",
          "decimals": 18,
          "name": "Gomining Token",
          "symbol": "gomining"
        },
        "59fdc69f3f20ebe4a513b3468dc61d194c3864a4464e3662c903648d1a52e6e0": {
          "address": "EQBZ_cafPyDr5KUTs0aNxh0ZTDhkpEZONmLJA2SNGlLm4Cko",
          "decodedAddress": "59fdc69f3f20ebe4a513b3468dc61d194c3864a4464e3662c903648d1a52e6e0",
          "decimals": 9,
          "name": "Resistance Dog",
          "symbol": "redo"
        },
        "9da73e90849b43b66dacf7e92b576ca0978e4fc25f8a249095d7e5eb3fe5eebb": {
          "address": "EQCdpz6QhJtDtm2s9-krV2ygl45Pwl-KJJCV1-XrP-Xuuxoq",
          "decodedAddress": "9da73e90849b43b66dacf7e92b576ca0978e4fc25f8a249095d7e5eb3fe5eebb",
          "decimals": 9,
          "name": "PunkCity",
          "symbol": "punk"
        },
        "aa9e166774119bc233e957c2bff1638ae7c66440f5e54bf6ec85abbd0ca5a700": {
          "address": "EQCqnhZndBGbwjPpV8K_8WOK58ZkQPXlS_bshau9DKWnAF-p",
          "decodedAddress": "aa9e166774119bc233e957c2bff1638ae7c66440f5e54bf6ec85abbd0ca5a700",
          "decimals": 16,
          "name": "GAMEE",
          "symbol": "gmee"
        },
        "2ec34d649712fca8a7bd7018a84df8ecb7477a19d6a0839d7f73bdf3f17dbecc": {
          "address": "EQAuw01klxL8qKe9cBioTfjst0d6Gdagg51_c73z8X2-zJmj",
          "decodedAddress": "2ec34d649712fca8a7bd7018a84df8ecb7477a19d6a0839d7f73bdf3f17dbecc",
          "decimals": 9,
          "name": "HyperGPT",
          "symbol": "hgpt"
        },
        "3690254dc15b2297610cda60744a45f2b710aa4234b89adb630e99d79b01bd4f": {
          "address": "EQA2kCVNwVsil2EM2mB0SkXytxCqQjS4mttjDpnXmwG9T6bO",
          "decodedAddress": "3690254dc15b2297610cda60744a45f2b710aa4234b89adb630e99d79b01bd4f",
          "decimals": 9,
          "name": "STON",
          "symbol": "ston"
        },
        "1371473af6c19208231269db1550a746c0cd4130a4be1ca09618f93ad3164683": {
          "address": "EQATcUc69sGSCCMSadsVUKdGwM1BMKS-HKCWGPk60xZGgwsK",
          "decodedAddress": "1371473af6c19208231269db1550a746c0cd4130a4be1ca09618f93ad3164683",
          "decimals": 9,
          "name": "TON FISH MEMECOIN",
          "symbol": "fish"
        },
        "6d0e662008a93779c435c7e8f408b6519cf632695edc077dda774dfa40df8713": {
          "address": "EQBtDmYgCKk3ecQ1x-j0CLZRnPYyaV7cB33ad036QN-HE2C7",
          "decodedAddress": "6d0e662008a93779c435c7e8f408b6519cf632695edc077dda774dfa40df8713",
          "decimals": 9,
          "name": "Ton Cat",
          "symbol": "tcat"
        },
        "74d8327471d503e2240345b06fe1a606de1b5e3c70512b5b46791b429dab5eb1": {
          "address": "EQB02DJ0cdUD4iQDRbBv4aYG3htePHBRK1tGeRtCnatescK0",
          "decodedAddress": "74d8327471d503e2240345b06fe1a606de1b5e3c70512b5b46791b429dab5eb1",
          "decimals": 9,
          "name": "Povel Durev",
          "symbol": "durev"
        },
        "105e5589bc66db15f13c177a12f2cf3b94881da2f4b8e7922c58569176625eb5": {
          "address": "EQAQXlWJvGbbFfE8F3oS8s87lIgdovS455IsWFaRdmJetTon",
          "decodedAddress": "105e5589bc66db15f13c177a12f2cf3b94881da2f4b8e7922c58569176625eb5",
          "decimals": 9,
          "name": "JetTon Games",
          "symbol": "jetton"
        },
        "b8ed87d52d6a3e53fcfbb3a8843a4600004285fc2d3e801881f0a24beace66e0": {
          "address": "EQC47YfVLWo-U_z7s6iEOkYAAEKF_C0-gBiB8KJL6s5m4JOP",
          "decodedAddress": "b8ed87d52d6a3e53fcfbb3a8843a4600004285fc2d3e801881f0a24beace66e0",
          "decimals": 18,
          "name": "Tower",
          "symbol": "tower"
        },
        "701cebdfdd4acf3c907b8de0c768e4fedaf3f4410943a040c1b207efe5717be4": {
          "address": "EQBwHOvf3UrPPJB7jeDHaOT-2vP0QQlDoEDBsgfv5XF75J3j",
          "decodedAddress": "701cebdfdd4acf3c907b8de0c768e4fedaf3f4410943a040c1b207efe5717be4",
          "decimals": 9,
          "name": "The Resistance Cat",
          "symbol": "$reca"
        },
        "022d70f08add35b2d8aa2bd16f622268d7996e5737c3e7353cbb00d2aba257c5": {
          "address": "EQACLXDwit01stiqK9FvYiJo15luVzfD5zU8uwDSq6JXxbP8",
          "decodedAddress": "022d70f08add35b2d8aa2bd16f622268d7996e5737c3e7353cbb00d2aba257c5",
          "decimals": 8,
          "name": "Spintria",
          "symbol": "sp"
        },
        "70cbec09fb00aa87499f247a168e6ba5274a0844a10926def950bcab24d3dc9e": {
          "address": "EQBwy-wJ-wCqh0mfJHoWjmulJ0oIRKEJJt75ULyrJNPcnn5z",
          "decodedAddress": "70cbec09fb00aa87499f247a168e6ba5274a0844a10926def950bcab24d3dc9e",
          "decimals": 9,
          "name": "Mittens",
          "symbol": "mittens"
        },
        "54ca11d89a16a7100decea415573ebca4f22f055f51f9da8d5d04a6d3cc4ffd4": {
          "address": "EQBUyhHYmhanEA3s6kFVc-vKTyLwVfUfnajV0EptPMT_1H_6",
          "decodedAddress": "54ca11d89a16a7100decea415573ebca4f22f055f51f9da8d5d04a6d3cc4ffd4",
          "decimals": 9,
          "name": "Troop",
          "symbol": "troop"
        },
        "5febe62847dc7296897f3708c7acb92b4c50192425fe6ec77e5f1ffdd3639a3d": {
          "address": "EQBf6-YoR9xylol_NwjHrLkrTFAZJCX-bsd-Xx_902OaPaBf",
          "decodedAddress": "5febe62847dc7296897f3708c7acb92b4c50192425fe6ec77e5f1ffdd3639a3d",
          "decimals": 9,
          "name": "Megaton Finance",
          "symbol": "mega"
        },
        "9c61458a8631b1c2ab64fe37bd2d6d95e11a0599b84e511f5ee34e18e8541311": {
          "address": "EQCcYUWKhjGxwqtk_je9LW2V4RoFmbhOUR9e404Y6FQTEXHh",
          "decodedAddress": "9c61458a8631b1c2ab64fe37bd2d6d95e11a0599b84e511f5ee34e18e8541311",
          "decimals": 9,
          "name": "Resistance Girl",
          "symbol": "regi"
        },
        "30eb766a2e69f0440efb3d6d3b0962049e0c20f9e222cac6aa67c216a542f49c": {
          "address": "EQAw63ZqLmnwRA77PW07CWIEngwg-eIiysaqZ8IWpUL0nP7a",
          "decodedAddress": "30eb766a2e69f0440efb3d6d3b0962049e0c20f9e222cac6aa67c216a542f49c",
          "decimals": 9,
          "name": "UTYABSWAP",
          "symbol": "utyab"
        },
        "7880f7c6d18b688891c231352ecf13fd7ca5f2f67c7a4c587e75c025b6b9cda4": {
          "address": "EQB4gPfG0YtoiJHCMTUuzxP9fKXy9nx6TFh-dcAltrnNpLNo",
          "decodedAddress": "7880f7c6d18b688891c231352ecf13fd7ca5f2f67c7a4c587e75c025b6b9cda4",
          "decimals": 9,
          "name": "Shitcoin on TON",
          "symbol": "shit"
        },
        "3a43774c81511f5d0f6d3412f67cc96312123f6b343e477bef3e08c6397c2817": {
          "address": "EQA6Q3dMgVEfXQ9tNBL2fMljEhI_azQ-R3vvPgjGOXwoF7kt",
          "decodedAddress": "3a43774c81511f5d0f6d3412f67cc96312123f6b343e477bef3e08c6397c2817",
          "decimals": 9,
          "name": "Ton Inu",
          "symbol": "tinu"
        },
        "eacfb2d3c208f4d7a9224e24a8a0cfdfb7c92f78bd8fe298f87e4266b1457f6a": {
          "address": "EQDqz7LTwgj016kiTiSooM_ft8kveL2P4pj4fkJmsUV_an_X",
          "decodedAddress": "eacfb2d3c208f4d7a9224e24a8a0cfdfb7c92f78bd8fe298f87e4266b1457f6a",
          "decimals": 9,
          "name": "Kakaxa",
          "symbol": "kakaxa"
        },
        "2e728e5910f801d7d7d24e8ec49ad2d3272b2b2b16eee8cfd73850f059088d8c": {
          "address": "EQAuco5ZEPgB19fSTo7EmtLTJysrKxbu6M_XOFDwWQiNjCsQ",
          "decodedAddress": "2e728e5910f801d7d7d24e8ec49ad2d3272b2b2b16eee8cfd73850f059088d8c",
          "decimals": 9,
          "name": "DOGWIFHOOD",
          "symbol": "wif"
        },
        "2b8f97e11dc3f3fa58e430135c76e42188ef16978266157ffd6bedb90df50c42": {
          "address": "EQArj5fhHcPz-ljkMBNcduQhiO8Wl4JmFX_9a-25DfUMQhxK",
          "decodedAddress": "2b8f97e11dc3f3fa58e430135c76e42188ef16978266157ffd6bedb90df50c42",
          "decimals": 9,
          "name": "INVITE Token",
          "symbol": "invite"
        },
        "5e720dc4ebcdb633569939986accc59a49118fef5dac0d19108073b831280344": {
          "address": "EQBecg3E6822M1aZOZhqzMWaSRGP712sDRkQgHO4MSgDRDHq",
          "decodedAddress": "5e720dc4ebcdb633569939986accc59a49118fef5dac0d19108073b831280344",
          "decimals": 9,
          "name": "INSECT",
          "symbol": "ins"
        },
        "cd2736cd280f08c765fb4efd7f8f1742a9e84f42025a35b8aca08912ab9b2b9d": {
          "address": "EQDNJzbNKA8Ix2X7Tv1_jxdCqehPQgJaNbisoIkSq5srnfLs",
          "decodedAddress": "cd2736cd280f08c765fb4efd7f8f1742a9e84f42025a35b8aca08912ab9b2b9d",
          "decimals": 9,
          "name": "Burncoin",
          "symbol": "burn"
        },
        "11ecbe27b6e054318d0a600029b2a44b0f909e3df63482d335e25ea138bbe778": {
          "address": "EQAR7L4ntuBUMY0KYAApsqRLD5CePfY0gtM14l6hOLvneBel",
          "decodedAddress": "11ecbe27b6e054318d0a600029b2a44b0f909e3df63482d335e25ea138bbe778",
          "decimals": 9,
          "name": "TOGE",
          "symbol": "toge"
        },
        "358ef3ea471e9bba36288439f2e378705fc159af76fa3989c8dedda31dde135d": {
          "address": "EQA1jvPqRx6bujYohDny43hwX8FZr3b6OYnI3t2jHd4TXSJs",
          "decodedAddress": "358ef3ea471e9bba36288439f2e378705fc159af76fa3989c8dedda31dde135d",
          "decimals": 9,
          "name": "Ton Ship",
          "symbol": "ship"
        },
        "fe27a52a6107b3b949ba4a53c39c7c13c57aa8e2e1f2b3f7e57bfccabcce6760": {
          "address": "EQD-J6UqYQezuUm6SlPDnHwTxXqo4uHys_fle_zKvM5nYJkA",
          "decodedAddress": "fe27a52a6107b3b949ba4a53c39c7c13c57aa8e2e1f2b3f7e57bfccabcce6760",
          "decimals": 8,
          "name": "BlackHat Coin",
          "symbol": "blkc"
        },
        "b6c07d48f4c550096bd508d7c0f3937f4c5ded488e740c4139f7b40d74eebaad": {
          "address": "EQC2wH1I9MVQCWvVCNfA85N_TF3tSI50DEE597QNdO66rclf",
          "decodedAddress": "b6c07d48f4c550096bd508d7c0f3937f4c5ded488e740c4139f7b40d74eebaad",
          "decimals": 9,
          "name": "BROKIE ON TON",
          "symbol": "broton"
        },
        "49389d9e2ff094153ff4afd99ea2a8ca53046db42ffe354272bd6431b335567b": {
          "address": "EQBJOJ2eL_CUFT_0r9meoqjKUwRttC_-NUJyvWQxszVWe1WY",
          "decodedAddress": "49389d9e2ff094153ff4afd99ea2a8ca53046db42ffe354272bd6431b335567b",
          "decimals": 9,
          "name": "Petcoin",
          "symbol": "pet"
        },
        "bbae71c7b4c5412b28621a701bb58225cc6c52d1d7e2dd96c7131157d0b622f5": {
          "address": "EQC7rnHHtMVBKyhiGnAbtYIlzGxS0dfi3ZbHExFX0LYi9cAH",
          "decodedAddress": "bbae71c7b4c5412b28621a701bb58225cc6c52d1d7e2dd96c7131157d0b622f5",
          "decimals": 9,
          "name": "1RUS BTC25",
          "symbol": "@btc25"
        },
        "53d847b82f1e70f6e23ba0c972e6ea5736cdc00562ff170935ba233be2064219": {
          "address": "EQBT2Ee4Lx5w9uI7oMly5upXNs3ABWL_Fwk1uiM74gZCGaYt",
          "decodedAddress": "53d847b82f1e70f6e23ba0c972e6ea5736cdc00562ff170935ba233be2064219",
          "decimals": 9,
          "name": "1RUS DAO",
          "symbol": "1rusd"
        },
        "0e2ce27d8e14b5466cc44306b209c0fff20959848de6ee534e7e83535213f84d": {
          "address": "EQAOLOJ9jhS1RmzEQwayCcD_8glZhI3m7lNOfoNTUhP4Ta8n",
          "decodedAddress": "0e2ce27d8e14b5466cc44306b209c0fff20959848de6ee534e7e83535213f84d",
          "decimals": 9,
          "name": "adDICted",
          "symbol": "dic"
        },
        "fa8a4bd23d472913a1c1fce8f108c564170aed2bbdc2555d552d1e8d584ca4a2": {
          "address": "EQD6ikvSPUcpE6HB_OjxCMVkFwrtK73CVV1VLR6NWEykojuQ",
          "decodedAddress": "fa8a4bd23d472913a1c1fce8f108c564170aed2bbdc2555d552d1e8d584ca4a2",
          "decimals": 9,
          "name": "Akita Inu",
          "symbol": "akita"
        },
        "9c2c05b9dfb2a7460fda48fae7409a32623399933a98a7a15599152f37572b49": {
          "address": "EQCcLAW537KnRg_aSPrnQJoyYjOZkzqYp6FVmRUvN1crSazV",
          "decodedAddress": "9c2c05b9dfb2a7460fda48fae7409a32623399933a98a7a15599152f37572b49",
          "decimals": 9,
          "name": "Ambra",
          "symbol": "ambr"
        },
        "effb2af8d7f099daeae0da07de8157dae383c33e320af45f8c8a510328350886": {
          "address": "EQDv-yr41_CZ2urg2gfegVfa44PDPjIK9F-MilEDKDUIhlwZ",
          "decodedAddress": "effb2af8d7f099daeae0da07de8157dae383c33e320af45f8c8a510328350886",
          "decimals": 9,
          "name": "ANON",
          "symbol": "anon"
        },
        "0cd8a583a7d94dd18bf1bdf49b234af28c15f033bd2b6a4a4d2076ee1136ad45": {
          "address": "EQAM2KWDp9lN0YvxvfSbI0ryjBXwM70rakpNIHbuETatRWA1",
          "decodedAddress": "0cd8a583a7d94dd18bf1bdf49b234af28c15f033bd2b6a4a4d2076ee1136ad45",
          "decimals": 9,
          "name": "ARBUZ",
          "symbol": "arbuz"
        },
        "11f8a05dbb02f8c3e2e0ef64055f8b564ce0090864bbd859061eb24bf50b7b3f": {
          "address": "EQAR-KBduwL4w-Lg72QFX4tWTOAJCGS72FkGHrJL9Qt7P9ln",
          "decodedAddress": "11f8a05dbb02f8c3e2e0ef64055f8b564ce0090864bbd859061eb24bf50b7b3f",
          "decimals": 9,
          "name": "AVACOIN",
          "symbol": "avacn"
        },
        "6dbfb237a59a4c0140a179fd95ae4f94d46702134d2b44eb8780c27d0af8e875": {
          "address": "EQBtv7I3pZpMAUChef2Vrk-U1GcCE00rROuHgMJ9CvjodRZW",
          "decodedAddress": "6dbfb237a59a4c0140a179fd95ae4f94d46702134d2b44eb8780c27d0af8e875",
          "decimals": 9,
          "name": "Bearcoin",
          "symbol": "bear"
        },
        "cd872fa7c5816052acdf5332260443faec9aacc8c21cca4d92e7f47034d11892": {
          "address": "EQDNhy-nxYFgUqzfUzImBEP67JqsyMIcyk2S5_RwNNEYku0k",
          "decodedAddress": "cd872fa7c5816052acdf5332260443faec9aacc8c21cca4d92e7f47034d11892",
          "decimals": 9,
          "name": "bemo Staked TON",
          "symbol": "stton"
        },
        "a77a7cafdfbc528aa2deb12790410e325175857057e84a9822329ced0e2d367f": {
          "address": "EQCnenyv37xSiqLesSeQQQ4yUXWFcFfoSpgiMpztDi02f8_z",
          "decodedAddress": "a77a7cafdfbc528aa2deb12790410e325175857057e84a9822329ced0e2d367f",
          "decimals": 9,
          "name": "Bitcoin TON",
          "symbol": "bitton"
        },
        "d7c307966d9b54050220c81df864f08e7bf3ccecf6abfd1e44cb487283fff287": {
          "address": "EQDXwweWbZtUBQIgyB34ZPCOe_PM7Par_R5Ey0hyg__yhz5f",
          "decodedAddress": "d7c307966d9b54050220c81df864f08e7bf3ccecf6abfd1e44cb487283fff287",
          "decimals": 9,
          "name": "Boom Up",
          "symbol": "boom"
        },
        "bf06bf7f705232c2b2a80064770b91019eb32b5ae794d33a90fb43ac95daa800": {
          "address": "EQC_Br9_cFIywrKoAGR3C5EBnrMrWueU0zqQ-0OsldqoADyW",
          "decodedAddress": "bf06bf7f705232c2b2a80064770b91019eb32b5ae794d33a90fb43ac95daa800",
          "decimals": 9,
          "name": "BORIS",
          "symbol": "boris"
        },
        "729c13b6df2c07cbf0a06ab63d34af454f3d320ec1bcd8fb5c6d24d0806a17c2": {
          "address": "EQBynBO23ywHy_CgarY9NK9FTz0yDsG82PtcbSTQgGoXwiuA",
          "decodedAddress": "729c13b6df2c07cbf0a06ab63d34af454f3d320ec1bcd8fb5c6d24d0806a17c2",
          "decimals": 6,
          "name": "Bridged Tether (TON Bridge)",
          "symbol": "jusdt"
        },
        "7e30fc2b7751ba58a3642f3fd59d5e96a810ddd78d8a310bfe8353bef10500df": {
          "address": "EQB-MPwrd1G6WKNkLz_VnV6WqBDd142KMQv-g1O-8QUA3728",
          "decodedAddress": "7e30fc2b7751ba58a3642f3fd59d5e96a810ddd78d8a310bfe8353bef10500df",
          "decimals": 6,
          "name": "Bridged USD Coin (TON Bridge)",
          "symbol": "jusdc"
        },
        "dc064187982e294dfdf8c771a6d395ef7a93b9c3ad0337167e5d3e08ebe5061b": {
          "address": "EQDcBkGHmC4pTf34x3Gm05XvepO5w60DNxZ-XT4I6-UGG5L5",
          "decodedAddress": "dc064187982e294dfdf8c771a6d395ef7a93b9c3ad0337167e5d3e08ebe5061b",
          "decimals": 8,
          "name": "Bridged Wrapped Bitcoin (TON Bridge)",
          "symbol": "jwbtc"
        },
        "716d0cad2fae30b93cf9d4a72938b7530d23a1aab5752da3ca0eb84ea8b077bf": {
          "address": "EQBxbQytL64wuTz51KcpOLdTDSOhqrV1LaPKDrhOqLB3v4qj",
          "decodedAddress": "716d0cad2fae30b93cf9d4a72938b7530d23a1aab5752da3ca0eb84ea8b077bf",
          "decimals": 9,
          "name": "Buffy",
          "symbol": "buffy"
        },
        "e07e848ca7590b45a057cf7bfbee3af6361594234ac78649284e4c4a3386149e": {
          "address": "EQDgfoSMp1kLRaBXz3v77jr2NhWUI0rHhkkoTkxKM4YUniBX",
          "decodedAddress": "e07e848ca7590b45a057cf7bfbee3af6361594234ac78649284e4c4a3386149e",
          "decimals": 9,
          "name": "BYIN",
          "symbol": "byin"
        },
        "5929790d91a2a08ab86c1b9d76414ebf1c3a154f853e2fcf6406d5addbcdef49": {
          "address": "EQBZKXkNkaKgirhsG512QU6_HDoVT4U-L89kBtWt283vSe12",
          "decodedAddress": "5929790d91a2a08ab86c1b9d76414ebf1c3a154f853e2fcf6406d5addbcdef49",
          "decimals": 9,
          "name": "Catboy",
          "symbol": "catboy"
        },
        "eefee16cea5f312ea8931e4044802f7aaefa5f8034577f3891053b0099ba4567": {
          "address": "EQDu_uFs6l8xLqiTHkBEgC96rvpfgDRXfziRBTsAmbpFZ-X6",
          "decodedAddress": "eefee16cea5f312ea8931e4044802f7aaefa5f8034577f3891053b0099ba4567",
          "decimals": 9,
          "name": "CLOWN",
          "symbol": "clown"
        },
        "f7e8bc69ea9e053331d04e15b3bc535aaa16d3f108a9e2b305d4d623092818ea": {
          "address": "EQD36Lxp6p4FMzHQThWzvFNaqhbT8Qip4rMF1NYjCSgY6ksE",
          "decodedAddress": "f7e8bc69ea9e053331d04e15b3bc535aaa16d3f108a9e2b305d4d623092818ea",
          "decimals": 9,
          "name": "Crypton Ai",
          "symbol": "$crypton"
        },
        "9748c357dce0798cf80e2641338d8866ec53817e4037720ee9681a93630cd7ae": {
          "address": "EQCXSMNX3OB5jPgOJkEzjYhm7FOBfkA3cg7paBqTYwzXrjIi",
          "decodedAddress": "9748c357dce0798cf80e2641338d8866ec53817e4037720ee9681a93630cd7ae",
          "decimals": 9,
          "name": "Cubigator",
          "symbol": "cub"
        },
        "f6eb371de82aa9cfb5b22ca547f31fdc0fa0fbb41ae89ba84a73272ff0bf2157": {
          "address": "EQD26zcd6Cqpz7WyLKVH8x_cD6D7tBrom6hKcycv8L8hV0GP",
          "decodedAddress": "f6eb371de82aa9cfb5b22ca547f31fdc0fa0fbb41ae89ba84a73272ff0bf2157",
          "decimals": 9,
          "name": "DeFinder Capital",
          "symbol": "dfc"
        },
        "aaacec8390058e66b54bccec50fc33123eba220f5337dd5653ee5f7f1624f86d": {
          "address": "EQCqrOyDkAWOZrVLzOxQ_DMSProiD1M33VZT7l9_FiT4bXOO",
          "decodedAddress": "aaacec8390058e66b54bccec50fc33123eba220f5337dd5653ee5f7f1624f86d",
          "decimals": 9,
          "name": "DexTon",
          "symbol": "dt"
        },
        "421705bcb85521f9a99d466358f4dc9e0c469e0d85ddf608091ac89ca6a55c1e": {
          "address": "EQBCFwW8uFUh-amdRmNY9NyeDEaeDYXd9ggJGsicpqVcHq7B",
          "decodedAddress": "421705bcb85521f9a99d466358f4dc9e0c469e0d85ddf608091ac89ca6a55c1e",
          "decimals": 9,
          "name": "DHD Coin",
          "symbol": "dhd"
        },
        "b0ec8f1a7fc027f2dea0acac59b2e4a602b80e51382aa28c3cd6ed52d460b572": {
          "address": "EQCw7I8af8An8t6grKxZsuSmArgOUTgqoow81u1S1GC1cpNT",
          "decodedAddress": "b0ec8f1a7fc027f2dea0acac59b2e4a602b80e51382aa28c3cd6ed52d460b572",
          "decimals": 9,
          "name": "DOGE MEMES TOPPLE REGIMES",
          "symbol": "dome"
        },
        "8f2228dc6951eeb9a3cbb6e0ad883d26c2e7991bbddb787279bdd57f97dfefce": {
          "address": "EQCPIijcaVHuuaPLtuCtiD0mwueZG73beHJ5vdV_l9_vzv5_",
          "decodedAddress": "8f2228dc6951eeb9a3cbb6e0ad883d26c2e7991bbddb787279bdd57f97dfefce",
          "decimals": 9,
          "name": "Dragunova Bot",
          "symbol": "nova"
        },
        "dd0a16bf2be67dee52a5e7df4ed060c0b74a72d9952ea27b385ae7fce6daba35": {
          "address": "EQDdCha_K-Z97lKl599O0GDAt0py2ZUuons4Wuf85tq6NXIO",
          "decodedAddress": "dd0a16bf2be67dee52a5e7df4ed060c0b74a72d9952ea27b385ae7fce6daba35",
          "decimals": 9,
          "name": "Du Rove\u2019s Wall",
          "symbol": "$wall"
        },
        "53732b598dd67014b8fa4ceec2786be7e1a326a97bdb5fe9ce0e20296ddd35d6": {
          "address": "EQBTcytZjdZwFLj6TO7CeGvn4aMmqXvbX-nODiApbd011gT3",
          "decodedAddress": "53732b598dd67014b8fa4ceec2786be7e1a326a97bdb5fe9ce0e20296ddd35d6",
          "decimals": 9,
          "name": "DuckCoin",
          "symbol": "duck"
        },
        "7c3b4249fa1a9e0c0a830b5386eb33d805fa55f90cf03de77492971b20b5ec98": {
          "address": "EQB8O0JJ-hqeDAqDC1OG6zPYBfpV-QzwPed0kpcbILXsmAxG",
          "decodedAddress": "7c3b4249fa1a9e0c0a830b5386eb33d805fa55f90cf03de77492971b20b5ec98",
          "decimals": 9,
          "name": "Gem DEX",
          "symbol": "gem"
        },
        "57e8af5a5d59779d720d0b23cf2fce82e0e355990f2f2b7eb4bba772905297a4": {
          "address": "EQBX6K9aXVl3nXINCyPPL86C4ONVmQ8vK360u6dykFKXpHCa",
          "decodedAddress": "57e8af5a5d59779d720d0b23cf2fce82e0e355990f2f2b7eb4bba772905297a4",
          "decimals": 9,
          "name": "GEMSTON",
          "symbol": "gemston"
        },
        "81771a4409f10f1f6c14c62d5ae9088e9127fee6a0e3516a8b094b8ab43f862c": {
          "address": "EQCBdxpECfEPH2wUxi1a6QiOkSf-5qDjUWqLCUuKtD-GLINT",
          "decodedAddress": "81771a4409f10f1f6c14c62d5ae9088e9127fee6a0e3516a8b094b8ab43f862c",
          "decimals": 9,
          "name": "Glint Coin",
          "symbol": "glint"
        },
        "b068e5a95afc6587ef9568225291ff08e71126b825ca2a45ee18cdcff4f02425": {
          "address": "EQCwaOWpWvxlh--VaCJSkf8I5xEmuCXKKkXuGM3P9PAkJclJ",
          "decodedAddress": "b068e5a95afc6587ef9568225291ff08e71126b825ca2a45ee18cdcff4f02425",
          "decimals": 9,
          "name": "Glitch",
          "symbol": "glitch"
        },
        "a2cfb8756357e6c4f3939ef3d09be0e31855f6d548aeab3cb68154280a2ebf25": {
          "address": "EQCiz7h1Y1fmxPOTnvPQm-DjGFX21Uiuqzy2gVQoCi6_JWWn",
          "decodedAddress": "a2cfb8756357e6c4f3939ef3d09be0e31855f6d548aeab3cb68154280a2ebf25",
          "decimals": 9,
          "name": "GODZI",
          "symbol": "gdz"
        },
        "b8ef4f77a17e5785bd31ba4da50abd91852f2b8febee97ad6ee16d941f939198": {
          "address": "EQC47093oX5Xhb0xuk2lCr2RhS8rj-vul61u4W2UH5ORmG_O",
          "decodedAddress": "b8ef4f77a17e5785bd31ba4da50abd91852f2b8febee97ad6ee16d941f939198",
          "decimals": 9,
          "name": "Gram",
          "symbol": "gram"
        },
        "e362287713324c235561d00b49e6a5a8fe34ea69d3d0820443df7fb12e0c4128": {
          "address": "EQDjYih3EzJMI1Vh0AtJ5qWo_jTqadPQggRD33-xLgxBKBLf",
          "decodedAddress": "e362287713324c235561d00b49e6a5a8fe34ea69d3d0820443df7fb12e0c4128",
          "decimals": 9,
          "name": "Hachiko Inu",
          "symbol": "haki"
        },
        "8b5af0a3e384184de2ee8e7098287ec3a00ba4fceed023e2e702ddd7e5b39f34": {
          "address": "EQCLWvCj44QYTeLujnCYKH7DoAuk_O7QI-LnAt3X5bOfNFMy",
          "decodedAddress": "8b5af0a3e384184de2ee8e7098287ec3a00ba4fceed023e2e702ddd7e5b39f34",
          "decimals": 9,
          "name": "Hedgehog in the fog",
          "symbol": "hif"
        },
        "cf76af318c0872b58a9f1925fc29c156211782b9fb01f56760d292e56123bf87": {
          "address": "EQDPdq8xjAhytYqfGSX8KcFWIReCufsB9Wdg0pLlYSO_h76w",
          "decodedAddress": "cf76af318c0872b58a9f1925fc29c156211782b9fb01f56760d292e56123bf87",
          "decimals": 9,
          "name": "Hipo Staked TON",
          "symbol": "hton"
        },
        "f4bdd480fcd79d47dbaf6e037d1229115feb2e7ac0f119e160ebd5d031abdf2e": {
          "address": "EQD0vdSA_NedR9uvbgN9EikRX-suesDxGeFg69XQMavfLqIw",
          "decodedAddress": "f4bdd480fcd79d47dbaf6e037d1229115feb2e7ac0f119e160ebd5d031abdf2e",
          "decimals": 9,
          "name": "Huebel Bolt",
          "symbol": "bolt"
        },
        "ad9cd74f9c0e0d4ede1743f336d5d2b2a1447b75afd25fbbaab4efb08751deaa": {
          "address": "EQCtnNdPnA4NTt4XQ_M21dKyoUR7da_SX7uqtO-wh1HeqsX4",
          "decodedAddress": "ad9cd74f9c0e0d4ede1743f336d5d2b2a1447b75afd25fbbaab4efb08751deaa",
          "decimals": 9,
          "name": "indicaTon",
          "symbol": "ictn"
        },
        "8559f83510b2d190d435560c4210e60aa8bab102e3494eb5171578246a0ec3da": {
          "address": "EQCFWfg1ELLRkNQ1VgxCEOYKqLqxAuNJTrUXFXgkag7D2ssH",
          "decodedAddress": "8559f83510b2d190d435560c4210e60aa8bab102e3494eb5171578246a0ec3da",
          "decimals": 9,
          "name": "John Doge",
          "symbol": "jdoge"
        },
        "bc16864c941719859e8fafdb071b21f3905bfdcb60795fdb4deb546fb9c2d1cc": {
          "address": "EQC8FoZMlBcZhZ6Pr9sHGyHzkFv9y2B5X9tN61RvucLRzFZz",
          "decodedAddress": "bc16864c941719859e8fafdb071b21f3905bfdcb60795fdb4deb546fb9c2d1cc",
          "decimals": 9,
          "name": "JVault Token",
          "symbol": "jvt"
        },
        "95a54d5564be0eadff660d74ee139cb1075bef16602940ff50fbaeafd11887f2": {
          "address": "EQCVpU1VZL4Orf9mDXTuE5yxB1vvFmApQP9Q-66v0RiH8his",
          "decodedAddress": "95a54d5564be0eadff660d74ee139cb1075bef16602940ff50fbaeafd11887f2",
          "decimals": 9,
          "name": "KGB Protocol",
          "symbol": "kgb"
        },
        "beb5d4638e860ccf7317296e298fde5b35982f4725b0676dc98b1de987b82ebc": {
          "address": "EQC-tdRjjoYMz3MXKW4pj95bNZgvRyWwZ23Jix3ph7guvHxJ",
          "decodedAddress": "beb5d4638e860ccf7317296e298fde5b35982f4725b0676dc98b1de987b82ebc",
          "decimals": 9,
          "name": "KingyTON",
          "symbol": "kingy"
        },
        "65de083a0007638233b6668354e50e44cd4225f1730d66b8b1f19e5d26690751": {
          "address": "EQBl3gg6AAdjgjO2ZoNU5Q5EzUIl8XMNZrix8Z5dJmkHUfxI",
          "decodedAddress": "65de083a0007638233b6668354e50e44cd4225f1730d66b8b1f19e5d26690751",
          "decimals": 9,
          "name": "Lavandos",
          "symbol": "lave"
        },
        "c95e05ef7644c21b437af9ee81d7e7e5d54d4b9cf1cc629aa2a3750403d28067": {
          "address": "EQDJXgXvdkTCG0N6-e6B1-fl1U1LnPHMYpqio3UEA9KAZ07j",
          "decodedAddress": "c95e05ef7644c21b437af9ee81d7e7e5d54d4b9cf1cc629aa2a3750403d28067",
          "decimals": 9,
          "name": "Llama",
          "symbol": "llama"
        },
        "9b28c4e61007529f3b0af392cea5a0e40c7dc78ee8c46d378f3127a2aef11a36": {
          "address": "EQCbKMTmEAdSnzsK85LOpaDkDH3HjujEbTePMSeirvEaNq-U",
          "decodedAddress": "9b28c4e61007529f3b0af392cea5a0e40c7dc78ee8c46d378f3127a2aef11a36",
          "decimals": 9,
          "name": "Magic Crystal",
          "symbol": "mc"
        },
        "63130f9239ef325769086c65591abb0fa4b4da6a800e13cec219723671ae1777": {
          "address": "EQBjEw-SOe8yV2kIbGVZGrsPpLTaaoAOE87CGXI2ca4XdzXA",
          "decodedAddress": "63130f9239ef325769086c65591abb0fa4b4da6a800e13cec219723671ae1777",
          "decimals": 9,
          "name": "Margaritis",
          "symbol": "marga"
        },
        "9a8da514d575d20234c3fb1395ee9138f5f1ad838abc905dc42c2389b46bd015": {
          "address": "EQCajaUU1XXSAjTD-xOV7pE49fGtg4q8kF3ELCOJtGvQFQ2C",
          "decodedAddress": "9a8da514d575d20234c3fb1395ee9138f5f1ad838abc905dc42c2389b46bd015",
          "decimals": 9,
          "name": "Megaton Finance Wrapped Toncoin",
          "symbol": "wton"
        },
        "15c3eeac2bb3497a94a3807d605bad256049076334a62bda476d7b2d08294363": {
          "address": "EQAVw-6sK7NJepSjgH1gW60lYEkHYzSmK9pHbXstCClDY4BV",
          "decodedAddress": "15c3eeac2bb3497a94a3807d605bad256049076334a62bda476d7b2d08294363",
          "decimals": 9,
          "name": "meh on TON",
          "symbol": "meh"
        },
        "f57c747413d72b4933cefe20c51ef728c2f0aaed0d58ff3328a20205cf021d32": {
          "address": "EQD1fHR0E9crSTPO_iDFHvcowvCq7Q1Y_zMoogIFzwIdMgRb",
          "decodedAddress": "f57c747413d72b4933cefe20c51ef728c2f0aaed0d58ff3328a20205cf021d32",
          "decimals": 9,
          "name": "MemeFund",
          "symbol": "mf"
        },
        "3b630a710501575fae7b455ec376123f5193fd93082c8452ad66347880f3a409": {
          "address": "EQA7YwpxBQFXX657RV7DdhI_UZP9kwgshFKtZjR4gPOkCVWZ",
          "decodedAddress": "3b630a710501575fae7b455ec376123f5193fd93082c8452ad66347880f3a409",
          "decimals": 9,
          "name": "MetaPhone",
          "symbol": "phone"
        },
        "706a2e504f979be562a6a4321fdacd4131e569d25ce93da5d156ba1636974274": {
          "address": "EQBwai5QT5eb5WKmpDIf2s1BMeVp0lzpPaXRVroWNpdCdNa8",
          "decodedAddress": "706a2e504f979be562a6a4321fdacd4131e569d25ce93da5d156ba1636974274",
          "decimals": 18,
          "name": "MetaToken",
          "symbol": "mtk"
        },
        "87e3837bdc15c4853f34eb72802bfdbba02a26bc99e601a79bb28f9d668c80cb": {
          "address": "EQCH44N73BXEhT8063KAK_27oComvJnmAaebso-dZoyAy6g_",
          "decodedAddress": "87e3837bdc15c4853f34eb72802bfdbba02a26bc99e601a79bb28f9d668c80cb",
          "decimals": 9,
          "name": "MMM",
          "symbol": "mmm"
        },
        "7ae10db5f371fd5eab2b47d87ab55f37027465157f3a30959108c425b20414db": {
          "address": "EQB64Q2183H9XqsrR9h6tV83AnRlFX86MJWRCMQlsgQU2-yv",
          "decodedAddress": "7ae10db5f371fd5eab2b47d87ab55f37027465157f3a30959108c425b20414db",
          "decimals": 9,
          "name": "Morfey",
          "symbol": "morfey"
        },
        "972070160c0244261322355a9e52fa7723a3bbcbf3f6b03f34cc4b095de522e7": {
          "address": "EQCXIHAWDAJEJhMiNVqeUvp3I6O7y_P2sD80zEsJXeUi56mb",
          "decodedAddress": "972070160c0244261322355a9e52fa7723a3bbcbf3f6b03f34cc4b095de522e7",
          "decimals": 9,
          "name": "Mumba",
          "symbol": "mumba"
        },
        "41f843111099081d5606e433e29253a158f72c09ac632fd1ca9a046fb86b73ff": {
          "address": "EQBB-EMREJkIHVYG5DPiklOhWPcsCaxjL9HKmgRvuGtz_1lu",
          "decodedAddress": "41f843111099081d5606e433e29253a158f72c09ac632fd1ca9a046fb86b73ff",
          "decimals": 9,
          "name": "Nobby Game",
          "symbol": "sox"
        },
        "16a73dbf1b434ac651b656f8056e06463edf18d6a7b47068fee18c3905f99847": {
          "address": "EQAWpz2_G0NKxlG2VvgFbgZGPt8Y1qe0cGj-4Yw5BfmYR5iF",
          "decodedAddress": "16a73dbf1b434ac651b656f8056e06463edf18d6a7b47068fee18c3905f99847",
          "decimals": 9,
          "name": "Not Meme",
          "symbol": "mem"
        },
        "454f32ed86faca3e04177e03a18658559d2b43b7bdf7510cddc478d8eb949d0d": {
          "address": "EQBFTzLthvrKPgQXfgOhhlhVnStDt733UQzdxHjY65SdDUc3",
          "decodedAddress": "454f32ed86faca3e04177e03a18658559d2b43b7bdf7510cddc478d8eb949d0d",
          "decimals": 9,
          "name": "Not Notcoin",
          "symbol": "notnot"
        },
        "6696fc34c79eb6b187f48bef8344c1f59004c7399e184205c90c48bcf5def763": {
          "address": "EQBmlvw0x562sYf0i--DRMH1kATHOZ4YQgXJDEi89d73Yw6W",
          "decodedAddress": "6696fc34c79eb6b187f48bef8344c1f59004c7399e184205c90c48bcf5def763",
          "decimals": 9,
          "name": "Notdogecoin",
          "symbol": "notdoge"
        },
        "746a957e372098243570481a032fce978e9d0e8b07320fc8c9d09e415569e70c": {
          "address": "EQB0apV-NyCYJDVwSBoDL86Xjp0OiwcyD8jJ0J5BVWnnDJu7",
          "decodedAddress": "746a957e372098243570481a032fce978e9d0e8b07320fc8c9d09e415569e70c",
          "decimals": 9,
          "name": "OPEN Tony",
          "symbol": "open"
        },
        "996a89e369f449306cfdf1b22d94008c04b875ed8ddb31fb64a6999e6c99b63b": {
          "address": "EQCZaonjafRJMGz98bItlACMBLh17Y3bMftkppmebJm2O92Z",
          "decodedAddress": "996a89e369f449306cfdf1b22d94008c04b875ed8ddb31fb64a6999e6c99b63b",
          "decimals": 9,
          "name": "Otton",
          "symbol": "otn"
        },
        "17f49eb4bdafb4c080cc76a18b44c7fb8a626f1b462dca2dd8c67abdcbe9db34": {
          "address": "EQAX9J60va-0wIDMdqGLRMf7imJvG0Ytyi3Yxnq9y-nbNCq2",
          "decodedAddress": "17f49eb4bdafb4c080cc76a18b44c7fb8a626f1b462dca2dd8c67abdcbe9db34",
          "decimals": 9,
          "name": "Paper Plane",
          "symbol": "plane"
        },
        "e8a882a439ebd566e9267f52fc9c685c8e585ae2c7ef825f06211a538ff6f9dc": {
          "address": "EQDoqIKkOevVZukmf1L8nGhcjlha4sfvgl8GIRpTj_b53HyR",
          "decodedAddress": "e8a882a439ebd566e9267f52fc9c685c8e585ae2c7ef825f06211a538ff6f9dc",
          "decimals": 9,
          "name": "Pizza Gram",
          "symbol": "pizza"
        },
        "bc5e450459be9bcdbcc4f5e55a012a0a502c9803f0944002c6135e635889c4aa": {
          "address": "EQC8XkUEWb6bzbzE9eVaASoKUCyYA_CUQALGE15jWInEqla6",
          "decodedAddress": "bc5e450459be9bcdbcc4f5e55a012a0a502c9803f0944002c6135e635889c4aa",
          "decimals": 9,
          "name": "Ponke TON",
          "symbol": "ponke"
        },
        "41ed158ed2ace8e898629172e398a25cf35212e094747327396cf00bfe1d061a": {
          "address": "EQBB7RWO0qzo6JhikXLjmKJc81IS4JR0cyc5bPAL_h0GGmxW",
          "decodedAddress": "41ed158ed2ace8e898629172e398a25cf35212e094747327396cf00bfe1d061a",
          "decimals": 9,
          "name": "Portal Network Token",
          "symbol": "poe"
        },
        "e8ce24adb5067de90251c4744a75ab429b92fd0d12fd2cac9c5dc8e5f113d764": {
          "address": "EQDoziSttQZ96QJRxHRKdatCm5L9DRL9LKycXcjl8RPXZM0N",
          "decodedAddress": "e8ce24adb5067de90251c4744a75ab429b92fd0d12fd2cac9c5dc8e5f113d764",
          "decimals": 9,
          "name": "POT",
          "symbol": "pot"
        },
        "213dca727e486fd8c3d4c589b7ee0f8d8d9a41ae9fa13be5c4a4e56480e2c013": {
          "address": "EQAhPcpyfkhv2MPUxYm37g-NjZpBrp-hO-XEpOVkgOLAE2hS",
          "decodedAddress": "213dca727e486fd8c3d4c589b7ee0f8d8d9a41ae9fa13be5c4a4e56480e2c013",
          "decimals": 9,
          "name": "Pun Dog",
          "symbol": "pun"
        },
        "b1d6b0f11d029ddd7589d67c4749fb869f6361df34c33a97987a6aca2dec33ca": {
          "address": "EQCx1rDxHQKd3XWJ1nxHSfuGn2Nh3zTDOpeYemrKLewzysng",
          "decodedAddress": "b1d6b0f11d029ddd7589d67c4749fb869f6361df34c33a97987a6aca2dec33ca",
          "decimals": 9,
          "name": "Raccoon",
          "symbol": "roon"
        },
        "85f68631a37ef10865f50d285913079a54625ee8ab9ca74ced28eeaf0ac44034": {
          "address": "EQCF9oYxo37xCGX1DShZEweaVGJe6Kucp0ztKO6vCsRANDOM",
          "decodedAddress": "85f68631a37ef10865f50d285913079a54625ee8ab9ca74ced28eeaf0ac44034",
          "decimals": 9,
          "name": "Random.tg",
          "symbol": "random"
        },
        "fd06cba941c9031512e77358b15675bec1ba414d5520dec9832bd9a4450ed63d": {
          "address": "EQD9BsupQckDFRLnc1ixVnW-wbpBTVUg3smDK9mkRQ7WPc8d",
          "decodedAddress": "fd06cba941c9031512e77358b15675bec1ba414d5520dec9832bd9a4450ed63d",
          "decimals": 9,
          "name": "Resistance Duck",
          "symbol": "redu"
        },
        "14fc1f849e725d0d6c881f1cd20585d2600ae098d616f913db6acfc427a95bbe": {
          "address": "EQAU_B-EnnJdDWyIHxzSBYXSYArgmNYW-RPbas_EJ6lbvhic",
          "decodedAddress": "14fc1f849e725d0d6c881f1cd20585d2600ae098d616f913db6acfc427a95bbe",
          "decimals": 9,
          "name": "Resistance Notcoin",
          "symbol": "reno"
        },
        "5daf96fb72c65b5e10e7439537eb86e92f29477e4f0059cba0f13c21cc231572": {
          "address": "EQBdr5b7csZbXhDnQ5U364bpLylHfk8AWcug8TwhzCMVcvPA",
          "decodedAddress": "5daf96fb72c65b5e10e7439537eb86e92f29477e4f0059cba0f13c21cc231572",
          "decimals": 9,
          "name": "Rosecoin",
          "symbol": "rose"
        },
        "730e3cf3a4de8f68b2b657175d00368f74d01501b733cef0438710564331e1e9": {
          "address": "EQBzDjzzpN6PaLK2VxddADaPdNAVAbczzvBDhxBWQzHh6aLV",
          "decodedAddress": "730e3cf3a4de8f68b2b657175d00368f74d01501b733cef0438710564331e1e9",
          "decimals": 9,
          "name": "Ruski Inu",
          "symbol": "ruski"
        },
        "65aac9b5e380eae928db3c8e238d9bc0d61a9320fdc2bc7a2f6c87d6fedf9208": {
          "address": "EQBlqsm144Dq6SjbPI4jjZvA1hqTIP3CvHovbIfW_t-SCALE",
          "decodedAddress": "65aac9b5e380eae928db3c8e238d9bc0d61a9320fdc2bc7a2f6c87d6fedf9208",
          "decimals": 9,
          "name": "Scaleton",
          "symbol": "scale"
        },
        "885d09fde3444d70e93a1b34a8ad14a203d5990bdc54cfeea5ca197a029ea76b": {
          "address": "EQCIXQn940RNcOk6GzSorRSiA9WZC9xUz-6lyhl6Ap6na2sh",
          "decodedAddress": "885d09fde3444d70e93a1b34a8ad14a203d5990bdc54cfeea5ca197a029ea76b",
          "decimals": 9,
          "name": "Shard of Notcoin NFT bond",
          "symbol": "wnot"
        },
        "9405ccbe2b9eb158229202d7f6c0c7e62263660ec8666250f1bca483bb22bcda": {
          "address": "EQCUBcy-K56xWCKSAtf2wMfmImNmDshmYlDxvKSDuyK82gBa",
          "decodedAddress": "9405ccbe2b9eb158229202d7f6c0c7e62263660ec8666250f1bca483bb22bcda",
          "decimals": 9,
          "name": "Shrimp",
          "symbol": "shrimp"
        },
        "adc5b7daf5b5579fbc2c7cae55ef67d7d5116e73c9050c5ee988c8a858436010": {
          "address": "EQCtxbfa9bVXn7wsfK5V72fX1RFuc8kFDF7piMioWENgEBx5",
          "decodedAddress": "adc5b7daf5b5579fbc2c7cae55ef67d7d5116e73c9050c5ee988c8a858436010",
          "decimals": 9,
          "name": "SQD",
          "symbol": "sqd"
        },
        "3a634ad6cac1b81d69aba2ced5fb3ecdae312bbf20b0bcd54596fc848cb1efe4": {
          "address": "EQA6Y0rWysG4HWmros7V-z7NrjErvyCwvNVFlvyEjLHv5PJe",
          "decodedAddress": "3a634ad6cac1b81d69aba2ced5fb3ecdae312bbf20b0bcd54596fc848cb1efe4",
          "decimals": 0,
          "name": "SquidTG",
          "symbol": "$sqg"
        },
        "6783f531f032ca79a2d9e2437879e73e53e489d5f32d62fa9000db4bd28c4a45": {
          "address": "EQBng_Ux8DLKeaLZ4kN4eec-U-SJ1fMtYvqQANtL0oxKRQh_",
          "decodedAddress": "6783f531f032ca79a2d9e2437879e73e53e489d5f32d62fa9000db4bd28c4a45",
          "decimals": 9,
          "name": "sTONks",
          "symbol": "stonks"
        },
        "552d1a1ac3517c544044fc01b92b6057697922d2728f9ef7fbd0202a1b2eadbb": {
          "address": "EQBVLRoaw1F8VEBE_AG5K2BXaXki0nKPnvf70CAqGy6tu22X",
          "decodedAddress": "552d1a1ac3517c544044fc01b92b6057697922d2728f9ef7fbd0202a1b2eadbb",
          "decimals": 9,
          "name": "Teh Upen Netwerg",
          "symbol": "tun"
        },
        "cdd754d33d3c70ff148f26cff3cabcc84669782570e5a6902663326afbeb66a4": {
          "address": "EQDN11TTPTxw_xSPJs_zyrzIRml4JXDlppAmYzJq--tmpA6V",
          "decodedAddress": "cdd754d33d3c70ff148f26cff3cabcc84669782570e5a6902663326afbeb66a4",
          "decimals": 9,
          "name": "Tepe",
          "symbol": "tepe"
        },
        "d1950f1e9fb036cec4ee17b49d0cec4c959ff0170d04ec4a30deef5ce294a87b": {
          "address": "EQDRlQ8en7A2zsTuF7SdDOxMlZ_wFw0E7Eow3u9c4pSoe4Tg",
          "decodedAddress": "d1950f1e9fb036cec4ee17b49d0cec4c959ff0170d04ec4a30deef5ce294a87b",
          "decimals": 9,
          "name": "TG20 TGram",
          "symbol": "tgram"
        },
        "5a76af69d76b82d4a7d288f0806a812f8695cf1e3ee1056abe9aa1a7b6ec04d8": {
          "address": "EQBadq9p12uC1KfSiPCAaoEvhpXPHj7hBWq-mqGntuwE2C1C",
          "decodedAddress": "5a76af69d76b82d4a7d288f0806a812f8695cf1e3ee1056abe9aa1a7b6ec04d8",
          "decimals": 9,
          "name": "TON Cats Jetton",
          "symbol": "cats"
        },
        "f85d35d625ec2e36d9e12864e465a3f4c2c2ef4323609155dc3cb5b9ccf4d077": {
          "address": "EQD4XTXWJewuNtnhKGTkZaP0wsLvQyNgkVXcPLW5zPTQdykb",
          "decodedAddress": "f85d35d625ec2e36d9e12864e465a3f4c2c2ef4323609155dc3cb5b9ccf4d077",
          "decimals": 9,
          "name": "TON DOG",
          "symbol": "tdog"
        },
        "e3387de7a142550972d20710a1d9a8278783842c3be81815f050d4f1cd9a5a11": {
          "address": "EQDjOH3noUJVCXLSBxCh2agnh4OELDvoGBXwUNTxzZpaEWH4",
          "decodedAddress": "e3387de7a142550972d20710a1d9a8278783842c3be81815f050d4f1cd9a5a11",
          "decimals": 9,
          "name": "TON KONG",
          "symbol": "kong"
        },
        "1d15bca749497322587f2387d7b9869eaf7aef6344c6d012be35067e63cef5a5": {
          "address": "EQAdFbynSUlzIlh_I4fXuYaer3rvY0TG0BK-NQZ-Y871pZoM",
          "decodedAddress": "1d15bca749497322587f2387d7b9869eaf7aef6344c6d012be35067e63cef5a5",
          "decimals": 9,
          "name": "$TON Mixer",
          "symbol": "mixer"
        },
        "213147f6c01a72af6290cc9b90377f5c9b037cc3b582d4cba9e3e1b2f6051aa4": {
          "address": "EQAhMUf2wBpyr2KQzJuQN39cmwN8w7WC1Mup4-Gy9gUapJgG",
          "decodedAddress": "213147f6c01a72af6290cc9b90377f5c9b037cc3b582d4cba9e3e1b2f6051aa4",
          "decimals": 9,
          "name": "Ton Printer",
          "symbol": "tp"
        },
        "896e9d240693f03e8046f94e42f9c59f3ff8e792cbe8b467c0acf179d10f508a": {
          "address": "EQCJbp0kBpPwPoBG-U5C-cWfP_jnksvotGfArPF50Q9Qiv9h",
          "decodedAddress": "896e9d240693f03e8046f94e42f9c59f3ff8e792cbe8b467c0acf179d10f508a",
          "decimals": 9,
          "name": "TON Raffles",
          "symbol": "raff"
        },
        "b3c7d43b7242995e4c9366c0a74d7c5029bafe974ebeab3f70ad759678dce5c0": {
          "address": "EQCzx9Q7ckKZXkyTZsCnTXxQKbr-l06-qz9wrXWWeNzlwO09",
          "decodedAddress": "b3c7d43b7242995e4c9366c0a74d7c5029bafe974ebeab3f70ad759678dce5c0",
          "decimals": 9,
          "name": "Ton Renaissance",
          "symbol": "tonr"
        },
        "b7e69198f5eacf3a737be706697e93b253983052798bbd4104eb5a0e6e99288a": {
          "address": "EQC35pGY9erPOnN75wZpfpOyU5gwUnmLvUEE61oObpkoilgq",
          "decodedAddress": "b7e69198f5eacf3a737be706697e93b253983052798bbd4104eb5a0e6e99288a",
          "decimals": 9,
          "name": "Ton Stars",
          "symbol": "stars"
        },
        "a4b44980b2f6019fc0cf4ba96ee107dab631092512f00fde1a0ea6fc4ace9eb6": {
          "address": "EQCktEmAsvYBn8DPS6lu4QfatjEJJRLwD94aDqb8Ss6etuaA",
          "decodedAddress": "a4b44980b2f6019fc0cf4ba96ee107dab631092512f00fde1a0ea6fc4ace9eb6",
          "decimals": 9,
          "name": "TON Tiger",
          "symbol": "tiger"
        },
        "7e6a33328b9f9628880e1e76ce180a5f7245066e5ead0e4dd0b7c3ca99bfb12c": {
          "address": "EQB-ajMyi5-WKIgOHnbOGApfckUGbl6tDk3Qt8PKmb-xLAvp",
          "decodedAddress": "7e6a33328b9f9628880e1e76ce180a5f7245066e5ead0e4dd0b7c3ca99bfb12c",
          "decimals": 9,
          "name": "Tonex",
          "symbol": "tnx"
        },
        "b4298559a7047e75390fc1546a6a01f60f7d617bddf547ba146cf201a3fefb17": {
          "address": "EQC0KYVZpwR-dTkPwVRqagH2D31he931R7oUbPIBo_77F97K",
          "decodedAddress": "b4298559a7047e75390fc1546a6a01f60f7d617bddf547ba146cf201a3fefb17",
          "decimals": 9,
          "name": "Tong",
          "symbol": "tong"
        },
        "f83f7d94d74b2736821abe8aba7183d3411f367b00233b6d1ea6282b59102ea7": {
          "address": "EQD4P32U10snNoIavoq6cYPTQR82ewAjO20epigrWRAup54_",
          "decodedAddress": "f83f7d94d74b2736821abe8aba7183d3411f367b00233b6d1ea6282b59102ea7",
          "decimals": 6,
          "name": "Hydra",
          "symbol": "hydra"
        },
        "efebc6f725a5813bf0eb3fabb5dceabb2ac9ca851f76ea433170e2700020d8fe": {
          "address": "EQDv68b3JaWBO_DrP6u13Oq7KsnKhR926kMxcOJwACDY_uQC",
          "decodedAddress": "efebc6f725a5813bf0eb3fabb5dceabb2ac9ca851f76ea433170e2700020d8fe",
          "decimals": 9,
          "name": "Tonk Inu",
          "symbol": "tonk"
        },
        "795a3a3bc9775a07bd32068376604bfc8953e301d30e6dffc3ab8d042cb68f96": {
          "address": "EQB5Wjo7yXdaB70yBoN2YEv8iVPjAdMObf_Dq40ELLaPllNb",
          "decodedAddress": "795a3a3bc9775a07bd32068376604bfc8953e301d30e6dffc3ab8d042cb68f96",
          "decimals": 9,
          "name": "TonMiner",
          "symbol": "1rus"
        },
        "cd0efe78bff4c4539b76eab17293296c74f42cbf99ec499687fefec94893ed32": {
          "address": "EQDNDv54v_TEU5t26rFykylsdPQsv5nsSZaH_v7JSJPtMitv",
          "decodedAddress": "cd0efe78bff4c4539b76eab17293296c74f42cbf99ec499687fefec94893ed32",
          "decimals": 6,
          "name": "TONNEL Network",
          "symbol": "tonnel"
        },
        "fbb087cfd8f47cbfb463671464f1f3f29ac8c4de15226030da003dfcc7a2c2b4": {
          "address": "EQD7sIfP2PR8v7RjZxRk8fPymsjE3hUiYDDaAD38x6LCtG2f",
          "decodedAddress": "fbb087cfd8f47cbfb463671464f1f3f29ac8c4de15226030da003dfcc7a2c2b4",
          "decimals": 9,
          "name": "Tonny",
          "symbol": "tonny"
        },
        "91864bf1896f4c978e052d3c4678fb35c4ca8101ff9ac5a90180211f23c6301d": {
          "address": "EQCRhkvxiW9Ml44FLTxGePs1xMqBAf-axakBgCEfI8YwHTWW",
          "decodedAddress": "91864bf1896f4c978e052d3c4678fb35c4ca8101ff9ac5a90180211f23c6301d",
          "decimals": 9,
          "name": "Tonoreum",
          "symbol": "tor"
        },
        "82b96cd009111e89b99e9c10162cd6f9875c4703d66df8333fb4ff4a9aab115d": {
          "address": "EQCCuWzQCREeibmenBAWLNb5h1xHA9Zt-DM_tP9KmqsRXWns",
          "decodedAddress": "82b96cd009111e89b99e9c10162cd6f9875c4703d66df8333fb4ff4a9aab115d",
          "decimals": 9,
          "name": "TONSniper",
          "symbol": "tons"
        },
        "32edc4b0c95bf6ca729d743a97494ad46ccca70325066543ff0e3ea6b4e9be71": {
          "address": "EQAy7cSwyVv2ynKddDqXSUrUbMynAyUGZUP_Dj6mtOm-cYWM",
          "decodedAddress": "32edc4b0c95bf6ca729d743a97494ad46ccca70325066543ff0e3ea6b4e9be71",
          "decimals": 9,
          "name": "TELE",
          "symbol": "tele"
        },
        "1a1a5c42df56254b1ccaffd846de46ba50dd46f616e15c9237493b5f5111e122": {
          "address": "EQAaGlxC31YlSxzK_9hG3ka6UN1G9hbhXJI3STtfURHhIvsu",
          "decodedAddress": "1a1a5c42df56254b1ccaffd846de46ba50dd46f616e15c9237493b5f5111e122",
          "decimals": 9,
          "name": "TONY",
          "symbol": "tny"
        },
        "7dac523dd9e6256a40c7ce09fd6d8c21ab019345e8d667eefc403c7901266593": {
          "address": "EQB9rFI92eYlakDHzgn9bYwhqwGTRejWZ-78QDx5ASZlk6Ha",
          "decodedAddress": "7dac523dd9e6256a40c7ce09fd6d8c21ab019345e8d667eefc403c7901266593",
          "decimals": 9,
          "name": "Tony McDuck",
          "symbol": "tony"
        },
        "6225deb3d168ae88241dcb03cea9a2f24f64db4df57bf4fceef4ad51de5fea95": {
          "address": "EQBiJd6z0WiuiCQdywPOqaLyT2TbTfV79Pzu9K1R3l_qlUZ5",
          "decodedAddress": "6225deb3d168ae88241dcb03cea9a2f24f64db4df57bf4fceef4ad51de5fea95",
          "decimals": 9,
          "name": "TONY THE DUCK",
          "symbol": "tony"
        },
        "f7431ea4cc23f46c961eb1f9f9536a944136e5a232865600109ddb4af217abd8": {
          "address": "EQD3Qx6kzCP0bJYesfn5U2qUQTblojKGVgAQndtK8her2Fyb",
          "decodedAddress": "f7431ea4cc23f46c961eb1f9f9536a944136e5a232865600109ddb4af217abd8",
          "decimals": 9,
          "name": "Toon Of Meme",
          "symbol": "tome"
        },
        "0f2aa4459d073eda6e4e820d1450c34cd1c65174ae09511da037ac24f0f5fdd3": {
          "address": "EQAPKqRFnQc-2m5Ogg0UUMNM0cZRdK4JUR2gN6wk8PX90_Wf",
          "decodedAddress": "0f2aa4459d073eda6e4e820d1450c34cd1c65174ae09511da037ac24f0f5fdd3",
          "decimals": 9,
          "name": "Uniton Token",
          "symbol": "utn"
        },
        "af69fd0932bbfa04ebcfa4081e7b4f2e40cfee46951dfff7e103b366f2dc33bd": {
          "address": "EQCvaf0JMrv6BOvPpAgee08uQM_uRpUd__fhA7Nm8twzvbE_",
          "decodedAddress": "af69fd0932bbfa04ebcfa4081e7b4f2e40cfee46951dfff7e103b366f2dc33bd",
          "decimals": 9,
          "name": "TonUP",
          "symbol": "up"
        },
        "5a0a05303a873a80708d967fe82736f4995b3bf581bbc18a1abe1fa8d48b5a9d": {
          "address": "EQBaCgUwOoc6gHCNln_oJzb0mVs79YG7wYoavh-o1ItaneLA",
          "decodedAddress": "5a0a05303a873a80708d967fe82736f4995b3bf581bbc18a1abe1fa8d48b5a9d",
          "decimals": 9,
          "name": "Utya",
          "symbol": "utya"
        },
        "6d70be0903e3dd3e252407cbad1dca9d69fb665124ea74bf19d4479778f2ed8b": {
          "address": "EQBtcL4JA-PdPiUkB8utHcqdaftmUSTqdL8Z1EeXePLti_nK",
          "decodedAddress": "6d70be0903e3dd3e252407cbad1dca9d69fb665124ea74bf19d4479778f2ed8b",
          "decimals": 3,
          "name": "Web3 TON Token",
          "symbol": "web3"
        },
        "91cb1d2499a76ad94719bbb18fea11fdb58b6a582e11e474e4eae2a5a1a8a7ba": {
          "address": "EQCRyx0kmadq2UcZu7GP6hH9tYtqWC4R5HTk6uKloainuqoB",
          "decodedAddress": "91cb1d2499a76ad94719bbb18fea11fdb58b6a582e11e474e4eae2a5a1a8a7ba",
          "decimals": 9,
          "name": "What The",
          "symbol": "wtf"
        },
        "8e6e1e3e65a8213af6bcb82cff00c327be27ccdcf4be129a542442505d79e53f": {
          "address": "EQCObh4-ZaghOva8uCz_AMMnvifM3PS-EppUJEJQXXnlP0zX",
          "decodedAddress": "8e6e1e3e65a8213af6bcb82cff00c327be27ccdcf4be129a542442505d79e53f",
          "decimals": 9,
          "name": "Whiskers",
          "symbol": "whisk"
        },
        "157c463688a4a91245218052c5580807792cf6347d9757e32f0ee88a179a6549": {
          "address": "EQAVfEY2iKSpEkUhgFLFWAgHeSz2NH2XV-MvDuiKF5plSbsU",
          "decodedAddress": "157c463688a4a91245218052c5580807792cf6347d9757e32f0ee88a179a6549",
          "decimals": 9,
          "name": "xRocket",
          "symbol": "xrock"
        },
        "a45b17f28409229b78360e3290420f13e4fe20f90d7e2bf8c4ac6703259e22fa": {
          "address": "EQCkWxfyhAkim3g2DjKQQg8T5P4g-Q1-K_jErGcDJZ4i-vqR",
          "decodedAddress": "a45b17f28409229b78360e3290420f13e4fe20f90d7e2bf8c4ac6703259e22fa",
          "decimals": 9,
          "name": "Tonstakers",
          "symbol": "tston"
        }
}