"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rotating = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/time/0.12.0/docs/resources/rotating time_rotating}
*/
class Rotating extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a Rotating resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Rotating to import
    * @param importFromId The id of the existing Rotating that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/time/0.12.0/docs/resources/rotating#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Rotating to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "time_rotating", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/time/0.12.0/docs/resources/rotating time_rotating} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RotatingConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'time_rotating',
            terraformGeneratorMetadata: {
                providerName: 'time',
                providerVersion: '0.12.0',
                providerVersionConstraint: '~> 0.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._rfc3339 = config.rfc3339;
        this._rotationDays = config.rotationDays;
        this._rotationHours = config.rotationHours;
        this._rotationMinutes = config.rotationMinutes;
        this._rotationMonths = config.rotationMonths;
        this._rotationRfc3339 = config.rotationRfc3339;
        this._rotationYears = config.rotationYears;
        this._triggers = config.triggers;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // day - computed: true, optional: false, required: false
    get day() {
        return this.getNumberAttribute('day');
    }
    // hour - computed: true, optional: false, required: false
    get hour() {
        return this.getNumberAttribute('hour');
    }
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    // minute - computed: true, optional: false, required: false
    get minute() {
        return this.getNumberAttribute('minute');
    }
    // month - computed: true, optional: false, required: false
    get month() {
        return this.getNumberAttribute('month');
    }
    get rfc3339() {
        return this.getStringAttribute('rfc3339');
    }
    set rfc3339(value) {
        this._rfc3339 = value;
    }
    resetRfc3339() {
        this._rfc3339 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rfc3339Input() {
        return this._rfc3339;
    }
    get rotationDays() {
        return this.getNumberAttribute('rotation_days');
    }
    set rotationDays(value) {
        this._rotationDays = value;
    }
    resetRotationDays() {
        this._rotationDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rotationDaysInput() {
        return this._rotationDays;
    }
    get rotationHours() {
        return this.getNumberAttribute('rotation_hours');
    }
    set rotationHours(value) {
        this._rotationHours = value;
    }
    resetRotationHours() {
        this._rotationHours = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rotationHoursInput() {
        return this._rotationHours;
    }
    get rotationMinutes() {
        return this.getNumberAttribute('rotation_minutes');
    }
    set rotationMinutes(value) {
        this._rotationMinutes = value;
    }
    resetRotationMinutes() {
        this._rotationMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rotationMinutesInput() {
        return this._rotationMinutes;
    }
    get rotationMonths() {
        return this.getNumberAttribute('rotation_months');
    }
    set rotationMonths(value) {
        this._rotationMonths = value;
    }
    resetRotationMonths() {
        this._rotationMonths = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rotationMonthsInput() {
        return this._rotationMonths;
    }
    get rotationRfc3339() {
        return this.getStringAttribute('rotation_rfc3339');
    }
    set rotationRfc3339(value) {
        this._rotationRfc3339 = value;
    }
    resetRotationRfc3339() {
        this._rotationRfc3339 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rotationRfc3339Input() {
        return this._rotationRfc3339;
    }
    get rotationYears() {
        return this.getNumberAttribute('rotation_years');
    }
    set rotationYears(value) {
        this._rotationYears = value;
    }
    resetRotationYears() {
        this._rotationYears = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rotationYearsInput() {
        return this._rotationYears;
    }
    // second - computed: true, optional: false, required: false
    get second() {
        return this.getNumberAttribute('second');
    }
    get triggers() {
        return this.getStringMapAttribute('triggers');
    }
    set triggers(value) {
        this._triggers = value;
    }
    resetTriggers() {
        this._triggers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get triggersInput() {
        return this._triggers;
    }
    // unix - computed: true, optional: false, required: false
    get unix() {
        return this.getNumberAttribute('unix');
    }
    // year - computed: true, optional: false, required: false
    get year() {
        return this.getNumberAttribute('year');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            rfc3339: cdktf.stringToTerraform(this._rfc3339),
            rotation_days: cdktf.numberToTerraform(this._rotationDays),
            rotation_hours: cdktf.numberToTerraform(this._rotationHours),
            rotation_minutes: cdktf.numberToTerraform(this._rotationMinutes),
            rotation_months: cdktf.numberToTerraform(this._rotationMonths),
            rotation_rfc3339: cdktf.stringToTerraform(this._rotationRfc3339),
            rotation_years: cdktf.numberToTerraform(this._rotationYears),
            triggers: cdktf.hashMapper(cdktf.stringToTerraform)(this._triggers),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            rfc3339: {
                value: cdktf.stringToHclTerraform(this._rfc3339),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            rotation_days: {
                value: cdktf.numberToHclTerraform(this._rotationDays),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            rotation_hours: {
                value: cdktf.numberToHclTerraform(this._rotationHours),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            rotation_minutes: {
                value: cdktf.numberToHclTerraform(this._rotationMinutes),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            rotation_months: {
                value: cdktf.numberToHclTerraform(this._rotationMonths),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            rotation_rfc3339: {
                value: cdktf.stringToHclTerraform(this._rotationRfc3339),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            rotation_years: {
                value: cdktf.numberToHclTerraform(this._rotationYears),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            triggers: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._triggers),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.Rotating = Rotating;
_a = JSII_RTTI_SYMBOL_1;
Rotating[_a] = { fqn: "@cdktf/provider-time.rotating.Rotating", version: "10.2.0" };
// =================
// STATIC PROPERTIES
// =================
Rotating.tfResourceType = "time_rotating";
//# sourceMappingURL=data:application/json;base64,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