/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SleepConfig extends cdktf.TerraformMetaArguments {
    /**
    * [Time duration](https://golang.org/pkg/time/#ParseDuration) to delay resource creation. For example, `30s` for 30 seconds or `5m` for 5 minutes. Updating this value by itself will not trigger a delay.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/time/0.12.0/docs/resources/sleep#create_duration Sleep#create_duration}
    */
    readonly createDuration?: string;
    /**
    * [Time duration](https://golang.org/pkg/time/#ParseDuration) to delay resource destroy. For example, `30s` for 30 seconds or `5m` for 5 minutes. Updating this value by itself will not trigger a delay. This value or any updates to it must be successfully applied into the Terraform state before destroying this resource to take effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/time/0.12.0/docs/resources/sleep#destroy_duration Sleep#destroy_duration}
    */
    readonly destroyDuration?: string;
    /**
    * (Optional) Arbitrary map of values that, when changed, will run any creation or destroy delays again. See [the main provider documentation](../index.md) for more information.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/time/0.12.0/docs/resources/sleep#triggers Sleep#triggers}
    */
    readonly triggers?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/time/0.12.0/docs/resources/sleep time_sleep}
*/
export declare class Sleep extends cdktf.TerraformResource {
    static readonly tfResourceType = "time_sleep";
    /**
    * Generates CDKTF code for importing a Sleep resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Sleep to import
    * @param importFromId The id of the existing Sleep that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/time/0.12.0/docs/resources/sleep#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Sleep to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/time/0.12.0/docs/resources/sleep time_sleep} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SleepConfig = {}
    */
    constructor(scope: Construct, id: string, config?: SleepConfig);
    private _createDuration?;
    get createDuration(): string;
    set createDuration(value: string);
    resetCreateDuration(): void;
    get createDurationInput(): string | undefined;
    private _destroyDuration?;
    get destroyDuration(): string;
    set destroyDuration(value: string);
    resetDestroyDuration(): void;
    get destroyDurationInput(): string | undefined;
    get id(): string;
    private _triggers?;
    get triggers(): {
        [key: string]: string;
    };
    set triggers(value: {
        [key: string]: string;
    });
    resetTriggers(): void;
    get triggersInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
