/*
 * Decompiled with CFR 0.152.
 */
package lightgbm.sklearn;

import lightgbm.sklearn.Booster;
import lightgbm.sklearn.HasBooster;
import lightgbm.sklearn.HasLightGBMOptions;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.lightgbm.LightGBMUtil;
import sklearn.Estimator;

public class BoosterUtil {
    private BoosterUtil() {
    }

    public static <E extends Estimator> int getNumberOfFeatures(E estimator) {
        GBDT gbdt = BoosterUtil.getGBDT((HasBooster)((Object)estimator));
        String[] featureNames = gbdt.getFeatureNames();
        return featureNames.length;
    }

    public static <E extends Estimator & HasLightGBMOptions> MiningModel encodeModel(E estimator, Schema schema) {
        GBDT gbdt = BoosterUtil.getGBDT((HasBooster)estimator);
        Integer numIteration = (Integer)estimator.getOption("num_iteration", null);
        Boolean compact = (Boolean)estimator.getOption("compact", Boolean.TRUE);
        Schema lgbmSchema = LightGBMUtil.toLightGBMSchema((GBDT)gbdt, (Schema)schema);
        MiningModel miningModel = gbdt.encodeMiningModel(numIteration, compact.booleanValue(), lgbmSchema);
        return miningModel;
    }

    private static GBDT getGBDT(HasBooster hasBooster) {
        Booster booster = hasBooster.getBooster();
        return booster.getGBDT();
    }
}

