/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.gradient_boosting;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import sklearn.HasEstimatorEnsemble;
import sklearn.Regressor;
import sklearn.ensemble.gradient_boosting.GradientBoostingUtil;
import sklearn.ensemble.gradient_boosting.HasDefaultValue;
import sklearn.tree.DecisionTreeRegressor;
import sklearn.tree.HasTreeOptions;

public class GradientBoostingRegressor
extends Regressor
implements HasEstimatorEnsemble<DecisionTreeRegressor>,
HasTreeOptions {
    public GradientBoostingRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        if (this.containsKey("n_features")) {
            return ValueUtil.asInt((Number)((Number)this.get("n_features")));
        }
        return super.getNumberOfFeatures();
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public MiningModel encodeModel(Schema schema) {
        HasDefaultValue init = this.getInit();
        return GradientBoostingUtil.encodeGradientBoosting(this, init.getDefaultValue(), this.getLearningRate(), schema);
    }

    public HasDefaultValue getInit() {
        return this.get("init_", HasDefaultValue.class);
    }

    public Number getLearningRate() {
        return (Number)this.get("learning_rate");
    }

    @Override
    public List<? extends DecisionTreeRegressor> getEstimators() {
        return this.getArray("estimators_", DecisionTreeRegressor.class);
    }
}

