/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Row;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.DOMUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn.TypeUtil;

public class LabelEncoder
extends Transformer {
    public LabelEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<?> classes = this.getClasses();
        return TypeUtil.getDataType(classes, DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<?> classes = this.getClasses();
        ClassDictUtil.checkSize(1, features);
        Feature feature = features.get(0);
        ArrayList<String> categories = new ArrayList<String>();
        for (int i = 0; i < classes.size(); ++i) {
            String category = ValueUtil.formatValue(classes.get(i));
            categories.add(category);
        }
        FieldName name = this.createName(feature);
        DerivedField derivedField = encoder.getDerivedField(name);
        if (derivedField == null) {
            DocumentBuilder documentBuilder = DOMUtil.createDocumentBuilder();
            InlineTable inlineTable = new InlineTable();
            List<String> columns = Arrays.asList("input", "output");
            for (int i = 0; i < categories.size(); ++i) {
                List<String> values = Arrays.asList((String)categories.get(i), String.valueOf(i));
                Row row = DOMUtil.createRow((DocumentBuilder)documentBuilder, columns, values);
                inlineTable.addRows(new Row[]{row});
            }
            encoder.toCategorical(feature.getName(), categories);
            MapValues mapValues = new MapValues().addFieldColumnPairs(new FieldColumnPair[]{new FieldColumnPair(feature.getName(), columns.get(0))}).setOutputColumn(columns.get(1)).setInlineTable(inlineTable);
            derivedField = encoder.createDerivedField(name, OpType.CATEGORICAL, DataType.INTEGER, (Expression)mapValues);
        }
        return Collections.singletonList(new CategoricalFeature((PMMLEncoder)encoder, (TypeDefinitionField)derivedField, categories));
    }

    public List<?> getClasses() {
        return this.getArray("classes_");
    }
}

