/*
 * Decompiled with CFR 0.152.
 */
package tpot.builtins;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.PMMLEncoder;
import tpot.builtins.ContinuousOutputFeature;
import tpot.builtins.OutputUtil;

public class CategoricalOutputFeature
extends CategoricalFeature {
    private Output output = null;

    public CategoricalOutputFeature(PMMLEncoder encoder, Output output, OutputField outputField, List<String> values) {
        this(encoder, output, outputField.getName(), outputField.getDataType(), values);
    }

    public CategoricalOutputFeature(PMMLEncoder encoder, Output output, FieldName name, DataType dataType, List<String> values) {
        super(encoder, name, dataType, values);
        this.setOutput(output);
    }

    public ContinuousOutputFeature toContinuousFeature() {
        PMMLEncoder encoder = this.ensureEncoder();
        Output output = this.getOutput();
        OutputField outputField = OutputUtil.getOutputField(output, this.getName());
        DataType dataType = outputField.getDataType();
        switch (dataType) {
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        outputField.setOpType(OpType.CONTINUOUS);
        return new ContinuousOutputFeature(encoder, output, outputField.getName(), outputField.getDataType());
    }

    public ContinuousOutputFeature toContinuousFeature(DataType dataType) {
        return (ContinuousOutputFeature)super.toContinuousFeature(dataType);
    }

    public Output getOutput() {
        return this.output;
    }

    private void setOutput(Output output) {
        if (output == null) {
            throw new IllegalArgumentException();
        }
        this.output = output;
    }
}

