/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.SigmoidTransformation;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.lightgbm.Classification;
import org.jpmml.lightgbm.Tree;

public class BinomialLogisticRegression
extends Classification {
    private double sigmoid_;

    public BinomialLogisticRegression(double sigmoid) {
        super(2);
        this.sigmoid_ = sigmoid;
    }

    @Override
    public MiningModel encodeMiningModel(List<Tree> trees, Integer numIteration, Schema schema) {
        Schema segmentSchema = new Schema((Label)new ContinuousLabel(null, DataType.DOUBLE), schema.getFeatures());
        MiningModel miningModel = BinomialLogisticRegression.createMiningModel(trees, numIteration, segmentSchema).setOutput(ModelUtil.createPredictedOutput((FieldName)FieldName.create((String)"lgbmValue"), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[]{new SigmoidTransformation((Number)(-1.0 * this.sigmoid_))}));
        return MiningModelUtil.createBinaryLogisticClassification((Model)miningModel, (double)1.0, (double)0.0, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.NONE, (boolean)true, (Schema)schema);
    }
}

