/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.lightgbm.ObjectiveFunction;

public abstract class Classification
extends ObjectiveFunction {
    private int num_class_;

    public Classification(int num_class) {
        this.num_class_ = num_class;
    }

    @Override
    public Label encodeLabel(FieldName targetField, List<String> targetCategories, PMMLEncoder encoder) {
        targetCategories = this.prepareTargetCategories(targetCategories);
        DataField dataField = encoder.createDataField(targetField, OpType.CATEGORICAL, DataType.STRING, targetCategories);
        return new CategoricalLabel(dataField);
    }

    private List<String> prepareTargetCategories(List<String> targetCategories) {
        if (targetCategories != null) {
            if (targetCategories.size() != this.num_class_) {
                throw new IllegalArgumentException();
            }
            return targetCategories;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.num_class_; ++i) {
            result.add(String.valueOf(i));
        }
        return result;
    }

    public int getNumClass() {
        return this.num_class_;
    }
}

