/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.Interval;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ImportanceDecorator;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.lightgbm.Section;

public class LightGBMUtil {
    static final Function<String, Integer> CATEGORY_PARSER = new Function<String, Integer>(){

        public Integer apply(String string) {
            return Integer.valueOf(string);
        }
    };
    static final Function<Integer, String> CATEGORY_FORMATTER = new Function<Integer, String>(){

        public String apply(Integer integer) {
            return ValueUtil.formatValue((Number)integer);
        }
    };

    private LightGBMUtil() {
    }

    public static GBDT loadGBDT(InputStream is) throws IOException {
        return LightGBMUtil.loadGBDT(LightGBMUtil.parseText(is));
    }

    public static GBDT loadGBDT(Iterator<String> lines) {
        List<Section> sections = LightGBMUtil.loadText(lines);
        GBDT gbdt = new GBDT();
        gbdt.load(sections);
        return gbdt;
    }

    public static Schema toLightGBMSchema(final GBDT gbdt, final Schema schema) {
        Function<Feature, Feature> function = new Function<Feature, Feature>(){
            private String[] featureNames;
            private List<Feature> features;
            {
                this.featureNames = gbdt.getFeatureNames();
                this.features = schema.getFeatures();
                if (this.featureNames.length != this.features.size()) {
                    throw new IllegalArgumentException();
                }
            }

            public Feature apply(Feature feature) {
                Boolean binary;
                int index = this.features.indexOf(feature);
                if (index < 0) {
                    throw new IllegalArgumentException();
                }
                Double importance = gbdt.getFeatureImportance(this.featureNames[index]);
                if (importance != null) {
                    ModelEncoder encoder = (ModelEncoder)feature.getEncoder();
                    ImportanceDecorator importanceDecorator = new ImportanceDecorator().setImportance(importance);
                    encoder.addDecorator(feature.getName(), (Decorator)importanceDecorator);
                }
                if (feature instanceof BinaryFeature) {
                    BinaryFeature binaryFeature = (BinaryFeature)feature;
                    binary = gbdt.isBinary(index);
                    if (binary != null && binary.booleanValue()) {
                        return binaryFeature;
                    }
                } else if (feature instanceof CategoricalFeature) {
                    CategoricalFeature categoricalFeature = (CategoricalFeature)feature;
                    Boolean categorical = gbdt.isCategorical(index);
                    if (categorical != null && categorical.booleanValue()) {
                        return categoricalFeature;
                    }
                } else if (feature instanceof WildcardFeature) {
                    WildcardFeature wildcardFeature = (WildcardFeature)feature;
                    binary = gbdt.isBinary(index);
                    if (binary != null && binary.booleanValue()) {
                        wildcardFeature.toCategoricalFeature(Arrays.asList("0", "1"));
                        BinaryFeature binaryFeature = new BinaryFeature(wildcardFeature.getEncoder(), wildcardFeature.getName(), wildcardFeature.getDataType(), "1");
                        return binaryFeature;
                    }
                }
                return feature.toContinuousFeature();
            }
        };
        return schema.toTransformedSchema((Function)function);
    }

    private static List<Section> loadText(Iterator<String> lines) {
        ArrayList<Section> sections = new ArrayList<Section>();
        Section section = new Section();
        while (lines.hasNext()) {
            String line = lines.next();
            if ("".equals(line)) {
                if (section.size() <= 0) continue;
                sections.add(section);
                section = new Section();
                continue;
            }
            section.put(line);
        }
        if (section.size() > 0) {
            sections.add(section);
        }
        return sections;
    }

    public static Iterator<String> parseText(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, "US-ASCII");
        List lines = CharStreams.readLines((Readable)reader);
        return lines.iterator();
    }

    public static String[] parseStringArray(String string, int length) {
        String[] result = string.split("\\s");
        if (length > -1 && result.length != length) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public static int[] parseIntArray(String string, int length) {
        String[] values = LightGBMUtil.parseStringArray(string, length);
        int[] result = new int[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(values[i]);
        }
        return result;
    }

    public static long[] parseUnsignedIntArray(String string, int length) {
        String[] values = LightGBMUtil.parseStringArray(string, length);
        long[] result = new long[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Long.parseLong(values[i]);
        }
        return result;
    }

    public static double[] parseDoubleArray(String string, int length) {
        String[] values = LightGBMUtil.parseStringArray(string, length);
        double[] result = new double[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Double.parseDouble(values[i]);
        }
        return result;
    }

    public static boolean isInterval(String string) {
        return string.startsWith("[") && string.endsWith("]");
    }

    public static boolean isBinaryInterval(String string) {
        return string.equals("[0:1]");
    }

    public static boolean isValues(String string) {
        return !LightGBMUtil.isInterval(string);
    }

    public static Interval parseInterval(String string) {
        Interval.Closure closure;
        if (string.length() < 3) {
            throw new IllegalArgumentException();
        }
        String bounds = string.substring(0, 1) + string.substring(string.length() - 1, string.length());
        String margins = string.substring(1, string.length() - 1);
        switch (bounds) {
            case "[]": {
                closure = Interval.Closure.CLOSED_CLOSED;
                break;
            }
            default: {
                throw new IllegalArgumentException(string);
            }
        }
        String[] values = margins.split(":");
        if (values.length != 2) {
            throw new IllegalArgumentException(margins);
        }
        Double leftMargin = Double.valueOf(values[0]);
        Double rightMargin = Double.valueOf(values[1]);
        Interval interval = new Interval(closure).setLeftMargin(leftMargin).setRightMargin(rightMargin);
        return interval;
    }

    public static List<Integer> parseValues(String string) {
        String[] values = string.split(":");
        return Lists.transform(Arrays.asList(values), CATEGORY_PARSER);
    }
}

