/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMML;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.lightgbm.LightGBMUtil;
import org.jpmml.model.MetroJAXBUtil;

public class Main {
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--lgbm-input"}, description="LightGBM text input file", required=true)
    private File input = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true)
    private File output = null;
    @Parameter(names={"--target-name"}, description="Target name. Defaults to \"_target\"")
    private String targetName = null;
    @Parameter(names={"--target-categories"}, description="Target categories. Defaults to 0-based index [0, 1, .., num_class - 1]")
    private List<String> targetCategories = null;
    @Parameter(names={"--num-iteration"}, description="Limit the number of trees. Defaults to all trees")
    private Integer numIteration = null;
    @Parameter(names={"--compact"}, description="Transform LightGBM-style trees to PMML-style trees")
    private boolean transform = false;

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            commander.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            commander.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    private void run() throws Exception {
        GBDT gbdt;
        try (FileInputStream is = new FileInputStream(this.input);){
            gbdt = LightGBMUtil.loadGBDT(is);
        }
        PMML pmml = gbdt.encodePMML(this.targetName != null ? FieldName.create((String)this.targetName) : null, this.targetCategories, this.numIteration, this.transform);
        try (FileOutputStream os = new FileOutputStream(this.output);){
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
        }
    }
}

