/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm;

import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jpmml.lightgbm.LightGBMUtil;

public class Section
extends LinkedHashMap<String, String> {
    public boolean checkId(String id) {
        return id.equals(this.id());
    }

    public String id() {
        Map.Entry entry = (Map.Entry)Iterables.getFirst(this.entrySet(), null);
        if (entry == null) {
            throw new IllegalStateException();
        }
        String key = (String)entry.getKey();
        String value = (String)entry.getValue();
        return value != null ? key + "=" + value : key;
    }

    public int getInt(String key) {
        return Integer.parseInt((String)this.get(key));
    }

    public int[] getIntArray(String key, int length) {
        return LightGBMUtil.parseIntArray((String)this.get(key), length);
    }

    public long parseUnsignedInt(String key) {
        return Long.parseLong((String)this.get(key));
    }

    public long[] getUnsignedIntArray(String key, int length) {
        return LightGBMUtil.parseUnsignedIntArray((String)this.get(key), length);
    }

    public double getDouble(String key) {
        return Double.parseDouble((String)this.get(key));
    }

    public double[] getDoubleArray(String key, int length) {
        return LightGBMUtil.parseDoubleArray((String)this.get(key), length);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public String[] getStringArray(String key, int length) {
        return LightGBMUtil.parseStringArray((String)this.get(key), length);
    }

    public String put(String string) {
        return this.put(string, '=');
    }

    @Override
    public String put(String string, char separator) {
        String value;
        String key;
        int index = string.indexOf(separator);
        if (index > 0) {
            key = string.substring(0, index);
            value = string.substring(index + 1);
        } else {
            key = string;
            value = null;
        }
        return this.put(key, value);
    }
}

