/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import javassist.ByteArrayClassPath;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jpmml.agent.TransformationUtil;

public class ExtensionListRemover
implements ClassFileTransformer {
    private ClassPool classPool = ClassPool.getDefault();

    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> clazz, ProtectionDomain protectionDomain, byte[] buffer) throws IllegalClassFormatException {
        if (className.startsWith("org/dmg/pmml/")) {
            className = className.replace('/', '.');
            this.classPool.insertClassPath((ClassPath)new ByteArrayClassPath(className, buffer));
            try {
                CtClass ctClass = this.classPool.get(className);
                try {
                    ctClass = this.transform(ctClass);
                }
                catch (NotFoundException nfe) {
                    return null;
                }
                return ctClass.toBytecode();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private CtClass transform(CtClass ctClass) throws CannotCompileException, NotFoundException {
        TransformationUtil.removeElementList(ctClass, "extensions");
        return ctClass;
    }
}

