/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Decisions;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasExpression;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.Property;
import org.jpmml.schema.Added;
import org.jpmml.schema.Deprecated;
import org.jpmml.schema.Optional;
import org.jpmml.schema.Required;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "decisions", "expression"})
@XmlRootElement(name="OutputField", namespace="http://www.dmg.org/PMML-4_3")
public class OutputField
extends Field
implements HasExpression<OutputField>,
HasExtensions<OutputField> {
    @XmlAttribute(name="name", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    private FieldName name;
    @XmlAttribute(name="displayName")
    private String displayName;
    @XmlAttribute(name="optype")
    private OpType opType;
    @XmlAttribute(name="dataType", required=true)
    @Required(value=Version.PMML_4_3)
    private DataType dataType;
    @XmlAttribute(name="targetField")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @Optional(value=Version.PMML_3_1)
    private FieldName targetField;
    @XmlAttribute(name="x-reportField")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @org.jpmml.schema.Extension
    private FieldName reportField;
    @XmlAttribute(name="feature")
    private ResultFeature resultFeature;
    @XmlAttribute(name="value")
    private String value;
    @XmlAttribute(name="ruleFeature")
    @Added(value=Version.PMML_4_0)
    @Deprecated(value=Version.PMML_4_2)
    private RuleFeature ruleFeature;
    @XmlAttribute(name="algorithm")
    @Added(value=Version.PMML_4_0)
    private Algorithm algorithm;
    @XmlAttribute(name="rank")
    private Integer rank;
    @XmlAttribute(name="rankBasis")
    @Added(value=Version.PMML_4_0)
    private RankBasis rankBasis;
    @XmlAttribute(name="rankOrder")
    @Added(value=Version.PMML_4_0)
    private RankOrder rankOrder;
    @XmlAttribute(name="isMultiValued")
    @XmlSchemaType(name="anySimpleType")
    @Added(value=Version.PMML_4_0)
    @Deprecated(value=Version.PMML_4_2)
    private String isMultiValued;
    @XmlAttribute(name="segmentId")
    @Added(value=Version.PMML_4_1)
    private String segmentId;
    @XmlAttribute(name="isFinalResult")
    @Added(value=Version.PMML_4_3)
    private Boolean finalResult;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name="Decisions", namespace="http://www.dmg.org/PMML-4_3")
    @Added(value=Version.PMML_4_1)
    private Decisions decisions;
    @XmlElements(value={@XmlElement(name="Constant", namespace="http://www.dmg.org/PMML-4_3", type=Constant.class), @XmlElement(name="FieldRef", namespace="http://www.dmg.org/PMML-4_3", type=FieldRef.class), @XmlElement(name="NormContinuous", namespace="http://www.dmg.org/PMML-4_3", type=NormContinuous.class), @XmlElement(name="NormDiscrete", namespace="http://www.dmg.org/PMML-4_3", type=NormDiscrete.class), @XmlElement(name="Discretize", namespace="http://www.dmg.org/PMML-4_3", type=Discretize.class), @XmlElement(name="MapValues", namespace="http://www.dmg.org/PMML-4_3", type=MapValues.class), @XmlElement(name="TextIndex", namespace="http://www.dmg.org/PMML-4_3", type=TextIndex.class), @XmlElement(name="Apply", namespace="http://www.dmg.org/PMML-4_3", type=Apply.class), @XmlElement(name="Aggregate", namespace="http://www.dmg.org/PMML-4_3", type=Aggregate.class), @XmlElement(name="Lag", namespace="http://www.dmg.org/PMML-4_3", type=Lag.class)})
    @Added(value=Version.PMML_4_1)
    private Expression expression;
    private static final Integer DEFAULT_RANK = 1;
    private static final Boolean DEFAULT_FINAL_RESULT = true;
    private static final long serialVersionUID = 67305478L;

    public OutputField() {
    }

    public OutputField(@Property(value="name") FieldName name, @Property(value="dataType") DataType dataType) {
        this.name = name;
        this.dataType = dataType;
    }

    @Override
    public FieldName getName() {
        return this.name;
    }

    @Override
    public OutputField setName(@Property(value="name") FieldName name) {
        this.name = name;
        return this;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public OutputField setDisplayName(@Property(value="displayName") String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public OpType getOpType() {
        return this.opType;
    }

    @Override
    public OutputField setOpType(@Property(value="opType") OpType opType) {
        this.opType = opType;
        return this;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public OutputField setDataType(@Property(value="dataType") DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public FieldName getTargetField() {
        return this.targetField;
    }

    public OutputField setTargetField(@Property(value="targetField") FieldName targetField) {
        this.targetField = targetField;
        return this;
    }

    public FieldName getReportField() {
        return this.reportField;
    }

    public OutputField setReportField(@Property(value="reportField") FieldName reportField) {
        this.reportField = reportField;
        return this;
    }

    public ResultFeature getResultFeature() {
        if (this.resultFeature == null) {
            return ResultFeature.PREDICTED_VALUE;
        }
        return this.resultFeature;
    }

    public OutputField setResultFeature(@Property(value="resultFeature") ResultFeature resultFeature) {
        this.resultFeature = resultFeature;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public OutputField setValue(@Property(value="value") String value) {
        this.value = value;
        return this;
    }

    public RuleFeature getRuleFeature() {
        if (this.ruleFeature == null) {
            return RuleFeature.CONSEQUENT;
        }
        return this.ruleFeature;
    }

    public OutputField setRuleFeature(@Property(value="ruleFeature") RuleFeature ruleFeature) {
        this.ruleFeature = ruleFeature;
        return this;
    }

    public Algorithm getAlgorithm() {
        if (this.algorithm == null) {
            return Algorithm.EXCLUSIVE_RECOMMENDATION;
        }
        return this.algorithm;
    }

    public OutputField setAlgorithm(@Property(value="algorithm") Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public Integer getRank() {
        if (this.rank == null) {
            return DEFAULT_RANK;
        }
        return this.rank;
    }

    public OutputField setRank(@Property(value="rank") Integer rank) {
        this.rank = rank;
        return this;
    }

    public RankBasis getRankBasis() {
        if (this.rankBasis == null) {
            return RankBasis.CONFIDENCE;
        }
        return this.rankBasis;
    }

    public OutputField setRankBasis(@Property(value="rankBasis") RankBasis rankBasis) {
        this.rankBasis = rankBasis;
        return this;
    }

    public RankOrder getRankOrder() {
        if (this.rankOrder == null) {
            return RankOrder.DESCENDING;
        }
        return this.rankOrder;
    }

    public OutputField setRankOrder(@Property(value="rankOrder") RankOrder rankOrder) {
        this.rankOrder = rankOrder;
        return this;
    }

    public String getIsMultiValued() {
        if (this.isMultiValued == null) {
            return "0";
        }
        return this.isMultiValued;
    }

    public OutputField setIsMultiValued(@Property(value="isMultiValued") String isMultiValued) {
        this.isMultiValued = isMultiValued;
        return this;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public OutputField setSegmentId(@Property(value="segmentId") String segmentId) {
        this.segmentId = segmentId;
        return this;
    }

    public boolean isFinalResult() {
        if (this.finalResult == null) {
            return DEFAULT_FINAL_RESULT;
        }
        return this.finalResult;
    }

    public OutputField setFinalResult(@Property(value="finalResult") Boolean finalResult) {
        this.finalResult = finalResult;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Decisions getDecisions() {
        return this.decisions;
    }

    public OutputField setDecisions(@Property(value="decisions") Decisions decisions) {
        this.decisions = decisions;
        return this;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public OutputField setExpression(@Property(value="expression") Expression expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public OutputField addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getDecisions(), (Visitable)this.getExpression());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    @Added(value=Version.PMML_4_0)
    public static enum RuleFeature {
        ANTECEDENT("antecedent"),
        CONSEQUENT("consequent"),
        RULE("rule"),
        RULE_ID("ruleId"),
        CONFIDENCE("confidence"),
        SUPPORT("support"),
        LIFT("lift"),
        LEVERAGE("leverage"),
        AFFINITY("affinity");

        private final String value;

        private RuleFeature(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static RuleFeature fromValue(String v) {
            for (RuleFeature c : RuleFeature.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    @Added(value=Version.PMML_4_0)
    public static enum RankOrder {
        DESCENDING("descending"),
        ASCENDING("ascending");

        private final String value;

        private RankOrder(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static RankOrder fromValue(String v) {
            for (RankOrder c : RankOrder.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    @Added(value=Version.PMML_4_0)
    public static enum RankBasis {
        CONFIDENCE("confidence"),
        SUPPORT("support"),
        LIFT("lift"),
        LEVERAGE("leverage"),
        AFFINITY("affinity");

        private final String value;

        private RankBasis(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static RankBasis fromValue(String v) {
            for (RankBasis c : RankBasis.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    @Added(value=Version.PMML_4_0)
    public static enum Algorithm {
        RECOMMENDATION("recommendation"),
        EXCLUSIVE_RECOMMENDATION("exclusiveRecommendation"),
        RULE_ASSOCIATION("ruleAssociation");

        private final String value;

        private Algorithm(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Algorithm fromValue(String v) {
            for (Algorithm c : Algorithm.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

