/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.clustering.CenterFields;
import org.dmg.pmml.clustering.Cluster;
import org.dmg.pmml.clustering.ClusteringField;
import org.dmg.pmml.clustering.MissingValueWeights;
import org.jpmml.model.Property;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Required;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "localTransformations", "comparisonMeasure", "clusteringFields", "centerFields", "missingValueWeights", "clusters", "modelVerification"})
@XmlRootElement(name="ClusteringModel", namespace="http://www.dmg.org/PMML-4_3")
public class ClusteringModel
extends Model
implements HasExtensions<ClusteringModel> {
    @XmlAttribute(name="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="modelClass", required=true)
    private ModelClass modelClass;
    @XmlAttribute(name="numberOfClusters", required=true)
    private int numberOfClusters;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @org.jpmml.schema.Extension
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_3", required=true)
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_3")
    @Added(value=Version.PMML_4_0)
    private ModelExplanation modelExplanation;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name="ComparisonMeasure", namespace="http://www.dmg.org/PMML-4_3", required=true)
    private ComparisonMeasure comparisonMeasure;
    @XmlElement(name="ClusteringField", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @Required(value=Version.PMML_4_2)
    private List<ClusteringField> clusteringFields;
    @XmlElement(name="CenterFields", namespace="http://www.dmg.org/PMML-4_3")
    @Removed(value=Version.PMML_3_2)
    private CenterFields centerFields;
    @XmlElement(name="MissingValueWeights", namespace="http://www.dmg.org/PMML-4_3")
    private MissingValueWeights missingValueWeights;
    @XmlElement(name="Cluster", namespace="http://www.dmg.org/PMML-4_3", required=true)
    private List<Cluster> clusters;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67305478L;

    public ClusteringModel() {
    }

    public ClusteringModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="modelClass") ModelClass modelClass, @Property(value="numberOfClusters") int numberOfClusters, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="comparisonMeasure") ComparisonMeasure comparisonMeasure, @Property(value="clusteringFields") List<ClusteringField> clusteringFields, @Property(value="clusters") List<Cluster> clusters) {
        this.miningFunction = miningFunction;
        this.modelClass = modelClass;
        this.numberOfClusters = numberOfClusters;
        this.miningSchema = miningSchema;
        this.comparisonMeasure = comparisonMeasure;
        this.clusteringFields = clusteringFields;
        this.clusters = clusters;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public ClusteringModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public ClusteringModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public ClusteringModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public ModelClass getModelClass() {
        return this.modelClass;
    }

    public ClusteringModel setModelClass(@Property(value="modelClass") ModelClass modelClass) {
        this.modelClass = modelClass;
        return this;
    }

    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public ClusteringModel setNumberOfClusters(@Property(value="numberOfClusters") int numberOfClusters) {
        this.numberOfClusters = numberOfClusters;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public ClusteringModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public ClusteringModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public ClusteringModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public ClusteringModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public ClusteringModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public ClusteringModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public ClusteringModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public ComparisonMeasure getComparisonMeasure() {
        return this.comparisonMeasure;
    }

    public ClusteringModel setComparisonMeasure(@Property(value="comparisonMeasure") ComparisonMeasure comparisonMeasure) {
        this.comparisonMeasure = comparisonMeasure;
        return this;
    }

    public List<ClusteringField> getClusteringFields() {
        if (this.clusteringFields == null) {
            this.clusteringFields = new ArrayList<ClusteringField>();
        }
        return this.clusteringFields;
    }

    public CenterFields getCenterFields() {
        return this.centerFields;
    }

    public ClusteringModel setCenterFields(@Property(value="centerFields") CenterFields centerFields) {
        this.centerFields = centerFields;
        return this;
    }

    public MissingValueWeights getMissingValueWeights() {
        return this.missingValueWeights;
    }

    public ClusteringModel setMissingValueWeights(@Property(value="missingValueWeights") MissingValueWeights missingValueWeights) {
        this.missingValueWeights = missingValueWeights;
        return this;
    }

    public List<Cluster> getClusters() {
        if (this.clusters == null) {
            this.clusters = new ArrayList<Cluster>();
        }
        return this.clusters;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public ClusteringModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public ClusteringModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasClusteringFields() {
        return this.clusteringFields != null && this.clusteringFields.size() > 0;
    }

    public ClusteringModel addClusteringFields(ClusteringField ... clusteringFields) {
        this.getClusteringFields().addAll(Arrays.asList(clusteringFields));
        return this;
    }

    public boolean hasClusters() {
        return this.clusters != null && this.clusters.size() > 0;
    }

    public ClusteringModel addClusters(Cluster ... clusters) {
        this.getClusters().addAll(Arrays.asList(clusters));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getLocalTransformations(), this.getComparisonMeasure());
            }
            if (status == VisitorAction.CONTINUE && this.hasClusteringFields()) {
                status = PMMLObject.traverse(visitor, this.getClusteringFields());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getCenterFields(), (Visitable)this.getMissingValueWeights());
            }
            if (status == VisitorAction.CONTINUE && this.hasClusters()) {
                status = PMMLObject.traverse(visitor, this.getClusters());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ModelClass {
        CENTER_BASED("centerBased"),
        DISTRIBUTION_BASED("distributionBased");

        private final String value;

        private ModelClass(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static ModelClass fromValue(String v) {
            for (ModelClass c : ModelClass.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

