/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dmg.pmml.PMMLObject;

public class ReflectionUtil {
    private static final FieldFilter FIELD_SELECTOR = new FieldFilter(){

        @Override
        public boolean accept(Field field) {
            return this.hasValidName(field);
        }

        private boolean hasValidName(Field field) {
            String name = field.getName();
            if (name.length() > 0) {
                return Character.isLetterOrDigit(name.charAt(0));
            }
            return false;
        }
    };
    private static final FieldFilter INSTANCE_FIELD_SELECTOR = new FieldFilter(){

        @Override
        public boolean accept(Field field) {
            if (FIELD_SELECTOR.accept(field)) {
                int modifiers = field.getModifiers();
                return !Modifier.isStatic(modifiers);
            }
            return false;
        }
    };
    private static final ConcurrentMap<Class<?>, List<Field>> classFields = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, List<Field>> classInstanceFields = new ConcurrentHashMap();
    private static final Set<Class<?>> primitiveWrapperClasses = new HashSet<Class>(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class));

    private ReflectionUtil() {
    }

    public static <E extends PMMLObject> void copyState(E from, E to) {
        Class<?> toClazz;
        Class<?> fromClazz = from.getClass();
        if (!fromClazz.isAssignableFrom(toClazz = to.getClass())) {
            throw new IllegalArgumentException();
        }
        List<Field> fields = ReflectionUtil.getInstanceFields(fromClazz);
        for (Field field : fields) {
            E value = ReflectionUtil.getFieldValue(field, from);
            ReflectionUtil.setFieldValue(field, to, value);
        }
    }

    public static Field getField(Class<?> clazz, String name) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new RuntimeException(new NoSuchFieldException(name));
    }

    public static List<Field> getFields(Class<?> clazz) {
        List<Field> result = (List<Field>)classFields.get(clazz);
        if (result == null) {
            result = ReflectionUtil.loadFields(clazz, FIELD_SELECTOR);
            classFields.putIfAbsent(clazz, result);
        }
        return result;
    }

    public static List<Field> getInstanceFields(Class<?> clazz) {
        List<Field> result = (List<Field>)classInstanceFields.get(clazz);
        if (result == null) {
            result = ReflectionUtil.loadFields(clazz, INSTANCE_FIELD_SELECTOR);
            classInstanceFields.putIfAbsent(clazz, result);
        }
        return result;
    }

    public static <E> E getFieldValue(Field field, Object object) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return (E)field.get(object);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public static void setFieldValue(Field field, Object object, Object value) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return primitiveWrapperClasses.contains(clazz);
    }

    public static boolean isDefaultValue(Object value) {
        if (value instanceof Boolean) {
            return Boolean.FALSE.equals(value);
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return character.charValue() == '\u0000';
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Double.compare(number.doubleValue(), 0.0) == 0;
        }
        return false;
    }

    private static List<Field> loadFields(Class<?> clazz, FieldFilter filter) {
        ArrayList<Field> result = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!filter.accept(field)) continue;
                result.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return Collections.unmodifiableList(result);
    }

    private static interface FieldFilter {
        public boolean accept(Field var1);
    }
}

