/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.serpent;

import java.io.Serializable;

public class ComplexNumber
implements Serializable {
    private static final long serialVersionUID = 5396759273405612137L;
    public double real;
    public double imaginary;

    public ComplexNumber(double r, double i) {
        this.real = r;
        this.imaginary = i;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.real);
        if (this.imaginary > 0.0) {
            sb.append('+');
        }
        return sb.append(this.imaginary).append('i').toString();
    }

    public double Magnitude() {
        return Math.sqrt(this.real * this.real + this.imaginary * this.imaginary);
    }

    public void add(ComplexNumber other) {
        this.real += other.real;
        this.imaginary += other.imaginary;
    }

    public void subtract(ComplexNumber other) {
        this.real -= other.real;
        this.imaginary -= other.imaginary;
    }

    public void multiply(ComplexNumber other) {
        double new_real = this.real * other.real - this.imaginary * other.imaginary;
        double new_imaginary = this.real * other.imaginary + this.imaginary * other.real;
        this.real = new_real;
        this.imaginary = new_imaginary;
    }

    public void divide(ComplexNumber other) {
        double new_real = (this.real * other.real + this.imaginary * other.imaginary) / (other.real * other.real + other.imaginary * other.imaginary);
        double new_imaginary = (this.imaginary * other.real - this.real * other.imaginary) / (other.real * other.real + other.imaginary * other.imaginary);
        this.real = new_real;
        this.imaginary = new_imaginary;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComplexNumber)) {
            return false;
        }
        ComplexNumber other = (ComplexNumber)obj;
        return this.real == other.real && this.imaginary == other.imaginary;
    }

    public int hashCode() {
        Double r = new Double(this.real);
        Double i = new Double(this.imaginary);
        return r.hashCode() ^ i.hashCode();
    }
}

