/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.base.Objects;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;

public class CategoricalFeature
extends Feature {
    private List<String> values = null;

    public CategoricalFeature(PMMLEncoder encoder, DataField dataField) {
        this(encoder, (TypeDefinitionField)dataField, PMMLUtil.getValues(dataField));
    }

    public CategoricalFeature(PMMLEncoder encoder, TypeDefinitionField field, List<String> values) {
        this(encoder, field.getName(), field.getDataType(), values);
    }

    public CategoricalFeature(PMMLEncoder encoder, FieldName name, DataType dataType, List<String> values) {
        super(encoder, name, dataType);
        this.setValues(values);
    }

    @Override
    public ContinuousFeature toContinuousFeature() {
        PMMLEncoder encoder = this.ensureEncoder();
        TypeDefinitionField field = encoder.getField(this.getName());
        DataType dataType = field.getDataType();
        switch (dataType) {
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        field.setOpType(OpType.CONTINUOUS);
        return new ContinuousFeature(encoder, field);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.getValues());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CategoricalFeature) {
            CategoricalFeature that = (CategoricalFeature)object;
            return super.equals(object) && Objects.equals(this.getValues(), that.getValues());
        }
        return false;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("values", this.getValues());
    }

    public String getValue(int index) {
        List<String> values = this.getValues();
        return values.get(index);
    }

    public List<String> getValues() {
        return this.values;
    }

    private void setValues(List<String> values) {
        if (values == null || values.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.values = values;
    }
}

