/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.base.Objects;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.Label;
import org.jpmml.converter.PMMLUtil;

public class CategoricalLabel
extends Label {
    private List<String> values = null;

    public CategoricalLabel(DataField dataField) {
        this(dataField.getName(), dataField.getDataType(), PMMLUtil.getValues(dataField));
    }

    public CategoricalLabel(FieldName name, DataType dataType, List<String> values) {
        super(name, dataType);
        this.setValues(values);
    }

    @Override
    public CategoricalLabel toAnonymousLabel() {
        return new CategoricalLabel(null, this.getDataType(), this.getValues());
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.getValues());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CategoricalLabel) {
            CategoricalLabel that = (CategoricalLabel)object;
            return super.equals(object) && Objects.equals(this.getValues(), that.getValues());
        }
        return false;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("values", this.getValues());
    }

    public int size() {
        List<String> values = this.getValues();
        return values.size();
    }

    public String getValue(int index) {
        List<String> values = this.getValues();
        return values.get(index);
    }

    public List<String> getValues() {
        return this.values;
    }

    private void setValues(List<String> values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        this.values = values;
    }
}

