/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.Feature;
import org.jpmml.converter.HasDerivedName;

public class FeatureUtil {
    private static final Joiner JOINER = Joiner.on((String)", ");

    private FeatureUtil() {
    }

    public static FieldName createName(String function, Feature feature) {
        return FieldName.create((String)(function + "(" + FeatureUtil.getName(feature).getValue() + ")"));
    }

    public static FieldName createName(String function, Feature feature, int index) {
        return FieldName.create((String)(function + "(" + FeatureUtil.getName(feature).getValue() + ")" + "[" + index + "]"));
    }

    public static FieldName getName(Feature feature) {
        if (feature instanceof HasDerivedName) {
            HasDerivedName hasDerivedName = (HasDerivedName)((Object)feature);
            return hasDerivedName.getDerivedName();
        }
        return feature.getName();
    }

    public static String formatFeatureList(List<Feature> features) {
        Function<Feature, FieldName> function = new Function<Feature, FieldName>(){

            public FieldName apply(Feature feature) {
                return FeatureUtil.getName(feature);
            }
        };
        return FeatureUtil.formatNameList(Lists.transform(features, (Function)function));
    }

    public static String formatNameList(List<FieldName> names) {
        ArrayList<String> values;
        Function<FieldName, String> function = new Function<FieldName, String>(){

            public String apply(FieldName name) {
                return name.getValue();
            }
        };
        if (names.size() <= 5) {
            values = Lists.transform(names, (Function)function);
        } else {
            values = new ArrayList<String>();
            values.addAll(Lists.transform(names.subList(0, 2), (Function)function));
            values.add("..");
            values.addAll(Lists.transform(names.subList(names.size() - 2, names.size()), (Function)function));
        }
        return JOINER.join(values);
    }
}

