/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.model.visitors.DataDictionaryCleaner;
import org.jpmml.model.visitors.DeepFieldResolver;
import org.jpmml.model.visitors.FieldRenamer;
import org.jpmml.model.visitors.MiningSchemaCleaner;
import org.jpmml.model.visitors.TransformationDictionaryCleaner;

public class ModelEncoder
extends PMMLEncoder {
    private Map<FieldName, List<Decorator>> decorators = new LinkedHashMap<FieldName, List<Decorator>>();
    private Map<FieldName, FieldName> renamedFields = new LinkedHashMap<FieldName, FieldName>();

    public PMML encodePMML(Model model) {
        PMML pmml = this.encodePMML();
        pmml.addModels(new Model[]{model});
        List<DeepFieldResolver> visitors = Arrays.asList(new MiningSchemaCleaner(), new TransformationDictionaryCleaner(), new DataDictionaryCleaner());
        for (Visitor visitor : visitors) {
            visitor.applyTo((Visitable)pmml);
        }
        MiningSchema miningSchema = model.getMiningSchema();
        List list = miningSchema.getMiningFields();
        for (MiningField miningField : list) {
            FieldName fieldName = miningField.getName();
            List<Decorator> decorators = this.getDecorators(fieldName);
            if (decorators == null) continue;
            DataField dataField = this.getDataField(fieldName);
            if (dataField == null) {
                throw new IllegalArgumentException();
            }
            for (Decorator decorator : decorators) {
                decorator.decorate(dataField, miningField);
            }
        }
        Set<Map.Entry<FieldName, FieldName>> entries = this.renamedFields.entrySet();
        for (Map.Entry entry : entries) {
            FieldRenamer renamer = new FieldRenamer((FieldName)entry.getKey(), (FieldName)entry.getValue());
            renamer.applyTo((Visitable)pmml);
        }
        return pmml;
    }

    public List<Decorator> getDecorators(FieldName name) {
        return this.decorators.get(name);
    }

    public void addDecorator(FieldName name, Decorator decorator) {
        List<Decorator> decorators = this.decorators.get(name);
        if (decorators == null) {
            decorators = new ArrayList<Decorator>();
            this.decorators.put(name, decorators);
        }
        decorators.add(decorator);
    }

    public FieldName getFinalName(FieldName name) {
        FieldName renamedName = this.renamedFields.get(name);
        if (renamedName != null) {
            return renamedName;
        }
        return name;
    }

    public void renameField(FieldName name, FieldName renamedName) {
        this.renamedFields.put(name, renamedName);
    }
}

