/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Entity;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.ValueUtil;

public class ModelUtil {
    private ModelUtil() {
    }

    public static MiningSchema createMiningSchema(Label label) {
        FieldName name;
        MiningSchema miningSchema = new MiningSchema();
        if (label != null && (name = label.getName()) != null) {
            MiningField miningField = ModelUtil.createMiningField(name, MiningField.UsageType.TARGET);
            miningSchema.addMiningFields(new MiningField[]{miningField});
        }
        return miningSchema;
    }

    public static MiningField createMiningField(FieldName name) {
        return ModelUtil.createMiningField(name, null);
    }

    public static MiningField createMiningField(FieldName name, MiningField.UsageType usageType) {
        MiningField miningField = new MiningField(name).setUsageType(usageType);
        return miningField;
    }

    public static Targets createRescaleTargets(Number slope, Number intercept, ContinuousLabel continuousLabel) {
        FieldName name = continuousLabel.getName();
        Target target = new Target().setField(name);
        boolean rescaled = false;
        if (slope != null && !ValueUtil.isOne(slope)) {
            target.setRescaleFactor(Double.valueOf(slope.doubleValue()));
            rescaled = true;
        }
        if (intercept != null && !ValueUtil.isZero(intercept)) {
            target.setRescaleConstant(Double.valueOf(intercept.doubleValue()));
            rescaled = true;
        }
        if (!rescaled) {
            return null;
        }
        Targets targets = new Targets().addTargets(new Target[]{target});
        return targets;
    }

    public static Output createPredictedOutput(FieldName name, OpType opType, DataType dataType, Transformation ... transformations) {
        ArrayList<OutputField> outputFields = new ArrayList<OutputField>();
        OutputField outputField = new OutputField(name, dataType).setOpType(opType).setResultFeature(ResultFeature.PREDICTED_VALUE).setFinalResult(Boolean.valueOf(false));
        outputFields.add(outputField);
        for (Transformation transformation : transformations) {
            outputField = new OutputField(transformation.getName(outputField.getName()), transformation.getDataType(outputField.getDataType())).setOpType(transformation.getOpType(outputField.getOpType())).setResultFeature(ResultFeature.TRANSFORMED_VALUE).setFinalResult(Boolean.valueOf(transformation.isFinalResult())).setExpression(transformation.createExpression(new FieldRef(outputField.getName())));
            outputFields.add(outputField);
        }
        return new Output(outputFields);
    }

    public static Output createProbabilityOutput(MathContext mathContext, CategoricalLabel categoricalLabel) {
        DataType dataType = DataType.DOUBLE;
        if (MathContext.FLOAT.equals((Object)mathContext)) {
            dataType = DataType.FLOAT;
        }
        return ModelUtil.createProbabilityOutput(dataType, categoricalLabel);
    }

    public static Output createProbabilityOutput(DataType dataType, CategoricalLabel categoricalLabel) {
        List<OutputField> outputFields = ModelUtil.createProbabilityFields(dataType, categoricalLabel.getValues());
        return new Output(outputFields);
    }

    public static OutputField createAffinityField(DataType dataType, String value) {
        return ModelUtil.createAffinityField(FieldName.create((String)("affinity(" + value + ")")), dataType, value);
    }

    public static OutputField createAffinityField(FieldName name, DataType dataType, String value) {
        OutputField outputField = new OutputField(name, dataType).setOpType(OpType.CONTINUOUS).setResultFeature(ResultFeature.AFFINITY).setValue(value);
        return outputField;
    }

    public static List<OutputField> createAffinityFields(final DataType dataType, List<? extends Entity> entities) {
        Function<Entity, OutputField> function = new Function<Entity, OutputField>(){

            public OutputField apply(Entity entity) {
                return ModelUtil.createAffinityField(dataType, entity.getId());
            }
        };
        return Lists.newArrayList((Iterable)Lists.transform(entities, (Function)function));
    }

    public static OutputField createEntityIdField(FieldName name) {
        OutputField outputField = new OutputField(name, DataType.STRING).setOpType(OpType.CATEGORICAL).setResultFeature(ResultFeature.ENTITY_ID);
        return outputField;
    }

    public static OutputField createPredictedField(FieldName name, DataType dataType, OpType opType) {
        OutputField outputField = new OutputField(name, dataType).setOpType(opType).setResultFeature(ResultFeature.PREDICTED_VALUE);
        return outputField;
    }

    public static OutputField createProbabilityField(DataType dataType, String value) {
        return ModelUtil.createProbabilityField(FieldName.create((String)("probability(" + value + ")")), dataType, value);
    }

    public static OutputField createProbabilityField(FieldName name, DataType dataType, String value) {
        OutputField outputField = new OutputField(name, dataType).setOpType(OpType.CONTINUOUS).setResultFeature(ResultFeature.PROBABILITY).setValue(value);
        return outputField;
    }

    public static List<OutputField> createProbabilityFields(final DataType dataType, List<String> values) {
        Function<String, OutputField> function = new Function<String, OutputField>(){

            public OutputField apply(String value) {
                return ModelUtil.createProbabilityField(dataType, value);
            }
        };
        return Lists.newArrayList((Iterable)Lists.transform(values, (Function)function));
    }

    public static MathContext simplifyMathContext(MathContext mathContext) {
        return MathContext.DOUBLE.equals((Object)mathContext) ? null : mathContext;
    }
}

