/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Header;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.PMMLUtil;

public class PMMLEncoder {
    private Map<FieldName, DataField> dataFields = new LinkedHashMap<FieldName, DataField>();
    private Map<FieldName, DerivedField> derivedFields = new LinkedHashMap<FieldName, DerivedField>();
    private Map<String, DefineFunction> defineFunctions = new LinkedHashMap<String, DefineFunction>();

    public PMML encodePMML() {
        if (!Collections.disjoint(this.dataFields.keySet(), this.derivedFields.keySet())) {
            throw new IllegalArgumentException();
        }
        ArrayList<DataField> dataFields = new ArrayList<DataField>(this.dataFields.values());
        DataDictionary dataDictionary = new DataDictionary();
        if (dataFields.size() > 0) {
            dataDictionary.getDataFields().addAll(dataFields);
        }
        ArrayList<DerivedField> derivedFields = new ArrayList<DerivedField>(this.derivedFields.values());
        ArrayList<DefineFunction> defineFunctions = new ArrayList<DefineFunction>(this.defineFunctions.values());
        TransformationDictionary transformationDictionary = null;
        if (derivedFields.size() > 0 || defineFunctions.size() > 0) {
            transformationDictionary = new TransformationDictionary();
            if (derivedFields.size() > 0) {
                transformationDictionary.getDerivedFields().addAll(derivedFields);
            }
            if (defineFunctions.size() > 0) {
                transformationDictionary.getDefineFunctions().addAll(defineFunctions);
            }
        }
        Header header = this.encodeHeader();
        PMML pmml = new PMML("4.3", header, dataDictionary).setTransformationDictionary(transformationDictionary);
        return pmml;
    }

    public Header encodeHeader() {
        return PMMLUtil.createHeader(this.getClass());
    }

    public DataField getDataField(FieldName name) {
        return this.dataFields.get(name);
    }

    public void addDataField(DataField dataField) {
        FieldName name = dataField.getName();
        this.checkName(name);
        this.dataFields.put(name, dataField);
    }

    public DataField createDataField(FieldName name, OpType opType, DataType dataType) {
        return this.createDataField(name, opType, dataType, null);
    }

    public DataField createDataField(FieldName name, OpType opType, DataType dataType, List<String> values) {
        DataField dataField = new DataField(name, opType, dataType);
        if (values != null && values.size() > 0) {
            PMMLUtil.addValues(dataField, values);
        }
        this.addDataField(dataField);
        return dataField;
    }

    public DerivedField getDerivedField(FieldName name) {
        return this.derivedFields.get(name);
    }

    public void addDerivedField(DerivedField derivedField) {
        FieldName name = derivedField.getName();
        this.checkName(name);
        this.derivedFields.put(name, derivedField);
    }

    public DerivedField createDerivedField(FieldName name, OpType opType, DataType dataType, Expression expression) {
        DerivedField derivedField = new DerivedField(opType, dataType).setName(name).setExpression(expression);
        this.addDerivedField(derivedField);
        return derivedField;
    }

    public TypeDefinitionField getField(FieldName name) {
        DataField dataField = this.getDataField(name);
        DerivedField derivedField = this.getDerivedField(name);
        if (dataField != null && derivedField == null) {
            return dataField;
        }
        if (dataField == null && derivedField != null) {
            return derivedField;
        }
        throw new IllegalArgumentException(name.getValue());
    }

    public TypeDefinitionField toContinuous(FieldName name) {
        TypeDefinitionField field = this.getField(name);
        DataType dataType = field.getDataType();
        switch (dataType) {
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + name.getValue() + " has data type " + dataType);
            }
        }
        field.setOpType(OpType.CONTINUOUS);
        return field;
    }

    public TypeDefinitionField toCategorical(FieldName name, List<String> values) {
        TypeDefinitionField field = this.getField(name);
        if (field instanceof DataField) {
            DataField dataField = (DataField)field;
            List<String> existingValues = PMMLUtil.getValues(dataField);
            if (existingValues != null && existingValues.size() > 0) {
                if (!existingValues.equals(values)) {
                    throw new IllegalArgumentException("Field " + name.getValue() + " has valid values " + existingValues);
                }
            } else {
                PMMLUtil.addValues(dataField, values);
            }
        }
        field.setOpType(OpType.CATEGORICAL);
        return field;
    }

    public DefineFunction getDefineFunction(String name) {
        return this.defineFunctions.get(name);
    }

    public void addDefineFunction(DefineFunction defineFunction) {
        String name = defineFunction.getName();
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.defineFunctions.containsKey(name)) {
            throw new IllegalArgumentException(name);
        }
        this.defineFunctions.put(name, defineFunction);
    }

    protected Map<FieldName, DataField> getDataFields() {
        return this.dataFields;
    }

    protected Map<FieldName, DerivedField> getDerivedFields() {
        return this.derivedFields;
    }

    private void checkName(FieldName name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.dataFields.containsKey(name) || this.derivedFields.containsKey(name)) {
            throw new IllegalArgumentException(name.getValue());
        }
    }
}

